/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.core.repository.dataview.analysis;

import com.bizunited.platform.common.util.ApplicationContextUtils;
import com.bizunited.platform.core.common.enums.AuthOperatorEnum;
import com.bizunited.platform.core.entity.DataViewFieldEntity;
import com.bizunited.platform.core.entity.dauth.DataAuthEntity;
import com.bizunited.platform.core.entity.dauth.DataAuthTypeEntity;
import com.bizunited.platform.core.entity.dauth.DataAuthVerticalEntity;
import com.bizunited.platform.core.entity.dauth.DataAuthVerticalRelationEntity;
import com.bizunited.platform.core.service.dataview.model.ExecuteContextModel;
import com.bizunited.platform.rbac.server.service.RoleService;
import com.bizunited.platform.rbac.server.util.SecurityUtils;
import com.bizunited.platform.rbac.server.vo.RoleVo;
import com.bizunited.platform.user.common.service.organization.OrganizationService;
import com.bizunited.platform.user.common.service.position.PositionService;
import com.bizunited.platform.user.common.service.userGroup.UserGroupService;
import com.bizunited.platform.user.common.vo.OrganizationVo;
import com.bizunited.platform.user.common.vo.PositionVo;
import com.bizunited.platform.user.common.vo.UserGroupVo;
import com.bizunited.platform.user.common.vo.UserVo;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.context.ApplicationContext;
import org.springframework.util.CollectionUtils;

public class SQLAuthVerticalAnalysis {
    private SQLAuthVerticalAnalysis() {
    }

    public static void buildSQLAuthVertical(ExecuteContextModel executeContext) {
        String sqlAlias = executeContext.getWrapperSqlAlias();
        String executeSql = executeContext.getExecuteSql();
        DataAuthEntity auth = executeContext.getDataAuth();
        Set<DataViewFieldEntity> fields = executeContext.getDataViewFields();
        Validate.notEmpty(fields, (String)"\u6570\u636e\u89c6\u56fe\u4e0d\u5b58\u5728\u67e5\u8be2\u5b57\u6bb5\uff1a%s", (Object[])new Object[]{executeContext.getExecuteParam().getDataViewCode()});
        Set<String> fieldNames = fields.stream().map(DataViewFieldEntity::getFieldName).collect(Collectors.toSet());
        if (!executeContext.isAdmin() && auth != null && !CollectionUtils.isEmpty(auth.getVerticalAuths())) {
            fieldNames = SQLAuthVerticalAnalysis.getVerticalField(fields, auth.getVerticalAuths());
        }
        String fieldSql = SQLAuthVerticalAnalysis.buildFieldSql(sqlAlias, fieldNames);
        String aliasSql = String.format("select %s from (%s) %s where 1=1 ", fieldSql, executeSql, sqlAlias);
        executeContext.setExecuteSql(aliasSql);
    }

    public static Set<String> getVerticalField(Set<DataViewFieldEntity> fields, Set<DataAuthVerticalEntity> verticals) {
        Validate.notEmpty(fields, (String)"\u6570\u636e\u89c6\u56fe\u7684\u5b57\u6bb5\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\uff01\uff01", (Object[])new Object[0]);
        Set<String> fieldNames = fields.stream().map(DataViewFieldEntity::getFieldName).collect(Collectors.toSet());
        if (CollectionUtils.isEmpty(verticals)) {
            return fieldNames;
        }
        HashSet<String> displayFields = new HashSet<String>();
        HashMap<Integer, Set<String>> cache = new HashMap<Integer, Set<String>>();
        for (DataAuthVerticalEntity vertical : verticals) {
            displayFields.addAll(SQLAuthVerticalAnalysis.getAuthFields(fieldNames, vertical, cache));
        }
        if (CollectionUtils.isEmpty(displayFields)) {
            return fieldNames;
        }
        return Sets.intersection(fieldNames, displayFields);
    }

    private static Set<String> getAuthFields(Set<String> fieldNames, DataAuthVerticalEntity vertical, Map<Integer, Set<String>> cache) {
        Set<String> verticalFields = Arrays.stream(vertical.getDisplayFields().split(",")).collect(Collectors.toSet());
        Set<DataAuthVerticalRelationEntity> relations = vertical.getAuthRelations();
        Set<String> presetValues = SQLAuthVerticalAnalysis.getPresetValues(vertical.getAuthType(), cache);
        Set<Object> relationValues = Sets.newHashSet();
        if (!CollectionUtils.isEmpty(relations)) {
            relationValues = relations.stream().map(DataAuthVerticalRelationEntity::getAuthRelationIds).collect(Collectors.toSet());
        }
        Sets.SetView intersection = Sets.intersection(presetValues, (Set)relationValues);
        AuthOperatorEnum verticalAuthOperator = AuthOperatorEnum.valueOf(vertical.getOprtType());
        boolean isAuth = false;
        block0 : switch (verticalAuthOperator) {
            case EQ: {
                isAuth = !CollectionUtils.isEmpty((Collection)intersection);
                break;
            }
            case NEQ: {
                isAuth = CollectionUtils.isEmpty((Collection)intersection);
                break;
            }
            case IN: {
                isAuth = !CollectionUtils.isEmpty((Collection)intersection);
                break;
            }
            case NIN: {
                for (String presetValue : presetValues) {
                    if (relationValues.contains(presetValue)) continue;
                    isAuth = true;
                    break block0;
                }
                break;
            }
        }
        if (isAuth) {
            return verticalFields;
        }
        return Sets.newHashSet();
    }

    private static Set<String> getPresetValues(DataAuthTypeEntity authTypeEntity, Map<Integer, Set<String>> cache) {
        Validate.notNull((Object)((Object)authTypeEntity), (String)"\u4f20\u5165\u7684\u5173\u8054\u79cd\u7c7b\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Integer authType = authTypeEntity.getInnerValue();
        if (cache.containsKey(authType)) {
            return cache.get(authType);
        }
        Set<String> presetValues = new HashSet<String>();
        ApplicationContext applicationContext = ApplicationContextUtils.getApplicationContext();
        UserVo user = SecurityUtils.getCurrentUser();
        switch (authType) {
            case 1: {
                presetValues.add(user.getAccount());
                break;
            }
            case 2: {
                RoleService roleService = (RoleService)applicationContext.getBean(RoleService.class);
                List roles = roleService.findAllByUserId(user.getId(), Integer.valueOf(0));
                if (CollectionUtils.isEmpty((Collection)roles)) break;
                presetValues = roles.stream().map(RoleVo::getRoleCode).collect(Collectors.toSet());
                break;
            }
            case 3: {
                PositionService positionService = (PositionService)applicationContext.getBean(PositionService.class);
                PositionVo position = positionService.findMainPositionByUserId(user.getId());
                if (position == null) break;
                presetValues.add(position.getCode());
                break;
            }
            case 4: {
                UserGroupService userGroupService = (UserGroupService)applicationContext.getBean(UserGroupService.class);
                Set groups = userGroupService.findByUserId(user.getId());
                if (CollectionUtils.isEmpty((Collection)groups)) break;
                presetValues = groups.stream().map(UserGroupVo::getGroupCode).collect(Collectors.toSet());
                break;
            }
            case 5: {
                OrganizationService organizationService = (OrganizationService)applicationContext.getBean(OrganizationService.class);
                Set orgs = organizationService.findOrgByUserId(user.getId());
                if (CollectionUtils.isEmpty((Collection)orgs)) break;
                presetValues = orgs.stream().map(OrganizationVo::getCode).collect(Collectors.toSet());
                break;
            }
        }
        cache.put(authType, presetValues);
        return presetValues;
    }

    private static String buildFieldSql(String sqlAlias, Set<String> fieldNames) {
        Validate.notEmpty(fieldNames, (String)"\u6c92\u6709\u5bf9\u5e94\u6743\u9650\uff08\u67e5\u8be2\u5b57\u6bb5\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5sql\u6216\u7eb5\u5411\u6743\u9650\u914d\u7f6e\uff09", (Object[])new Object[0]);
        ArrayList<String> sqls = new ArrayList<String>();
        for (String fieldName : fieldNames) {
            sqls.add(String.format(" %s.%s as %s", sqlAlias, fieldName, fieldName));
        }
        return StringUtils.join(sqls, (String)",");
    }
}

