/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.core.repository.dataview.analysis;

import com.bizunited.platform.common.vo.UuidVo;
import com.bizunited.platform.core.common.enums.InnerPresetValuesEnum;
import com.bizunited.platform.core.entity.dauth.DataAuthPrefabricateEntity;
import com.bizunited.platform.core.service.dauth.DataAuthPrefabricateEntityService;
import com.bizunited.platform.core.service.dauth.executor.DataAuthPrefabricateExecutor;
import com.bizunited.platform.rbac.server.service.RoleService;
import com.bizunited.platform.rbac.server.util.SecurityUtils;
import com.bizunited.platform.rbac.server.vo.RoleVo;
import com.bizunited.platform.user.common.service.organization.OrganizationService;
import com.bizunited.platform.user.common.service.position.PositionService;
import com.bizunited.platform.user.common.service.userGroup.UserGroupService;
import com.bizunited.platform.user.common.vo.OrganizationVo;
import com.bizunited.platform.user.common.vo.PositionVo;
import com.bizunited.platform.user.common.vo.UserGroupVo;
import com.bizunited.platform.user.common.vo.UserVo;
import com.google.common.collect.Lists;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.redisson.api.RMapCache;
import org.redisson.api.RedissonClient;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class SQLPresetValueAnalysis {
    public static final String HORIZONTAL_MAP_NAME_PREFIX = "HORIZONTAL_PRESET_VALUE";
    public static final String VERTICAL_MAP_NAME_PREFIX = "VERTICAL_PRESET_VALUE";
    public static final Integer MAX_CACHE_MIN = 10;
    @Autowired
    private RoleService roleService;
    @Autowired
    private PositionService positionService;
    @Autowired
    private UserGroupService userGroupService;
    @Autowired
    private OrganizationService organizationService;
    @Autowired
    private DataAuthPrefabricateEntityService dataAuthPrefabricateEntityService;
    @Autowired
    private RedissonClient redissonClient;
    @Autowired
    private DataAuthPrefabricateExecutor dataAuthPrefabricateExecutor;

    public Object getPresetValue(String paramKey, Integer level) {
        if (StringUtils.isBlank((CharSequence)paramKey)) {
            return null;
        }
        Object value = this.getCacheValue(paramKey, HORIZONTAL_MAP_NAME_PREFIX);
        if (value != null) {
            return value;
        }
        UserVo user = SecurityUtils.getCurrentUser();
        InnerPresetValuesEnum presetValuesEnum = InnerPresetValuesEnum.valueOfParamKey(paramKey);
        if (presetValuesEnum != null) {
            Validate.notNull((Object)((Object)presetValuesEnum), (String)"\u6839\u636e\u9884\u5236\u503c\u6807\u8bc6paramKey\uff0c\u672a\u80fd\u83b7\u53d6\u9884\u5236\u503c\u4fe1\u606f\uff01", (Object[])new Object[0]);
            switch (presetValuesEnum) {
                case OPT_USER_ID: {
                    value = user.getId();
                    break;
                }
                case OPT_USER_NAME: {
                    value = user.getUserName();
                    break;
                }
                case OPT_USER_ACCOUNT: {
                    value = user.getAccount();
                    break;
                }
                case OPT_USER_CODE: {
                    value = user.getId();
                    break;
                }
                case OPT_USER_PHONE: {
                    value = user.getPhone();
                    break;
                }
                case OPT_USER_STATUS: {
                    value = user.getUseStatus();
                    break;
                }
                case OPT_USER_IDCARD: {
                    value = user.getIdcard();
                    break;
                }
                case OPT_USER_POSITION_ID: 
                case OPT_USER_POSITION: 
                case OPT_USER_POSITION_CODE: 
                case OPT_USER_POSITION_STATUS: {
                    value = this.getPositionPreset(user, presetValuesEnum);
                    break;
                }
                case OPT_USER_ORG_STATUS: 
                case OPT_USER_ORG_DESC: 
                case OPT_USER_ORG_TYPE: 
                case OPT_USER_ORG_ID: 
                case OPT_USER_ORG: 
                case OPT_CUR_ORGS: 
                case OPT_PARENT_ORGS: 
                case OPT_PARENT_ALL_ORGS: 
                case OPT_CHILDREN_ORGS: 
                case OPT_CHILDREN_ALL_ORGS: 
                case OPT_CURRENT_ORG_AND_ALL_CHILDREN: 
                case OPT_PARENT_LEVEL_ORGS: 
                case OPT_CHILDREN_LEVEL_ORGS: {
                    value = this.getOrgPreset(user, presetValuesEnum, level);
                    break;
                }
                case OPT_USER_GROUP: {
                    value = this.getUserGroupPreset(user, presetValuesEnum);
                    break;
                }
                case OPT_USER_ROLE: {
                    value = this.getUserRolePreset(user, presetValuesEnum);
                    break;
                }
                default: {
                    value = this.getOtherPreset(user, presetValuesEnum);
                    break;
                }
            }
        } else {
            DataAuthPrefabricateEntity entity = this.dataAuthPrefabricateEntityService.findByCode(paramKey);
            value = this.dataAuthPrefabricateExecutor.executor(entity);
        }
        if (value != null) {
            this.setCacheValue(paramKey, value, HORIZONTAL_MAP_NAME_PREFIX);
        }
        return value;
    }

    private Object getOtherPreset(UserVo user, InnerPresetValuesEnum presetValuesEnum) {
        Object value;
        switch (presetValuesEnum) {
            case CURRENT_USER_LOGIN_TIME: {
                value = user.getLastloginTime();
                break;
            }
            case NOW_DATE_MONTH: {
                value = new SimpleDateFormat("yyyy-MM").format(new Date());
                break;
            }
            case NOW_DATE_DAY: {
                value = new SimpleDateFormat("yyyy-MM-dd").format(new Date());
                break;
            }
            case NOW_DATE_MINUTE: {
                value = new SimpleDateFormat("yyyy-MM-dd HH:mm").format(new Date());
                break;
            }
            case NOW_DATE_SECOND: {
                value = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date());
                break;
            }
            default: {
                throw new IllegalArgumentException(String.format("\u4e0d\u80fd\u8bc6\u522b\u7684\u9884\u5236\u503c\u7c7b\u522b\uff1a%s", presetValuesEnum.getParamKey()));
            }
        }
        return value;
    }

    private Object getUserRolePreset(UserVo user, InnerPresetValuesEnum presetValuesEnum) {
        List roles = this.roleService.findAllByUserId(user.getId(), Integer.valueOf(0));
        if (CollectionUtils.isEmpty((Collection)roles)) {
            return Lists.newArrayList((Object[])new String[]{"-0101010101"});
        }
        return roles.stream().map(RoleVo::getRoleCode).collect(Collectors.toList());
    }

    private Object getUserGroupPreset(UserVo user, InnerPresetValuesEnum presetValuesEnum) {
        Set groups = this.userGroupService.findByUserId(user.getId());
        if (CollectionUtils.isEmpty((Collection)groups)) {
            return Lists.newArrayList((Object[])new String[]{"-0101010101"});
        }
        return groups.stream().map(UserGroupVo::getGroupCode).collect(Collectors.toList());
    }

    private Object getPositionPreset(UserVo user, InnerPresetValuesEnum presetValuesEnum) {
        PositionVo position = this.positionService.findMainPositionByUserId(user.getId());
        if (position == null) {
            return "-0101010101";
        }
        switch (presetValuesEnum) {
            case OPT_USER_POSITION_ID: {
                return position.getId();
            }
            case OPT_USER_POSITION: 
            case OPT_USER_POSITION_CODE: {
                return position.getCode();
            }
            case OPT_USER_POSITION_STATUS: {
                return position.getTstatus();
            }
        }
        return position.getCode();
    }

    private Object getOrgPreset(UserVo user, InnerPresetValuesEnum presetValuesEnum, Integer level) {
        Set<OrganizationVo> orgs = null;
        Function<OrganizationVo, Object> function = null;
        switch (presetValuesEnum) {
            case OPT_USER_ORG_STATUS: {
                orgs = this.organizationService.findOrgByUserId(user.getId());
                function = OrganizationVo::getTstatus;
                break;
            }
            case OPT_USER_ORG_DESC: {
                orgs = this.organizationService.findOrgByUserId(user.getId());
                function = OrganizationVo::getDescription;
                break;
            }
            case OPT_USER_ORG_TYPE: {
                orgs = this.organizationService.findOrgByUserId(user.getId());
                function = OrganizationVo::getType;
                break;
            }
            case OPT_USER_ORG_ID: {
                orgs = this.organizationService.findOrgByUserId(user.getId());
                function = UuidVo::getId;
                break;
            }
            case OPT_USER_ORG: 
            case OPT_CUR_ORGS: {
                orgs = this.organizationService.findOrgByUserId(user.getId());
                function = OrganizationVo::getCode;
                break;
            }
            case OPT_PARENT_ORGS: {
                orgs = this.findParentOrgsByUserId(user.getId());
                function = OrganizationVo::getCode;
                break;
            }
            case OPT_PARENT_ALL_ORGS: {
                orgs = this.findAllParentOrgsByUserId(user.getId());
                function = OrganizationVo::getCode;
                break;
            }
            case OPT_CHILDREN_ORGS: {
                orgs = this.findChildrenOrgsByUserId(user.getId());
                function = OrganizationVo::getCode;
                break;
            }
            case OPT_CHILDREN_ALL_ORGS: {
                orgs = this.findAllChildrenOrgsByUserId(user.getId());
                function = OrganizationVo::getCode;
                break;
            }
            case OPT_CURRENT_ORG_AND_ALL_CHILDREN: {
                orgs = this.findCurrentOrgAndAllChildrenByUserId(user.getId());
                function = OrganizationVo::getCode;
                break;
            }
            case OPT_PARENT_LEVEL_ORGS: {
                orgs = this.findLevelParentOrgsByUserId(user.getAccount(), level);
                function = OrganizationVo::getCode;
                break;
            }
            case OPT_CHILDREN_LEVEL_ORGS: {
                orgs = this.findLevelChildrenOrgsByUserId(user.getAccount(), level);
                function = OrganizationVo::getCode;
                break;
            }
            default: {
                throw new IllegalArgumentException(String.format("\u4e0d\u80fd\u8bc6\u522b\u7684\u7ec4\u7ec7\u673a\u6784\u9884\u5236\u503c\uff1a%s", presetValuesEnum.getParamKey()));
            }
        }
        if (CollectionUtils.isEmpty(orgs)) {
            return Lists.newArrayList((Object[])new String[]{"-0101010101"});
        }
        return orgs.stream().map(function).collect(Collectors.toList());
    }

    private Set<OrganizationVo> findLevelChildrenOrgsByUserId(String account, Integer level) {
        Set orgs = this.organizationService.findByTypeAndLevel(Integer.valueOf(2), account, level);
        HashSet<OrganizationVo> result = new HashSet<OrganizationVo>();
        for (OrganizationVo org : orgs) {
            this.getChlidrenOrgs(org, result);
        }
        return result;
    }

    private void getChlidrenOrgs(OrganizationVo org, Set<OrganizationVo> result) {
        Set children = org.getChild();
        if (CollectionUtils.isEmpty((Collection)children)) {
            return;
        }
        result.addAll(children);
        for (OrganizationVo item : children) {
            this.getChlidrenOrgs(item, result);
        }
    }

    private Set<OrganizationVo> findLevelParentOrgsByUserId(String account, Integer level) {
        Set orgs = this.organizationService.findByTypeAndLevel(Integer.valueOf(1), account, level);
        HashSet<OrganizationVo> result = new HashSet<OrganizationVo>();
        for (OrganizationVo org : orgs) {
            this.getParentOrgs(org, result);
        }
        return result;
    }

    private void getParentOrgs(OrganizationVo org, Set<OrganizationVo> result) {
        OrganizationVo parent = org.getParent();
        if (parent == null) {
            return;
        }
        result.add(parent);
        this.getParentOrgs(parent, result);
    }

    private Set<OrganizationVo> findChildrenOrgsByUserId(String userId) {
        Set orgs = this.organizationService.findOrgByUserId(userId);
        if (CollectionUtils.isEmpty((Collection)orgs)) {
            return orgs;
        }
        HashSet<OrganizationVo> children = new HashSet<OrganizationVo>(16);
        for (OrganizationVo org : orgs) {
            List son = this.organizationService.findByParent(org.getId());
            if (CollectionUtils.isEmpty((Collection)son)) continue;
            children.addAll(son);
        }
        return children;
    }

    private Set<OrganizationVo> findAllChildrenOrgsByUserId(String userId) {
        Set orgs = this.organizationService.findOrgByUserId(userId);
        if (CollectionUtils.isEmpty((Collection)orgs)) {
            return orgs;
        }
        HashSet<OrganizationVo> children = new HashSet<OrganizationVo>(16);
        for (OrganizationVo org : orgs) {
            this.findChildrenOrgs(children, org.getId());
        }
        return children;
    }

    private Set<OrganizationVo> findCurrentOrgAndAllChildrenByUserId(String userId) {
        Set orgs = this.organizationService.findOrgByUserId(userId);
        if (CollectionUtils.isEmpty((Collection)orgs)) {
            return orgs;
        }
        HashSet<OrganizationVo> children = new HashSet<OrganizationVo>(16);
        for (OrganizationVo org : orgs) {
            this.findChildrenOrgs(children, org.getId());
        }
        children.addAll(orgs);
        return children;
    }

    private void findChildrenOrgs(Set<OrganizationVo> orgs, String parentOrgId) {
        List children = this.organizationService.findByParent(parentOrgId);
        if (CollectionUtils.isEmpty((Collection)children)) {
            return;
        }
        orgs.addAll(children);
        for (OrganizationVo org : children) {
            this.findChildrenOrgs(orgs, org.getId());
        }
    }

    private Set<OrganizationVo> findParentOrgsByUserId(String userId) {
        Set orgs = this.organizationService.findOrgByUserId(userId);
        if (CollectionUtils.isEmpty((Collection)orgs)) {
            return orgs;
        }
        HashSet<OrganizationVo> parents = new HashSet<OrganizationVo>(16);
        for (OrganizationVo org : orgs) {
            OrganizationVo parent = this.organizationService.findByChild(org.getId());
            if (parent == null) continue;
            parents.add(parent);
        }
        return parents;
    }

    private Set<OrganizationVo> findAllParentOrgsByUserId(String userId) {
        Set orgs = this.organizationService.findOrgByUserId(userId);
        if (CollectionUtils.isEmpty((Collection)orgs)) {
            return orgs;
        }
        HashSet<OrganizationVo> parents = new HashSet<OrganizationVo>(16);
        for (OrganizationVo org : orgs) {
            this.findParentOrg(this.organizationService, parents, org.getId());
        }
        return parents;
    }

    private void findParentOrg(OrganizationService organizationService, Set<OrganizationVo> orgs, String childOrgId) {
        OrganizationVo parent = organizationService.findByChild(childOrgId);
        if (parent == null) {
            return;
        }
        orgs.add(parent);
        this.findParentOrg(organizationService, orgs, parent.getId());
    }

    private Object getCacheValue(String key, String prefix) {
        RMapCache currentMap = this.redissonClient.getMapCache(prefix);
        if (currentMap == null) {
            return null;
        }
        return currentMap.get((Object)key);
    }

    private void setCacheValue(String key, Object content, String prefix) {
        RMapCache currentMap = this.redissonClient.getMapCache(prefix);
        Validate.notNull((Object)currentMap, (String)"\u9884\u5236\u503c\uff1a\u672a\u83b7\u53d6\u5230redis\u76f8\u5173\u4fe1\u606f\uff01", (Object[])new Object[0]);
        currentMap.put((Object)key, content, (long)MAX_CACHE_MIN.intValue(), TimeUnit.MINUTES);
    }
}

