/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.core.service.dataview.internal;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.bizunited.platform.common.constant.PlatformContext;
import com.bizunited.platform.common.enums.ImportExecuteModeEnum;
import com.bizunited.platform.common.model.MigrateImportModel;
import com.bizunited.platform.common.util.ChineseCharUtils;
import com.bizunited.platform.core.entity.DataSourceEntity;
import com.bizunited.platform.core.entity.DataViewEntity;
import com.bizunited.platform.core.entity.DataViewFieldEntity;
import com.bizunited.platform.core.entity.DataViewFilterEntity;
import com.bizunited.platform.core.entity.DataViewGroupEntity;
import com.bizunited.platform.core.entity.DataViewSystemEntity;
import com.bizunited.platform.core.entity.dauth.DataAuthEntity;
import com.bizunited.platform.core.repository.dataview.DataViewRepository;
import com.bizunited.platform.core.repository.dataview.analysis.SQLAuthVerticalAnalysis;
import com.bizunited.platform.core.repository.dynamic.DynamicDataSourceManager;
import com.bizunited.platform.core.service.dataview.DataSourceService;
import com.bizunited.platform.core.service.dataview.DataViewFieldService;
import com.bizunited.platform.core.service.dataview.DataViewFilterService;
import com.bizunited.platform.core.service.dataview.DataViewGroupService;
import com.bizunited.platform.core.service.dataview.DataViewService;
import com.bizunited.platform.core.service.dataview.DataViewSystemService;
import com.bizunited.platform.core.service.dataview.executor.DataViewExecutor;
import com.bizunited.platform.core.service.dataview.model.ExecuteContextModel;
import com.bizunited.platform.core.service.dataview.model.ExecuteParamModel;
import com.bizunited.platform.core.service.dataview.model.PageableModel;
import com.bizunited.platform.core.service.dauth.DataAuthService;
import com.bizunited.platform.core.vo.dataview.DataviewExportExcelFieldVo;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.security.Principal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.transaction.Transactional;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.data.domain.Example;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="DataViewEntityServiceImpl")
public class DataViewServiceImpl
implements DataViewService {
    private static final Logger LOGGER = LoggerFactory.getLogger(DataViewServiceImpl.class);
    private static final String ERROR_MESS_SQL = "\u539f\u59cbSQL\u4e0d\u80fd\u4e3a\u7a7a\uff01";
    private static final String DEFAULT_DATE_FORMAT = "yyyy-MM-dd HH:mm:ss";
    private static final int DEFAULT_COLUMN_WIDTH = 5000;
    @Autowired
    private DataViewRepository dataViewEntityRepository;
    @Autowired
    private DataViewFieldService dataViewFieldService;
    @Autowired
    private DataViewFilterService dataViewFilterService;
    @Autowired
    private DataViewSystemService dataViewSystemService;
    @Autowired
    private DataSourceService dataSourceService;
    @Autowired
    private DataAuthService dataAuthService;
    @Autowired
    private DataViewGroupService dataViewGroupService;
    @Autowired
    private DynamicDataSourceManager dynamicDataSourceManager;
    @Autowired
    private DataViewExecutor dataViewExecutor;
    @Autowired
    private PlatformContext platformContext;

    @Override
    public void createValidation(DataViewEntity dataViewEntity) {
        Validate.notNull((Object)((Object)dataViewEntity), (String)"\u8fdb\u884c\u5f53\u524d\u64cd\u4f5c\u65f6\uff0c\u4fe1\u606f\u5bf9\u8c61\u5fc5\u987b\u4f20\u5165!!", (Object[])new Object[0]);
        Validate.isTrue((boolean)StringUtils.isBlank((CharSequence)dataViewEntity.getId()), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u5f53\u524d\u4fe1\u606f\u7684\u6570\u636e\u7f16\u53f7\uff08\u4e3b\u952e\uff09\u4e0d\u80fd\u6709\u503c\uff01", (Object[])new Object[0]);
        dataViewEntity.setId(null);
        Validate.notBlank((CharSequence)dataViewEntity.getCode(), (String)"\u6570\u636e\u89c6\u56fe\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        DataViewEntity currentEntity = this.dataViewEntityRepository.findByCode(dataViewEntity.getCode());
        Validate.isTrue((null == currentEntity ? 1 : 0) != 0, (String)"\u8be5CODE\u89c6\u56fe\u5df2\u5b58\u5728\uff0c\u8bf7\u6539\u53d8\u7f16\u7801\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dataViewEntity.getName(), (String)"\u89c6\u56fe\u4e2d\u6587\u540d\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.isTrue((!ChineseCharUtils.hasChinese((String)dataViewEntity.getCode()) ? 1 : 0) != 0, (String)"\u89c6\u56fe\u7f16\u7801\u4e0d\u80fd\u542b\u6709\u4e2d\u6587\uff0c\u8bf7\u68c0\u67e5\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dataViewEntity.getSourceSql(), (String)ERROR_MESS_SQL, (Object[])new Object[0]);
        Validate.notNull((Object)dataViewEntity.getTstatus(), (String)"\u89c6\u56fe\u72b6\u6001\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.isTrue((dataViewEntity.getCode() == null || dataViewEntity.getCode().length() < 64 ? 1 : 0) != 0, (String)"\u6570\u636e\u89c6\u56fe\u7f16\u53f7,\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(64)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((dataViewEntity.getName() == null || dataViewEntity.getName().length() < 64 ? 1 : 0) != 0, (String)"\u89c6\u56fe\u4e2d\u6587\u540d,\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(64)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((dataViewEntity.getSourceSql() == null || dataViewEntity.getSourceSql().length() < 4096 ? 1 : 0) != 0, (String)"\u539f\u59cbSQL,\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(4096)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
    }

    @Override
    @Transactional
    public DataViewEntity create(DataViewEntity dataViewEntity, boolean ignoreValidate) {
        DataSourceEntity dataSource;
        if (!ignoreValidate) {
            this.createValidation(dataViewEntity);
        }
        if ((dataSource = dataViewEntity.getDataSource()) != null && StringUtils.isNotBlank((CharSequence)dataSource.getId())) {
            DataSourceEntity currentDataSource = this.dataSourceService.findById(dataSource.getId());
            Validate.notNull((Object)((Object)currentDataSource), (String)"\u672a\u627e\u5230\u8be5\u6570\u636e\u6e90!", (Object[])new Object[0]);
        }
        DataViewGroupEntity dataViewGroup = dataViewEntity.getDataViewGroup();
        Validate.notNull((Object)((Object)dataViewGroup), (String)"\u89c6\u56fe\u5206\u7ec4\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dataViewGroup.getId(), (String)"\u89c6\u56fe\u6240\u9009\u5206\u7ec4id\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        dataViewEntity.setProjectName(this.platformContext.getAppName());
        this.dataViewEntityRepository.saveAndFlush((Object)dataViewEntity);
        Set<DataViewFieldEntity> fields = dataViewEntity.getFields();
        this.dataViewFieldService.create(fields, dataViewEntity);
        Set<DataViewSystemEntity> systemFilters = dataViewEntity.getSystemFilters();
        this.dataViewSystemService.create(systemFilters, dataViewEntity);
        Set<DataViewFilterEntity> filters = dataViewEntity.getFilters();
        this.dataViewFilterService.create(filters, fields, dataViewEntity);
        dataViewEntity.setFields(fields);
        dataViewEntity.setFilters(filters);
        dataViewEntity.setSystemFilters(systemFilters);
        return dataViewEntity;
    }

    @Override
    @Transactional
    @CacheEvict(cacheNames={"dataView"}, allEntries=true)
    public DataViewEntity update(DataViewEntity dataView) {
        this.updateValidation(dataView);
        DataViewEntity dbDataView = this.dataViewEntityRepository.findById(dataView.getId()).orElse(null);
        Validate.notNull((Object)((Object)dbDataView), (String)"\u672a\u627e\u5230\u6570\u636e\u89c6\u56fe\u5bf9\u8c61", (Object[])new Object[0]);
        dbDataView.setCode(dataView.getCode());
        dbDataView.setName(dataView.getName());
        dbDataView.setProjectName(this.platformContext.getAppName());
        dbDataView.setSourceSql(dataView.getSourceSql());
        dbDataView.setTstatus(dataView.getTstatus());
        this.dataViewEntityRepository.saveAndFlush((Object)dbDataView);
        Set<DataViewFieldEntity> fields = this.dataViewFieldService.update(dbDataView, dataView.getFields());
        dbDataView.setFields(fields);
        Set<DataViewFilterEntity> filters = this.dataViewFilterService.update(dbDataView, dataView.getFilters());
        dbDataView.setFilters(filters);
        Set<DataViewSystemEntity> systemFilters = this.dataViewSystemService.update(dbDataView, dataView.getSystemFilters());
        dbDataView.setSystemFilters(systemFilters);
        return dbDataView;
    }

    @Override
    public void updateValidation(DataViewEntity dataViewEntity) {
        Validate.isTrue((!StringUtils.isBlank((CharSequence)dataViewEntity.getId()) ? 1 : 0) != 0, (String)"\u4fee\u6539\u4fe1\u606f\u65f6\uff0c\u5f53\u524d\u4fe1\u606f\u7684\u6570\u636e\u7f16\u53f7\uff08\u4e3b\u952e\uff09\u5fc5\u987b\u6709\u503c\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dataViewEntity.getCode(), (String)"\u6570\u636e\u89c6\u56fe\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dataViewEntity.getName(), (String)"\u89c6\u56fe\u4e2d\u6587\u540d\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dataViewEntity.getSourceSql(), (String)ERROR_MESS_SQL, (Object[])new Object[0]);
        Validate.notNull((Object)dataViewEntity.getTstatus(), (String)"\u89c6\u56fe\u72b6\u6001\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.isTrue((dataViewEntity.getCode() == null || dataViewEntity.getCode().length() < 64 ? 1 : 0) != 0, (String)"\u6570\u636e\u89c6\u56fe\u7f16\u53f7,\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(64)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((dataViewEntity.getName() == null || dataViewEntity.getName().length() < 64 ? 1 : 0) != 0, (String)"\u89c6\u56fe\u4e2d\u6587\u540d,\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(64)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((dataViewEntity.getSourceSql() == null || dataViewEntity.getSourceSql().length() < 4096 ? 1 : 0) != 0, (String)"\u539f\u59cbSQL,\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(4096)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
    }

    @Override
    @Transactional
    public void deleteById(String id) {
        Validate.notBlank((CharSequence)id, (String)"\u8fdb\u884c\u5220\u9664\u65f6\uff0c\u5fc5\u987b\u7ed9\u5b9a\u4e3b\u952e\u4fe1\u606f!!", (Object[])new Object[0]);
        Optional op = this.dataViewEntityRepository.findById(id);
        op.ifPresent(dataViewEntity -> this.dataViewEntityRepository.delete(dataViewEntity));
    }

    @Override
    public byte[] exportExcel(ExecuteParamModel executeParam, Principal principal, List<DataviewExportExcelFieldVo> excelFields) {
        if (CollectionUtils.isEmpty(excelFields)) {
            return new byte[0];
        }
        List<JSONObject> list = this.executeQuery(executeParam);
        Workbook workbook = this.buildWorkbook(list, excelFields);
        byte[] bytes = new byte[]{};
        try (ByteArrayOutputStream os = new ByteArrayOutputStream();){
            workbook.write((OutputStream)os);
            bytes = os.toByteArray();
        }
        catch (IOException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
        return bytes;
    }

    private Workbook buildWorkbook(List<JSONObject> list, List<DataviewExportExcelFieldVo> excelFields) {
        XSSFWorkbook workbook = new XSSFWorkbook();
        Sheet sheet = workbook.createSheet();
        List<DataviewExportExcelFieldVo> sortedExcelFields = excelFields.stream().sorted(Comparator.comparing(DataviewExportExcelFieldVo::getSortIndex)).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(list)) {
            this.initTitle(sheet, sortedExcelFields);
            return workbook;
        }
        this.initColumnWidth(sheet, list.size());
        this.initTitle(sheet, sortedExcelFields);
        this.initRows(sheet, list, sortedExcelFields);
        return workbook;
    }

    private void initRows(Sheet sheet, List<JSONObject> list, List<DataviewExportExcelFieldVo> fields) {
        for (int i = 0; i < list.size(); ++i) {
            JSONObject jsonObject = list.get(i);
            Row row = sheet.createRow(i + 1);
            this.initRow(row, jsonObject, fields);
        }
    }

    private void initRow(Row row, JSONObject jsonObject, List<DataviewExportExcelFieldVo> fields) {
        for (int i = 0; i < fields.size(); ++i) {
            DataviewExportExcelFieldVo field = fields.get(i);
            Cell cell = row.createCell(i);
            this.setCellValue(cell, jsonObject, field);
        }
    }

    private String getCellDictKey(Map<String, String> dicts, Object obj) {
        String[] values = obj.toString().split(",");
        ArrayList<String> keys = new ArrayList<String>();
        Map vDicts = dicts.entrySet().stream().collect(Collectors.toMap(Map.Entry::getValue, Map.Entry::getKey, (a, b) -> b, () -> new HashMap(16)));
        for (String value : values) {
            String key = (String)vDicts.get(value);
            if (key == null) {
                keys.add(value);
                continue;
            }
            keys.add(key);
        }
        return StringUtils.join(keys, (String)"\u3001");
    }

    private void setCellValue(Cell cell, JSONObject jsonObject, DataviewExportExcelFieldVo field) {
        Object obj = jsonObject.get((Object)field.getFieldName());
        if (obj == null) {
            cell.setCellValue("");
            return;
        }
        Map<String, String> dicts = field.getDicts();
        if (dicts != null && dicts.size() > 0) {
            String key = this.getCellDictKey(dicts, obj);
            cell.setCellValue(key);
            return;
        }
        if (obj instanceof Integer) {
            cell.setCellValue((double)((Integer)obj).intValue());
        } else if (obj instanceof Double) {
            cell.setCellValue(((Double)obj).doubleValue());
        } else if (obj instanceof Float) {
            cell.setCellValue((double)((Float)obj).floatValue());
        } else if (obj instanceof String) {
            cell.setCellValue((String)obj);
        } else if (obj instanceof Date) {
            String format = DEFAULT_DATE_FORMAT;
            if (StringUtils.isNotBlank((CharSequence)field.getFormat())) {
                format = field.getFormat();
            }
            SimpleDateFormat dateFormat = new SimpleDateFormat(format);
            cell.setCellValue(dateFormat.format((Date)obj));
        } else if (obj instanceof Long) {
            Long data = (Long)obj;
            if (Objects.equals("java.sql.Timestamp", field.getFieldType()) || Objects.equals("java.util.Date", field.getFieldType())) {
                String format = DEFAULT_DATE_FORMAT;
                if (StringUtils.isNotBlank((CharSequence)field.getFormat())) {
                    format = field.getFormat();
                }
                SimpleDateFormat dateFormat = new SimpleDateFormat(format);
                cell.setCellValue(dateFormat.format(data));
            } else {
                cell.setCellValue((double)((Long)obj).longValue());
            }
        } else if (obj instanceof Boolean) {
            cell.setCellValue(((Boolean)obj).booleanValue());
        } else if (obj instanceof BigDecimal) {
            cell.setCellValue(((BigDecimal)obj).toString());
        } else if (obj instanceof Byte) {
            cell.setCellValue((double)((Byte)obj).byteValue());
        } else if (obj instanceof Short) {
            cell.setCellValue((double)((Short)obj).shortValue());
        } else {
            cell.setCellValue(obj.toString());
        }
    }

    private void initColumnWidth(Sheet sheet, int columnCount) {
        for (int i = 0; i < columnCount; ++i) {
            sheet.setColumnWidth(i, 5000);
        }
    }

    private void initTitle(Sheet sheet, List<DataviewExportExcelFieldVo> fields) {
        Row row = sheet.createRow(0);
        for (int i = 0; i < fields.size(); ++i) {
            Cell cell = row.createCell(i);
            cell.setCellValue(fields.get(i).getDisplayName());
        }
    }

    @Override
    public DataViewEntity executeResource(String dataSourceCode, DataViewEntity dataView) {
        this.checkSQL(dataView);
        DataViewEntity dataViewEntity = this.dataViewEntityRepository.executeResource(dataSourceCode, dataView);
        return this.handleDataView(dataViewEntity);
    }

    private DataViewEntity handleDataView(DataViewEntity dataView) {
        if (dataView == null) {
            return null;
        }
        if (dataView.getFilters() == null) {
            dataView.setFilters(Sets.newHashSet());
        }
        return dataView;
    }

    @Override
    public DataViewEntity executeResource(DataViewEntity dataView) {
        this.checkSQL(dataView);
        DataViewEntity dataViewEntity = this.dataViewEntityRepository.executeResource(dataView);
        return this.handleDataView(dataViewEntity);
    }

    @Override
    public List<JSONObject> executeQuery(ExecuteParamModel executeParam) {
        if (executeParam == null) {
            return Lists.newArrayList();
        }
        ExecuteContextModel executeContext = this.dataViewExecutor.buildContext(executeParam);
        return this.dataViewExecutor.executeQuery(executeContext);
    }

    @Override
    public Page<JSONObject> executePageQuery(ExecuteParamModel executeParam) {
        if (executeParam == null) {
            return new PageImpl((List)Lists.newArrayList());
        }
        PageableModel pageable = executeParam.getPageable();
        if (pageable == null) {
            pageable = new PageableModel(0, 50);
            executeParam.setPageable(pageable);
        }
        ExecuteContextModel executeContext = this.dataViewExecutor.buildContext(executeParam);
        return this.dataViewExecutor.executePageQuery(executeContext);
    }

    private void checkSQL(DataViewEntity dataView) {
        String[] notAllowed = new String[]{"delete", "insert", "drop", "create", "alter", ";"};
        List<String> notAllowedList = Arrays.asList(notAllowed);
        Validate.notNull((Object)((Object)dataView), (String)"\u6570\u636e\u89c6\u56fe\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dataView.getSourceSql(), (String)ERROR_MESS_SQL, (Object[])new Object[0]);
        String sql = dataView.getSourceSql();
        List<String> words = Arrays.asList(StringUtils.split((String)sql, (String)" "));
        if (!CollectionUtils.isEmpty(words)) {
            Validate.isTrue((boolean)"select".equals(StringUtils.lowerCase((String)words.get(0))), (String)"\u67e5\u8be2\u8bed\u53e5\u53ea\u5141\u8bb8\u4ee5'select'\u8d77\u59cb\u7684\u67e5\u8be2\u8bed\u53e5", (Object[])new Object[0]);
            words.forEach(o -> Validate.isTrue((!notAllowedList.contains(o) ? 1 : 0) != 0, (String)String.format("\u8bed\u53e5\u4e2d\u4e0d\u80fd\u542b\u6709\u5b57\u7b26%s", o), (Object[])new Object[0]));
            Validate.isTrue((!words.get(words.size() - 1).contains(";") ? 1 : 0) != 0, (String)"\u6700\u540e\u4e00\u4e2a\u8bcd\u540e\u4e0d\u80fd\u63a5\u5206\u53f7", (Object[])new Object[0]);
        }
    }

    @Override
    public JSONArray findByDataSourceCode(String dataSourceCode) {
        List<Object[]> jsonList = StringUtils.isBlank((CharSequence)dataSourceCode) ? this.dataViewEntityRepository.findByDataSourceCode() : this.dataViewEntityRepository.findByDataSourceCode(dataSourceCode);
        JSONArray jsonViewArr = new JSONArray();
        if (!CollectionUtils.isEmpty(jsonList)) {
            jsonList.forEach(e -> {
                JSONObject jsonObject = new JSONObject();
                jsonObject.put("id", (Object)e[0].toString());
                jsonObject.put("code", (Object)e[1].toString());
                jsonObject.put("title", (Object)e[2].toString());
                jsonObject.put("datasourcegroup", (Object)e[3].toString());
                jsonObject.put("outCount", (Object)(e[4] == null ? 0 : ((BigInteger)e[4]).intValue()));
                jsonObject.put("displayCount", (Object)(e[5] == null ? 0 : ((BigInteger)e[5]).intValue()));
                jsonViewArr.add((Object)jsonObject);
            });
        }
        JSONArray groupArr = new JSONArray();
        List<DataViewGroupEntity> groupList = this.dataViewGroupService.findByDataSourceCode(dataSourceCode);
        Validate.notNull(groupList, (String)"\u6839\u636e\u6570\u636e\u6e90code\u503c\u672a\u80fd\u83b7\u53d6\u5230\u89c6\u56fe\u5206\u7ec4\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        groupList.forEach(e -> {
            JSONObject jsonObject = new JSONObject();
            JSONArray viewArr = new JSONArray();
            jsonObject.put("id", (Object)e.getId());
            jsonObject.put("title", (Object)e.getGroupName());
            jsonObject.put("targetTable", (Object)e.getTargetTable());
            if (!jsonViewArr.isEmpty()) {
                jsonViewArr.stream().filter(view -> StringUtils.equals((CharSequence)e.getId(), (CharSequence)((JSONObject)view).getString("datasourcegroup"))).forEach(arg_0 -> ((JSONArray)viewArr).add(arg_0));
            }
            jsonObject.put("children", (Object)viewArr);
            groupArr.add((Object)jsonObject);
        });
        return groupArr;
    }

    @Override
    public List<DataViewEntity> findByDataSource(String dataSourceId) {
        if (StringUtils.isBlank((CharSequence)dataSourceId)) {
            return Collections.emptyList();
        }
        return this.dataViewEntityRepository.findByDataSource(dataSourceId);
    }

    @Override
    public List<DataViewEntity> findByDataViewGroup(String dataViewGroupId) {
        if (StringUtils.isBlank((CharSequence)dataViewGroupId)) {
            return Collections.emptyList();
        }
        return this.dataViewEntityRepository.findByDataViewGroup(dataViewGroupId);
    }

    @Override
    public DataViewEntity findByFields(String fieldsId) {
        if (StringUtils.isBlank((CharSequence)fieldsId)) {
            return null;
        }
        return this.dataViewEntityRepository.findByFields(fieldsId);
    }

    @Override
    public DataViewEntity findByFilters(String filtersId) {
        if (StringUtils.isBlank((CharSequence)filtersId)) {
            return null;
        }
        return this.dataViewEntityRepository.findByFilters(filtersId);
    }

    @Override
    public DataViewEntity findBySystemFilters(String systemFiltersId) {
        if (StringUtils.isBlank((CharSequence)systemFiltersId)) {
            return null;
        }
        return this.dataViewEntityRepository.findBySystemFilters(systemFiltersId);
    }

    @Override
    @Cacheable(cacheNames={"dataView"}, key="'findDetailsByCode_' + #code", unless="#result == null")
    public DataViewEntity findDetailsByCode(String code) {
        if (StringUtils.isBlank((CharSequence)code)) {
            return null;
        }
        return this.dataViewEntityRepository.findDetailsByCode(code);
    }

    @Override
    @Cacheable(cacheNames={"dataView"}, key="'findByCode_' + #code", unless="#result == null")
    public DataViewEntity findByCode(String code) {
        if (StringUtils.isBlank((CharSequence)code)) {
            return null;
        }
        return this.dataViewEntityRepository.findByCode(code);
    }

    @Override
    public List<DataViewEntity> findDetailsByIds(String[] ids) {
        if (ids == null || ids.length == 0) {
            return Lists.newArrayList();
        }
        return this.dataViewEntityRepository.findDetailsByIds(ids);
    }

    @Override
    public DataViewEntity findById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        Optional op = this.dataViewEntityRepository.findById(id);
        return op.orElse(null);
    }

    @Override
    public int countByIds(String[] ids) {
        if (ids == null || ids.length <= 0) {
            return 0;
        }
        return this.dataViewEntityRepository.countByIds(ids);
    }

    @Override
    @Transactional
    public void moveGroup(String dataViewId, String dataViewGroupId) {
        Validate.notBlank((CharSequence)dataViewId, (String)"\u6240\u9009\u89c6\u56feID\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dataViewGroupId, (String)"\u6240\u9009\u65b0\u5206\u7ec4ID\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        DataViewEntity dataViewEntity = this.dataViewEntityRepository.findById(dataViewId).orElse(null);
        Validate.notNull((Object)((Object)dataViewEntity), (String)"\u672a\u627e\u5230\u6240\u9009\u89c6\u56fe\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5\uff01", (Object[])new Object[0]);
        DataViewGroupEntity group = this.dataViewGroupService.findById(dataViewGroupId);
        Validate.notNull((Object)((Object)group), (String)"\u672a\u627e\u5230\u6240\u9009\u5206\u7ec4\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5\uff01", (Object[])new Object[0]);
        dataViewEntity.setDataViewGroup(group);
        this.dataViewEntityRepository.saveAndFlush((Object)dataViewEntity);
    }

    @Override
    public long countByDataViewGroupId(String groupId) {
        return this.dataViewEntityRepository.countByDataViewGroupId(groupId);
    }

    @Override
    public List<DataViewEntity> findAllByConditions(DataViewEntity dataView) {
        if (dataView == null) {
            List dataViewEntities = this.dataViewEntityRepository.findAll();
            if (!CollectionUtils.isEmpty((Collection)dataViewEntities)) {
                dataViewEntities = dataViewEntities.stream().filter(dataViewEntity -> StringUtils.equals((CharSequence)this.platformContext.getAppName(), (CharSequence)dataViewEntity.getProjectName())).collect(Collectors.toList());
            }
            return dataViewEntities;
        }
        Example example = Example.of((Object)((Object)dataView));
        return this.dataViewEntityRepository.findAll(example);
    }

    @Override
    @Transactional(value=Transactional.TxType.REQUIRES_NEW)
    public void importData(MigrateImportModel importModel) {
        Validate.notNull((Object)importModel, (String)"\u5bfc\u5165\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        ZipFile zipFile = importModel.getZipFile();
        Validate.notNull((Object)zipFile, (String)"\u5bfc\u5165\u6587\u4ef6\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)importModel.getExecuteMode(), (String)"\u6267\u884c\u6a21\u5f0f\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        importModel.appendLine("\u5f00\u59cb\u5bfc\u5165\u6570\u636e");
        ZipEntry dataViewEntry = zipFile.getEntry("dataview.in");
        if (dataViewEntry == null) {
            importModel.appendLine("\u5bfc\u5165\u538b\u7f29\u5305\u4e2d\u672a\u53d1\u73b0\u6570\u636e\u6587\u4ef6\uff0c\u8bf7\u68c0\u67e5");
        }
        if (dataViewEntry != null) {
            try (InputStream is = zipFile.getInputStream(dataViewEntry);
                 ObjectInputStream ois = new ObjectInputStream(is);){
                List dataViews = (List)ois.readObject();
                List auths = (List)ois.readObject();
                if (CollectionUtils.isEmpty((Collection)dataViews)) {
                    importModel.appendLine("\u5bfc\u5165\u7684\u6570\u636e\u4e3a\u7a7a");
                } else {
                    this.importData(dataViews, auths, importModel);
                }
            }
            catch (IOException | ClassNotFoundException e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
                importModel.append("\u8bfb\u53d6\u4e1a\u52a1\u6570\u636e\u5931\u8d25\uff1a").appendLine(e.getMessage());
            }
        }
    }

    @Override
    public Set<String> findFieldsByCodeAndAuthCode(String code, String authCode) {
        if (StringUtils.isBlank((CharSequence)code)) {
            return Sets.newHashSet();
        }
        DataViewEntity dataView = this.dataViewEntityRepository.findByCode(code);
        if (dataView == null) {
            return Sets.newHashSet();
        }
        Set<DataViewFieldEntity> fields = dataView.getFields();
        if (CollectionUtils.isEmpty(fields)) {
            return Sets.newHashSet();
        }
        Set<String> fieldNames = fields.stream().map(DataViewFieldEntity::getFieldName).collect(Collectors.toSet());
        if (StringUtils.isBlank((CharSequence)authCode)) {
            return fieldNames;
        }
        DataAuthEntity auth = this.dataAuthService.findDetailsByDataViewCodeAndAuthCode(code, authCode);
        if (auth == null || CollectionUtils.isEmpty(auth.getVerticalAuths())) {
            return fieldNames;
        }
        return SQLAuthVerticalAnalysis.getVerticalField(fields, auth.getVerticalAuths());
    }

    private void importData(List<DataViewEntity> dataViews, List<DataAuthEntity> auths, MigrateImportModel importModel) {
        importModel.setTotalCount(dataViews.size());
        Map<String, List<DataAuthEntity>> authMap = this.getAuthMapByDataViewKey(auths);
        for (int i = 0; i < dataViews.size(); ++i) {
            DataViewEntity dataView = dataViews.get(i);
            importModel.appendLine(StringUtils.join((Object[])new Serializable[]{"--------[", Integer.valueOf(i + 1), "]----------"}));
            this.importData(dataView, importModel, authMap);
        }
    }

    private Map<String, List<DataAuthEntity>> getAuthMapByDataViewKey(List<DataAuthEntity> auths) {
        HashMap<String, List<DataAuthEntity>> authMap = new HashMap<String, List<DataAuthEntity>>();
        if (!CollectionUtils.isEmpty(auths)) {
            for (DataAuthEntity auth : auths) {
                String dataViewCode = auth.getDataView().getCode();
                ArrayList<DataAuthEntity> dataAuths = (ArrayList<DataAuthEntity>)authMap.get(dataViewCode);
                if (dataAuths == null) {
                    dataAuths = new ArrayList<DataAuthEntity>();
                }
                dataAuths.add(auth);
                authMap.put(dataViewCode, dataAuths);
            }
        }
        return authMap;
    }

    private void importData(DataViewEntity dataView, MigrateImportModel importModel, Map<String, List<DataAuthEntity>> authMap) {
        importModel.append("\u5f00\u59cb\u5904\u7406\u6570\u636e\uff1a").appendLine(dataView.getName());
        ImportExecuteModeEnum executeMode = importModel.getExecuteMode();
        DataViewEntity dbDataView = this.dataViewEntityRepository.findByCode(dataView.getCode());
        this.handleImportDataId(dataView);
        if (dbDataView != null && ImportExecuteModeEnum.SKIP == executeMode) {
            importModel.appendLine("\u6570\u636e\u89c6\u56fe\u5df2\u5b58\u5728\uff0c\u8df3\u8fc7");
            importModel.addSkipCount();
            return;
        }
        if (dbDataView != null && ImportExecuteModeEnum.UPDATE == executeMode) {
            importModel.appendLine("\u6570\u636e\u89c6\u56fe\u5df2\u5b58\u5728\uff0c\u8fdb\u884c\u66f4\u65b0\u8986\u76d6");
            this.handleUpdateData(dataView, dbDataView, importModel);
            this.dataAuthService.importAuths(authMap.get(dataView.getCode()), importModel);
            return;
        }
        if (dbDataView != null && ImportExecuteModeEnum.ADD == executeMode) {
            this.handleCreateDataOnExist(dataView, importModel);
            this.dataAuthService.importAuths(authMap.get(dataView.getCode()), importModel);
            return;
        }
        if (dbDataView == null) {
            this.handleCreateData(dataView, importModel);
            this.dataAuthService.importAuths(authMap.get(dataView.getCode()), importModel);
            return;
        }
        importModel.appendLine("\u6682\u4e0d\u652f\u6301\u7684\u6267\u884c\u65b9\u5f0f");
        importModel.addSkipCount();
    }

    private void handleCreateDataOnExist(DataViewEntity dataView, MigrateImportModel importModel) {
        String newCode;
        long codeCount;
        importModel.appendLine("\u6570\u636e\u89c6\u56fe\u5df2\u5b58\u5728\uff0c\u6267\u884c\u5df2\u5b58\u5728\u65b0\u589e\u5bfc\u5165");
        int count = 1;
        do {
            newCode = StringUtils.join((Object[])new Serializable[]{dataView.getCode(), "_", Integer.valueOf(count)});
            ++count;
        } while ((codeCount = this.dataViewEntityRepository.countByCode(newCode)) > 0L);
        importModel.append("\u751f\u6210\u65b0\u7684\u6570\u636e\u89c6\u56fe\uff1a").appendLine(newCode);
        importModel.appendLine("\u5bfc\u5165\u6a21\u7248\u6570\u636e");
        dataView.setCode(newCode);
        this.handleCreateData(dataView, importModel);
    }

    private void handleCreateData(DataViewEntity dataView, MigrateImportModel importModel) {
        DataViewGroupEntity group;
        importModel.appendLine("\u5f00\u59cb\u65b0\u589e\u6570\u636e\u89c6\u56fe");
        DataSourceEntity dataSource = dataView.getDataSource();
        if (dataSource != null) {
            DataSourceEntity dbDataSource = this.dataSourceService.findByCode(dataSource.getCode());
            if (dbDataSource == null) {
                importModel.appendLine("\u5bfc\u5165\u6570\u636e\u89c6\u56fe\u5173\u8054\u7684\u6570\u636e\u6e90");
                dbDataSource = this.dynamicDataSourceManager.create(dataSource);
            }
            dataView.setDataSource(dbDataSource);
        }
        if ((group = dataView.getDataViewGroup()) != null) {
            DataViewGroupEntity dbGroup = this.handleDataViewGroup(group, importModel);
            dataView.setDataViewGroup(dbGroup);
        }
        importModel.appendLine("\u5bfc\u5165\u6570\u636e\u89c6\u56fe");
        this.create(dataView, false);
        importModel.addCreateCount();
    }

    private DataViewGroupEntity handleDataViewGroup(DataViewGroupEntity group, MigrateImportModel importModel) {
        DataViewGroupEntity dbGroup = this.dataViewGroupService.findByCode(group.getCode());
        if (dbGroup != null) {
            return dbGroup;
        }
        DataViewGroupEntity parent = group.getParent();
        if (parent != null) {
            DataViewGroupEntity dbParent = this.handleDataViewGroup(parent, importModel);
            group.setParent(dbParent);
        }
        importModel.append("\u5bfc\u5165\u6570\u636e\u89c6\u56fe\u5206\u7ec4\uff1a").appendLine(group.getGroupName());
        return this.dataViewGroupService.create(group, false);
    }

    private void handleUpdateData(DataViewEntity dataView, DataViewEntity dbDataView, MigrateImportModel importModel) {
        DataSourceEntity dataSource = dataView.getDataSource();
        DataSourceEntity dbDataSource = dbDataView.getDataSource();
        if (dataSource == null && dbDataSource != null || dataSource != null && dbDataSource == null) {
            throw new IllegalArgumentException("\u5bfc\u5165\u7684\u6570\u636e\u89c6\u56fe\u4e0e\u73b0\u6709\u6570\u636e\u89c6\u56fe\u5206\u522b\u5c5e\u4e8e\u4e3b\u6570\u636e\u6e90\u548c\u7b2c\u4e09\u65b9\u6570\u636e\u6e90\uff0c\u53d6\u6d88\u5bfc\u5165");
        }
        dataView.setId(dbDataView.getId());
        this.update(dataView);
        importModel.appendLine("\u66f4\u65b0\u6210\u529f");
        importModel.addUpdateCount();
    }

    private void handleImportDataId(DataViewEntity dataView) {
        DataSourceEntity dataSource;
        Set<DataViewSystemEntity> systemFilters;
        Set<DataViewFieldEntity> fields;
        Set<DataViewFilterEntity> filters;
        dataView.setId(null);
        DataViewGroupEntity group = dataView.getDataViewGroup();
        if (group != null) {
            do {
                group.setId(null);
            } while ((group = group.getParent()) != null);
        }
        if (!CollectionUtils.isEmpty(filters = dataView.getFilters())) {
            filters.forEach(f -> f.setId(null));
        }
        if (!CollectionUtils.isEmpty(fields = dataView.getFields())) {
            fields.forEach(f -> f.setId(null));
        }
        if (!CollectionUtils.isEmpty(systemFilters = dataView.getSystemFilters())) {
            systemFilters.forEach(f -> f.setId(null));
        }
        if ((dataSource = dataView.getDataSource()) != null) {
            dataSource.setId(null);
        }
    }
}

