/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.core.service.dauth.internal;

import com.bizunited.platform.core.entity.dauth.DataAuthPreRuleEntity;
import com.bizunited.platform.core.service.dauth.DataAuthPreRuleEntityService;
import com.bizunited.platform.core.service.dauth.internal.DataAuthPreRuleDistinguishService;
import com.bizunited.platform.rbac.server.service.RoleService;
import com.bizunited.platform.rbac.server.util.SecurityUtils;
import com.bizunited.platform.rbac.server.vo.RoleVo;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class DataAuthPreAuthDecisionService {
    @Value(value="${rbac.ignoreMethodCheckRoles:ADMIN}")
    private String[] adminRoleCodes;
    @Autowired
    private DataAuthPreRuleEntityService dataAuthPreRuleEntityService;
    @Autowired
    private RoleService roleService;
    @Autowired
    private DataAuthPreRuleDistinguishService dataAuthPreRoleDistinguishService;

    public DataAuthPreRuleEntity decision(String authCode) {
        Validate.notBlank((CharSequence)authCode, (String)"\u6570\u636e\u6743\u9650code\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Set<DataAuthPreRuleEntity> preRules = this.dataAuthPreRuleEntityService.findDetailsByDataAuthCode(authCode);
        if (CollectionUtils.isEmpty(preRules)) {
            return null;
        }
        Set preRuleNotDefaultSorted = preRules.stream().filter(e -> e.getIsDefault() == 0).sorted(Comparator.comparingInt(DataAuthPreRuleEntity::getSortIndex)).collect(Collectors.toCollection(LinkedHashSet::new));
        if (preRuleNotDefaultSorted.size() == 0) {
            return preRules.iterator().next();
        }
        for (DataAuthPreRuleEntity preRule : preRuleNotDefaultSorted) {
            boolean flag = this.dataAuthPreRoleDistinguishService.distinguish(preRule);
            if (!flag) continue;
            return preRule;
        }
        DataAuthPreRuleEntity defaultPreRule = preRules.stream().filter(e -> e.getIsDefault() == 1).findFirst().orElse(null);
        Validate.notNull((Object)((Object)defaultPreRule), (String)"\u6570\u636e\u6743\u9650\u3010%s\u3011\u672a\u80fd\u627e\u5230\u9ed8\u8ba4\u524d\u7f6e\u89c4\u5219\uff0c\u8bf7\u68c0\u67e5\uff01", (Object[])new Object[]{authCode});
        return defaultPreRule;
    }

    public boolean hasAdminRole() {
        HashSet ignoreMethodCheckRoles;
        String account = SecurityUtils.getUserAccount();
        Set roles = this.roleService.findByUserAccount(account);
        if (CollectionUtils.isEmpty((Collection)roles)) {
            return false;
        }
        Set roleCodes = roles.stream().map(RoleVo::getRoleCode).collect(Collectors.toSet());
        Sets.SetView intersections = Sets.intersection(roleCodes, (Set)(ignoreMethodCheckRoles = Sets.newHashSet((Object[])this.adminRoleCodes)));
        return !CollectionUtils.isEmpty((Collection)intersections);
    }
}

