/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.core.service.dauth.internal;

import com.bizunited.platform.core.common.enums.AuthTypeEnum;
import com.bizunited.platform.core.entity.dauth.DataAuthPreRuleEntity;
import com.bizunited.platform.core.entity.dauth.DataAuthPreRuleItemEntity;
import com.bizunited.platform.core.entity.dauth.DataAuthPreRuleValuesEntity;
import com.bizunited.platform.core.entity.dauth.DataAuthTypeEntity;
import com.bizunited.platform.rbac.server.service.RoleService;
import com.bizunited.platform.rbac.server.util.SecurityUtils;
import com.bizunited.platform.rbac.server.vo.RoleVo;
import com.bizunited.platform.user.common.service.organization.OrganizationService;
import com.bizunited.platform.user.common.service.position.PositionService;
import com.bizunited.platform.user.common.service.userGroup.UserGroupService;
import com.bizunited.platform.user.common.vo.OrganizationVo;
import com.bizunited.platform.user.common.vo.PositionVo;
import com.bizunited.platform.user.common.vo.UserGroupVo;
import com.bizunited.platform.user.common.vo.UserVo;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.redisson.api.RMapCache;
import org.redisson.api.RedissonClient;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class DataAuthPreRuleDistinguishService {
    private static final String MAP_NAME_PREFIX = "DATA_AUTH_PRE_RULE";
    private static final Integer MAX_CACHE_MIN = 10;
    @Autowired
    private RedissonClient redissonClient;
    @Autowired
    private RoleService roleService;
    @Autowired
    private OrganizationService organizationService;
    @Autowired
    private PositionService positionService;
    @Autowired
    private UserGroupService userGroupService;

    public boolean distinguish(DataAuthPreRuleEntity preRule) {
        Set<DataAuthPreRuleItemEntity> items = preRule.getPreAuthItems();
        for (DataAuthPreRuleItemEntity item : items) {
            DataAuthTypeEntity authType = item.getAuthType();
            Validate.notNull((Object)((Object)authType), (String)"\u6570\u636e\u5f02\u5e38\uff0c\u672a\u80fd\u83b7\u53d6\u5230\u5173\u8054\u7684\u79cd\u7c7b\u4fe1\u606f\uff01", (Object[])new Object[0]);
            Iterable<String> userInfoValues = this.getCurrentUserInfo(authType);
            if (userInfoValues == null || CollectionUtils.isEmpty(item.getValues())) continue;
            Set itemValues = item.getValues().stream().map(DataAuthPreRuleValuesEntity::getValue).collect(Collectors.toSet());
            Sets.SetView intersections = Sets.intersection((Set)Sets.newHashSet(userInfoValues), itemValues);
            if (CollectionUtils.isEmpty((Collection)intersections)) continue;
            return true;
        }
        return false;
    }

    private Iterable<String> getCurrentUserInfo(DataAuthTypeEntity authType) {
        UserVo user = SecurityUtils.getCurrentUser();
        Validate.notNull((Object)user, (String)"\u672a\u80fd\u83b7\u53d6\u5230\u5f53\u524d\u7528\u6237\u4fe1\u606f\uff0c\u8bf7\u91cd\u65b0\u767b\u5f55\uff01", (Object[])new Object[0]);
        String account = user.getAccount();
        String mapName = StringUtils.join((Object[])new String[]{MAP_NAME_PREFIX, ":", account});
        switch (authType.getInnerValue()) {
            case 1: {
                return Sets.newHashSet((Object[])new String[]{account});
            }
            case 2: {
                String key = AuthTypeEnum.ROLE.name();
                Iterable<String> value = this.getCacheValue(key, account);
                if (value == null) {
                    Set roles = this.roleService.findByUserAccount(account);
                    Validate.notEmpty((Collection)roles, (String)"\u5f53\u524d\u7528\u6237\u6ca1\u6709\u4efb\u4f55\u6743\u9650\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
                    value = this.setCacheValue(mapName, key, roles.stream().map(RoleVo::getRoleCode).collect(Collectors.toSet()));
                }
                return value;
            }
            case 3: {
                String key = AuthTypeEnum.POSITION.name();
                Iterable<String> value = this.getCacheValue(key, account);
                if (value == null) {
                    List positions = this.positionService.findByUserId(user.getId());
                    if (CollectionUtils.isEmpty((Collection)positions)) {
                        return value;
                    }
                    value = this.setCacheValue(mapName, key, positions.stream().map(PositionVo::getCode).collect(Collectors.toSet()));
                }
                return value;
            }
            case 4: {
                String key = AuthTypeEnum.GROUP.name();
                Iterable<String> value = this.getCacheValue(key, account);
                if (value == null) {
                    Set groups = this.userGroupService.findByUserId(user.getId());
                    if (CollectionUtils.isEmpty((Collection)groups)) {
                        return value;
                    }
                    value = this.setCacheValue(mapName, key, groups.stream().map(UserGroupVo::getGroupCode).collect(Collectors.toSet()));
                }
                return value;
            }
            case 5: {
                String key = AuthTypeEnum.ORG.name();
                Iterable<String> value = this.getCacheValue(key, account);
                if (value == null) {
                    Set orgs = this.organizationService.findOrgByUserId(user.getId());
                    Validate.notEmpty((Collection)orgs, (String)"\u5f53\u524d\u7528\u6237\u6ca1\u6709\u4efb\u4f55\u7ec4\u7ec7\u673a\u6784\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
                    value = this.setCacheValue(mapName, key, orgs.stream().map(OrganizationVo::getCode).collect(Collectors.toSet()));
                }
                return value;
            }
        }
        return null;
    }

    private Iterable<String> getCacheValue(String key, String account) {
        String mapName = StringUtils.join((Object[])new String[]{MAP_NAME_PREFIX, ":", account});
        RMapCache currentMap = this.redissonClient.getMapCache(mapName);
        if (currentMap == null) {
            return null;
        }
        return (Iterable)currentMap.get((Object)key);
    }

    private Iterable<String> setCacheValue(String mapName, String key, Iterable<String> content) {
        RMapCache currentMap = this.redissonClient.getMapCache(mapName);
        Validate.notNull((Object)currentMap, (String)"\u6570\u636e\u6743\u9650\uff1a\u672a\u83b7\u53d6\u5230redis\u76f8\u5173\u4fe1\u606f\uff01", (Object[])new Object[0]);
        return (Iterable)currentMap.put((Object)key, content, (long)MAX_CACHE_MIN.intValue(), TimeUnit.MINUTES);
    }
}

