/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.core.service.dauth.internal;

import com.bizunited.platform.common.entity.UuidEntity;
import com.bizunited.platform.common.service.NebulaToolkitService;
import com.bizunited.platform.core.entity.dauth.DataAuthPreRuleItemEntity;
import com.bizunited.platform.core.entity.dauth.DataAuthPreRuleValuesEntity;
import com.bizunited.platform.core.repository.dauth.DataAuthPreRuleValuesRepository;
import com.bizunited.platform.core.service.dauth.DataAuthPreRuleValuesEntityService;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.transaction.Transactional;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="DataAuthPreRuleValuesEntityServiceImpl")
public class DataAuthPreRuleValuesEntityServiceImpl
implements DataAuthPreRuleValuesEntityService {
    @Autowired
    private DataAuthPreRuleValuesRepository dataAuthPreRuleValuesRepository;
    @Autowired
    private NebulaToolkitService nebulaToolkitService;

    @Override
    @Transactional
    public Set<DataAuthPreRuleValuesEntity> create(Set<DataAuthPreRuleValuesEntity> values) {
        Validate.notEmpty(values, (String)"\u524d\u7f6e\u89c4\u5219\u660e\u7ec6\u9879\u5173\u8054\u7684\u503c\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        for (DataAuthPreRuleValuesEntity value : values) {
            Validate.isTrue((boolean)StringUtils.isBlank((CharSequence)value.getId()), (String)"\u6dfb\u52a0\u503c\u6570\u636e\u65f6\uff0cid\u4e3b\u952e\u4e0d\u80fd\u6709\u503c\uff01", (Object[])new Object[0]);
            value.setId(null);
            Validate.notBlank((CharSequence)value.getValue(), (String)"\u503c\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            Validate.notNull((Object)((Object)value.getPreRuleItem()), (String)"\u5173\u8054\u7684\u660e\u7ec6\u9879\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            this.dataAuthPreRuleValuesRepository.saveAndFlush((Object)value);
        }
        return values;
    }

    @Override
    @Transactional
    public Set<DataAuthPreRuleValuesEntity> update(Set<DataAuthPreRuleValuesEntity> values) {
        Validate.notEmpty(values, (String)"\u524d\u7f6e\u89c4\u5219\u660e\u7ec6\u9879\u5173\u8054\u7684\u503c\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        for (DataAuthPreRuleValuesEntity value : values) {
            Validate.notBlank((CharSequence)value.getValue(), (String)"\u503c\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            Validate.notBlank((CharSequence)value.getDisplayName(), (String)"\u663e\u793a\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            Validate.notNull((Object)((Object)value.getPreRuleItem()), (String)"\u5173\u8054\u7684\u660e\u7ec6\u9879\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        }
        Map<String, DataAuthPreRuleValuesEntity> valuesMap = values.stream().filter(e -> StringUtils.isNotBlank((CharSequence)e.getId())).collect(Collectors.toMap(UuidEntity::getId, v -> v));
        DataAuthPreRuleItemEntity preRuleItemEntity = values.iterator().next().getPreRuleItem();
        Set<DataAuthPreRuleValuesEntity> oldValues = this.dataAuthPreRuleValuesRepository.findByPreRuleItemId(preRuleItemEntity.getId());
        Validate.notEmpty(oldValues, (String)"\u672a\u80fd\u83b7\u53d6\u5230\u503c\u6570\u636e\u7684\u5386\u53f2\u6570\u636e!", (Object[])new Object[0]);
        Set<Object> createItems = Sets.newHashSet();
        HashSet updateItems = Sets.newHashSet();
        HashSet deleteItems = Sets.newHashSet();
        this.nebulaToolkitService.collectionDiscrepancy(values, oldValues, UuidEntity::getId, (Collection)deleteItems, (Collection)updateItems, (Collection)createItems);
        if (!CollectionUtils.isEmpty((Collection)updateItems)) {
            for (DataAuthPreRuleValuesEntity item : updateItems) {
                DataAuthPreRuleValuesEntity newItem = valuesMap.get(item.getId());
                item.setPreRuleItem(preRuleItemEntity);
                item.setValue(newItem.getDisplayName());
                item.setValue(newItem.getValue());
                this.dataAuthPreRuleValuesRepository.save((Object)item);
            }
        }
        if (!CollectionUtils.isEmpty((Collection)deleteItems)) {
            for (DataAuthPreRuleValuesEntity item : deleteItems) {
                this.dataAuthPreRuleValuesRepository.delete((Object)item);
            }
        }
        if (!CollectionUtils.isEmpty((Collection)(createItems = values.stream().filter(e -> StringUtils.isBlank((CharSequence)e.getId())).collect(Collectors.toSet())))) {
            this.create(createItems);
        }
        updateItems.addAll(createItems);
        return updateItems;
    }

    @Override
    public void deleteByPreAuthItemId(String id) {
        Validate.notBlank((CharSequence)id, (String)"\u8fdb\u884c\u5220\u9664\u65f6\uff0c\u5fc5\u987b\u7ed9\u5b9a\u660e\u7ec6\u4e3b\u952e\u4fe1\u606f!!", (Object[])new Object[0]);
        this.dataAuthPreRuleValuesRepository.deleteByPreAuthItemId(id);
    }
}

