/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.core.service.log.aspect;

import com.bizunited.platform.common.service.NebulaToolkitService;
import com.bizunited.platform.core.service.LoggerFiledMappingEntityService;
import com.bizunited.platform.core.service.LoggerInfoEntityService;
import com.bizunited.platform.core.service.LoggerTemplateEntityService;
import com.bizunited.platform.core.service.log.LoggerNotifyService;
import com.bizunited.platform.core.service.log.LoggerValidator;
import com.bizunited.platform.core.service.log.aspect.NebulaLoggerHandle;
import com.bizunited.platform.venus.common.service.file.VenusFileService;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import org.apache.commons.lang3.StringUtils;
import org.springframework.aop.ClassFilter;
import org.springframework.aop.support.DynamicMethodMatcherPointcut;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Component;
import org.springframework.stereotype.Controller;
import org.springframework.stereotype.Service;
import org.springframework.web.bind.annotation.RestController;

public class AnnotationLoggerDynamicPointcut
extends DynamicMethodMatcherPointcut {
    private static final String[] IGNORE_PACKAGES = new String[]{"com.bizunited.platform.common", "com.bizunited.platform.dictionary", "com.bizunited.platform.kuiper", "com.bizunited.platform.titan", "com.bizunited.platform.venus", "com.bizunited.platform.core", "com.bizunited.platform.mars", "springfox", "org.springframework", "com.github"};
    private static final Class<?>[] IGNORE_INTERFACES = new Class[]{LoggerTemplateEntityService.class, NebulaToolkitService.class, LoggerInfoEntityService.class, VenusFileService.class, LoggerFiledMappingEntityService.class, ApplicationContext.class, NebulaLoggerHandle.class, LoggerNotifyService.class, LoggerValidator.class};
    @Value(value="${nebula.ignorePackages:}")
    private String[] ignorePackages;
    @Value(value="${nebula.forcerLogPackages:}")
    private String[] forcerLogPackages;
    private static final Class<Annotation>[] INCLUDE_ANNOTATIONS = new Class[]{RestController.class, Controller.class, Component.class, Service.class};

    public ClassFilter getClassFilter() {
        return new ClassFilter(){

            public boolean matches(Class<?> clazz) {
                Package packages = clazz.getPackage();
                if (packages == null) {
                    return false;
                }
                String packageName = packages.getName();
                if (StringUtils.isBlank((CharSequence)packageName)) {
                    return false;
                }
                if (StringUtils.indexOfAny((CharSequence)packageName, (CharSequence[])IGNORE_PACKAGES) != -1) {
                    return false;
                }
                if (StringUtils.indexOfAny((CharSequence)packageName, (CharSequence[])AnnotationLoggerDynamicPointcut.this.ignorePackages) != -1) {
                    return false;
                }
                for (Class ignoreInterface : IGNORE_INTERFACES) {
                    if (!ignoreInterface.isAssignableFrom(clazz)) continue;
                    return false;
                }
                for (Class includeAnnotation : INCLUDE_ANNOTATIONS) {
                    if (clazz.getDeclaredAnnotation(includeAnnotation) == null) continue;
                    return true;
                }
                return StringUtils.indexOfAny((CharSequence)packageName, (CharSequence[])AnnotationLoggerDynamicPointcut.this.forcerLogPackages) != -1;
            }
        };
    }

    public boolean matches(Method method, Class<?> clazz, Object ... args) {
        return true;
    }
}

