/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.core.service.serviceable.aspect;

import com.bizunited.platform.core.service.invoke.InvokeProxyBuilder;
import com.bizunited.platform.core.service.invoke.InvokeRequestHandle;
import com.bizunited.platform.core.service.invoke.InvokeResponseHandle;
import com.bizunited.platform.core.service.serviceable.ServicableMethodService;
import com.bizunited.platform.core.service.serviceable.aspect.NebulaServiceMethodExecutionInfo;
import com.bizunited.platform.core.service.serviceable.model.ServicableMethodInfo;
import java.lang.reflect.Method;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;

public abstract class AbstractNebulaServiceMethodExecution {
    private ThreadLocal<NebulaServiceMethodExecutionInfo> nebulaServiceMethodExecutionInfo = new ThreadLocal();
    @Autowired
    private ApplicationContext applicationContext;
    @Autowired
    private ServicableMethodService servicableMethodService;

    public void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    public void setServicableMethodService(ServicableMethodService servicableMethodService) {
        this.servicableMethodService = servicableMethodService;
    }

    protected InvokeProxyBuilder buildInvokeProxy(ServicableMethodInfo servicableMethodInfo) {
        InvokeProxyBuilder sourceBuilder;
        int index;
        String requestHandleGroup = servicableMethodInfo.getRequestHandleGroup();
        Class<?>[] requestHandleTypes = servicableMethodInfo.getRequestHandleTypes();
        String responseHandleGroup = servicableMethodInfo.getResponseHandleGroup();
        Class<?>[] responseHandleTypes = servicableMethodInfo.getResponseHandleTypes();
        InvokeProxyBuilder invokeProxyBuilder = new InvokeProxyBuilder();
        invokeProxyBuilder.addClassLoader(this.applicationContext.getClassLoader());
        for (index = 0; requestHandleTypes != null && index < requestHandleTypes.length; ++index) {
            Class<?> invokeRequestHandleType = requestHandleTypes[index];
            invokeProxyBuilder.addInvokeRequestTypeFilter(invokeRequestHandleType);
        }
        if (!StringUtils.isBlank((CharSequence)requestHandleGroup)) {
            Object targetObject = this.applicationContext.getBean(requestHandleGroup);
            sourceBuilder = (InvokeProxyBuilder)targetObject;
            invokeProxyBuilder.copy(sourceBuilder);
        }
        for (index = 0; responseHandleTypes != null && index < responseHandleTypes.length; ++index) {
            Class<?> invokeResponseHandleType = responseHandleTypes[index];
            invokeProxyBuilder.addInvokeResponseTypeFilter(invokeResponseHandleType);
        }
        if (!StringUtils.isBlank((CharSequence)responseHandleGroup)) {
            Object targetObject = this.applicationContext.getBean(responseHandleGroup);
            sourceBuilder = (InvokeProxyBuilder)targetObject;
            invokeProxyBuilder.copy(sourceBuilder);
        }
        invokeProxyBuilder.setInvokeRequestHandleBinding(requestHandleClass -> {
            try {
                return (InvokeRequestHandle)this.applicationContext.getBean(requestHandleClass);
            }
            catch (NoSuchBeanDefinitionException e) {
                return (InvokeRequestHandle)BeanUtils.instantiateClass((Class)requestHandleClass);
            }
        });
        invokeProxyBuilder.setInvokeResponseHandleBinding(responseHandleClass -> {
            try {
                return (InvokeResponseHandle)this.applicationContext.getBean(responseHandleClass);
            }
            catch (NoSuchBeanDefinitionException e) {
                return (InvokeResponseHandle)BeanUtils.instantiateClass((Class)responseHandleClass);
            }
        });
        return invokeProxyBuilder;
    }

    protected ServicableMethodInfo findByServicableMethodName(String servicableMethodName) {
        return this.servicableMethodService.findDetailsByName(servicableMethodName);
    }

    protected boolean isExecutionInfoEmpty() {
        if (this.nebulaServiceMethodExecutionInfo.get() == null) {
            this.nebulaServiceMethodExecutionInfo.set(new NebulaServiceMethodExecutionInfo());
        }
        return this.nebulaServiceMethodExecutionInfo.get().isEmpty();
    }

    protected boolean hasExecutionInfo(Method currentMethod) {
        if (this.nebulaServiceMethodExecutionInfo.get() == null) {
            this.nebulaServiceMethodExecutionInfo.set(new NebulaServiceMethodExecutionInfo());
        }
        return this.nebulaServiceMethodExecutionInfo.get().hasMehtod(currentMethod);
    }

    protected void pushExecutionInfo(Method currentMethod) {
        if (this.nebulaServiceMethodExecutionInfo.get() == null) {
            this.nebulaServiceMethodExecutionInfo.set(new NebulaServiceMethodExecutionInfo());
        }
        this.nebulaServiceMethodExecutionInfo.get().push(currentMethod);
    }

    protected void popExecutionInfo() {
        if (this.nebulaServiceMethodExecutionInfo.get() == null) {
            this.nebulaServiceMethodExecutionInfo.set(new NebulaServiceMethodExecutionInfo());
        }
        this.nebulaServiceMethodExecutionInfo.get().pop();
    }
}

