/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.core.service.serviceable.template;

import com.bizunited.platform.common.util.JsonUtils;
import com.bizunited.platform.core.service.invoke.InvokeParams;
import com.bizunited.platform.core.service.serviceable.template.ValueMappingTemplate;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.Collection;
import org.springframework.stereotype.Component;

@Component
public class ArrayValueMappingTemplate
implements ValueMappingTemplate {
    @Override
    public boolean match(Class<?> targetClass, Method targetMethod, Parameter parameter, int index) {
        Class<?> parameterType = parameter.getType();
        return parameterType.isArray();
    }

    @Override
    public Object mapping(Class<?> targetClass, Method targetMethod, Parameter parameter, int index, String parameterName, InvokeParams invokeParams) {
        Object value = invokeParams.getInvokeParam(parameterName);
        if (value == null) {
            return null;
        }
        Class<?> valueClass = value.getClass();
        Class<?> parameterType = parameter.getType();
        if (valueClass.isArray() || Collection.class.isAssignableFrom(value.getClass())) {
            return JsonUtils.convert((Object)value, parameterType);
        }
        throw new IllegalArgumentException(String.format("\u53c2\u6570\u3010%s\u3011\u4f20\u5165\u7684\u6570\u636e\u7ed3\u6784\u4e0d\u662f\u6570\u7ec4\uff0c\u8bf7\u68c0\u67e5\uff01\uff01", parameterName));
    }
}

