/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.core.service.serviceable.template;

import com.bizunited.platform.common.util.JsonUtils;
import com.bizunited.platform.core.service.invoke.InvokeParams;
import com.bizunited.platform.core.service.serviceable.template.ValueMappingTemplate;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collection;
import org.apache.commons.lang3.Validate;
import org.springframework.stereotype.Component;

@Component
public class CollectionValueMappingTemplate
implements ValueMappingTemplate {
    @Override
    public boolean match(Class<?> targetClass, Method targetMethod, Parameter parameter, int index) {
        Class<?> parameterType = parameter.getType();
        boolean isArray = parameterType.isArray();
        if (isArray) {
            return false;
        }
        return Collection.class.isAssignableFrom(parameterType);
    }

    @Override
    public Object mapping(Class<?> targetClass, Method targetMethod, Parameter parameter, int index, String parameterName, InvokeParams invokeParams) {
        Object value = invokeParams.getInvokeParam(parameterName);
        if (value == null) {
            return null;
        }
        Class<?> valueClass = value.getClass();
        if (valueClass.isArray() || Collection.class.isAssignableFrom(valueClass)) {
            Type parameterizedType = parameter.getParameterizedType();
            Validate.isTrue((boolean)ParameterizedType.class.isAssignableFrom(parameterizedType.getClass()), (String)"\u96c6\u5408\u53c2\u6570\u3010%s\u3011\u5fc5\u987b\u6307\u5b9a\u8303\u578b", (Object[])new Object[]{parameterName});
            return JsonUtils.convert((Object)value, (ParameterizedType)((ParameterizedType)parameterizedType));
        }
        throw new IllegalArgumentException(String.format("\u53c2\u6570\u3010%s\u3011\u4f20\u5165\u7684\u6570\u636e\u7ed3\u6784\u4e0d\u662f\u6570\u7ec4\uff0c\u8bf7\u68c0\u67e5\uff01\uff01", parameterName));
    }
}

