/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.core.configuration.datasource;

import com.alibaba.druid.pool.DruidDataSource;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.sql.DataSource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.orm.jpa.HibernateProperties;
import org.springframework.boot.autoconfigure.orm.jpa.HibernateSettings;
import org.springframework.boot.autoconfigure.orm.jpa.JpaProperties;
import org.springframework.boot.orm.jpa.EntityManagerFactoryBuilder;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.data.jpa.repository.config.EnableJpaRepositories;
import org.springframework.orm.jpa.JpaTransactionManager;
import org.springframework.orm.jpa.LocalContainerEntityManagerFactoryBean;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.annotation.EnableTransactionManagement;

@Configuration
@EnableTransactionManagement
@EnableJpaRepositories(entityManagerFactoryRef="entityManagerFactoryPrimary", transactionManagerRef="transactionManagerPrimary")
public class PrimaryJpaConfig {
    @Autowired
    private JpaProperties jpaProperties;
    @Autowired
    private HibernateProperties hibernateProperties;
    @Autowired
    @Qualifier(value="primaryDataSource")
    private DruidDataSource primaryDataSource;
    @Value(value="${nebula.scanPackages}")
    private String[] scanPackages;
    @Value(value="${nebula.datasourceCount}")
    private int datasourceCount;

    @Primary
    @Bean(name={"entityManager"})
    public EntityManager entityManager(EntityManagerFactoryBuilder builder) {
        return this.entityManagerFactoryPrimary(builder).getObject().createEntityManager();
    }

    @Primary
    @Bean(name={"entityManagerFactory"})
    public LocalContainerEntityManagerFactoryBean entityManagerFactoryPrimary(EntityManagerFactoryBuilder builder) {
        String[] entityPackages = this.datasourceCount > 1 ? new String[]{"com.bizunited.platform.rbac.server.vo", "com.bizunited.platform.core.entity", "com.bizunited.platform.kuiper.entity", "com.bizunited.platform.kuiper.vo", "com.bizunited.platform.user.service.local.entity", "com.bizunited.platform.rbac.server.starter.entity", "com.bizunited.platform.titan.starter.entity", "com.bizunited.platform.dictionary.service.local.entity", "com.bizunited.platform.venus.service.local.entity"} : this.scanPackages;
        return builder.dataSource((DataSource)this.primaryDataSource).properties(this.jpaProperties.getProperties()).properties(this.getVendorProperties()).packages(entityPackages).persistenceUnit("primaryPersistenceUnit").build();
    }

    private Map<String, ?> getVendorProperties() {
        return this.hibernateProperties.determineHibernateProperties(this.jpaProperties.getProperties(), new HibernateSettings());
    }

    @Primary
    @Bean(name={"transactionManager"})
    public PlatformTransactionManager transactionManagerPrimary(EntityManagerFactoryBuilder builder) {
        return new JpaTransactionManager(this.entityManagerFactoryPrimary(builder).getObject());
    }
}

