/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.core.controller;

import com.bizunited.platform.common.controller.BaseController;
import com.bizunited.platform.common.controller.model.ResponseModel;
import com.bizunited.platform.core.entity.log.LoggerInfoEntity;
import com.bizunited.platform.core.service.LoggerInfoEntityService;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v1/loggerInfos"})
public class LoggerInfoEntityController
extends BaseController {
    private static final Logger LOGGER = LoggerFactory.getLogger(LoggerInfoEntityController.class);
    @Autowired
    private LoggerInfoEntityService loggerInfoEntityService;

    @ApiOperation(value="\u6309\u7167\u6307\u5b9a\u7684\u6a21\u5757\u548c\u64cd\u4f5c\u4e1a\u52a1\u7f16\u53f7\uff0c\u67e5\u8be2\u7b26\u5408\u6761\u4ef6\u7684\u65e5\u5fd7\u4fe1\u606f\uff0c\u5e76\u6309\u7167\u65e5\u5fd7\u4e8b\u4ef6\u8fdb\u884c\u5012\u5e8f\u6392\u5217")
    @RequestMapping(value={"/findByOpidAndModule"}, method={RequestMethod.GET})
    public ResponseModel findByOpidAndModule(@RequestParam(value="opid") @ApiParam(name="opid", value="\u6307\u5b9a\u7684\u4e1a\u52a1\u7f16\u53f7") String opid, @RequestParam(value="module") @ApiParam(name="module", value="\u6307\u5b9a\u7684\u4e1a\u52a1\u6a21\u5757\u4fe1\u606f") String module, @PageableDefault(value=50) @ApiParam(value="\u5206\u9875\u53c2\u6570\uff0c\u5f53\u6307\u5b9apage\u65f6\u4e3a\u67e5\u8be2\u5f53\u524d\u9875\u7801\uff08\u9875\u7801\u4ece0\u5f00\u59cb\uff09\uff1b\u5f53\u6307\u5b9asize\u65f6\uff0c\u4e3a\u6307\u5b9a\u6bcf\u9875\u5927\u5c0f\uff0c\u9ed8\u8ba4\u4e3a50") Pageable pageable) {
        try {
            Page<LoggerInfoEntity> result = this.loggerInfoEntityService.findByOpidAndModule(opid, module, pageable);
            return this.buildHttpResultW(result, new String[]{""});
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }
}

