/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.core.controller;

import com.bizunited.platform.common.controller.BaseController;
import com.bizunited.platform.common.controller.model.ResponseModel;
import com.bizunited.platform.core.entity.MigrateImportEntity;
import com.bizunited.platform.core.service.migrate.MigrateImportService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@Api(value="MigrateImportController")
@RestController
@RequestMapping(value={"/v1/nebula/migrationsImport"})
public class MigrateImportController
extends BaseController {
    @Autowired
    private MigrateImportService migrateImportService;
    private static final Logger LOGGER = LoggerFactory.getLogger(MigrateImportController.class);

    @ApiOperation(value="\u4e0a\u4f20\u8fc1\u5165\u6587\u4ef6")
    @RequestMapping(value={"/upload"}, method={RequestMethod.POST})
    public ResponseModel upload(@RequestParam(name="file", required=true) @ApiParam(required=true, value="\u8fc1\u5165\u6587\u4ef6\u5bf9\u8c61") MultipartFile file, @RequestParam @ApiParam(value="\u8fc1\u79fb\u6570\u636e\u7c7b\u578b,1:\u7f16\u7801\u89c4\u5219\uff0c2\uff1a\u6570\u636e\u89c6\u56fe\uff0c3\uff1a\u5168\u5c40\u53c2\u6570\uff0c4\uff1a\u6570\u636e\u5b57\u5178\uff0c5\uff1a\u8fdc\u7aef\u670d\u52a1\u6e90\uff0c6\uff1a\u8868\u5355\u6a21\u7248\uff0c7\uff1a\u5217\u8868\u6a21\u7248\uff0c8\uff1a\u5168\u5c40\u51fd\u6570") Integer dataType) {
        try {
            MigrateImportEntity entity = this.migrateImportService.upload(file, dataType);
            return this.buildHttpResultW((Object)entity, new String[]{"creator", "executor"});
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @PostMapping(value={"execute"})
    @ApiOperation(value="\u6839\u636eID\u6267\u884c\u5bfc\u5165")
    public ResponseModel execute(@RequestParam @ApiParam(value="\u5bfc\u5165ID") String id, @RequestParam(defaultValue="0") @ApiParam(value="\u5bfc\u5165\u6267\u884c\u6a21\u5f0f0\uff1a\u5df2\u5b58\u5728\u8df3\u8fc7\uff0c1\uff1a\u5df2\u5b58\u5728\u65b0\u589e\uff0c2\uff1a\u5df2\u5b58\u5728\u66f4\u65b0") Integer mode) {
        try {
            MigrateImportEntity migrateImport = this.migrateImportService.execute(id, mode);
            return this.buildHttpResultW((Object)migrateImport, new String[]{"detail"});
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u6839\u636eID\u67e5\u8be2\u8be6\u60c5")
    @GetMapping(value={"findDetailsById"})
    public ResponseModel findDetailsById(@RequestParam(required=true) @ApiParam(value="\u4e3b\u952eID", required=true) String id) {
        try {
            MigrateImportEntity migrateImport = this.migrateImportService.findDetailsById(id);
            return this.buildHttpResultW((Object)migrateImport, new String[]{"detail"});
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @GetMapping(value={"findDetailsByDataType"})
    @ApiOperation(value="\u6839\u636e\u6570\u636e\u7c7b\u578b\u67e5\u8be2\u5bfc\u5165\u65e5\u5fd7")
    public ResponseModel findDetailsByDataType(Integer dataType) {
        try {
            List<MigrateImportEntity> migrateImports = this.migrateImportService.findDetailsByDataType(dataType);
            return this.buildHttpResultW(migrateImports, new String[]{"createUser", "executeUser"});
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }
}

