/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.core.controller.dataview;

import com.bizunited.platform.common.controller.BaseController;
import com.bizunited.platform.common.controller.model.ResponseModel;
import com.bizunited.platform.core.entity.DataViewAuthEntity;
import com.bizunited.platform.core.service.dataview.DataViewAuthService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(value="\u6570\u636e\u6743\u9650")
@RequestMapping(value={"/v1/nebula/dataview/auths"})
public class DataViewAuthController
extends BaseController {
    private static final Logger LOGGER = LoggerFactory.getLogger(DataViewAuthController.class);
    private static final String[] WHITE_DETAILS = new String[]{"dataView", "horizontalAuths", "horizontalAuths.authRelations", "verticalAuths.authRelations.relation", "verticalAuths", "verticalAuths.authRelations", "horizontalAuths.authRelations.relation", "interceptors", "preAuths"};
    @Autowired
    private DataViewAuthService dataViewAuthService;

    @PostMapping(value={""})
    @ApiOperation(value="\u521b\u5efa\u6570\u636e\u6743\u9650")
    public ResponseModel create(@RequestBody DataViewAuthEntity dataViewAuth) {
        try {
            DataViewAuthEntity result = this.dataViewAuthService.create(dataViewAuth);
            return this.buildHttpResultW((Object)result, WHITE_DETAILS);
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @PatchMapping(value={""})
    @ApiOperation(value="\u66f4\u65b0\u6570\u636e\u6743\u9650")
    public ResponseModel update(@RequestBody DataViewAuthEntity dataViewAuth) {
        try {
            DataViewAuthEntity result = this.dataViewAuthService.update(dataViewAuth);
            return this.buildHttpResultW((Object)result, new String[0]);
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @GetMapping(value={"findDetailsByCode"})
    @ApiOperation(value="\u6839\u636e\u6743\u9650\u7f16\u7801\u83b7\u53d6\u6743\u9650\u8be6\u60c5")
    public ResponseModel findDetailsByCode(@RequestParam @ApiParam(value="\u6743\u9650\u7f16\u7801") String code) {
        try {
            DataViewAuthEntity auth = this.dataViewAuthService.findDetailsByCode(code);
            return this.buildHttpResultW((Object)auth, WHITE_DETAILS);
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @GetMapping(value={"findByDataView"})
    @ApiOperation(value="\u6839\u636e\u6570\u636e\u89c6\u56fe\u7f16\u7801\u83b7\u53d6\u6743\u9650")
    public ResponseModel findByDataView(@RequestParam @ApiParam(value="\u6570\u636e\u89c6\u56fe\u7f16\u7801") String dataViewCode) {
        try {
            Set<DataViewAuthEntity> auths = this.dataViewAuthService.findByDataView(dataViewCode);
            return this.buildHttpResultW(auths, new String[0]);
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u6839\u636eID\u5220\u9664")
    @DeleteMapping(value={"deleteById"})
    public ResponseModel deleteById(@RequestParam @ApiParam(value="\u4e3b\u952eID") String id) {
        try {
            this.dataViewAuthService.deleteById(id);
            return this.buildHttpResult();
        }
        catch (RuntimeException e) {
            return this.buildHttpResultForException(e);
        }
    }
}

