/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.core.controller.dataview;

import com.bizunited.platform.common.controller.BaseController;
import com.bizunited.platform.common.controller.model.ResponseModel;
import com.bizunited.platform.core.entity.DataViewAuthHorizontalEntity;
import com.bizunited.platform.core.service.dataview.DataViewAuthHorizontalService;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v1/nebula/dataViewAuthHorizontals"})
public class DataViewAuthHorizontalController
extends BaseController {
    private static final Logger LOGGER = LoggerFactory.getLogger(DataViewAuthHorizontalController.class);
    @Autowired
    private DataViewAuthHorizontalService dataViewAuthHorizontalService;

    @PostMapping(value={""})
    @ApiOperation(value="\u4fdd\u5b58\u6a2a\u5411\u6570\u636e\u6743\u9650")
    public ResponseModel save(@RequestParam @ApiParam(value="\u6743\u9650ID") String authId, @RequestBody @ApiParam(value="\u6a2a\u5411\u6743\u9650\u6570\u636e") Set<DataViewAuthHorizontalEntity> horizontals) {
        try {
            Set<DataViewAuthHorizontalEntity> authHorizontals = this.dataViewAuthHorizontalService.save(authId, horizontals);
            return this.buildHttpResultW(authHorizontals, new String[]{"dataViewAuth", "authRelations", "preRule", "authType"});
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u6839\u636e\u6570\u636e\u6743\u9650\u7f16\u7801code\uff0c\u83b7\u53d6\u6a2a\u5411\u6743\u9650\u8be6\u60c5")
    @RequestMapping(value={"/findDetailsByAuthCode"}, method={RequestMethod.GET})
    public ResponseModel findDetailsByAuthCode(@ApiParam(name="\u6839\u636e\u6570\u636e\u6743\u9650\u7f16\u7801code\uff0c\u83b7\u53d6\u6a2a\u5411\u6743\u9650\u8be6\u60c5") @RequestParam(value="authCode") String authCode) {
        try {
            Set<DataViewAuthHorizontalEntity> authHorizontals = this.dataViewAuthHorizontalService.findDetailsByAuthCode(authCode);
            return this.buildHttpResultW(authHorizontals, new String[]{"dataViewAuth", "authRelations", "preRule", "authType", "authRelations", "authRelations.relation"});
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }
}

