/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.core.repository.dataview;

import com.bizunited.platform.core.repository.dataview.DataViewThirdDataSourceRepository;
import com.bizunited.platform.core.repository.dynamic.DynamicDataSourceManager;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import org.apache.commons.lang3.Validate;
import org.hibernate.SessionFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.orm.hibernate5.SessionFactoryUtils;
import org.springframework.stereotype.Repository;

@Repository(value="DataViewThirdDataSourceRepositoryImpl")
public class DataViewThirdDataSourceRepositoryImpl
implements DataViewThirdDataSourceRepository {
    @Autowired
    private DynamicDataSourceManager dynamicDataSourceManager;
    private static final String ERROR_SQL = "SQL\u6267\u884c\u5f02\u5e38\uff0c\u8bf7\u68c0\u67e5!!\u8be6\u60c5\uff1a";

    @Override
    public void checkTable(String dataSourceCode, String tableName) {
        Validate.notBlank((CharSequence)tableName, (String)"\u8f93\u5165\u6570\u636e\u8868\u540d\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dataSourceCode, (String)"\u8f93\u5165\u7b2c\u4e09\u65b9\u6570\u636e\u6e90\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\uff01", (Object[])new Object[0]);
        SessionFactory sessionFactory = this.dynamicDataSourceManager.getCurrentSessionFactory(dataSourceCode);
        try (Connection connection = SessionFactoryUtils.getDataSource((SessionFactory)sessionFactory).getConnection();){
            DatabaseMetaData md = connection.getMetaData();
            try (ResultSet rs = md.getTables(null, null, tableName, null);){
                Validate.isTrue((boolean)rs.next(), (String)"\u6240\u8bbe\u7f6e\u7b2c\u4e09\u65b9\u6570\u636e\u6e90\u4e2d\u57fa\u7840\u8868\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\uff01", (Object[])new Object[0]);
            }
        }
        catch (Exception e) {
            throw new IllegalArgumentException(ERROR_SQL + e.getMessage());
        }
    }
}

