/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.core.repository.dataview.analysis;

import com.bizunited.platform.core.entity.DataViewAuthEntity;
import com.bizunited.platform.core.entity.DataViewAuthInterceptorEntity;
import com.bizunited.platform.core.repository.dataview.analysis.SQLAuthHorizontalAnalysis;
import com.bizunited.platform.core.repository.dataview.analysis.SQLAuthVerticalAnalysis;
import com.bizunited.platform.core.repository.dataview.analysis.SQLConditionFilterAnalysis;
import com.bizunited.platform.core.repository.dataview.analysis.SQLOrderbyAnalysis;
import com.bizunited.platform.core.repository.dataview.analysis.SQLSystemParamAnalysis;
import com.bizunited.platform.core.repository.dataview.analysis.SqlAnalysis;
import com.bizunited.platform.core.service.dataview.executor.InterceptorExecutor;
import com.bizunited.platform.core.service.dataview.model.ExecuteContextModel;
import java.util.Set;
import org.springframework.util.CollectionUtils;

public abstract class AbstractSqlAnalysis
implements SqlAnalysis {
    protected static final String ERROR_SQL = "SQL\u6267\u884c\u4f20\u5165\u7684\u7684\u53c2\u6570";
    protected ExecuteContextModel executeContext;

    public AbstractSqlAnalysis(ExecuteContextModel executeContext) {
        this.executeContext = executeContext;
    }

    @Override
    public void analysis() {
        this.executeContext.setExecuteSql(this.executeContext.getDataView().getSourceSql());
        SQLAuthVerticalAnalysis.buildSQLAuthVertical(this.executeContext);
        SQLSystemParamAnalysis.buildSystemParamAnalysis(this.executeContext);
        SQLConditionFilterAnalysis.buildSQLConditions(this.executeContext);
        SQLAuthHorizontalAnalysis.buildSQLAuthHorizoncal(this.executeContext);
        this.interceptor();
        SQLOrderbyAnalysis.buildOrderBy(this.executeContext);
        this.pageAnalysis();
    }

    abstract void pageAnalysis();

    protected void interceptor() {
        DataViewAuthEntity dataViewAuth = this.executeContext.getDataViewAuth();
        if (dataViewAuth == null) {
            return;
        }
        Set<DataViewAuthInterceptorEntity> interceptors = dataViewAuth.getInterceptors();
        if (CollectionUtils.isEmpty(interceptors)) {
            return;
        }
        new InterceptorExecutor(this.executeContext, interceptors).execute();
    }
}

