/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.core.repository.dataview.analysis;

import com.bizunited.platform.core.repository.dataview.analysis.AbstractSqlAnalysis;
import com.bizunited.platform.core.service.dataview.model.ExecuteContextModel;
import com.bizunited.platform.core.service.dataview.model.PageableModel;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;

public class MysqlAnalysis
extends AbstractSqlAnalysis {
    public MysqlAnalysis(ExecuteContextModel executeContext) {
        super(executeContext);
    }

    @Override
    protected void pageAnalysis() {
        PageableModel pageable = this.executeContext.getExecuteParam().getPageable();
        if (pageable == null) {
            return;
        }
        Validate.isTrue((pageable.getPage() >= 0 ? 1 : 0) != 0, (String)"\u5206\u9875\u9875\u7801\u4e0d\u80fd\u5c0f\u4e8e0", (Object[])new Object[0]);
        Validate.isTrue((pageable.getSize() > 0 ? 1 : 0) != 0, (String)"\u5206\u9875\u5927\u5c0f\u4e0d\u80fd\u5c0f\u4e8e1", (Object[])new Object[0]);
        String executeSql = this.executeContext.getExecuteSql();
        String countSQL = String.format("select count(*) from (%s) a", executeSql);
        int pageStart = pageable.getPage() * pageable.getSize();
        this.executeContext.addExecuteCountSqlParameters(this.executeContext.getExecuteSqlParameters());
        this.executeContext.addExecuteSqlParameter(pageStart);
        this.executeContext.addExecuteSqlParameter(pageable.getSize());
        this.executeContext.appendExecuteSql(" limit ?,?");
        this.executeContext.setExecuteCountSql(countSQL);
    }

    @Override
    public String concatSql(String ... strs) {
        if (strs == null || strs.length == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder("concat(");
        sb.append(StringUtils.join((Object[])strs, (String)",")).append(")");
        return sb.toString();
    }
}

