/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.core.repository.dataview.analysis;

import com.bizunited.platform.core.repository.dataview.analysis.AbstractSqlAnalysis;
import com.bizunited.platform.core.service.dataview.model.ExecuteContextModel;
import com.bizunited.platform.core.service.dataview.model.PageableModel;
import org.apache.commons.lang3.StringUtils;

public class OracleSqlAnalysis
extends AbstractSqlAnalysis {
    public OracleSqlAnalysis(ExecuteContextModel executeContext) {
        super(executeContext);
    }

    @Override
    protected void pageAnalysis() {
        PageableModel pageable = this.executeContext.getExecuteParam().getPageable();
        if (pageable == null) {
            return;
        }
        String executeSql = this.executeContext.getExecuteSql();
        String countSQL = String.format("select count(*) from (%s) a", executeSql);
        int start = pageable.getPage() * pageable.getSize();
        int end = (pageable.getPage() + 1) * pageable.getSize();
        executeSql = String.format("select * from (select %s.*,ROWNUM RN from (%s) %s where ROWNUM <= ?) %s where RN > ?", "s02y02s02", executeSql, "s02y02s02", "s03y03s03");
        this.executeContext.setExecuteSql(executeSql);
        this.executeContext.addExecuteCountSqlParameters(this.executeContext.getExecuteSqlParameters());
        this.executeContext.addExecuteSqlParameter(end);
        this.executeContext.addExecuteSqlParameter(start);
        this.executeContext.setExecuteCountSql(countSQL);
    }

    @Override
    public String concatSql(String ... strs) {
        if (strs == null || strs.length == 0) {
            return "";
        }
        return StringUtils.join((Object[])strs, (String)"||");
    }
}

