/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.core.repository.dataview.analysis;

import com.bizunited.platform.core.common.enums.SqlOperatorEnum;
import com.bizunited.platform.core.entity.DataViewAuthEntity;
import com.bizunited.platform.core.entity.DataViewAuthHorizontalEntity;
import com.bizunited.platform.core.entity.DataViewAuthHorizontalRelationEntity;
import com.bizunited.platform.core.entity.DataViewFieldEntity;
import com.bizunited.platform.core.repository.dataview.analysis.SQLPresetValueAnalysis;
import com.bizunited.platform.core.repository.dataview.analysis.SqlParamAnalysis;
import com.bizunited.platform.core.service.dataview.model.ExecuteContextModel;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.Validate;
import org.springframework.util.CollectionUtils;

class SQLAuthHorizontalAnalysis {
    private SQLAuthHorizontalAnalysis() {
    }

    public static void buildSQLAuthHorizoncal(ExecuteContextModel executeContext) {
        DataViewAuthEntity auth = executeContext.getDataViewAuth();
        if (auth == null) {
            return;
        }
        Set<DataViewAuthHorizontalEntity> horizontals = auth.getHorizontalAuths();
        if (CollectionUtils.isEmpty(horizontals)) {
            return;
        }
        Set<DataViewFieldEntity> fields = executeContext.getDataViewFields();
        Map<String, DataViewFieldEntity> fieldsMap = fields.stream().collect(Collectors.toMap(DataViewFieldEntity::getFieldName, f -> f));
        for (DataViewAuthHorizontalEntity horizontal : horizontals) {
            DataViewFieldEntity field = fieldsMap.get(horizontal.getFieldName());
            Validate.notNull((Object)"\u672a\u627e\u5230\u6570\u636e\u89c6\u56fe\u5b57\u6bb5\uff1a%s", (String)horizontal.getFieldName(), (Object[])new Object[0]);
            Object value = SQLAuthHorizontalAnalysis.getConditionValue(executeContext, horizontal);
            SqlParamAnalysis.handleParamCondition(executeContext, horizontal.getFieldName(), field.getFieldType(), horizontal.getOprtType(), value);
        }
    }

    private static Object getConditionValue(ExecuteContextModel executeContext, DataViewAuthHorizontalEntity horizontal) {
        Integer sourceType = horizontal.getParamSourceType();
        switch (sourceType) {
            case 2: {
                return SQLAuthHorizontalAnalysis.getRelationValue(horizontal);
            }
            case 3: {
                SQLPresetValueAnalysis sqlPresetValueAnalysis = executeContext.getSqlPresetValueAnalysis();
                return sqlPresetValueAnalysis.getPresetValue(horizontal.getParamKey(), horizontal.getLevel());
            }
        }
        throw new IllegalArgumentException(String.format("\u4e0d\u80fd\u8bc6\u522b\u53c2\u6570\u6765\u6e90\uff1a%s", sourceType));
    }

    private static Object getRelationValue(DataViewAuthHorizontalEntity horizontal) {
        SqlOperatorEnum operator = SqlOperatorEnum.valueOf(horizontal.getOprtType());
        Set<DataViewAuthHorizontalRelationEntity> relations = horizontal.getAuthRelations();
        if (operator == SqlOperatorEnum.EQ || operator == SqlOperatorEnum.NEQ) {
            Validate.isTrue((relations != null && relations.size() == 1 ? 1 : 0) != 0, (String)"\u6a2a\u5411\u6743\u9650\u3010%s\u3011\u7684\u56fa\u5b9a\u503c\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5", (Object[])new Object[]{horizontal.getFieldName()});
            DataViewAuthHorizontalRelationEntity relation = relations.iterator().next();
            return relation.getAuthRelationIds();
        }
        if (operator == SqlOperatorEnum.IN || operator == SqlOperatorEnum.NIN) {
            Validate.notEmpty(relations, (String)"\u6a2a\u5411\u6743\u9650\u3010%s\u3011\u7684\u56fa\u5b9a\u503c\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5", (Object[])new Object[]{horizontal.getFieldName()});
            return relations.stream().map(DataViewAuthHorizontalRelationEntity::getAuthRelationIds).collect(Collectors.toList());
        }
        throw new IllegalArgumentException(String.format("\u4e0d\u80fd\u8bc6\u522b\u7684\u6a2a\u5411\u6743\u9650\u64cd\u4f5c\u7b26\uff1a%s", horizontal.getOprtType()));
    }
}

