/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.core.repository.dataview.analysis;

import com.bizunited.platform.core.entity.DataViewSystemEntity;
import com.bizunited.platform.core.repository.dataview.analysis.SQLPresetValueAnalysis;
import com.bizunited.platform.core.repository.dataview.analysis.SqlParamAnalysis;
import com.bizunited.platform.core.service.dataview.model.ExecuteContextModel;
import com.bizunited.platform.core.service.dataview.model.ExecuteParamModel;
import com.google.common.collect.Sets;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang3.Validate;
import org.springframework.util.CollectionUtils;

class SQLSystemParamAnalysis {
    private SQLSystemParamAnalysis() {
    }

    static void buildSystemParamAnalysis(ExecuteContextModel executeContext) {
        HashSet systemFilters = executeContext.getSystemFilters();
        if (CollectionUtils.isEmpty(systemFilters)) {
            systemFilters = Sets.newHashSet();
        }
        Map<String, DataViewSystemEntity> filterMap = systemFilters.stream().collect(Collectors.toMap(DataViewSystemEntity::getParamName, s -> s));
        String executeSql = executeContext.getExecuteSql();
        Pattern p = Pattern.compile("\\{\\:[a-zA-Z]{1}\\w*\\}");
        Matcher matcher = p.matcher(executeSql);
        HashMap<String, String> groupMap = new HashMap<String, String>();
        while (matcher.find()) {
            String group = matcher.group();
            String paramName = group.substring(2, group.length() - 1);
            DataViewSystemEntity filter = filterMap.get(paramName);
            Validate.notNull((Object)((Object)filter), (String)"\u672a\u627e\u5230\u53c2\u6570\u7684\u914d\u7f6e\uff1a%s", (Object[])new Object[]{paramName});
            Object value = SQLSystemParamAnalysis.getParamValue(executeContext, filter, paramName);
            String replace = SqlParamAnalysis.handleAndGetParamReplaceStr(executeContext, paramName, filter.getParamType(), value);
            groupMap.put(group, replace);
        }
        for (Map.Entry entry : groupMap.entrySet()) {
            executeSql = executeSql.replace((CharSequence)entry.getKey(), (CharSequence)entry.getValue());
        }
        executeContext.setExecuteSql(executeSql);
    }

    private static Object getParamValue(ExecuteContextModel executeContext, DataViewSystemEntity filter, String paramName) {
        ExecuteParamModel executeParam = executeContext.getExecuteParam();
        switch (filter.getParamSourceType()) {
            case 1: {
                Object value = executeParam.getSystemParam(paramName);
                Validate.notNull((Object)value, (String)"\u9700\u8981\u4f20\u5165\u7cfb\u7edf\u53c2\u6570\uff1a%s", (Object[])new Object[]{paramName});
                return value;
            }
            case 2: {
                return filter.getParamValue();
            }
            case 3: {
                SQLPresetValueAnalysis sqlPresetValueAnalysis = executeContext.getSqlPresetValueAnalysis();
                return sqlPresetValueAnalysis.getPresetValue(filter.getParamValue(), null);
            }
        }
        throw new IllegalArgumentException(String.format("\u4e0d\u80fd\u8bc6\u522b\u53c2\u6570\u6765\u6e90\uff1a%s", filter.getParamSourceType()));
    }
}

