/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.core.repository.dataview.analysis;

import com.bizunited.platform.common.enums.ClassTypeNameEnum;
import com.bizunited.platform.core.common.enums.SqlOperatorEnum;
import com.bizunited.platform.core.repository.dataview.analysis.SqlAnalysis;
import com.bizunited.platform.core.repository.dataview.analysis.SqlParamFormater;
import com.bizunited.platform.core.service.dataview.model.ExecuteContextModel;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;

public class SqlParamAnalysis {
    private SqlParamAnalysis() {
        throw new IllegalStateException("\u9759\u6001\u7c7b\u4e0d\u80fd\u5b9e\u4f8b\u5316");
    }

    public static void handleParamCondition(ExecuteContextModel executeContext, String paramName, String paramType, String opType, Object value) {
        Validate.notBlank((CharSequence)opType, (String)"\u64cd\u4f5c\u7b26\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        SqlOperatorEnum operator = SqlOperatorEnum.valueOf(opType);
        Validate.notNull((Object)((Object)operator), (String)"\u4e0d\u652f\u6301\u7684\u64cd\u4f5c\u7b26\uff1a%s", (Object[])new Object[]{opType});
        switch (operator) {
            case NEQ: 
            case EQ: 
            case GT: 
            case LT: 
            case GE: 
            case LE: {
                SqlParamAnalysis.handleNormalCondition(executeContext, paramName, paramType, operator, value);
                break;
            }
            case LC_RC: 
            case LO_RC: 
            case LO_RO: 
            case LC_RO: 
            case BETWEEN: {
                SqlParamAnalysis.handleRegionCondition(executeContext, paramName, paramType, operator, value);
                break;
            }
            case IN: 
            case NIN: {
                SqlParamAnalysis.handleInCondition(executeContext, paramName, paramType, operator, value);
                break;
            }
            case LLIKE: 
            case RLIKE: 
            case LIKE: {
                SqlParamAnalysis.handleLikeCondition(executeContext, paramName, paramType, operator, value);
                break;
            }
            default: {
                throw new IllegalArgumentException(String.format("\u4e0d\u652f\u6301\u7684\u64cd\u4f5c\u7b26:%s", operator.getOprtValue()));
            }
        }
    }

    private static void handleNormalCondition(ExecuteContextModel executeContext, String paramName, String paramType, SqlOperatorEnum operator, Object value) {
        Object formatValue = SqlParamFormater.format(paramType, value);
        String sqlAlias = executeContext.getWrapperSqlAlias();
        String condition = String.format(" and %s.%s %s %s", sqlAlias, paramName, operator.getOprtValue(), "?");
        executeContext.appendExecuteSql(condition);
        executeContext.addExecuteSqlParameter(formatValue);
    }

    private static void handleLikeCondition(ExecuteContextModel executeContext, String paramName, String paramType, SqlOperatorEnum operator, Object value) {
        String concat;
        SqlAnalysis sqlAnalysis = executeContext.getSqlAnalysis();
        String sqlAlias = executeContext.getWrapperSqlAlias();
        switch (operator) {
            case LLIKE: {
                concat = sqlAnalysis.concatSql("'%%'", "?");
                break;
            }
            case RLIKE: {
                concat = sqlAnalysis.concatSql("?", "'%%'");
                break;
            }
            case LIKE: {
                concat = sqlAnalysis.concatSql("'%%'", "?", "'%%'");
                break;
            }
            default: {
                throw new IllegalArgumentException(String.format("\u4e0d\u652f\u6301\u7684\u64cd\u4f5c\u7b26:%s", operator.getOprtValue()));
            }
        }
        String condition = String.format(" and %s.%s like %s", sqlAlias, paramName, concat);
        executeContext.appendExecuteSql(condition);
        executeContext.addExecuteSqlParameter(value == null ? value : value.toString());
    }

    private static void handleInCondition(ExecuteContextModel executeContext, String paramName, String paramType, SqlOperatorEnum operator, Object value) {
        List<Object> values = SqlParamAnalysis.getArrayValue(value);
        String sqlAlias = executeContext.getWrapperSqlAlias();
        String replace = SqlParamAnalysis.handleAndGetParamReplaceStr(executeContext, paramName, paramType, values);
        String condition = String.format(" and %s.%s %s %s ", sqlAlias, paramName, operator.getOprtValue(), replace);
        executeContext.appendExecuteSql(condition);
    }

    private static void handleRegionCondition(ExecuteContextModel executeContext, String paramName, String paramType, SqlOperatorEnum operator, Object value) {
        String format;
        String sqlAlias = executeContext.getWrapperSqlAlias();
        Validate.isTrue((boolean)SqlParamAnalysis.isArray(value), (String)"\u53c2\u6570\u3010%s\u3011\u5728\u4f7f\u7528\u64cd\u4f5c\u7b26\u3010%s\u3011\u65f6\u4f20\u5165\u7684\u53c2\u6570\u3010%s\u3011\u975e\u4e24\u4f4d\u6570\u7ec4", (Object[])new Object[]{paramName, operator.getOprtValue(), value});
        List<Object> values = SqlParamAnalysis.getArrayValue(value);
        Validate.isTrue((values.size() == 2 ? 1 : 0) != 0, (String)"\u53c2\u6570\u3010%s\u3011\u5728\u4f7f\u7528\u64cd\u4f5c\u7b26\u3010%s\u3011\u65f6\u4f20\u5165\u7684\u53c2\u6570\u3010%s\u3011\u975e\u4e24\u4f4d\u6570\u7ec4", (Object[])new Object[]{paramName, operator.getOprtValue(), value});
        switch (operator) {
            case LC_RC: {
                format = " and %s.%s >= ? and %s.%s <= ? ";
                break;
            }
            case LO_RC: {
                format = " and %s.%s > ? and %s.%s <= ? ";
                break;
            }
            case LO_RO: {
                format = " and %s.%s > ? and %s.%s < ? ";
                break;
            }
            case LC_RO: {
                format = " and %s.%s >= ? and %s.%s < ? ";
                break;
            }
            case BETWEEN: {
                format = " and %s.%s between ? and ? ";
                break;
            }
            default: {
                throw new IllegalArgumentException(String.format("\u4e0d\u652f\u6301\u7684\u64cd\u4f5c\u7b26:%s", operator.getOprtValue()));
            }
        }
        String condition = operator.equals((Object)SqlOperatorEnum.BETWEEN) ? String.format(format, sqlAlias, paramName) : String.format(format, sqlAlias, paramName, sqlAlias, paramName);
        executeContext.appendExecuteSql(condition);
        ClassTypeNameEnum classType = ClassTypeNameEnum.valueOfClassName((String)paramType);
        if (classType != null && (classType == ClassTypeNameEnum.DATE || classType == ClassTypeNameEnum.TIMESTAMP)) {
            values = SqlParamAnalysis.handleRegionDateValues(values);
        }
        for (Object v : values) {
            executeContext.addExecuteSqlParameter(SqlParamFormater.format(paramType, v));
        }
    }

    private static List<Object> handleRegionDateValues(List<Object> values) {
        Calendar calendar;
        Object start = SqlParamFormater.formatDate(values.get(0));
        Object end = SqlParamFormater.formatDate(values.get(1));
        if (start != null && Date.class.isAssignableFrom(start.getClass())) {
            calendar = Calendar.getInstance();
            calendar.setTime((Date)start);
            calendar.set(11, 0);
            calendar.set(12, 0);
            calendar.set(13, 0);
            calendar.set(14, 0);
            values.set(0, calendar.getTime());
        }
        if (end != null && Date.class.isAssignableFrom(end.getClass())) {
            calendar = Calendar.getInstance();
            calendar.setTime((Date)end);
            calendar.set(11, 23);
            calendar.set(12, 59);
            calendar.set(13, 59);
            calendar.set(14, 999);
            values.set(1, calendar.getTime());
        }
        return values;
    }

    public static String handleAndGetParamReplaceStr(ExecuteContextModel executeContext, String paramName, String paramType, Object value) {
        if (value == null) {
            executeContext.addExecuteSqlParameter(value);
            return "?";
        }
        if (value.getClass().isArray() || Iterable.class.isAssignableFrom(value.getClass())) {
            List<Object> values = SqlParamAnalysis.getArrayValue(value);
            Validate.notEmpty(values, (String)"\u4f20\u5165\u7684\u53c2\u6570\u4e3a\u7a7a\uff1a%s", (Object[])new Object[]{paramName});
            StringBuilder replace = new StringBuilder();
            replace.append("(");
            ArrayList<String> holders = new ArrayList<String>();
            for (Object obj : values) {
                holders.add("?");
                executeContext.addExecuteSqlParameter(SqlParamFormater.format(paramType, obj));
            }
            replace.append(StringUtils.join(holders, (String)","));
            replace.append(")");
            return replace.toString();
        }
        executeContext.addExecuteSqlParameter(SqlParamFormater.format(paramType, value));
        return "?";
    }

    private static boolean isArray(Object value) {
        if (value == null) {
            return false;
        }
        return value.getClass().isArray() || Iterable.class.isAssignableFrom(value.getClass());
    }

    private static List<Object> getArrayValue(Object value) {
        ArrayList<Object> values = new ArrayList<Object>();
        if (value.getClass().isArray()) {
            Object[] objs;
            for (Object obj : objs = (Object[])value) {
                values.add(obj);
            }
        } else if (Iterable.class.isAssignableFrom(value.getClass())) {
            Iterable iterable = (Iterable)value;
            iterable.forEach(v -> values.add(v));
        } else {
            values.add(value);
        }
        return values;
    }
}

