/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.core.repository.dynamic;

import com.alibaba.druid.pool.DruidDataSource;
import com.bizunited.platform.common.enums.NormalStatusEnum;
import com.bizunited.platform.core.common.PlatformContext;
import com.bizunited.platform.core.entity.DataSourceEntity;
import com.bizunited.platform.core.entity.DataSourceTableEntity;
import com.bizunited.platform.core.entity.DataViewEntity;
import com.bizunited.platform.core.entity.DataViewGroupEntity;
import com.bizunited.platform.core.repository.DataSourceTableRepository;
import com.bizunited.platform.core.repository.dataview.DataSourceRepository;
import com.bizunited.platform.core.repository.dataview.DataViewGroupRepository;
import com.bizunited.platform.core.repository.dataview.DataViewRepository;
import com.bizunited.platform.core.repository.dynamic.DynamicDataSourceManager;
import com.bizunited.platform.rbac.server.crypto.password.Aes2PasswordEncoder;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.sql.DataSource;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.hibernate.SessionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.orm.hibernate5.LocalSessionFactoryBean;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component(value="DynamicDataSourceManagerImpl")
public class DynamicDataSourceManagerImpl
implements DynamicDataSourceManager {
    @Autowired
    private PlatformContext platformContext;
    @Autowired
    private ApplicationContext ctx;
    @Autowired
    private DataSourceRepository dataSourceRepository;
    @Autowired
    private DataViewGroupRepository dataViewGroupRepository;
    @Autowired
    private DataViewRepository dataViewRepository;
    @Autowired
    private Aes2PasswordEncoder passwordEncoder;
    @Autowired
    private DataSourceTableRepository dataSourceTableRepository;
    private ReentrantReadWriteLock readWriteLock = new ReentrantReadWriteLock();
    private static final Logger LOGGER = LoggerFactory.getLogger(DynamicDataSourceManagerImpl.class);
    private static final String ERROR_CODE = "\u672a\u627e\u5230\u6307\u5b9a\u7684\u6570\u636e\u6e90\u540d\u79f0\u4fe1\u606f";
    private static final String ERROR_CODE_NOTNULL = "\u6570\u636e\u6e90\u540d\u79f0\u5fc5\u987b\u4f20\u5165!!";
    private static final String MESS_MYSQL = "mysql";
    private static final String MESS_ORACLE = "oracle";
    private static Map<String, String> jdbcDrives = new HashMap<String, String>();
    private static final String BEANNAMEPREFIX = "_datasource_";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void init() {
        List<DataSourceEntity> dataSources = this.dataSourceRepository.findByTstatusAndProjectName(1, this.platformContext.getAppName());
        if (dataSources == null || dataSources.isEmpty()) {
            return;
        }
        ArrayList<String> arrayErrors = new ArrayList<String>();
        ArrayList<String> errorCode = new ArrayList<String>();
        for (DataSourceEntity dataSourceEntity : dataSources) {
            String code = dataSourceEntity.getCode();
            try {
                this.validate(dataSourceEntity);
            }
            catch (RuntimeException e) {
                errorCode.add(code);
                arrayErrors.add(String.format("\u6570\u636e\u6e90%s\u9a8c\u8bc1\u5931\u8d25\uff0c\u539f\u56e0\uff1a%s\uff1b", code, e.getMessage()));
            }
        }
        if (!arrayErrors.isEmpty()) {
            this.dataSourceRepository.updateDisable(errorCode.toArray(new String[0]));
            throw new IllegalArgumentException(Arrays.toString(arrayErrors.toArray()));
        }
        try {
            this.writeLock();
            for (DataSourceEntity dataSourceEntity : dataSources) {
                this.buildSessionFactory(dataSourceEntity);
            }
        }
        finally {
            this.unWriteLock();
        }
    }

    private void buildSessionFactory(DataSourceEntity dataSourceEntity) {
        String type = dataSourceEntity.getType();
        String password = this.passwordEncoder.decode(dataSourceEntity.getPassword());
        String userName = dataSourceEntity.getUserName();
        String code = dataSourceEntity.getCode();
        String url = this.getUrlFromDataSourceEntity(dataSourceEntity);
        String beanName = StringUtils.join((Object[])new String[]{BEANNAMEPREFIX, code});
        this.unregistSessionFactory(beanName);
        DruidDataSource currentDataSource = this.getDataSource(type, userName, password, url);
        this.registSessionFactory(type, beanName, (DataSource)currentDataSource);
    }

    private void unregistSessionFactory(String beanName) {
        DefaultListableBeanFactory defaultListableBeanFactory = (DefaultListableBeanFactory)this.ctx.getAutowireCapableBeanFactory();
        if (defaultListableBeanFactory.containsBean(beanName)) {
            defaultListableBeanFactory.removeBeanDefinition(beanName);
        }
    }

    private void registSessionFactory(String type, String beanName, DataSource dataSource) {
        DefaultListableBeanFactory defaultListableBeanFactory = (DefaultListableBeanFactory)this.ctx.getAutowireCapableBeanFactory();
        BeanDefinitionBuilder beanDefinitionBuilder = BeanDefinitionBuilder.genericBeanDefinition(LocalSessionFactoryBean.class);
        beanDefinitionBuilder.addPropertyValue("dataSource", (Object)dataSource);
        HashMap<String, String> properties = new HashMap<String, String>();
        if (StringUtils.equalsIgnoreCase((CharSequence)type, (CharSequence)MESS_MYSQL)) {
            properties.put("hibernate.dialect", "org.hibernate.dialect.MySQLDialect");
        } else {
            properties.put("hibernate.dialect", "org.hibernate.dialect.Oracle10gDialect");
        }
        properties.put("hibernate.current_session_context_class", "thread");
        properties.put("hibernate.show_sql", "true");
        properties.put("hibernate.format_sql", "true");
        beanDefinitionBuilder.addPropertyValue("hibernateProperties", properties);
        beanDefinitionBuilder.setLazyInit(false);
        AbstractBeanDefinition beanDefinition = beanDefinitionBuilder.getBeanDefinition();
        defaultListableBeanFactory.registerBeanDefinition(beanName, (BeanDefinition)beanDefinition);
    }

    private DruidDataSource getDataSource(String type, String userName, String password, String url) {
        DruidDataSource dataSource = new DruidDataSource();
        if (StringUtils.equalsIgnoreCase((CharSequence)MESS_MYSQL, (CharSequence)type)) {
            dataSource.setDriverClassName(jdbcDrives.get(MESS_MYSQL));
            dataSource.setPoolPreparedStatements(false);
        } else {
            dataSource.setDriverClassName(jdbcDrives.get(MESS_ORACLE));
        }
        dataSource.setPassword(password);
        dataSource.setUsername(userName);
        dataSource.setUrl(url);
        dataSource.setInitialSize(5);
        dataSource.setMinIdle(2);
        dataSource.setMaxActive(10);
        return dataSource;
    }

    @Override
    public void check(DataSourceEntity dataSource) {
        DataSourceEntity dbDataSource;
        this.validate(dataSource);
        String type = dataSource.getType();
        try {
            if (StringUtils.equalsIgnoreCase((CharSequence)MESS_MYSQL, (CharSequence)type)) {
                Class.forName(jdbcDrives.get(MESS_MYSQL));
            } else {
                Class.forName(jdbcDrives.get(MESS_ORACLE));
            }
        }
        catch (ClassNotFoundException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            throw new IllegalArgumentException(e);
        }
        String username = dataSource.getUserName();
        String password = dataSource.getPassword();
        if (StringUtils.isNotBlank((CharSequence)dataSource.getCode()) && (dbDataSource = this.dataSourceRepository.findByCode(dataSource.getCode())) != null && dbDataSource.getPassword().equals(dataSource.getPassword())) {
            password = this.passwordEncoder.decode(dataSource.getPassword());
        }
        String url = this.getUrlFromDataSourceEntity(dataSource);
        Connection conn = null;
        try {
            conn = DriverManager.getConnection(url, username, password);
        }
        catch (SQLException e) {
            throw new IllegalArgumentException(e);
        }
        finally {
            this.closeConnection(conn);
        }
    }

    private String getUrlFromDataSourceEntity(DataSourceEntity dataSource) {
        if (StringUtils.equalsIgnoreCase((CharSequence)MESS_MYSQL, (CharSequence)dataSource.getType())) {
            if (StringUtils.isBlank((CharSequence)dataSource.getUrlParams())) {
                return String.format("jdbc:mysql://%s:%d/%s", dataSource.getAddress(), dataSource.getPort(), dataSource.getDbName());
            }
            return String.format("jdbc:mysql://%s:%d/%s?%s", dataSource.getAddress(), dataSource.getPort(), dataSource.getDbName(), dataSource.getUrlParams());
        }
        return String.format("jdbc:oracle:thin:@%s:%d:%s", dataSource.getAddress(), dataSource.getPort(), dataSource.getDbName());
    }

    private void closeConnection(Connection conn) {
        try {
            if (conn != null) {
                conn.close();
            }
        }
        catch (SQLException e) {
            throw new IllegalArgumentException(e);
        }
    }

    private void validate(DataSourceEntity dataSource) {
        Validate.notNull((Object)((Object)dataSource), (String)"\u8fdb\u884c\u64cd\u4f5c\u65f6\uff0c\u5fc5\u987b\u5bf9\u6570\u636e\u6e90\u8fdb\u884c\u63cf\u8ff0", (Object[])new Object[0]);
        String address = dataSource.getAddress();
        Validate.notBlank((CharSequence)address, (String)"\u8fdb\u884c\u64cd\u4f5c\u65f6\uff0c\u5fc5\u987b\u4f20\u5165\u6570\u636e\u5e93\u8fde\u63a5\u5730\u5740\uff08IP\u6216\u8005\u57df\u540d\u90fd\u53ef\uff09", (Object[])new Object[0]);
        String dbName = dataSource.getDbName();
        Validate.notBlank((CharSequence)dbName, (String)"\u8fdb\u884c\u64cd\u4f5c\u65f6\uff0c\u5fc5\u987b\u4f20\u5165\u8fde\u63a5\u7684\u6570\u636e\u5e93\u540d", (Object[])new Object[0]);
        String password = dataSource.getPassword();
        Validate.notBlank((CharSequence)password, (String)"\u64cd\u4f5c\u65f6\uff0c\u5fc5\u987b\u4f20\u5165\u6570\u636e\u5e93\u5bc6\u7801", (Object[])new Object[0]);
        Integer port = dataSource.getPort();
        Validate.notNull((Object)port, (String)"\u6570\u636e\u5e93\u8fde\u63a5\u7aef\u53e3\u5fc5\u987b\u586b\u5199!!", (Object[])new Object[0]);
        String urlParams = dataSource.getUrlParams();
        if (StringUtils.isBlank((CharSequence)urlParams)) {
            dataSource.setUrlParams("");
        }
        String username = dataSource.getUserName();
        Validate.notBlank((CharSequence)username, (String)"\u64cd\u4f5c\u65f6\uff0c\u5fc5\u987b\u4f20\u5165\u6570\u636e\u5e93\u7528\u6237\u540d", (Object[])new Object[0]);
        String type = dataSource.getType();
        Validate.notBlank((CharSequence)type, (String)"\u64cd\u4f5c\u65f6\uff0c\u5fc5\u987b\u4f20\u5165\u6570\u636e\u5e93\u7c7b\u578b\uff08Mysql/Oracle\uff09", (Object[])new Object[0]);
        Validate.isTrue((StringUtils.equalsIgnoreCase((CharSequence)type, (CharSequence)MESS_MYSQL) || StringUtils.equalsIgnoreCase((CharSequence)type, (CharSequence)MESS_ORACLE) ? 1 : 0) != 0, (String)"\u76ee\u524d\u6570\u636e\u89c6\u56fe\u53ea\u652f\u6301MySQL\u548cOracle\u6570\u636e\u5e93!!", (Object[])new Object[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DataSourceEntity create(DataSourceEntity dataSource) {
        this.validate(dataSource);
        String code = dataSource.getCode();
        DataSourceEntity oldDataSource = this.dataSourceRepository.findByCode(code);
        Validate.isTrue((oldDataSource == null ? 1 : 0) != 0, (String)"\u5f53\u524d\u6570\u636e\u6e90\u540d\u79f0\u5df2\u7ecf\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u586b\u5199!!", (Object[])new Object[0]);
        this.check(dataSource);
        try {
            this.writeLock();
            dataSource.setPassword(this.passwordEncoder.encode((CharSequence)dataSource.getPassword()));
            this.buildSessionFactory(dataSource);
            dataSource.setCreateTime(new Date());
            dataSource.setProjectName(this.platformContext.getAppName());
            this.dataSourceRepository.save((Object)dataSource);
        }
        finally {
            this.unWriteLock();
        }
        return dataSource;
    }

    @Override
    public DataSourceEntity update(DataSourceEntity dataSource) {
        Validate.notNull((Object)((Object)dataSource), (String)"\u4fee\u6539\u4fe1\u606f\u5fc5\u987b\u4f20\u5165!!", (Object[])new Object[0]);
        String code = dataSource.getCode();
        Validate.notBlank((CharSequence)code, (String)"\u7f16\u7801\u4fe1\u606f\u5fc5\u987b\u4f20\u5165!!", (Object[])new Object[0]);
        DataSourceEntity current = this.dataSourceRepository.findByCode(dataSource.getCode());
        Validate.notNull((Object)((Object)current), (String)"\u6ca1\u6709\u67e5\u5230\u5f53\u524d\u7f16\u7801\u5bf9\u5e94\u7684\u6570\u636e\u5e93\u4fe1\u606f!!", (Object[])new Object[0]);
        Validate.isTrue((current.getTstatus() == NormalStatusEnum.DISABLE.getStatus() ? 1 : 0) != 0, (String)"\u53ea\u6709\u6570\u636e\u6e90\u72b6\u6001\u7981\u7528\u7684\u60c5\u51b5\u4e0b\uff0c\u624d\u80fd\u8fdb\u884c\u4fee\u6539!!", (Object[])new Object[0]);
        current.setAddress(dataSource.getAddress());
        current.setDbName(dataSource.getDbName());
        current.setUserName(dataSource.getUserName());
        if (!current.getPassword().equals(dataSource.getPassword())) {
            current.setPassword(this.passwordEncoder.encode((CharSequence)dataSource.getPassword()));
        }
        current.setPort(dataSource.getPort());
        current.setUrlParams(dataSource.getUrlParams());
        current.setTstatus(dataSource.getTstatus());
        this.validate(current);
        this.dataSourceRepository.save((Object)current);
        if (current.getTstatus().equals(NormalStatusEnum.ENABLE.getStatus())) {
            this.reload(current.getCode());
        }
        return current;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reload(String dataSourceCode) {
        DataSourceEntity currentDataSource = this.dataSourceRepository.findByCode(dataSourceCode);
        Validate.notNull((Object)((Object)currentDataSource), (String)ERROR_CODE, (Object[])new Object[0]);
        try {
            this.check(currentDataSource);
        }
        catch (RuntimeException e) {
            this.dataSourceRepository.updateDisable(new String[]{dataSourceCode});
            throw new IllegalArgumentException(e.getMessage(), e);
        }
        try {
            this.writeLock();
            this.buildSessionFactory(currentDataSource);
        }
        finally {
            this.unWriteLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void disable(String dataSourceCode) {
        Validate.notBlank((CharSequence)dataSourceCode, (String)ERROR_CODE_NOTNULL, (Object[])new Object[0]);
        DataSourceEntity currentDataSource = this.dataSourceRepository.findByCode(dataSourceCode);
        Validate.notNull((Object)((Object)currentDataSource), (String)ERROR_CODE, (Object[])new Object[0]);
        this.dataSourceRepository.updateDisable(new String[]{dataSourceCode});
        String code = currentDataSource.getCode();
        String beanName = StringUtils.join((Object[])new String[]{BEANNAMEPREFIX, code});
        try {
            this.writeLock();
            this.unregistSessionFactory(beanName);
        }
        finally {
            this.unWriteLock();
        }
    }

    @Override
    public void enable(String dataSourceCode) {
        Validate.notBlank((CharSequence)dataSourceCode, (String)ERROR_CODE_NOTNULL, (Object[])new Object[0]);
        DataSourceEntity currentDataSource = this.dataSourceRepository.findByCode(dataSourceCode);
        Validate.notNull((Object)((Object)currentDataSource), (String)ERROR_CODE, (Object[])new Object[0]);
        this.dataSourceRepository.updateEnable(new String[]{dataSourceCode});
        try {
            this.writeLock();
            this.reload(dataSourceCode);
        }
        finally {
            this.unWriteLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void delete(String dataSourceCode) {
        Validate.notBlank((CharSequence)dataSourceCode, (String)ERROR_CODE_NOTNULL, (Object[])new Object[0]);
        DataSourceEntity currentDataSource = this.dataSourceRepository.findByCode(dataSourceCode);
        Validate.notNull((Object)((Object)currentDataSource), (String)"\u6839\u636e\u6570\u636e\u6e90\u540d\u79f0\u4fe1\u606f\uff0c\u672a\u80fd\u83b7\u53d6\u6570\u636e\u6e90\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)currentDataSource.getId(), (String)"\u6839\u636e\u6570\u636e\u6e90\u540d\u79f0\u4fe1\u606f\uff0c\u672a\u80fd\u83b7\u53d6\u6570\u636e\u6e90\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        List<DataViewGroupEntity> groupList = this.dataViewGroupRepository.findByDataSourceCode(dataSourceCode);
        List<DataViewEntity> viewList = this.dataViewRepository.findByDataSource(currentDataSource.getId());
        Validate.isTrue((boolean)CollectionUtils.isEmpty(viewList), (String)"\u5f53\u524d\u6570\u636e\u6e90\u5df2\u5b58\u5728\u6b63\u5728\u4f7f\u7528\u7684\u6570\u636e\u89c6\u56fe\u4fe1\u606f\uff0c\u4e0d\u80fd\u5f3a\u5236\u5220\u9664!!", (Object[])new Object[0]);
        if (!CollectionUtils.isEmpty(groupList)) {
            for (DataViewGroupEntity group : groupList) {
                List<DataViewEntity> tempViewList = this.dataViewRepository.findByDataViewGroup(group.getId());
                Validate.isTrue((boolean)CollectionUtils.isEmpty(tempViewList), (String)"%s\u5206\u7ec4\u4e2d\u8fd8\u5b58\u5728\u5176\u4ed6\u7684\u89c6\u56fe\u4fe1\u606f\uff0c\u4e0d\u80fd\u6e05\u9664\u5206\u7ec4\u4fe1\u606f!!", (Object[])new Object[]{group.getGroupName()});
            }
            this.dataViewGroupRepository.deleteAll(groupList);
        }
        List<DataSourceTableEntity> dataSourceTables = this.dataSourceTableRepository.findByDataSource(currentDataSource.getId());
        Validate.isTrue((boolean)CollectionUtils.isEmpty(dataSourceTables), (String)"\u6709\u6a21\u677f\u6b63\u5728\u4f7f\u7528\u8be5\u6570\u636e\u6e90\uff0c\u4e0d\u80fd\u5220\u9664", (Object[])new Object[0]);
        this.dataSourceRepository.delete((Object)currentDataSource);
        try {
            this.writeLock();
            String beanName = StringUtils.join((Object[])new String[]{BEANNAMEPREFIX, dataSourceCode});
            this.unregistSessionFactory(beanName);
        }
        finally {
            this.unWriteLock();
        }
    }

    @Override
    public SessionFactory getCurrentSessionFactory(String dataSourceCode) {
        if (StringUtils.isBlank((CharSequence)dataSourceCode)) {
            return null;
        }
        String beanName = StringUtils.join((Object[])new String[]{BEANNAMEPREFIX, dataSourceCode});
        return (SessionFactory)this.ctx.getBean(beanName, SessionFactory.class);
    }

    @Override
    public void readLock() {
        this.readWriteLock.readLock().lock();
    }

    @Override
    public void unReadLock() {
        this.readWriteLock.readLock().unlock();
    }

    @Override
    public void writeLock() {
        this.readWriteLock.writeLock().lock();
    }

    @Override
    public void unWriteLock() {
        this.readWriteLock.writeLock().unlock();
    }

    static {
        jdbcDrives.put(MESS_MYSQL, "com.mysql.jdbc.Driver");
        jdbcDrives.put(MESS_ORACLE, "oracle.jdbc.driver.OracleDriver");
    }
}

