/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.core.repository.dynamic;

import com.bizunited.platform.core.repository.dynamic.DynamicDataSourceManager;
import com.bizunited.platform.core.service.dataview.model.ExecuteParamModel;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.AfterReturning;
import org.aspectj.lang.annotation.AfterThrowing;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.annotation.Pointcut;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.Transaction;
import org.hibernate.resource.transaction.spi.TransactionStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.aspectj.MethodInvocationProceedingJoinPoint;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class DynamicDataSourceTaskAspect {
    @Autowired
    private DynamicDataSourceManager dynamicDataSourceManager;
    private static final String ERROR_MESS_CODE = "\u672a\u53d1\u73b0\u6307\u5b9adataSourceCode(%s)\u5bf9\u5e94\u7684\u6570\u636e\u6e90\u4fe1\u606f,\u8bf7\u68c0\u67e5";
    private static final Logger LOGGER = LoggerFactory.getLogger(DynamicDataSourceTaskAspect.class);

    @Pointcut(value="@annotation(org.springframework.scheduling.annotation.Async)")
    public void aspectHandle() {
    }

    @Before(value="aspectHandle() && @annotation(async)", argNames="async")
    public void before(JoinPoint point, Async async) {
        if (!this.checkAsync(async)) {
            return;
        }
        String dataSourceCode = this.getDataSourceCode(point);
        Validate.notBlank((CharSequence)dataSourceCode, (String)"\u7b2c\u4e09\u65b9\u6570\u636e\u6e90\u8c03\u7528\u65f6,\u672a\u627e\u5230\u4f20\u5165\u7684dataSourceCode", (Object[])new Object[0]);
        SessionFactory sessionFactory = this.dynamicDataSourceManager.getCurrentSessionFactory(dataSourceCode);
        Validate.notNull((Object)sessionFactory, (String)ERROR_MESS_CODE, (Object[])new Object[]{dataSourceCode});
        Session currentSession = sessionFactory.getCurrentSession();
        if (currentSession == null || !currentSession.isOpen()) {
            currentSession = sessionFactory.openSession();
        }
        currentSession.beginTransaction();
        LOGGER.debug("before()");
    }

    private boolean checkAsync(Async async) {
        if (async == null) {
            return false;
        }
        String asyncValue = async.value();
        return !StringUtils.isBlank((CharSequence)asyncValue) && StringUtils.equals((CharSequence)asyncValue, (CharSequence)"dynamicExecutor");
    }

    @AfterReturning(value="aspectHandle() && @annotation(async)", argNames="async")
    public void afterReturning(JoinPoint point, Async async) {
        if (!this.checkAsync(async)) {
            return;
        }
        String dataSourceCode = this.getDataSourceCode(point);
        SessionFactory sessionFactory = this.dynamicDataSourceManager.getCurrentSessionFactory(dataSourceCode);
        Validate.notNull((Object)sessionFactory, (String)ERROR_MESS_CODE, (Object[])new Object[]{dataSourceCode});
        Session currentSession = sessionFactory.getCurrentSession();
        if (currentSession == null || !currentSession.isOpen()) {
            currentSession = sessionFactory.openSession();
        }
        if (!currentSession.isOpen()) {
            return;
        }
        Transaction transaction = currentSession.getTransaction();
        if (transaction.getStatus() == TransactionStatus.ACTIVE) {
            transaction.commit();
        } else {
            currentSession.close();
        }
        LOGGER.debug("afterReturning()");
    }

    @AfterThrowing(value="aspectHandle() && @annotation(async)", argNames="async")
    public void afterThrowing(JoinPoint point, Async async) {
        if (!this.checkAsync(async)) {
            return;
        }
        String dataSourceCode = this.getDataSourceCode(point);
        SessionFactory sessionFactory = this.dynamicDataSourceManager.getCurrentSessionFactory(dataSourceCode);
        Validate.notNull((Object)sessionFactory, (String)ERROR_MESS_CODE, (Object[])new Object[]{dataSourceCode});
        Session currentSession = sessionFactory.getCurrentSession();
        if (currentSession == null || !currentSession.isOpen()) {
            currentSession = sessionFactory.openSession();
        }
        if (!currentSession.isOpen()) {
            return;
        }
        Transaction transaction = currentSession.getTransaction();
        if (transaction.getStatus() == TransactionStatus.ACTIVE) {
            transaction.rollback();
        } else {
            currentSession.close();
        }
        LOGGER.debug("afterThrowing()");
    }

    private String getDataSourceCode(JoinPoint point) {
        MethodInvocationProceedingJoinPoint methodJoinPoint = (MethodInvocationProceedingJoinPoint)point;
        Object[] args = methodJoinPoint.getArgs();
        List notNullArgs = Arrays.stream(args).filter(item -> item != null).collect(Collectors.toList());
        List notNullArgsClasses = notNullArgs.stream().map(Object::getClass).collect(Collectors.toList());
        String dataSourceCode = null;
        for (int index = 0; index < notNullArgsClasses.size(); ++index) {
            Class notNullArgsClass = (Class)notNullArgsClasses.get(index);
            if (notNullArgsClass != ExecuteParamModel.class) continue;
            ExecuteParamModel executeParam = (ExecuteParamModel)notNullArgs.get(index);
            dataSourceCode = executeParam.getDataSourceCode();
            break;
        }
        Validate.notBlank(dataSourceCode, (String)"\u672a\u627e\u5230dataSourceCode\u53c2\u6570", (Object[])new Object[0]);
        return dataSourceCode;
    }
}

