/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.core.repository.internal;

import com.bizunited.platform.common.repository.PageRepositoryImpl;
import com.bizunited.platform.core.entity.CodeRuleEntity;
import com.bizunited.platform.core.repository.internal.CodeRuleRepositoryCustom;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Repository;

@Repository(value="CodeRuleRepositoryImpl")
public class CodeRuleRepositoryImpl
implements CodeRuleRepositoryCustom,
PageRepositoryImpl {
    @Autowired
    @PersistenceContext
    private EntityManager entityManager;
    private static final String RULE_NAME = "ruleName";
    private static final String RULE_CODE = "ruleCode";
    private static final String RULE_TYPE = "ruleType";
    private static final String LANGUAGE = "language";

    @Override
    public Page<CodeRuleEntity> findByConditions(Pageable pageable, Map<String, Object> conditions) {
        String projectName;
        Object language;
        Object ruleType;
        Object ruleCode;
        StringBuilder hql = new StringBuilder("from CodeRuleEntity cgr where 1=1");
        StringBuilder countHql = new StringBuilder("select count(*) from CodeRuleEntity cgr where 1=1");
        StringBuilder condition = new StringBuilder();
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        Object ruleName = conditions.get(RULE_NAME);
        if (ruleName != null) {
            condition.append(" AND cgr.ruleName = :ruleName ");
            parameters.put(RULE_NAME, ruleName);
        }
        if ((ruleCode = conditions.get(RULE_CODE)) != null) {
            condition.append(" AND cgr.ruleCode = :ruleCode ");
            parameters.put(RULE_CODE, ruleCode);
        }
        if ((ruleType = conditions.get(RULE_TYPE)) != null) {
            condition.append(" AND cgr.ruleType = :ruleType ");
            parameters.put(RULE_TYPE, ruleType);
        }
        if ((language = conditions.get(LANGUAGE)) != null) {
            condition.append(" AND cgr.language = :language ");
            parameters.put(LANGUAGE, language);
        }
        if (StringUtils.isNotBlank((CharSequence)(projectName = (String)conditions.get("projectName")))) {
            condition.append(" AND cgr.projectName = :projectName ");
            parameters.put("projectName", projectName);
        } else {
            condition.append(" AND (cgr.projectName = '' OR cgr.projectName IS NULL)");
        }
        hql.append((CharSequence)condition).append(" order by cgr.createTime desc  ");
        countHql.append((CharSequence)condition);
        return this.queryByConditions(this.entityManager, hql.toString(), countHql.toString(), parameters, pageable, false, null);
    }

    @Override
    public List<CodeRuleEntity> findAllByConditions(CodeRuleEntity codeRule) {
        StringBuilder hql = new StringBuilder("from CodeRuleEntity cgr where 1=1");
        StringBuilder condition = new StringBuilder();
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        if (StringUtils.isNotBlank((CharSequence)codeRule.getRuleName())) {
            condition.append(" AND cgr.ruleName = :ruleName ");
            parameters.put(RULE_NAME, codeRule.getRuleName());
        }
        if (StringUtils.isNotBlank((CharSequence)codeRule.getRuleCode())) {
            condition.append(" AND cgr.ruleCode = :ruleCode ");
            parameters.put(RULE_CODE, codeRule.getRuleCode());
        }
        if (StringUtils.isNotBlank((CharSequence)codeRule.getRuleType())) {
            condition.append(" AND cgr.ruleType = :ruleType ");
            parameters.put(RULE_TYPE, codeRule.getRuleType());
        }
        if (StringUtils.isNotBlank((CharSequence)codeRule.getLanguage())) {
            condition.append(" AND cgr.language = :language ");
            parameters.put(LANGUAGE, codeRule.getLanguage());
        }
        if (StringUtils.isNotBlank((CharSequence)codeRule.getProjectName())) {
            condition.append(" AND cgr.projectName = :projectName ");
            parameters.put("projectName", codeRule.getProjectName());
        } else {
            condition.append(" AND (cgr.projectName = '' OR cgr.projectName IS NULL)");
        }
        hql.append((CharSequence)condition).append(" order by cgr.createTime desc  ");
        Query query = this.entityManager.createQuery(hql.toString());
        parameters.forEach((k, v) -> query.setParameter(k, v));
        return query.getResultList();
    }
}

