/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.core.repository.internal;

import com.alibaba.druid.pool.DruidDataSource;
import com.bizunited.platform.common.repository.PageRepositoryImpl;
import com.bizunited.platform.common.util.ApplicationContextUtils;
import com.bizunited.platform.core.common.enums.DataSourceTypeEnum;
import com.bizunited.platform.core.entity.DataSourceTableEntity;
import com.bizunited.platform.core.repository.internal.DataSourceTableRepositoryCustom;
import com.google.common.collect.Sets;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.sql.DataSource;
import org.apache.commons.lang3.StringUtils;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.orm.hibernate5.SessionFactoryUtils;
import org.springframework.stereotype.Repository;

@Repository(value="DataSourceTableRepositoryImpl")
public class DataSourceTableRepositoryImpl
implements DataSourceTableRepositoryCustom,
PageRepositoryImpl {
    private static final Logger LOGGER = LoggerFactory.getLogger(DataSourceTableRepositoryImpl.class);
    private static final String ORACLE_QUERY_TABLE_SQL = "select TABLE_NAME from user_tables";
    @Autowired
    @PersistenceContext
    private EntityManager entityManager;

    @Override
    public Page<DataSourceTableEntity> findByConditions(Pageable pageable, Integer tableType, String dataSourceId, Integer status, String tableName) {
        StringBuilder hql = new StringBuilder("select dtt from DataSourceTableEntity dtt left join fetch dtt.dataSource ds where 1=1 ");
        StringBuilder countHql = new StringBuilder("select count(*) from DataSourceTableEntity dtt left join dtt.dataSource ds where 1=1 ");
        StringBuilder conditions = new StringBuilder();
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        conditions.append(" AND dtt.projectName=:projectName ");
        parameters.put("projectName", ApplicationContextUtils.getProjectName());
        if (tableType != null) {
            conditions.append(" AND dtt.tableType = :tableType");
            parameters.put("tableType", tableType);
        }
        if (status != null) {
            conditions.append(" AND dtt.tStatus = :status");
            parameters.put("status", status);
        }
        if (StringUtils.isNotBlank((CharSequence)tableName)) {
            conditions.append(" AND dtt.tableName = :tableName");
            parameters.put("tableName", tableName);
        }
        if (StringUtils.isNotBlank((CharSequence)dataSourceId)) {
            conditions.append(" AND ds.id = :dataSourceId");
            parameters.put("dataSourceId", dataSourceId);
        } else {
            conditions.append(" AND ds.id is null");
        }
        hql.append((CharSequence)conditions);
        countHql.append((CharSequence)conditions);
        return this.queryByConditions(this.entityManager, hql.toString(), countHql.toString(), parameters, pageable, false, null);
    }

    @Override
    public Set<String> queryMainDataSourceTables() {
        Session session = (Session)this.entityManager.getDelegate();
        return this.queryDataSourceTables(session.getSessionFactory());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Set<String> queryDataSourceTables(SessionFactory sessionFactory) {
        DataSource dataSource = SessionFactoryUtils.getDataSource((SessionFactory)sessionFactory);
        try (Connection conn = dataSource.getConnection();){
            String driverClass = this.getDriverClass(dataSource);
            DataSourceTypeEnum dataSourceType = DataSourceTypeEnum.valueOfDriver(driverClass);
            if (DataSourceTypeEnum.MYSQL.equals((Object)dataSourceType)) {
                Set<String> set2 = this.queryMysqlTables(conn);
                return set2;
            }
            Set<String> set = this.queryOracleTables(conn);
            return set;
        }
        catch (SQLException e) {
            LOGGER.warn(e.getMessage(), (Throwable)e);
            return Sets.newHashSet();
        }
    }

    private Set<String> queryMysqlTables(Connection conn) throws SQLException {
        String catalog = conn.getCatalog();
        DatabaseMetaData metaData = conn.getMetaData();
        ResultSet rs = metaData.getTables(catalog, null, null, new String[]{"TABLE"});
        return this.getTableNames(rs);
    }

    private Set<String> queryOracleTables(Connection conn) throws SQLException {
        try (PreparedStatement pre = conn.prepareStatement(ORACLE_QUERY_TABLE_SQL);){
            ResultSet rs = pre.executeQuery();
            Set<String> set = this.getTableNames(rs);
            return set;
        }
    }

    private Set<String> getTableNames(ResultSet rs) throws SQLException {
        HashSet<String> tableNames = new HashSet<String>();
        while (rs.next()) {
            String tableName = rs.getString("TABLE_NAME");
            tableNames.add(tableName);
        }
        rs.close();
        return tableNames;
    }

    private String getDriverClass(DataSource dataSource) {
        String dataSourceName = dataSource.getClass().getName();
        if (dataSourceName.equals("com.alibaba.druid.pool.DruidDataSource")) {
            DruidDataSource druidDataSource = (DruidDataSource)dataSource;
            return druidDataSource.getDriverClassName();
        }
        return DataSourceTypeEnum.MYSQL.getDriverClassNames()[0];
    }
}

