/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.core.service.dataview.executor;

import com.alibaba.fastjson.JSONObject;
import com.bizunited.platform.common.enums.ClassTypeNameEnum;
import com.bizunited.platform.common.util.JsonUtils;
import com.bizunited.platform.core.common.enums.DataSourceTypeEnum;
import com.bizunited.platform.core.entity.DataSourceEntity;
import com.bizunited.platform.core.entity.DataViewAuthEntity;
import com.bizunited.platform.core.entity.DataViewEntity;
import com.bizunited.platform.core.entity.dauth.DataAuthPreRuleEntity;
import com.bizunited.platform.core.repository.dataview.analysis.MysqlAnalysis;
import com.bizunited.platform.core.repository.dataview.analysis.OracleSqlAnalysis;
import com.bizunited.platform.core.repository.dataview.analysis.SQLPresetValueAnalysis;
import com.bizunited.platform.core.repository.dataview.analysis.SqlAnalysis;
import com.bizunited.platform.core.repository.dynamic.DynamicDataSourceManager;
import com.bizunited.platform.core.service.dataview.DataViewAuthService;
import com.bizunited.platform.core.service.dataview.DataViewService;
import com.bizunited.platform.core.service.dataview.model.ExecuteContextModel;
import com.bizunited.platform.core.service.dataview.model.ExecuteParamModel;
import com.bizunited.platform.core.service.dataview.model.PageableModel;
import com.bizunited.platform.core.service.dauth.internal.DataAuthPreAuthDecisionService;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import javax.persistence.EntityManager;
import javax.sql.DataSource;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.jdbc.DataSourceProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.orm.hibernate5.SessionFactoryUtils;
import org.springframework.util.CollectionUtils;

public class DataViewExecutor {
    private static final Logger LOGGER = LoggerFactory.getLogger(DataViewExecutor.class);
    private ExecuteContextModel executeContext;
    private SqlAnalysis sqlAnalysis;

    public DataViewExecutor(ApplicationContext applicationContext, ExecuteParamModel executeParam) {
        this.init(applicationContext, executeParam);
    }

    private void init(ApplicationContext applicationContext, ExecuteParamModel executeParam) {
        Validate.notNull((Object)executeParam, (String)"\u6267\u884c\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)applicationContext, (String)"spring\u4e0a\u4e0b\u6587\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)executeParam.getDataViewCode(), (String)"\u6570\u636e\u89c6\u56fe\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        DataViewService dataViewService = (DataViewService)applicationContext.getBean(DataViewService.class);
        DataViewEntity dataView = dataViewService.findByCode(executeParam.getDataViewCode());
        Validate.notNull((Object)((Object)dataView), (String)"\u672a\u627e\u5230\u6570\u636e\u89c6\u56fe\uff1a%s", (Object[])new Object[]{executeParam.getDataViewCode()});
        DataSourceEntity dataSource = dataView.getDataSource();
        DataSourceProperties dataSourceProperties = (DataSourceProperties)applicationContext.getBean(DataSourceProperties.class);
        DataSourceTypeEnum dataSourceType = this.getDataSourceType(dataSource, dataSourceProperties);
        SQLPresetValueAnalysis sqlPresetValueAnalysis = new SQLPresetValueAnalysis(applicationContext);
        DataAuthPreAuthDecisionService dataAuthPreAuthDecisionService = (DataAuthPreAuthDecisionService)applicationContext.getBean(DataAuthPreAuthDecisionService.class);
        DataViewAuthEntity auth = null;
        DataAuthPreRuleEntity preRule = null;
        this.executeContext = new ExecuteContextModel();
        boolean hasAdmin = dataAuthPreAuthDecisionService.hasAdminRole();
        if (hasAdmin) {
            this.executeContext.setAdmin(true);
        }
        if (StringUtils.isNotBlank((CharSequence)executeParam.getAuthCode()) && !hasAdmin) {
            preRule = dataAuthPreAuthDecisionService.decision(executeParam.getAuthCode());
            DataViewAuthService dataViewAuthService = (DataViewAuthService)applicationContext.getBean(DataViewAuthService.class);
            auth = preRule == null ? dataViewAuthService.findDetailsByDataViewCodeAndCode(dataView.getCode(), executeParam.getAuthCode()) : dataViewAuthService.findDetailsByDataViewCodeAndCodeAndPreRule(dataView.getCode(), executeParam.getAuthCode(), preRule.getCode());
            Validate.notNull((Object)((Object)auth), (String)"\u672a\u627e\u5230\u6307\u5b9a\u7684\u6570\u636e\u6743\u9650:%s", (Object[])new Object[]{executeParam.getAuthCode()});
        }
        this.executeContext.setApplicationContext(applicationContext);
        this.executeContext.setExecuteParam(executeParam);
        this.executeContext.setDataView(dataView);
        this.executeContext.setPreRule(preRule);
        this.executeContext.setDataSourceType(dataSourceType);
        this.executeContext.setDataSource(dataSource);
        this.executeContext.setDataViewFields(dataView.getFields());
        this.executeContext.setSqlPresetValueAnalysis(sqlPresetValueAnalysis);
        this.executeContext.setWrapperSqlAlias("s01y01s01");
        this.executeContext.setDataViewFilters(dataView.getFilters());
        this.executeContext.setSystemFilters(dataView.getSystemFilters());
        this.executeContext.setDataViewAuth(auth);
        if (dataSourceType.equals((Object)DataSourceTypeEnum.MYSQL)) {
            this.sqlAnalysis = new MysqlAnalysis(this.executeContext);
        } else if (dataSourceType.equals((Object)DataSourceTypeEnum.ORACLE)) {
            this.sqlAnalysis = new OracleSqlAnalysis(this.executeContext);
        }
        this.executeContext.setSqlAnalysis(this.sqlAnalysis);
        this.sqlAnalysis.analysis();
    }

    private DataSourceTypeEnum getDataSourceType(DataSourceEntity dataSource, DataSourceProperties dataSourceProperties) {
        if (dataSource == null) {
            DataSourceTypeEnum dataSourceTypeEnum = DataSourceTypeEnum.valueOfDriver(dataSourceProperties.getDriverClassName());
            Validate.notNull((Object)((Object)dataSourceTypeEnum), (String)String.format("\u4e0d\u652f\u6301\u7684\u6570\u636e\u5e93\u9a71\u52a8\u7c7b\uff1a%s", dataSourceProperties.getDriverClassName()), (Object[])new Object[0]);
            return dataSourceTypeEnum;
        }
        DataSourceTypeEnum dataSourceTypeEnum = DataSourceTypeEnum.valueOfDatabase(dataSource.getType());
        Validate.notNull((Object)((Object)dataSourceTypeEnum), (String)"\u4e0d\u652f\u6301\u7684\u6570\u636e\u5e93\u7c7b\u578b\uff1a%s", (Object[])new Object[]{dataSource.getType()});
        return dataSourceTypeEnum;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<JSONObject> executeQuery() {
        SessionFactory sessionFactory = this.getSessionFactory();
        DataSource dataSource = SessionFactoryUtils.getDataSource((SessionFactory)sessionFactory);
        try (Connection conn = Objects.requireNonNull(dataSource).getConnection();){
            List<JSONObject> list = this.executeQuery(conn, this.executeContext.getExecuteSql(), this.executeContext.getExecuteSqlParameters());
            return list;
        }
        catch (SQLException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            throw new IllegalArgumentException(String.format("\u6267\u884csql\u51fa\u9519\uff1a%s", e.getMessage()));
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Page<JSONObject> executePageQuery() {
        SessionFactory sessionFactory = this.getSessionFactory();
        DataSource dataSource = SessionFactoryUtils.getDataSource((SessionFactory)sessionFactory);
        PageableModel pageable = this.executeContext.getExecuteParam().getPageable();
        Validate.notNull((Object)pageable, (String)"\u672a\u627e\u5230\u5206\u9875\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5\u53c2\u6570", (Object[])new Object[0]);
        try (Connection conn = Objects.requireNonNull(dataSource).getConnection();){
            List<JSONObject> resultList = this.executeQuery(conn, this.executeContext.getExecuteSql(), this.executeContext.getExecuteSqlParameters());
            List<JSONObject> countResult = this.executeQuery(conn, this.executeContext.getExecuteCountSql(), this.executeContext.getExecuteCountSqlParameters());
            long count = this.getCount(countResult);
            PageImpl pageImpl = new PageImpl(resultList, (Pageable)PageRequest.of((int)pageable.getPage(), (int)pageable.getSize()), count);
            return pageImpl;
        }
        catch (SQLException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            throw new IllegalArgumentException(String.format("\u6267\u884csql\u51fa\u9519\uff1a%s", e.getMessage()));
        }
    }

    private long getCount(List<JSONObject> countResult) {
        if (CollectionUtils.isEmpty(countResult)) {
            return 0L;
        }
        JSONObject jsonObject = countResult.get(0);
        Iterator iterator = jsonObject.keySet().iterator();
        return iterator.hasNext() ? jsonObject.getLongValue((String)iterator.next()) : 0L;
    }

    private List<JSONObject> executeQuery(Connection conn, String sql, List<Object> parameters) throws SQLException {
        LOGGER.info("executeSql:{}", (Object)sql);
        try {
            LOGGER.info("parameters:{}", (Object)JsonUtils.obj2JsonString(parameters));
        }
        catch (JsonProcessingException e) {
            LOGGER.warn(e.getMessage(), (Throwable)e);
        }
        try (PreparedStatement preparedStatement = conn.prepareStatement(sql);){
            this.setStatementParameters(preparedStatement, parameters);
            ResultSet resultSet = preparedStatement.executeQuery();
            List<JSONObject> list = this.getResultList(resultSet);
            return list;
        }
    }

    private List<JSONObject> getResultList(ResultSet resultSet) throws SQLException {
        ArrayList<JSONObject> list = new ArrayList<JSONObject>();
        while (resultSet.next()) {
            ResultSetMetaData metaData = resultSet.getMetaData();
            int columnCount = metaData.getColumnCount();
            JSONObject jsonObject = new JSONObject();
            for (int i = 1; i <= columnCount; ++i) {
                jsonObject.put(metaData.getColumnLabel(i), resultSet.getObject(i));
            }
            list.add(jsonObject);
        }
        return list;
    }

    private SessionFactory getSessionFactory() {
        ApplicationContext applicationContext = this.executeContext.getApplicationContext();
        DataSourceEntity dataSource = this.executeContext.getDataSource();
        if (dataSource == null) {
            EntityManager entityManager = (EntityManager)applicationContext.getBean(EntityManager.class);
            Session session = (Session)entityManager.getDelegate();
            return session.getSessionFactory();
        }
        DynamicDataSourceManager dataSourceManager = (DynamicDataSourceManager)applicationContext.getBean(DynamicDataSourceManager.class);
        SessionFactory sessionFactory = dataSourceManager.getCurrentSessionFactory(dataSource.getCode());
        if (sessionFactory == null) {
            throw new NullPointerException(String.format("\u672a\u627e\u5230\u6570\u636e\u6e90\uff1a%s", dataSource.getCode()));
        }
        return sessionFactory;
    }

    private void setStatementParameters(PreparedStatement preparedStatement, List<Object> parameters) throws SQLException {
        if (CollectionUtils.isEmpty(parameters)) {
            return;
        }
        block13: for (int i = 0; i < parameters.size(); ++i) {
            int index = i + 1;
            Object value = parameters.get(i);
            if (value == null) {
                preparedStatement.setObject(index, value);
                continue;
            }
            ClassTypeNameEnum classTypeName = ClassTypeNameEnum.valueOfClassName((String)value.getClass().getName());
            if (classTypeName == null) {
                preparedStatement.setObject(index, value);
                continue;
            }
            switch (classTypeName) {
                case STRING: {
                    preparedStatement.setString(index, value.toString());
                    continue block13;
                }
                case INT: 
                case INTEGER: {
                    preparedStatement.setInt(index, (Integer)value);
                    continue block13;
                }
                case DOUBLE: 
                case DOUBLE_PACK: {
                    preparedStatement.setDouble(index, (Double)value);
                    continue block13;
                }
                case FLOAT: 
                case FLOAT_PACK: {
                    preparedStatement.setFloat(index, ((Float)value).floatValue());
                    continue block13;
                }
                case LONG: 
                case LONG_PACK: {
                    preparedStatement.setLong(index, (Long)value);
                    continue block13;
                }
                case SHORT: 
                case SHORT_PACK: {
                    preparedStatement.setShort(index, (Short)value);
                    continue block13;
                }
                case BYTE: 
                case BYTE_PACK: {
                    preparedStatement.setByte(index, (Byte)value);
                    continue block13;
                }
                case BOOLEAN: 
                case BOOLEAN_PACK: {
                    preparedStatement.setBoolean(index, (Boolean)value);
                    continue block13;
                }
                case CHAR: 
                case CHAR_PACK: {
                    preparedStatement.setString(index, value.toString());
                    continue block13;
                }
                case DATE: {
                    Date date = (Date)value;
                    Timestamp timestamp = new Timestamp(date.getTime());
                    preparedStatement.setTimestamp(index, timestamp);
                    continue block13;
                }
                case BIG_DECIMAL: {
                    preparedStatement.setString(index, value.toString());
                    continue block13;
                }
                default: {
                    preparedStatement.setObject(index, value);
                }
            }
        }
    }
}

