/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.core.service.dataview.internal;

import com.bizunited.platform.common.entity.UuidEntity;
import com.bizunited.platform.common.service.NebulaToolkitService;
import com.bizunited.platform.common.util.ApplicationContextUtils;
import com.bizunited.platform.common.vo.UuidVo;
import com.bizunited.platform.core.entity.DataViewAuthHorizontalEntity;
import com.bizunited.platform.core.entity.DataViewAuthHorizontalRelationEntity;
import com.bizunited.platform.core.repository.dataview.DataViewAuthHorizontalRelationRepository;
import com.bizunited.platform.core.service.dataview.DataViewAuthHorizontalRelationService;
import com.bizunited.platform.core.service.dataview.DataViewAuthHorizontalService;
import com.bizunited.platform.core.service.dataview.internal.DataViewAuthRelationService;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.transaction.Transactional;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="DataViewAuthHorizontalRelationServiceImpl")
public class DataViewAuthHorizontalRelationServiceImpl
implements DataViewAuthHorizontalRelationService {
    @Autowired
    private DataViewAuthHorizontalRelationRepository dataViewAuthHorizontalRelationRepository;
    @Autowired
    private NebulaToolkitService nebulaToolkitService;
    @Autowired
    private DataViewAuthHorizontalService dataViewAuthHorizontalService;
    @Autowired
    private DataViewAuthRelationService dataViewAuthRelationService;

    @Override
    public Set<DataViewAuthHorizontalRelationEntity> findDetailsByAuthHorizontal(String authHorizontal) {
        if (StringUtils.isBlank((CharSequence)authHorizontal)) {
            return Sets.newHashSet();
        }
        DataViewAuthHorizontalEntity horizontal = this.dataViewAuthHorizontalService.findById(authHorizontal);
        if (horizontal == null) {
            return Sets.newHashSet();
        }
        Set<DataViewAuthHorizontalRelationEntity> relations = this.dataViewAuthHorizontalRelationRepository.findDetailsByAuthHorizontal(authHorizontal);
        if (CollectionUtils.isEmpty(relations)) {
            return relations;
        }
        for (DataViewAuthHorizontalRelationEntity relation : relations) {
            UuidVo relationObj = this.dataViewAuthRelationService.findRelation(relation.getAuthRelationIds(), horizontal.getAuthType());
            relation.setRelation(relationObj);
        }
        return relations;
    }

    @Override
    public DataViewAuthHorizontalRelationEntity findDetailsById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        return this.dataViewAuthHorizontalRelationRepository.findDetailsById(id);
    }

    @Override
    public DataViewAuthHorizontalRelationEntity findById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        return this.dataViewAuthHorizontalRelationRepository.findById(id).orElse(null);
    }

    @Override
    @Transactional
    public void deleteById(String id) {
        Validate.notBlank((CharSequence)id, (String)"\u8fdb\u884c\u5220\u9664\u65f6\uff0c\u5fc5\u987b\u7ed9\u5b9a\u4e3b\u952e\u4fe1\u606f!!", (Object[])new Object[0]);
        Optional op = this.dataViewAuthHorizontalRelationRepository.findById(id);
        op.ifPresent(dataViewAuthHorizontalRelationEntity -> this.dataViewAuthHorizontalRelationRepository.delete(dataViewAuthHorizontalRelationEntity));
    }

    @Override
    @Transactional
    public void deleteByAuthHorizontal(String authHorizontal) {
        Validate.notBlank((CharSequence)authHorizontal, (String)"\u8fdb\u884c\u5220\u9664\u65f6\uff0c\u5fc5\u987b\u7ed9\u5b9a\u6a2a\u5411\u6570\u636e\u6743\u9650\u4fe1\u606f!", (Object[])new Object[0]);
        this.dataViewAuthHorizontalRelationRepository.deleteByAuthHorizontal(authHorizontal);
    }

    @Override
    @Transactional
    public Set<DataViewAuthHorizontalRelationEntity> save(DataViewAuthHorizontalEntity authHorizontal, Set<DataViewAuthHorizontalRelationEntity> authRelations) {
        this.saveValidation(authHorizontal, authRelations);
        if (authRelations == null) {
            authRelations = Sets.newHashSet();
        }
        Map<String, DataViewAuthHorizontalRelationEntity> authRelationsMap = authRelations.stream().collect(Collectors.toMap(UuidEntity::getId, r -> r, (r1, r2) -> r1));
        Set<DataViewAuthHorizontalRelationEntity> dbAuthRelations = this.dataViewAuthHorizontalRelationRepository.findDetailsByAuthHorizontal(authHorizontal.getId());
        HashSet deletes = Sets.newHashSet();
        HashSet updates = Sets.newHashSet();
        HashSet creates = Sets.newHashSet();
        this.nebulaToolkitService.collectionDiscrepancy((Collection)authRelations, dbAuthRelations, UuidEntity::getId, (Collection)deletes, (Collection)updates, (Collection)creates);
        for (DataViewAuthHorizontalRelationEntity delete : deletes) {
            this.dataViewAuthHorizontalRelationRepository.delete((Object)delete);
        }
        for (DataViewAuthHorizontalRelationEntity update : updates) {
            DataViewAuthHorizontalRelationEntity relation = authRelationsMap.get(update.getId());
            update.setAuthRelationIds(relation.getAuthRelationIds());
            update.setSortIndex(relation.getSortIndex());
            this.dataViewAuthHorizontalRelationRepository.save((Object)update);
        }
        for (DataViewAuthHorizontalRelationEntity create : creates) {
            create.setAuthHorizontal(authHorizontal);
            create.setProjectName(ApplicationContextUtils.getProjectName());
            this.dataViewAuthHorizontalRelationRepository.save((Object)create);
        }
        updates.addAll(creates);
        return updates;
    }

    private void saveValidation(DataViewAuthHorizontalEntity authHorizontal, Set<DataViewAuthHorizontalRelationEntity> relations) {
        Validate.notNull((Object)((Object)authHorizontal), (String)"\u6a2a\u5411\u6743\u9650\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)authHorizontal.getId(), (String)"\u6a2a\u5411\u6743\u9650ID\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        DataViewAuthHorizontalEntity horizontal = this.dataViewAuthHorizontalService.findById(authHorizontal.getId());
        Validate.notNull((Object)((Object)horizontal), (String)"\u672a\u627e\u5230\u6a2a\u5411\u6743\u9650\uff1a%s", (Object[])new Object[]{authHorizontal.getId()});
        if (CollectionUtils.isEmpty(relations)) {
            return;
        }
        for (DataViewAuthHorizontalRelationEntity authRelation : relations) {
            Validate.notBlank((CharSequence)authRelation.getAuthRelationIds(), (String)"\u6743\u9650\u503c\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            Validate.notNull((Object)authRelation.getSortIndex(), (String)"\u6743\u9650\u503c\u6392\u5e8f\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        }
    }
}

