/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.core.service.dataview.internal;

import com.bizunited.platform.common.entity.UuidEntity;
import com.bizunited.platform.common.service.NebulaToolkitService;
import com.bizunited.platform.common.util.ApplicationContextUtils;
import com.bizunited.platform.core.common.enums.AuthOperatorEnum;
import com.bizunited.platform.core.entity.DataViewAuthEntity;
import com.bizunited.platform.core.entity.DataViewAuthHorizontalEntity;
import com.bizunited.platform.core.entity.DataViewAuthHorizontalRelationEntity;
import com.bizunited.platform.core.repository.dataview.DataViewAuthHorizontalRepository;
import com.bizunited.platform.core.service.dataview.DataViewAuthHorizontalRelationService;
import com.bizunited.platform.core.service.dataview.DataViewAuthHorizontalService;
import com.bizunited.platform.core.service.dataview.DataViewAuthService;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.transaction.Transactional;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="DataViewAuthHorizontalServiceImpl")
public class DataViewAuthHorizontalServiceImpl
implements DataViewAuthHorizontalService {
    @Autowired
    private DataViewAuthHorizontalRepository dataViewAuthHorizontalRepository;
    @Autowired
    private DataViewAuthService dataViewAuthService;
    @Autowired
    private DataViewAuthHorizontalRelationService dataViewAuthHorizontalRelationService;
    @Autowired
    private NebulaToolkitService nebulaToolkitService;

    @Override
    @Transactional
    public Set<DataViewAuthHorizontalEntity> save(String authId, Set<DataViewAuthHorizontalEntity> authHorizontals) {
        this.saveValidation(authId, authHorizontals);
        DataViewAuthEntity auth = this.dataViewAuthService.findById(authId);
        Validate.notNull((Object)((Object)auth), (String)"\u672a\u627e\u5230\u6570\u636e\u6743\u9650\uff1a%s", (Object[])new Object[]{authId});
        if (authHorizontals == null) {
            authHorizontals = Sets.newHashSet();
        }
        Map<String, DataViewAuthHorizontalEntity> authHorizontalsMap = authHorizontals.stream().collect(Collectors.toMap(UuidEntity::getId, ah -> ah, (ah1, ah2) -> ah1));
        Set<DataViewAuthHorizontalEntity> dbAuthHorizontals = this.dataViewAuthHorizontalRepository.findByAuth(auth);
        HashSet deletes = Sets.newHashSet();
        HashSet updates = Sets.newHashSet();
        HashSet creates = Sets.newHashSet();
        this.nebulaToolkitService.collectionDiscrepancy((Collection)authHorizontals, dbAuthHorizontals, UuidEntity::getId, (Collection)deletes, (Collection)updates, (Collection)creates);
        for (DataViewAuthHorizontalEntity delete : deletes) {
            this.dataViewAuthHorizontalRelationService.deleteByAuthHorizontal(delete.getId());
            this.dataViewAuthHorizontalRepository.delete((Object)delete);
        }
        for (DataViewAuthHorizontalEntity update : updates) {
            DataViewAuthHorizontalEntity authHorizontal = authHorizontalsMap.get(update.getId());
            update.setAuthType(authHorizontal.getAuthType());
            update.setPreRule(authHorizontal.getPreRule());
            update.setOprtType(authHorizontal.getOprtType());
            update.setParamSourceType(authHorizontal.getParamSourceType());
            update.setParamKey(authHorizontal.getParamKey());
            update.setFieldName(authHorizontal.getFieldName());
            update.setSortIndex(authHorizontal.getSortIndex());
            update.setLevel(authHorizontal.getLevel());
            this.dataViewAuthHorizontalRepository.save((Object)update);
            if (2 != update.getParamSourceType()) continue;
            this.dataViewAuthHorizontalRelationService.save(update, authHorizontal.getAuthRelations());
        }
        for (DataViewAuthHorizontalEntity create : creates) {
            create.setDataViewAuth(auth);
            create.setId(null);
            this.dataViewAuthHorizontalRepository.save((Object)create);
            if (2 != create.getParamSourceType()) continue;
            this.dataViewAuthHorizontalRelationService.save(create, create.getAuthRelations());
        }
        updates.addAll(creates);
        return updates;
    }

    private void saveValidation(String authId, Set<DataViewAuthHorizontalEntity> authHorizontals) {
        Validate.notBlank((CharSequence)authId, (String)"\u6570\u636e\u6743\u9650\u5bf9\u8c61ID\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        if (CollectionUtils.isEmpty(authHorizontals)) {
            return;
        }
        for (DataViewAuthHorizontalEntity authHorizontal : authHorizontals) {
            Validate.notNull((Object)((Object)authHorizontal), (String)"\u66f4\u65b0\u65f6\uff0c\u6a2a\u5411\u6743\u9650\u4fe1\u606f\u5fc5\u987b\u4f20\u5165\uff01\uff01", (Object[])new Object[0]);
            Validate.notNull((Object)authHorizontal.getSortIndex(), (String)"\u6392\u5e8f\u5b57\u6bb5\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            Validate.notNull((Object)authHorizontal.getParamSourceType(), (String)"\u53c2\u6570\u6765\u6e90\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            Validate.notNull((Object)((Object)authHorizontal.getAuthType()), (String)"\u6743\u9650\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            Validate.notBlank((CharSequence)authHorizontal.getOprtType(), (String)"\u64cd\u4f5c\u7b26\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            AuthOperatorEnum authOperator = AuthOperatorEnum.valueOf(authHorizontal.getOprtType());
            Validate.notNull((Object)((Object)authHorizontal), (String)"\u4e0d\u652f\u6301\u7684\u64cd\u4f5c\u7b26\uff1a%s", (Object[])new Object[]{authHorizontal.getOprtType()});
            if (authHorizontal.getParamSourceType() == 2) {
                Validate.notEmpty(authHorizontal.getAuthRelations(), (String)"\u5b57\u6bb5\u6743\u9650\u3010%s\u3011\u7684\u56fa\u5b9a\u53c2\u6570\u6ca1\u6709\u503c\uff0c\u8bf7\u68c0\u67e5\uff01\uff01", (Object[])new Object[]{authHorizontal.getFieldName()});
                if (authOperator == AuthOperatorEnum.EQ || authOperator == AuthOperatorEnum.NEQ) {
                    Validate.isTrue((authHorizontal.getAuthRelations().size() == 1 ? 1 : 0) != 0, (String)"\u5b57\u6bb5\u6743\u9650\u3010%s\u3011\u7684\u56fa\u5b9a\u53c2\u6570\u503c\u53ea\u80fd\u6709\u4e00\u4e2a\uff0c\u8bf7\u68c0\u67e5\uff01\uff01", (Object[])new Object[0]);
                }
            } else if (authHorizontal.getParamSourceType() == 3) {
                Validate.notBlank((CharSequence)authHorizontal.getParamKey(), (String)"\u9884\u5236\u503c\u7684\u503c\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            }
            Validate.isTrue((authHorizontal.getOprtType() == null || authHorizontal.getOprtType().length() < 32 ? 1 : 0) != 0, (String)"\u64cd\u4f5c\u7b26\u7c7b\u578b,\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(32)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
            Validate.isTrue((authHorizontal.getParamKey() == null || authHorizontal.getParamKey().length() < 64 ? 1 : 0) != 0, (String)"\u9884\u5236\u503c\u6807\u8bc6,\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(64)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        }
    }

    @Override
    public DataViewAuthHorizontalEntity findDetailsById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        return this.dataViewAuthHorizontalRepository.findDetailsById(id);
    }

    @Override
    public DataViewAuthHorizontalEntity findById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        return this.dataViewAuthHorizontalRepository.findById(id).orElse(null);
    }

    @Override
    @Transactional
    public void deleteById(String id) {
        Validate.notBlank((CharSequence)id, (String)"\u8fdb\u884c\u5220\u9664\u65f6\uff0c\u5fc5\u987b\u7ed9\u5b9a\u4e3b\u952e\u4fe1\u606f!!", (Object[])new Object[0]);
        DataViewAuthHorizontalEntity authHorizontal = this.dataViewAuthHorizontalRepository.findById(id).orElse(null);
        if (authHorizontal == null) {
            return;
        }
        this.dataViewAuthHorizontalRelationService.deleteByAuthHorizontal(id);
        this.dataViewAuthHorizontalRepository.delete((Object)authHorizontal);
    }

    @Override
    public Set<DataViewAuthHorizontalEntity> findDetailsByAuthId(String authId) {
        if (StringUtils.isBlank((CharSequence)authId)) {
            return Sets.newHashSet();
        }
        DataViewAuthEntity auth = new DataViewAuthEntity();
        auth.setId(authId);
        Set<DataViewAuthHorizontalEntity> horizontals = this.dataViewAuthHorizontalRepository.findByAuth(auth);
        if (CollectionUtils.isEmpty(horizontals)) {
            return Sets.newHashSet();
        }
        for (DataViewAuthHorizontalEntity horizontal : horizontals) {
            Set<DataViewAuthHorizontalRelationEntity> relations = this.dataViewAuthHorizontalRelationService.findDetailsByAuthHorizontal(horizontal.getId());
            horizontal.setAuthRelations(relations);
        }
        return horizontals;
    }

    @Override
    @Transactional
    public void deleteByField(String fieldName) {
        if (StringUtils.isBlank((CharSequence)fieldName)) {
            return;
        }
        DataViewAuthHorizontalEntity horizontal = this.dataViewAuthHorizontalRepository.findByFieldNameAndProjectName(fieldName, ApplicationContextUtils.getProjectName());
        if (horizontal == null) {
            return;
        }
        this.dataViewAuthHorizontalRelationService.deleteByAuthHorizontal(horizontal.getId());
        this.dataViewAuthHorizontalRepository.delete((Object)horizontal);
    }

    @Override
    @Transactional
    public void deleteByAuthId(String authId) {
        Validate.notBlank((CharSequence)authId, (String)"\u6743\u9650ID\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        DataViewAuthEntity auth = new DataViewAuthEntity();
        auth.setId(authId);
        Set<DataViewAuthHorizontalEntity> horizontals = this.dataViewAuthHorizontalRepository.findByAuth(auth);
        if (CollectionUtils.isEmpty(horizontals)) {
            return;
        }
        for (DataViewAuthHorizontalEntity horizontal : horizontals) {
            this.dataViewAuthHorizontalRelationService.deleteByAuthHorizontal(horizontal.getId());
            this.dataViewAuthHorizontalRepository.delete((Object)horizontal);
        }
    }

    @Override
    public Set<DataViewAuthHorizontalEntity> findDetailsByAuthCode(String authCode) {
        if (StringUtils.isBlank((CharSequence)authCode)) {
            return Sets.newHashSet();
        }
        Set<DataViewAuthHorizontalEntity> horizontals = this.dataViewAuthHorizontalRepository.findByCode(authCode);
        if (CollectionUtils.isEmpty(horizontals)) {
            return Sets.newHashSet();
        }
        for (DataViewAuthHorizontalEntity horizontal : horizontals) {
            Set<DataViewAuthHorizontalRelationEntity> relations = this.dataViewAuthHorizontalRelationService.findDetailsByAuthHorizontal(horizontal.getId());
            horizontal.setAuthRelations(relations);
        }
        return horizontals;
    }

    @Override
    public Set<DataViewAuthHorizontalEntity> findByPreRuleCode(String preRuleCode) {
        if (StringUtils.isBlank((CharSequence)preRuleCode)) {
            return null;
        }
        return this.dataViewAuthHorizontalRepository.findByPreRuleCode(preRuleCode);
    }
}

