/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.core.service.dataview.internal;

import com.bizunited.platform.common.entity.UuidEntity;
import com.bizunited.platform.common.service.NebulaToolkitService;
import com.bizunited.platform.common.util.ApplicationContextUtils;
import com.bizunited.platform.core.entity.DataViewAuthEntity;
import com.bizunited.platform.core.entity.DataViewAuthInterceptorEntity;
import com.bizunited.platform.core.interceptor.DataViewAuthInterceptor;
import com.bizunited.platform.core.repository.dataview.DataViewAuthInterceptorRepository;
import com.bizunited.platform.core.service.dataview.DataViewAuthInterceptorService;
import com.bizunited.platform.core.service.dataview.DataViewAuthService;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.transaction.Transactional;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="DataViewAuthInterceptorServiceImpl")
public class DataViewAuthInterceptorServiceImpl
implements DataViewAuthInterceptorService {
    @Autowired
    private DataViewAuthInterceptorRepository dataViewAuthInterceptorRepository;
    @Autowired
    private DataViewAuthService dataViewAuthService;
    @Autowired
    private NebulaToolkitService nebulaToolkitService;
    @Autowired
    private ApplicationContext applicationContext;

    @Override
    public Set<DataViewAuthInterceptorEntity> save(String authId, Set<DataViewAuthInterceptorEntity> interceptors) {
        this.saveValidation(authId, interceptors);
        DataViewAuthEntity auth = this.dataViewAuthService.findById(authId);
        Validate.notNull((Object)((Object)auth), (String)"\u672a\u627e\u5230\u6570\u636e\u6743\u9650\uff1a%s", (Object[])new Object[]{authId});
        if (interceptors == null) {
            interceptors = Sets.newHashSet();
        }
        Map<String, DataViewAuthInterceptorEntity> interceptorsMap = interceptors.stream().collect(Collectors.toMap(UuidEntity::getId, i -> i, (i1, i2) -> i1));
        Set<DataViewAuthInterceptorEntity> dbInterceptors = this.dataViewAuthInterceptorRepository.findByAuth(auth);
        HashSet deletes = Sets.newHashSet();
        HashSet updates = Sets.newHashSet();
        HashSet creates = Sets.newHashSet();
        this.nebulaToolkitService.collectionDiscrepancy((Collection)interceptors, dbInterceptors, UuidEntity::getId, (Collection)deletes, (Collection)updates, (Collection)creates);
        for (DataViewAuthInterceptorEntity delete : deletes) {
            this.dataViewAuthInterceptorRepository.delete((Object)delete);
        }
        for (DataViewAuthInterceptorEntity update : updates) {
            DataViewAuthInterceptorEntity interceptor = interceptorsMap.get(update.getId());
            update.setClassType(interceptor.getClassType());
            update.setInterceptor(interceptor.getInterceptor());
            update.setSort(interceptor.getSort());
            this.dataViewAuthInterceptorRepository.save((Object)update);
        }
        for (DataViewAuthInterceptorEntity create : creates) {
            create.setId(null);
            create.setDataViewAuth(auth);
            create.setProjectName(ApplicationContextUtils.getProjectName());
            this.dataViewAuthInterceptorRepository.save((Object)create);
        }
        updates.addAll(creates);
        return updates;
    }

    @Override
    public Set<DataViewAuthInterceptorEntity> findByAuthId(String authId) {
        if (StringUtils.isBlank((CharSequence)authId)) {
            return Sets.newHashSet();
        }
        DataViewAuthEntity auth = new DataViewAuthEntity();
        auth.setId(authId);
        return this.dataViewAuthInterceptorRepository.findByAuth(auth);
    }

    @Override
    @Transactional
    public void deleteByAuthId(String authId) {
        Validate.notBlank((CharSequence)authId, (String)"\u6743\u9650ID\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Set<DataViewAuthInterceptorEntity> interceptors = this.findByAuthId(authId);
        if (CollectionUtils.isEmpty(interceptors)) {
            return;
        }
        this.dataViewAuthInterceptorRepository.deleteAll(interceptors);
    }

    private void saveValidation(String authId, Set<DataViewAuthInterceptorEntity> interceptors) {
        Validate.notBlank((CharSequence)authId, (String)"\u6743\u9650\u5bf9\u8c61\u7684ID\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        if (CollectionUtils.isEmpty(interceptors)) {
            return;
        }
        HashSet interceptorSet = Sets.newHashSet();
        for (DataViewAuthInterceptorEntity interceptor : interceptors) {
            Validate.notNull((Object)((Object)interceptor), (String)"\u4fdd\u5b58\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a\uff01\uff01", (Object[])new Object[0]);
            Validate.notBlank((CharSequence)interceptor.getInterceptor(), (String)"\u62e6\u622a\u5668\u4e0d\u80fd\u4e3a\u7a7a\uff01\uff01", (Object[])new Object[0]);
            Validate.notNull((Object)interceptor.getClassType(), (String)"\u62e6\u622a\u5668\u7c7b\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            Validate.notNull((Object)interceptor.getSort(), (String)"\u6392\u5e8f\u5b57\u6bb5\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            Validate.isTrue((boolean)interceptorSet.add(interceptor.getInterceptor()), (String)"\u91cd\u590d\u7684\u62e6\u622a\u5668\uff1a%s", (Object[])new Object[]{interceptor.getInterceptor()});
        }
    }

    @Override
    public List<String> findAll() {
        String[] result = this.applicationContext.getBeanNamesForType(DataViewAuthInterceptor.class);
        if (result.length <= 0) {
            return Lists.newArrayList();
        }
        return Arrays.asList(result);
    }
}

