/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.core.service.dataview.internal;

import com.bizunited.platform.common.vo.UuidVo;
import com.bizunited.platform.core.common.enums.AuthTypeEnum;
import com.bizunited.platform.core.entity.dauth.DataAuthTypeEntity;
import com.bizunited.platform.rbac.server.service.RoleService;
import com.bizunited.platform.user.common.service.organization.OrganizationService;
import com.bizunited.platform.user.common.service.position.PositionService;
import com.bizunited.platform.user.common.service.user.UserService;
import com.bizunited.platform.user.common.service.userGroup.UserGroupService;
import com.bizunited.platform.user.common.vo.UserVo;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="DataViewAuthRelationService")
public class DataViewAuthRelationService {
    private static final Logger LOGGER = LoggerFactory.getLogger(DataViewAuthRelationService.class);
    @Autowired
    private UserService userService;
    @Autowired
    private RoleService roleService;
    @Autowired
    private PositionService positionService;
    @Autowired
    private UserGroupService userGroupService;
    @Autowired
    private OrganizationService organizationService;

    public UuidVo findRelation(String relationId, DataAuthTypeEntity authType) {
        if (StringUtils.isBlank((CharSequence)relationId)) {
            return null;
        }
        if (authType == null) {
            return null;
        }
        if (authType.getExpand() == 0) {
            return this.findInnerRelation(relationId, authType);
        }
        return this.findExpandRelation(relationId, authType);
    }

    public UuidVo findInnerRelation(String relationId, DataAuthTypeEntity authType) {
        if (StringUtils.isBlank((CharSequence)relationId)) {
            return null;
        }
        if (authType == null) {
            return null;
        }
        UserVo relation = null;
        AuthTypeEnum authTypeEnum = AuthTypeEnum.valueOfType(authType.getInnerValue());
        if (authTypeEnum == null) {
            LOGGER.warn("\u672a\u77e5\u7684\u6743\u9650\u7c7b\u578b:{}", (Object)authType);
            return null;
        }
        switch (authTypeEnum) {
            case USER: {
                relation = this.userService.findByAccount(relationId);
                break;
            }
            case ROLE: {
                relation = this.roleService.findByCode(relationId);
                break;
            }
            case POSITION: {
                relation = this.positionService.findByCode(relationId);
                break;
            }
            case GROUP: {
                relation = this.userGroupService.findByCode(relationId);
                break;
            }
            case ORG: {
                relation = this.organizationService.findByCode(relationId);
                break;
            }
        }
        return relation;
    }

    private UuidVo findExpandRelation(String relationId, DataAuthTypeEntity authType) {
        if (StringUtils.isBlank((CharSequence)relationId)) {
            return null;
        }
        if (authType == null) {
            return null;
        }
        UuidVo relation = null;
        return relation;
    }
}

