/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.core.service.dataview.internal;

import com.bizunited.platform.common.enums.ImportExecuteModeEnum;
import com.bizunited.platform.common.model.MigrateImportModel;
import com.bizunited.platform.common.util.ApplicationContextUtils;
import com.bizunited.platform.core.entity.DataViewAuthEntity;
import com.bizunited.platform.core.entity.DataViewAuthHorizontalEntity;
import com.bizunited.platform.core.entity.DataViewAuthHorizontalRelationEntity;
import com.bizunited.platform.core.entity.DataViewAuthInterceptorEntity;
import com.bizunited.platform.core.entity.DataViewAuthVerticalEntity;
import com.bizunited.platform.core.entity.DataViewAuthVerticalRelationEntity;
import com.bizunited.platform.core.entity.DataViewEntity;
import com.bizunited.platform.core.entity.dauth.DataAuthPreRuleEntity;
import com.bizunited.platform.core.repository.dataview.DataViewAuthRepository;
import com.bizunited.platform.core.service.dataview.DataViewAuthHorizontalService;
import com.bizunited.platform.core.service.dataview.DataViewAuthInterceptorService;
import com.bizunited.platform.core.service.dataview.DataViewAuthService;
import com.bizunited.platform.core.service.dataview.DataViewAuthVerticalService;
import com.bizunited.platform.core.service.dataview.DataViewService;
import com.bizunited.platform.core.service.dauth.DataAuthPreRuleEntityService;
import com.bizunited.platform.rbac.server.util.SecurityUtils;
import com.google.common.collect.Sets;
import java.util.Date;
import java.util.List;
import java.util.Set;
import javax.transaction.Transactional;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="DataViewAuthServiceImpl")
public class DataViewAuthServiceImpl
implements DataViewAuthService {
    @Autowired
    private DataViewAuthRepository dataViewAuthRepository;
    @Autowired
    private DataViewService dataViewService;
    @Autowired
    private DataViewAuthVerticalService dataViewAuthVerticalService;
    @Autowired
    private DataViewAuthHorizontalService dataViewAuthHorizontalService;
    @Autowired
    private DataViewAuthInterceptorService dataViewAuthInterceptorService;
    @Autowired
    private DataAuthPreRuleEntityService dataAuthPreRuleEntityService;

    @Override
    @Transactional
    public DataViewAuthEntity create(DataViewAuthEntity dataViewAuth) {
        this.createValidation(dataViewAuth);
        SecurityUtils.getCurrentUser();
        dataViewAuth.setCreateTime(new Date());
        dataViewAuth.setProjectName(ApplicationContextUtils.getProjectName());
        this.dataViewAuthRepository.save((Object)dataViewAuth);
        return dataViewAuth;
    }

    private void createValidation(DataViewAuthEntity dataViewAuth) {
        Validate.notNull((Object)((Object)dataViewAuth), (String)"\u4f20\u5165\u7684\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)((Object)dataViewAuth.getDataView()), (String)"\u5173\u8054\u7684\u6570\u636e\u89c6\u56fe\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        String dataViewId = dataViewAuth.getDataView().getId();
        Validate.notBlank((CharSequence)dataViewId, (String)"\u5173\u8054\u7684\u6570\u636e\u89c6\u56feID\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        DataViewEntity dataView = this.dataViewService.findById(dataViewId);
        Validate.notNull((Object)((Object)dataView), (String)"\u672a\u627e\u5230\u6570\u636e\u89c6\u56fe:%s", (Object[])new Object[]{dataViewId});
        Validate.notBlank((CharSequence)dataViewAuth.getCode(), (String)"\u6743\u9650\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dataViewAuth.getName(), (String)"\u6743\u9650\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.isTrue((dataViewAuth.getId() == null ? 1 : 0) != 0, (String)"\u65b0\u589e\u6570\u636e\u4e0d\u80fd\u4f20\u5165ID", (Object[])new Object[0]);
        long count = this.dataViewAuthRepository.countByCode(dataViewAuth.getCode());
        Validate.isTrue((count == 0L ? 1 : 0) != 0, (String)"\u91cd\u590d\u7684\u6743\u9650\u7f16\u7801\uff1a%s", (Object[])new Object[]{dataViewAuth.getCode()});
    }

    private void updateValidation(DataViewAuthEntity dataViewAuth) {
        Validate.notNull((Object)((Object)dataViewAuth), (String)"\u4f20\u5165\u7684\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dataViewAuth.getCode(), (String)"\u6743\u9650\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dataViewAuth.getName(), (String)"\u6743\u9650\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dataViewAuth.getId(), (String)"\u66f4\u65b0\u6570\u636e\u5fc5\u987b\u4f20\u5165ID", (Object[])new Object[0]);
        long count = this.dataViewAuthRepository.countByCodeExcludeId(dataViewAuth.getCode(), dataViewAuth.getId());
        Validate.isTrue((count == 0L ? 1 : 0) != 0, (String)"\u91cd\u590d\u7684\u6743\u9650\u7f16\u7801\uff1a%s", (Object[])new Object[]{dataViewAuth.getCode()});
    }

    @Override
    @Transactional
    public DataViewAuthEntity update(DataViewAuthEntity dataViewAuth) {
        this.updateValidation(dataViewAuth);
        DataViewAuthEntity dbAuth = this.dataViewAuthRepository.findById(dataViewAuth.getId()).orElse(null);
        Validate.notNull((Object)((Object)dbAuth), (String)"\u66f4\u65b0\u7684\u5bf9\u8c61\u4e0d\u5b58\u5728", (Object[])new Object[0]);
        dbAuth.setCode(dataViewAuth.getCode());
        dbAuth.setName(dataViewAuth.getName());
        this.dataViewAuthRepository.save((Object)dbAuth);
        return dbAuth;
    }

    @Override
    public DataViewAuthEntity findById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        return this.dataViewAuthRepository.findById(id).orElse(null);
    }

    @Override
    public DataViewAuthEntity findDetailsByCode(String code) {
        if (StringUtils.isBlank((CharSequence)code)) {
            return null;
        }
        DataViewAuthEntity auth = this.dataViewAuthRepository.findDetailsByCode(code);
        if (auth == null) {
            return auth;
        }
        Set<DataViewAuthVerticalEntity> verticals = this.dataViewAuthVerticalService.findDetailsByAuthId(auth.getId());
        Set<DataViewAuthHorizontalEntity> horizontals = this.dataViewAuthHorizontalService.findDetailsByAuthId(auth.getId());
        Set<DataViewAuthInterceptorEntity> interceptors = this.dataViewAuthInterceptorService.findByAuthId(auth.getId());
        Set<DataAuthPreRuleEntity> preRules = this.dataAuthPreRuleEntityService.findByDataViewAuthCode(code);
        auth.setVerticalAuths(verticals);
        auth.setHorizontalAuths(horizontals);
        auth.setInterceptors(interceptors);
        auth.setPreAuths(preRules);
        return auth;
    }

    @Override
    public Set<DataViewAuthEntity> findByDataView(String dataViewCode) {
        if (StringUtils.isBlank((CharSequence)dataViewCode)) {
            return Sets.newHashSet();
        }
        return this.dataViewAuthRepository.findByDataViewCode(dataViewCode);
    }

    @Override
    public DataViewAuthEntity findDetailsByDataViewCodeAndCode(String dataViewCode, String authCode) {
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{dataViewCode, authCode})) {
            return null;
        }
        return this.dataViewAuthRepository.findDetailsByDataViewCodeAndCode(dataViewCode, authCode);
    }

    @Override
    public DataViewAuthEntity findDetailsByDataViewCodeAndCodeAndPreRule(String dataViewCode, String authCode, String preRuleCode) {
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{dataViewCode, authCode, preRuleCode})) {
            return null;
        }
        DataViewAuthEntity dataViewAuthEntity = this.dataViewAuthRepository.findDetailsByDataViewCodeAndCode(dataViewCode, authCode);
        if (dataViewAuthEntity == null) {
            return null;
        }
        Set<DataViewAuthHorizontalEntity> horizontalEntities = this.dataViewAuthHorizontalService.findByPreRuleCode(preRuleCode);
        Set<DataViewAuthVerticalEntity> verticalEntities = this.dataViewAuthVerticalService.findByPreRuleCode(preRuleCode);
        dataViewAuthEntity.setHorizontalAuths(horizontalEntities);
        dataViewAuthEntity.setVerticalAuths(verticalEntities);
        return dataViewAuthEntity;
    }

    @Override
    @Transactional
    public void deleteById(String id) {
        Validate.notBlank((CharSequence)id, (String)"\u4e3b\u952eID\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        DataViewAuthEntity auth = this.dataViewAuthRepository.findById(id).orElse(null);
        if (auth == null) {
            return;
        }
        this.dataViewAuthVerticalService.deleteByAuthId(id);
        this.dataViewAuthHorizontalService.deleteByAuthId(id);
        this.dataViewAuthInterceptorService.deleteByAuthId(id);
        Set<DataAuthPreRuleEntity> preRules = this.dataAuthPreRuleEntityService.findDetailsByDataViewAuthCode(auth.getCode());
        this.dataAuthPreRuleEntityService.deleteAll(preRules);
        this.dataViewAuthRepository.deleteById(id);
    }

    @Override
    public Set<DataViewAuthEntity> findDetailsByDataViewIds(String[] dataviewIds) {
        if (dataviewIds == null || dataviewIds.length == 0) {
            return Sets.newHashSet();
        }
        Set<DataViewAuthEntity> auths = this.dataViewAuthRepository.findDetailsByDataViewIds(dataviewIds);
        if (CollectionUtils.isEmpty(auths)) {
            return auths;
        }
        for (DataViewAuthEntity auth : auths) {
            Set<DataViewAuthVerticalEntity> verticals = this.dataViewAuthVerticalService.findDetailsByAuthId(auth.getId());
            Set<DataViewAuthHorizontalEntity> horizontals = this.dataViewAuthHorizontalService.findDetailsByAuthId(auth.getId());
            Set<DataViewAuthInterceptorEntity> interceptors = this.dataViewAuthInterceptorService.findByAuthId(auth.getId());
            Set<DataAuthPreRuleEntity> preRules = this.dataAuthPreRuleEntityService.findByDataViewAuthCode(auth.getCode());
            auth.setVerticalAuths(verticals);
            auth.setHorizontalAuths(horizontals);
            auth.setInterceptors(interceptors);
            auth.setPreAuths(preRules);
        }
        return auths;
    }

    @Override
    @Transactional
    public void importAuths(List<DataViewAuthEntity> auths, MigrateImportModel importModel) {
        if (CollectionUtils.isEmpty(auths)) {
            importModel.appendLine("\u4e0d\u9700\u8981\u5bfc\u5165\u6570\u636e\u6743\u9650");
            return;
        }
        importModel.appendLine("\u5f00\u59cb\u6279\u91cf\u5bfc\u5165\u6570\u636e\u6743\u9650");
        for (DataViewAuthEntity auth : auths) {
            this.importAuth(auth, importModel);
        }
        importModel.appendLine("\u6279\u91cf\u5bfc\u5165\u6570\u636e\u6743\u9650\u6210\u529f");
        importModel.appendLine("\u5b8c\u6210\u6570\u636e\u6743\u9650\u5bfc\u5165");
    }

    @Override
    @Transactional
    public void importAuth(DataViewAuthEntity importAuth, MigrateImportModel importModel) {
        Validate.notNull((Object)((Object)importAuth), (String)"\u5bfc\u5165\u7684\u6570\u636e\u6743\u9650\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)importAuth.getCode(), (String)"\u5bfc\u5165\u7684\u6570\u636e\u6743\u9650\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        importModel.append("\u5f00\u59cb\u5bfc\u5165\u6570\u636e\u6743\u9650\uff1a").appendLine(importAuth.getName());
        DataViewEntity importDataView = importAuth.getDataView();
        Validate.notNull((Object)((Object)importDataView), (String)"\u5bfc\u5165\u7684\u6570\u636e\u6743\u9650\u7f3a\u5931\u6570\u636e\u89c6\u56fe\uff0c\u8bf7\u68c0\u67e5\u6570\u636e\uff01\uff01", (Object[])new Object[0]);
        DataViewEntity dataView = this.dataViewService.findByCode(importDataView.getCode());
        Validate.notNull((Object)((Object)dataView), (String)"\u672a\u627e\u5230\u6570\u636e\u6743\u9650\u5173\u8054\u7684\u6570\u636e\u89c6\u56fe\uff1a%s", (Object[])new Object[]{importDataView.getCode()});
        importAuth.setDataView(dataView);
        this.handleImportId(importAuth);
        ImportExecuteModeEnum executeMode = importModel.getExecuteMode();
        long count = this.dataViewAuthRepository.countByCode(importAuth.getCode());
        if (count > 0L && ImportExecuteModeEnum.SKIP == executeMode) {
            importModel.appendLine("\u6570\u636e\u6743\u9650\u5df2\u5b58\u5728\uff0c\u8df3\u8fc7\u672c\u6b21\u5bfc\u5165");
            return;
        }
        if (count > 0L && ImportExecuteModeEnum.UPDATE == executeMode) {
            importModel.appendLine("\u6570\u636e\u6743\u9650\u5df2\u5b58\u5728\uff0c\u6267\u884c\u66f4\u65b0\u5bfc\u5165");
            this.handleUpdateData(importAuth);
            return;
        }
        if (count == 0L) {
            importModel.appendLine("\u6267\u884c\u6570\u636e\u6743\u9650\u7684\u65b0\u589e\u5bfc\u5165");
            this.handleCreateData(importAuth);
        }
    }

    private void handleUpdateData(DataViewAuthEntity importAuth) {
        DataViewAuthEntity dbAuth = this.dataViewAuthRepository.findDetailsByCode(importAuth.getCode());
        Validate.notNull((Object)((Object)dbAuth), (String)"\u6570\u636e\u6743\u9650\u4e0d\u5b58\u5728", (Object[])new Object[0]);
        importAuth.setId(dbAuth.getId());
        this.update(importAuth);
        this.saveAuthDetails(importAuth);
    }

    private void saveAuthDetails(DataViewAuthEntity importAuth) {
        this.dataViewAuthVerticalService.save(importAuth.getId(), importAuth.getVerticalAuths());
        this.dataViewAuthHorizontalService.save(importAuth.getId(), importAuth.getHorizontalAuths());
        this.dataViewAuthInterceptorService.save(importAuth.getId(), importAuth.getInterceptors());
        Set<DataAuthPreRuleEntity> preRuleEntitySet = importAuth.getPreAuths();
        for (DataAuthPreRuleEntity preRuleEntity : preRuleEntitySet) {
            preRuleEntity.setDataViewAuth(importAuth);
        }
        this.dataAuthPreRuleEntityService.save(importAuth.getCode(), preRuleEntitySet);
    }

    private void handleCreateData(DataViewAuthEntity importAuth) {
        this.dataViewAuthRepository.save((Object)importAuth);
        this.saveAuthDetails(importAuth);
    }

    private void handleImportId(DataViewAuthEntity importAuth) {
        Set<DataAuthPreRuleEntity> set;
        Set<DataViewAuthInterceptorEntity> set2;
        Set<DataViewAuthVerticalEntity> verticalAuths;
        importAuth.setId(null);
        Set<DataViewAuthHorizontalEntity> horizontalAuths = importAuth.getHorizontalAuths();
        if (!CollectionUtils.isEmpty(horizontalAuths)) {
            for (DataViewAuthHorizontalEntity dataViewAuthHorizontalEntity : horizontalAuths) {
                dataViewAuthHorizontalEntity.setId(null);
                Set<DataViewAuthHorizontalRelationEntity> set3 = dataViewAuthHorizontalEntity.getAuthRelations();
                if (CollectionUtils.isEmpty(set3)) continue;
                for (DataViewAuthHorizontalRelationEntity dataViewAuthHorizontalRelationEntity : set3) {
                    dataViewAuthHorizontalRelationEntity.setId(null);
                }
            }
        }
        if (!CollectionUtils.isEmpty(verticalAuths = importAuth.getVerticalAuths())) {
            for (DataViewAuthVerticalEntity dataViewAuthVerticalEntity : verticalAuths) {
                dataViewAuthVerticalEntity.setId(null);
                Set<DataViewAuthVerticalRelationEntity> relations = dataViewAuthVerticalEntity.getAuthRelations();
                if (CollectionUtils.isEmpty(relations)) continue;
                for (DataViewAuthVerticalRelationEntity relation : relations) {
                    relation.setId(null);
                }
            }
        }
        if (!CollectionUtils.isEmpty(set2 = importAuth.getInterceptors())) {
            for (DataViewAuthInterceptorEntity interceptor : set2) {
                interceptor.setId(null);
            }
        }
        if (!CollectionUtils.isEmpty(set = importAuth.getPreAuths())) {
            for (DataAuthPreRuleEntity dataAuthPreRuleEntity : set) {
                dataAuthPreRuleEntity.setId(null);
            }
        }
    }
}

