/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.core.service.dataview.internal;

import com.bizunited.platform.common.entity.UuidEntity;
import com.bizunited.platform.common.service.NebulaToolkitService;
import com.bizunited.platform.common.util.ApplicationContextUtils;
import com.bizunited.platform.common.vo.UuidVo;
import com.bizunited.platform.core.entity.DataViewAuthVerticalEntity;
import com.bizunited.platform.core.entity.DataViewAuthVerticalRelationEntity;
import com.bizunited.platform.core.repository.dataview.DataViewAuthVerticalRelationRepository;
import com.bizunited.platform.core.service.dataview.DataViewAuthVerticalRelationService;
import com.bizunited.platform.core.service.dataview.DataViewAuthVerticalService;
import com.bizunited.platform.core.service.dataview.internal.DataViewAuthRelationService;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.transaction.Transactional;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="DataViewAuthVerticalRelationServiceImpl")
public class DataViewAuthVerticalRelationServiceImpl
implements DataViewAuthVerticalRelationService {
    @Autowired
    private DataViewAuthVerticalRelationRepository dataViewAuthVerticalRelationRepository;
    @Autowired
    private NebulaToolkitService nebulaToolkitService;
    @Autowired
    private DataViewAuthVerticalService dataViewAuthVerticalService;
    @Autowired
    private DataViewAuthRelationService dataViewAuthRelationService;

    @Override
    public Set<DataViewAuthVerticalRelationEntity> findDetailsByAuthVertical(String authVertical) {
        if (StringUtils.isBlank((CharSequence)authVertical)) {
            return Sets.newHashSet();
        }
        DataViewAuthVerticalEntity vertical = this.dataViewAuthVerticalService.findById(authVertical);
        if (vertical == null) {
            return Sets.newHashSet();
        }
        Set<DataViewAuthVerticalRelationEntity> relations = this.dataViewAuthVerticalRelationRepository.findDetailsByAuthVertical(authVertical);
        if (CollectionUtils.isEmpty(relations)) {
            return relations;
        }
        for (DataViewAuthVerticalRelationEntity relation : relations) {
            UuidVo relationObj = null;
            relationObj = vertical.getAuthType().getExpand() == 0 ? this.dataViewAuthRelationService.findInnerRelation(relation.getAuthRelationIds(), vertical.getAuthType()) : this.dataViewAuthRelationService.findInnerRelation(relation.getAuthRelationIds(), vertical.getAuthType());
            relation.setRelation(relationObj);
        }
        return relations;
    }

    @Override
    public DataViewAuthVerticalRelationEntity findDetailsById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        return this.dataViewAuthVerticalRelationRepository.findDetailsById(id);
    }

    @Override
    public DataViewAuthVerticalRelationEntity findById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        Optional op = this.dataViewAuthVerticalRelationRepository.findById(id);
        return op.orElse(null);
    }

    @Override
    @Transactional
    public void deleteById(String id) {
        Validate.notBlank((CharSequence)id, (String)"\u8fdb\u884c\u5220\u9664\u65f6\uff0c\u5fc5\u987b\u7ed9\u5b9a\u4e3b\u952e\u4fe1\u606f!!", (Object[])new Object[0]);
        Optional op = this.dataViewAuthVerticalRelationRepository.findById(id);
        op.ifPresent(dataViewAuthVerticalRelationEntity -> this.dataViewAuthVerticalRelationRepository.delete(dataViewAuthVerticalRelationEntity));
    }

    @Override
    @Transactional
    public void deleteByAuthVertical(String authVerticalId) {
        Validate.notBlank((CharSequence)authVerticalId, (String)"\u8fdb\u884c\u5220\u9664\u65f6\uff0c\u5fc5\u987b\u7ed9\u5b9a\u7eb5\u5411\u6570\u636e\u6743\u9650\u4e3b\u952e\u4fe1\u606f!!", (Object[])new Object[0]);
        this.dataViewAuthVerticalRelationRepository.deleteByAuthVertical(authVerticalId);
    }

    @Override
    @Transactional
    public Set<DataViewAuthVerticalRelationEntity> save(DataViewAuthVerticalEntity authVertical, Set<DataViewAuthVerticalRelationEntity> authRelations) {
        this.saveValidation(authVertical, authRelations);
        if (authRelations == null) {
            authRelations = Sets.newHashSet();
        }
        Map<String, DataViewAuthVerticalRelationEntity> authRelationsMap = authRelations.stream().collect(Collectors.toMap(UuidEntity::getId, r -> r, (r1, r2) -> r1));
        Set<DataViewAuthVerticalRelationEntity> dbAuthRelations = this.dataViewAuthVerticalRelationRepository.findDetailsByAuthVertical(authVertical.getId());
        HashSet deletes = Sets.newHashSet();
        HashSet updates = Sets.newHashSet();
        HashSet creates = Sets.newHashSet();
        this.nebulaToolkitService.collectionDiscrepancy((Collection)authRelations, dbAuthRelations, UuidEntity::getId, (Collection)deletes, (Collection)updates, (Collection)creates);
        for (DataViewAuthVerticalRelationEntity delete : deletes) {
            this.dataViewAuthVerticalRelationRepository.delete((Object)delete);
        }
        for (DataViewAuthVerticalRelationEntity update : updates) {
            DataViewAuthVerticalRelationEntity relation = authRelationsMap.get(update.getId());
            update.setAuthRelationIds(relation.getAuthRelationIds());
            update.setSortIndex(relation.getSortIndex());
            update.setRelation(relation.getRelation());
            this.dataViewAuthVerticalRelationRepository.save((Object)update);
        }
        for (DataViewAuthVerticalRelationEntity create : creates) {
            create.setAuthVertical(authVertical);
            create.setProjectName(ApplicationContextUtils.getProjectName());
            this.dataViewAuthVerticalRelationRepository.save((Object)create);
        }
        updates.addAll(creates);
        return updates;
    }

    private void saveValidation(DataViewAuthVerticalEntity authVertical, Set<DataViewAuthVerticalRelationEntity> authRelations) {
        Validate.notNull((Object)((Object)authVertical), (String)"\u7ad6\u5411\u6743\u9650\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)authVertical.getId(), (String)"\u7ad6\u5411\u6743\u9650ID\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        DataViewAuthVerticalEntity vertical = this.dataViewAuthVerticalService.findById(authVertical.getId());
        Validate.notNull((Object)((Object)vertical), (String)"\u672a\u627e\u5230\u7ad6\u5411\u6743\u9650\uff1a%s", (Object[])new Object[]{authVertical.getId()});
        if (CollectionUtils.isEmpty(authRelations)) {
            return;
        }
        for (DataViewAuthVerticalRelationEntity authRelation : authRelations) {
            Validate.notNull((Object)authRelation.getAuthRelationIds(), (String)"\u6743\u9650\u503c\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            Validate.notNull((Object)authRelation.getSortIndex(), (String)"\u6743\u9650\u503c\u6392\u5e8f\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            UuidVo relationObj = this.dataViewAuthRelationService.findInnerRelation(authRelation.getAuthRelationIds(), vertical.getAuthType());
            Validate.notNull((Object)relationObj, (String)"\u672a\u627e\u5230\u6743\u9650\u503c\uff1a%s", (Object[])new Object[]{authRelation.getAuthRelationIds()});
            authRelation.setRelation(relationObj);
        }
    }
}

