/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.core.service.dataview.internal;

import com.bizunited.platform.common.entity.UuidEntity;
import com.bizunited.platform.common.service.NebulaToolkitService;
import com.bizunited.platform.common.util.ApplicationContextUtils;
import com.bizunited.platform.core.common.enums.AuthOperatorEnum;
import com.bizunited.platform.core.entity.DataViewAuthEntity;
import com.bizunited.platform.core.entity.DataViewAuthVerticalEntity;
import com.bizunited.platform.core.entity.DataViewAuthVerticalRelationEntity;
import com.bizunited.platform.core.repository.dataview.DataViewAuthVerticalRepository;
import com.bizunited.platform.core.service.dataview.DataViewAuthService;
import com.bizunited.platform.core.service.dataview.DataViewAuthVerticalRelationService;
import com.bizunited.platform.core.service.dataview.DataViewAuthVerticalService;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.transaction.Transactional;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="DataViewAuthVerticalServiceImpl")
public class DataViewAuthVerticalServiceImpl
implements DataViewAuthVerticalService {
    @Autowired
    private DataViewAuthVerticalRepository dataViewAuthVerticalRepository;
    @Autowired
    private DataViewAuthService dataViewAuthService;
    @Autowired
    private DataViewAuthVerticalRelationService dataViewAuthVerticalRelationService;
    @Autowired
    private NebulaToolkitService nebulaToolkitService;

    @Override
    @Transactional
    public Set<DataViewAuthVerticalEntity> save(String authId, Set<DataViewAuthVerticalEntity> authVerticals) {
        this.saveValidation(authId, authVerticals);
        DataViewAuthEntity auth = this.dataViewAuthService.findById(authId);
        Validate.notNull((Object)((Object)auth), (String)"\u672a\u627e\u5230\u6570\u636e\u6743\u9650\uff1a%s", (Object[])new Object[]{authId});
        if (authVerticals == null) {
            authVerticals = Sets.newHashSet();
        }
        Map<String, DataViewAuthVerticalEntity> authVerticalsMap = authVerticals.stream().collect(Collectors.toMap(UuidEntity::getId, v -> v, (v1, v2) -> v2));
        Set<DataViewAuthVerticalEntity> dbAuthVerticals = this.dataViewAuthVerticalRepository.findByAuth(auth);
        HashSet creates = Sets.newHashSet();
        HashSet updates = Sets.newHashSet();
        HashSet deletes = Sets.newHashSet();
        this.nebulaToolkitService.collectionDiscrepancy((Collection)authVerticals, dbAuthVerticals, UuidEntity::getId, (Collection)deletes, (Collection)updates, (Collection)creates);
        for (DataViewAuthVerticalEntity delete : deletes) {
            this.dataViewAuthVerticalRelationService.deleteByAuthVertical(delete.getId());
            this.dataViewAuthVerticalRepository.delete((Object)delete);
        }
        for (DataViewAuthVerticalEntity update : updates) {
            DataViewAuthVerticalEntity authVertical = authVerticalsMap.get(update.getId());
            update.setAuthType(authVertical.getAuthType());
            update.setPreRule(authVertical.getPreRule());
            update.setDisplayFields(authVertical.getDisplayFields());
            update.setOprtType(authVertical.getOprtType());
            if (authVertical.getSortIndex() != null) {
                update.setSortIndex(authVertical.getSortIndex());
            }
            Set<DataViewAuthVerticalRelationEntity> relations = this.dataViewAuthVerticalRelationService.save(update, update.getAuthRelations());
            update.setAuthRelations(relations);
        }
        for (DataViewAuthVerticalEntity create : creates) {
            if (create.getSortIndex() == null) {
                create.setSortIndex(0);
            }
            create.setId(null);
            create.setDataViewAuth(auth);
            create.setProjectName(ApplicationContextUtils.getProjectName());
            this.dataViewAuthVerticalRepository.save((Object)create);
            Set<DataViewAuthVerticalRelationEntity> relations = this.dataViewAuthVerticalRelationService.save(create, create.getAuthRelations());
            create.setAuthRelations(relations);
        }
        updates.addAll(creates);
        return updates;
    }

    private void validation(DataViewAuthVerticalEntity authVertical) {
        Validate.notBlank((CharSequence)authVertical.getDisplayFields(), (String)"\u663e\u793a\u7684\u5b57\u6bb5\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)authVertical.getOprtType(), (String)"\u64cd\u4f5c\u7b26\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)((Object)AuthOperatorEnum.valueOf(authVertical.getOprtType())), (String)"\u4e0d\u652f\u6301\u7684\u64cd\u4f5c\u7b26\uff1a%s", (Object[])new Object[]{authVertical.getOprtType()});
        Validate.notNull((Object)((Object)authVertical.getAuthType()), (String)"\u6743\u9650\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notEmpty(authVertical.getAuthRelations(), (String)"\u6743\u9650\u503c\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
    }

    private void saveValidation(String authId, Set<DataViewAuthVerticalEntity> authVerticals) {
        Validate.notBlank((CharSequence)authId, (String)"\u6743\u9650\u5bf9\u8c61\u7684ID\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        if (CollectionUtils.isEmpty(authVerticals)) {
            return;
        }
        for (DataViewAuthVerticalEntity authVertical : authVerticals) {
            this.validation(authVertical);
        }
    }

    @Override
    public DataViewAuthVerticalEntity findDetailsById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        return this.dataViewAuthVerticalRepository.findDetailsById(id);
    }

    @Override
    public DataViewAuthVerticalEntity findById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        Optional op = this.dataViewAuthVerticalRepository.findById(id);
        return op.orElse(null);
    }

    @Override
    @Transactional
    public void deleteById(String id) {
        Validate.notBlank((CharSequence)id, (String)"\u8fdb\u884c\u5220\u9664\u65f6\uff0c\u5fc5\u987b\u7ed9\u5b9a\u4e3b\u952e\u4fe1\u606f!!", (Object[])new Object[0]);
        DataViewAuthVerticalEntity av = this.dataViewAuthVerticalRepository.findById(id).orElse(null);
        if (av == null) {
            return;
        }
        this.dataViewAuthVerticalRelationService.deleteByAuthVertical(id);
        this.dataViewAuthVerticalRepository.delete((Object)av);
    }

    @Override
    public Set<DataViewAuthVerticalEntity> findDetailsByAuthId(String authId) {
        if (StringUtils.isBlank((CharSequence)authId)) {
            return Sets.newHashSet();
        }
        DataViewAuthEntity auth = new DataViewAuthEntity();
        auth.setId(authId);
        Set<DataViewAuthVerticalEntity> verticals = this.dataViewAuthVerticalRepository.findByAuth(auth);
        if (CollectionUtils.isEmpty(verticals)) {
            return Sets.newHashSet();
        }
        for (DataViewAuthVerticalEntity vertical : verticals) {
            Set<DataViewAuthVerticalRelationEntity> relations = this.dataViewAuthVerticalRelationService.findDetailsByAuthVertical(vertical.getId());
            vertical.setAuthRelations(relations);
        }
        return verticals;
    }

    @Override
    @Transactional
    public void deleteByAuthId(String authId) {
        Validate.notBlank((CharSequence)authId, (String)"\u6743\u9650ID\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        DataViewAuthEntity auth = new DataViewAuthEntity();
        auth.setId(authId);
        Set<DataViewAuthVerticalEntity> verticals = this.dataViewAuthVerticalRepository.findByAuth(auth);
        if (CollectionUtils.isEmpty(verticals)) {
            return;
        }
        for (DataViewAuthVerticalEntity vertical : verticals) {
            this.dataViewAuthVerticalRelationService.deleteByAuthVertical(vertical.getId());
        }
        this.dataViewAuthVerticalRepository.deleteAll(verticals);
    }

    @Override
    public Set<DataViewAuthVerticalEntity> findDetailsByAuthCode(String authCode) {
        if (StringUtils.isBlank((CharSequence)authCode)) {
            return Sets.newHashSet();
        }
        Set<DataViewAuthVerticalEntity> verticals = this.dataViewAuthVerticalRepository.findByCode(authCode);
        if (CollectionUtils.isEmpty(verticals)) {
            return Sets.newHashSet();
        }
        for (DataViewAuthVerticalEntity vertical : verticals) {
            Set<DataViewAuthVerticalRelationEntity> relations = this.dataViewAuthVerticalRelationService.findDetailsByAuthVertical(vertical.getId());
            vertical.setAuthRelations(relations);
        }
        return verticals;
    }

    @Override
    public Set<DataViewAuthVerticalEntity> findByPreRuleCode(String preRuleCode) {
        if (StringUtils.isBlank((CharSequence)preRuleCode)) {
            return null;
        }
        return this.dataViewAuthVerticalRepository.findByPreRuleCode(preRuleCode);
    }
}

