/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.core.service.dataview.internal;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.bizunited.platform.common.service.NebulaToolkitService;
import com.bizunited.platform.common.util.ApplicationContextUtils;
import com.bizunited.platform.common.util.ChineseCharUtils;
import com.bizunited.platform.core.entity.DataSourceEntity;
import com.bizunited.platform.core.entity.DataViewAuthEntity;
import com.bizunited.platform.core.entity.DataViewEntity;
import com.bizunited.platform.core.entity.DataViewGroupEntity;
import com.bizunited.platform.core.repository.dataview.DataViewGroupRepository;
import com.bizunited.platform.core.repository.dataview.DataViewRepository;
import com.bizunited.platform.core.repository.dataview.DataViewThirdDataSourceRepository;
import com.bizunited.platform.core.service.dataview.DataSourceService;
import com.bizunited.platform.core.service.dataview.DataViewAuthService;
import com.bizunited.platform.core.service.dataview.DataViewGroupService;
import com.bizunited.platform.core.service.dataview.DataViewService;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.transaction.Transactional;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="DataViewGroupEntityServiceImpl")
public class DataViewGroupServiceImpl
implements DataViewGroupService {
    @Autowired
    private DataViewRepository dataViewRepository;
    @Autowired
    private DataViewGroupRepository dataViewGroupEntityRepository;
    @Autowired
    private DataViewThirdDataSourceRepository dataViewThirdDataSourceRepository;
    @Autowired
    private DataViewService dataViewService;
    @Autowired
    private DataSourceService dataSourceService;
    @Autowired
    private DataViewAuthService dataViewAuthService;
    @Autowired
    private NebulaToolkitService nebulaToolkitService;

    @Override
    public void createValidation(DataViewGroupEntity dataViewGroupEntity) {
        Validate.notNull((Object)((Object)dataViewGroupEntity), (String)"\u8fdb\u884c\u5f53\u524d\u64cd\u4f5c\u65f6\uff0c\u4fe1\u606f\u5bf9\u8c61\u5fc5\u987b\u4f20\u5165!!", (Object[])new Object[0]);
        Validate.isTrue((boolean)StringUtils.isBlank((CharSequence)dataViewGroupEntity.getId()), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u5f53\u671f\u4fe1\u606f\u7684\u6570\u636e\u7f16\u53f7\uff08\u4e3b\u952e\uff09\u4e0d\u80fd\u6709\u503c\uff01", (Object[])new Object[0]);
        dataViewGroupEntity.setId(null);
        Validate.notBlank((CharSequence)dataViewGroupEntity.getGroupName(), (String)"\u5206\u7ec4\u540d(\u4e2d\u6587\u540d)\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dataViewGroupEntity.getCode(), (String)"\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dataViewGroupEntity.getTargetTable(), (String)"\u57fa\u51c6\u6570\u636e\u8868\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.isTrue((dataViewGroupEntity.getGroupName() == null || dataViewGroupEntity.getGroupName().length() < 64 ? 1 : 0) != 0, (String)"\u5206\u7ec4\u540d(\u4e2d\u6587\u540d),\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(64)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((dataViewGroupEntity.getTargetTable() == null || dataViewGroupEntity.getTargetTable().length() < 64 ? 1 : 0) != 0, (String)"\u57fa\u51c6\u6570\u636e\u8868,\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(64)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        long count = this.dataViewGroupEntityRepository.countByCode(dataViewGroupEntity.getCode());
        Validate.isTrue((count == 0L ? 1 : 0) != 0, (String)"\u91cd\u590d\u5206\u7ec4\u7f16\u7801\uff1a%s", (Object[])new Object[]{dataViewGroupEntity.getCode()});
        List<DataViewGroupEntity> existGroups = this.dataViewGroupEntityRepository.findDetails();
        HashSet mainGroups = new HashSet();
        HashSet threeGroups = new HashSet();
        if (CollectionUtils.isEmpty(existGroups)) {
            return;
        }
        existGroups.stream().forEach(e -> {
            if (e.getDataSource() == null) {
                mainGroups.add(e);
            } else {
                threeGroups.add(e);
            }
        });
        if (dataViewGroupEntity.getDataSource() == null) {
            Validate.isTrue((boolean)mainGroups.stream().allMatch(e -> !StringUtils.equals((CharSequence)e.getTargetTable(), (CharSequence)dataViewGroupEntity.getTargetTable())), (String)"\u65b0\u589e\u57fa\u51c6\u8868\u5df2\u5b58\u5728\u4e8e\u4e3b\u6570\u636e\u6e90\u5206\u7ec4:%s,\u8bf7\u68c0\u67e5", (Object[])new Object[]{dataViewGroupEntity.getTargetTable()});
        } else {
            Validate.isTrue((boolean)threeGroups.stream().allMatch(e -> !StringUtils.equals((CharSequence)e.getTargetTable(), (CharSequence)dataViewGroupEntity.getTargetTable())), (String)"\u65b0\u589e\u57fa\u51c6\u8868\u5df2\u5b58\u5728\u4e8e\u6570\u636e\u6e90\u5206\u7ec4:%s,\u8bf7\u68c0\u67e5", (Object[])new Object[]{dataViewGroupEntity.getTargetTable()});
        }
        this.validParent(dataViewGroupEntity);
    }

    @Override
    @Transactional
    public DataViewGroupEntity create(DataViewGroupEntity dataViewGroupEntity, boolean ignoreValidate) {
        if (StringUtils.isBlank((CharSequence)dataViewGroupEntity.getCode())) {
            dataViewGroupEntity.setCode(UUID.randomUUID().toString());
        }
        if (!ignoreValidate) {
            this.createValidation(dataViewGroupEntity);
        }
        DataSourceEntity dataSourceEntity = null;
        if (null != dataViewGroupEntity.getDataSource()) {
            DataSourceEntity dataSource = dataViewGroupEntity.getDataSource();
            Validate.notNull((Object)dataSource.getId(), (String)"\u6240\u9009\u6570\u636e\u6e90ID\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            dataSourceEntity = this.dataSourceService.findById(dataSource.getId());
            Validate.notNull((Object)((Object)dataSourceEntity), (String)"\u672a\u5728\u6570\u636e\u5e93\u4e2d\u627e\u5230\u7b2c\u4e09\u65b9\u6570\u636e\u6e90", (Object[])new Object[0]);
            Validate.isTrue((!ChineseCharUtils.hasChinese((String)dataViewGroupEntity.getTargetTable()) ? 1 : 0) != 0, (String)"\u57fa\u51c6\u8868\u8868\u540d\u4e0d\u80fd\u542b\u6709\u4e2d\u6587\uff0c\u8bf7\u68c0\u67e5\uff01", (Object[])new Object[0]);
        }
        if (null == dataSourceEntity) {
            this.dataViewRepository.checkTable(dataViewGroupEntity.getTargetTable());
        } else {
            this.dataViewThirdDataSourceRepository.checkTable(dataSourceEntity.getCode(), dataViewGroupEntity.getTargetTable());
        }
        dataViewGroupEntity.setCreateTime(new Date());
        dataViewGroupEntity.setProjectName(ApplicationContextUtils.getProjectName());
        return (DataViewGroupEntity)((Object)this.dataViewGroupEntityRepository.save((Object)dataViewGroupEntity));
    }

    @Override
    @Transactional
    public DataViewGroupEntity update(DataViewGroupEntity dataViewGroupEntity) {
        this.updateValidation(dataViewGroupEntity);
        String currentId = dataViewGroupEntity.getId();
        DataViewGroupEntity currentDataViewGroupEntity = this.dataViewGroupEntityRepository.findById(currentId).orElse(null);
        Validate.notNull((Object)((Object)currentDataViewGroupEntity), (String)"\u672a\u53d1\u73b0\u6307\u5b9a\u7684\u539f\u59cb\u6a21\u578b\u5bf9\u8c61\u4fe1", (Object[])new Object[0]);
        currentDataViewGroupEntity.setGroupName(dataViewGroupEntity.getGroupName());
        currentDataViewGroupEntity.setTargetTable(dataViewGroupEntity.getTargetTable());
        if (dataViewGroupEntity.getParent() != null) {
            currentDataViewGroupEntity.setParent(dataViewGroupEntity.getParent());
        }
        this.dataViewGroupEntityRepository.saveAndFlush((Object)currentDataViewGroupEntity);
        return currentDataViewGroupEntity;
    }

    @Override
    public void updateValidation(DataViewGroupEntity dataViewGroupEntity) {
        List sameSourceGroups;
        Validate.isTrue((!StringUtils.isBlank((CharSequence)dataViewGroupEntity.getId()) ? 1 : 0) != 0, (String)"\u4fee\u6539\u4fe1\u606f\u65f6\uff0c\u5f53\u671f\u4fe1\u606f\u7684\u6570\u636e\u7f16\u53f7\uff08\u4e3b\u952e\uff09\u5fc5\u987b\u6709\u503c\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dataViewGroupEntity.getGroupName(), (String)"\u5206\u7ec4\u540d(\u4e2d\u6587\u540d)\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dataViewGroupEntity.getTargetTable(), (String)"\u57fa\u51c6\u6570\u636e\u8868\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.isTrue((dataViewGroupEntity.getGroupName() == null || dataViewGroupEntity.getGroupName().length() < 64 ? 1 : 0) != 0, (String)"\u5206\u7ec4\u540d(\u4e2d\u6587\u540d),\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(64)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((dataViewGroupEntity.getTargetTable() == null || dataViewGroupEntity.getTargetTable().length() < 64 ? 1 : 0) != 0, (String)"\u57fa\u51c6\u6570\u636e\u8868,\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(64)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        DataViewGroupEntity dataViewGroup = this.dataViewGroupEntityRepository.findDetailsById(dataViewGroupEntity.getId());
        List<DataViewGroupEntity> existGroups = this.dataViewGroupEntityRepository.findDetails();
        if (!CollectionUtils.isEmpty(existGroups) && !CollectionUtils.isEmpty(sameSourceGroups = existGroups.stream().filter(o -> {
            if (null == dataViewGroup.getDataSource()) {
                return null == o.getDataSource();
            }
            return dataViewGroup.getDataSource().getId().equals(o.getDataSource().getId());
        }).collect(Collectors.toList()))) {
            sameSourceGroups.stream().forEach(o -> {
                if (o.getId().equals(dataViewGroupEntity.getId())) {
                    return;
                }
                Validate.isTrue((!o.getGroupName().equals(dataViewGroupEntity.getGroupName()) ? 1 : 0) != 0, (String)"\u540c\u4e00\u6570\u636e\u6e90\u4e0b\uff0c\u4fee\u6539\u6570\u636e\u89c6\u56fe\u5206\u7ec4\u540d\u4e0d\u80fd\u91cd\u590d\uff01\u8bf7\u68c0\u67e5", (Object[])new Object[0]);
            });
        }
        this.validParent(dataViewGroupEntity);
    }

    private void validParent(DataViewGroupEntity group) {
        DataViewGroupEntity parent = group.getParent();
        if (parent == null) {
            return;
        }
        Validate.notBlank((CharSequence)parent.getId(), (String)"\u7236\u7ea7ID\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        DataViewGroupEntity dbParent = this.dataViewGroupEntityRepository.findById(parent.getId()).orElse(null);
        Validate.notNull((Object)((Object)dbParent), (String)"\u672a\u627e\u5230\u7236\u7ea7\u5bf9\u8c61", (Object[])new Object[0]);
        if (StringUtils.isNotBlank((CharSequence)group.getId())) {
            Validate.isTrue((!parent.getId().equals(group.getId()) ? 1 : 0) != 0, (String)"\u4e0d\u80fd\u5c06\u81ea\u5df1\u8bbe\u7f6e\u6210\u81ea\u5df1\u7684\u7236\u7ea7", (Object[])new Object[0]);
            this.validCircle(group, parent.getParent());
        }
    }

    private void validCircle(DataViewGroupEntity group, DataViewGroupEntity parent) {
        if (parent == null) {
            return;
        }
        Validate.isTrue((!group.getId().equals(parent.getId()) ? 1 : 0) != 0, (String)"\u6570\u636e\u5f62\u6210\u5faa\u73af\u4f9d\u8d56\uff0c\u4e0d\u80fd\u5c06\u5b50\u7ea7\u8bbe\u7f6e\u6210\u81ea\u5df1\u7684\u7236\u7ea7\uff0c\u8bf7\u68c0\u67e5", (Object[])new Object[0]);
        this.validCircle(group, parent.getParent());
    }

    @Override
    public List<DataViewGroupEntity> findByDataSource(String dataSourceId) {
        if (StringUtils.isBlank((CharSequence)dataSourceId)) {
            return this.dataViewGroupEntityRepository.findByDataSourceIsNull(ApplicationContextUtils.getProjectName());
        }
        return this.dataViewGroupEntityRepository.findByDataSource(dataSourceId);
    }

    @Override
    public DataViewGroupEntity findDetailsById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        return this.dataViewGroupEntityRepository.findDetailsById(id);
    }

    @Override
    @Transactional
    public void deleteById(String id) {
        Validate.notBlank((CharSequence)id, (String)"\u8fdb\u884c\u5220\u9664\u65f6\uff0c\u5fc5\u987b\u7ed9\u5b9a\u4e3b\u952e\u4fe1\u606f!!", (Object[])new Object[0]);
        DataViewGroupEntity group = this.dataViewGroupEntityRepository.findById(id).orElse(null);
        Validate.isTrue((boolean)CollectionUtils.isEmpty(group.getChildren()), (String)"\u8be5\u5206\u7ec4\u5b58\u5728\u5b50\u5206\u7ec4\uff0c\u4e0d\u80fd\u5220\u9664", (Object[])new Object[0]);
        long count = this.dataViewService.countByDataViewGroupId(group.getId());
        Validate.isTrue((count == 0L ? 1 : 0) != 0, (String)"\u8be5\u5206\u7ec4\u4e0b\u5b58\u5728\u6570\u636e\u89c6\u56fe\uff0c\u4e0d\u80fd\u5220\u9664!!", (Object[])new Object[0]);
        this.dataViewGroupEntityRepository.delete((Object)group);
    }

    @Override
    public List<DataViewGroupEntity> findByDataSourceCode(String code) {
        List<DataViewGroupEntity> gourpList = null;
        gourpList = StringUtils.isBlank((CharSequence)code) ? this.dataViewGroupEntityRepository.findByDataSourceIsNull(ApplicationContextUtils.getProjectName()) : this.dataViewGroupEntityRepository.findByDataSourceCode(code);
        return gourpList;
    }

    @Override
    public List<JSONObject> findDetailsByDataSource(String dataSourceId, boolean isAuth) {
        List<DataViewGroupEntity> rootGroups = StringUtils.isBlank((CharSequence)dataSourceId) ? this.dataViewGroupEntityRepository.findByNullDataSourceAndNullParentAndProjectName(ApplicationContextUtils.getProjectName()) : this.dataViewGroupEntityRepository.findByDataSourceIdAndNullParent(dataSourceId);
        if (CollectionUtils.isEmpty(rootGroups)) {
            return Lists.newArrayList();
        }
        ArrayList<JSONObject> result = new ArrayList<JSONObject>();
        for (DataViewGroupEntity group : rootGroups) {
            JSONObject jsonObject = this.convert2JSONObject(group, isAuth);
            result.add(jsonObject);
        }
        return result;
    }

    private JSONObject convert2JSONObject(DataViewGroupEntity group, boolean isAuth) {
        DataViewGroupEntity cpGroup = (DataViewGroupEntity)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)group, DataViewGroupEntity.class, HashSet.class, ArrayList.class, new String[0]));
        JSONObject json = (JSONObject)JSON.toJSON((Object)((Object)cpGroup));
        json.put("title", (Object)group.getGroupName());
        json.put("type", (Object)"group");
        JSONArray children = new JSONArray();
        children.addAll((Collection)this.getDataViewJsonArray(group, isAuth));
        Set<DataViewGroupEntity> groupChildren = group.getChildren();
        if (!CollectionUtils.isEmpty(groupChildren)) {
            for (DataViewGroupEntity groupChild : groupChildren) {
                JSONObject jsonObject = this.convert2JSONObject(groupChild, isAuth);
                children.add((Object)jsonObject);
            }
        }
        if (!children.isEmpty()) {
            json.put("children", (Object)children);
        }
        return json;
    }

    private JSONArray getDataViewJsonArray(DataViewGroupEntity group, boolean isAuth) {
        List<DataViewEntity> dataViews = this.dataViewService.findByDataViewGroup(group.getId());
        if (CollectionUtils.isEmpty(dataViews)) {
            return new JSONArray();
        }
        JSONArray jsonArray = new JSONArray();
        for (DataViewEntity dataView : dataViews) {
            DataViewEntity cpDataView = (DataViewEntity)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)dataView, DataViewEntity.class, HashSet.class, ArrayList.class, new String[0]));
            JSONObject jsonObject = (JSONObject)JSON.toJSON((Object)((Object)cpDataView));
            jsonObject.put("title", (Object)dataView.getName());
            jsonObject.put("type", (Object)"dataView");
            if (isAuth) {
                this.loadAuthJsonArray(dataView, jsonObject);
            }
            jsonArray.add((Object)jsonObject);
        }
        return jsonArray;
    }

    private void loadAuthJsonArray(DataViewEntity dataView, JSONObject jsonObject) {
        Set<DataViewAuthEntity> auths = this.dataViewAuthService.findByDataView(dataView.getCode());
        if (CollectionUtils.isEmpty(auths)) {
            return;
        }
        JSONArray jsonArray = new JSONArray();
        for (DataViewAuthEntity auth : auths) {
            DataViewAuthEntity cpAuth = (DataViewAuthEntity)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)auth, DataViewAuthEntity.class, HashSet.class, ArrayList.class, new String[0]));
            JSONObject json = (JSONObject)JSON.toJSON((Object)((Object)cpAuth));
            json.put("title", (Object)auth.getName());
            json.put("type", (Object)"auth");
            jsonArray.add((Object)json);
        }
        jsonObject.put("children", (Object)jsonArray);
    }

    @Override
    public DataViewGroupEntity findByCode(String code) {
        if (StringUtils.isBlank((CharSequence)code)) {
            return null;
        }
        return this.dataViewGroupEntityRepository.findByCode(code);
    }

    @Override
    public DataViewGroupEntity findById(String dataViewGroupId) {
        if (StringUtils.isBlank((CharSequence)dataViewGroupId)) {
            return null;
        }
        return this.dataViewGroupEntityRepository.findById(dataViewGroupId).orElse(null);
    }
}

