/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.core.service.dauth.internal;

import com.bizunited.platform.common.entity.UuidEntity;
import com.bizunited.platform.common.service.NebulaToolkitService;
import com.bizunited.platform.common.util.ApplicationContextUtils;
import com.bizunited.platform.core.annotations.ServiceMethodParam;
import com.bizunited.platform.core.entity.DataViewAuthEntity;
import com.bizunited.platform.core.entity.dauth.DataAuthPreRuleEntity;
import com.bizunited.platform.core.entity.dauth.DataAuthPreRuleItemEntity;
import com.bizunited.platform.core.repository.dauth.DataAuthPreRuleEntityRepository;
import com.bizunited.platform.core.service.dauth.DataAuthPreRuleEntityService;
import com.bizunited.platform.core.service.dauth.DataAuthPreRuleItemEntityService;
import com.bizunited.platform.core.service.dauth.DataAuthPreRuleValuesEntityService;
import com.bizunited.platform.rbac.server.util.SecurityUtils;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.transaction.Transactional;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="DataAuthPreRuleEntityServiceImpl")
public class DataAuthPreRuleEntityServiceImpl
implements DataAuthPreRuleEntityService {
    @Autowired
    private DataAuthPreRuleEntityRepository dataAuthPreRuleEntityRepository;
    @Autowired
    private DataAuthPreRuleItemEntityService dataAuthPreRuleItemEntityService;
    @Autowired
    private DataAuthPreRuleValuesEntityService dataAuthPreRuleValuesEntityService;
    @Autowired
    private NebulaToolkitService nebulaToolkitService;

    @Override
    @Transactional
    public Set<DataAuthPreRuleEntity> save(String dataViewAuthCode, Set<DataAuthPreRuleEntity> dataAuthPreRules) {
        Set<DataAuthPreRuleEntity> needCreate;
        Validate.notBlank((CharSequence)dataViewAuthCode, (String)"\u6570\u636e\u6743\u9650\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        this.validateDefaultPreRule(dataAuthPreRules);
        HashSet results = Sets.newHashSet();
        if (CollectionUtils.isEmpty(dataAuthPreRules)) {
            this.deleteByAuthCode(dataViewAuthCode);
            return results;
        }
        Map<String, DataAuthPreRuleEntity> preRulesMap = dataAuthPreRules.stream().filter(e -> StringUtils.isNotBlank((CharSequence)e.getId())).collect(Collectors.toMap(UuidEntity::getId, v -> v));
        Set<DataAuthPreRuleEntity> dbDatas = this.findByDataViewAuthCode(dataViewAuthCode);
        HashSet updateDatas = Sets.newHashSet();
        HashSet deleteDatas = Sets.newHashSet();
        this.nebulaToolkitService.collectionDiscrepancy(dataAuthPreRules, dbDatas, UuidEntity::getId, (Collection)deleteDatas, (Collection)updateDatas, (Collection)Sets.newHashSet());
        for (DataAuthPreRuleEntity e2 : deleteDatas) {
            this.deleteById(e2.getId());
        }
        if (!CollectionUtils.isEmpty((Collection)updateDatas)) {
            for (DataAuthPreRuleEntity updatePreAuth : updateDatas) {
                DataAuthPreRuleEntity frontData = preRulesMap.get(updatePreAuth.getId());
                updatePreAuth.setId(frontData.getId());
                updatePreAuth.setDataViewAuth(frontData.getDataViewAuth());
                updatePreAuth.setCode(frontData.getCode());
                updatePreAuth.setName(frontData.getName());
                updatePreAuth.setSortIndex(frontData.getSortIndex());
                updatePreAuth.setIsDefault(frontData.getIsDefault());
                updatePreAuth.setPreAuthItems(frontData.getPreAuthItems());
            }
            results.addAll(this.updateForm(dataViewAuthCode, updateDatas));
        }
        if (!CollectionUtils.isEmpty(needCreate = dataAuthPreRules.stream().filter(e -> StringUtils.isBlank((CharSequence)e.getId())).collect(Collectors.toSet()))) {
            results.addAll(this.createForm(dataViewAuthCode, needCreate));
        }
        return results;
    }

    private void validateDefaultPreRule(Set<DataAuthPreRuleEntity> dataAuthPreRules) {
        dataAuthPreRules.forEach(e -> {
            Integer cfr_ignored_0 = (Integer)Validate.notNull((Object)e.getIsDefault(), (String)"\u662f\u5426\u9ed8\u8ba4\u6807\u8bc6\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        });
        long count = dataAuthPreRules.stream().filter(e -> e.getIsDefault() == 1).count();
        Validate.isTrue((count <= 1L ? 1 : 0) != 0, (String)"\u9ed8\u8ba4\u524d\u7f6e\u89c4\u5219\u5fc5\u987b\u552f\u4e00\uff0c\u8bf7\u68c0\u67e5\uff01", (Object[])new Object[0]);
        Validate.isTrue((count == 1L ? 1 : 0) != 0, (String)"\u672a\u53d1\u73b0\u9ed8\u8ba4\u524d\u7f6e\u89c4\u5219\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5\uff01", (Object[])new Object[0]);
    }

    private Set<DataAuthPreRuleEntity> createForm(String dataViewAuthCode, Set<DataAuthPreRuleEntity> dataAuthPreRules) {
        this.createValidation(dataViewAuthCode, dataAuthPreRules);
        for (DataAuthPreRuleEntity dataAuthPreRuleEntity : dataAuthPreRules) {
            dataAuthPreRuleEntity.setProjectName(ApplicationContextUtils.getProjectName());
            this.dataAuthPreRuleEntityRepository.saveAndFlush((Object)dataAuthPreRuleEntity);
            if (dataAuthPreRuleEntity.getIsDefault() != 0) continue;
            for (DataAuthPreRuleItemEntity item : dataAuthPreRuleEntity.getPreAuthItems()) {
                item.setPreRule(dataAuthPreRuleEntity);
                this.dataAuthPreRuleItemEntityService.create(item);
            }
        }
        return dataAuthPreRules;
    }

    private void createValidation(String dataViewAuthCode, Set<DataAuthPreRuleEntity> dataAuthPreRules) {
        Validate.notEmpty(dataAuthPreRules, (String)"\u8fdb\u884c\u5f53\u524d\u64cd\u4f5c\u65f6\uff0c\u4fe1\u606f\u5bf9\u8c61\u5fc5\u987b\u4f20\u5165!!", (Object[])new Object[0]);
        String account = SecurityUtils.getUserAccount();
        Validate.notBlank((CharSequence)account, (String)"\u672a\u80fd\u83b7\u53d6\u5230\u5f53\u524d\u7528\u6237\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        Date now = new Date();
        for (DataAuthPreRuleEntity dataAuthPreRuleEntity : dataAuthPreRules) {
            Validate.isTrue((boolean)StringUtils.isBlank((CharSequence)dataAuthPreRuleEntity.getId()), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u5f53\u671f\u4fe1\u606f\u7684\u6570\u636e\u7f16\u53f7\uff08\u4e3b\u952e\uff09\u4e0d\u80fd\u6709\u503c\uff01", (Object[])new Object[0]);
            Validate.notBlank((CharSequence)dataAuthPreRuleEntity.getName(), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u524d\u7f6e\u89c4\u5219\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            Validate.notNull((Object)dataAuthPreRuleEntity.getSortIndex(), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u4f18\u5148\u7ea7\u6392\u5e8f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            DataViewAuthEntity dataViewAuth = dataAuthPreRuleEntity.getDataViewAuth();
            Validate.notNull((Object)((Object)dataViewAuth), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u6570\u636e\u6743\u9650\u5173\u8054\u4fe1\u606f\u5fc5\u987b\u4f20\u5165!", (Object[])new Object[0]);
            Validate.isTrue((!StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{dataViewAuth.getCode(), dataViewAuth.getId()}) ? 1 : 0) != 0, (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u6570\u636e\u6743\u9650id\u4e3b\u952e\u548ccode\u7f16\u7801\u4fe1\u606f\u5fc5\u987b\u6709\u503c!", (Object[])new Object[0]);
            if (dataAuthPreRuleEntity.getIsDefault() == 0) {
                Validate.notEmpty(dataAuthPreRuleEntity.getPreAuthItems(), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u524d\u7f6e\u89c4\u5219\u660e\u7ec6\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            }
            dataAuthPreRuleEntity.setId(null);
            dataAuthPreRuleEntity.setCreateAccount(account);
            dataAuthPreRuleEntity.setModifyAccount(account);
            dataAuthPreRuleEntity.setCreateTime(now);
            if (StringUtils.isBlank((CharSequence)dataAuthPreRuleEntity.getCode())) {
                dataAuthPreRuleEntity.setCode(UUID.randomUUID().toString().replaceAll("-", ""));
            }
            Validate.isTrue((dataAuthPreRuleEntity.getCreateAccount() == null || dataAuthPreRuleEntity.getCreateAccount().length() < 255 ? 1 : 0) != 0, (String)"\u521b\u5efa\u4eba\u8d26\u53f7,\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(255)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
            Validate.isTrue((dataAuthPreRuleEntity.getName() == null || dataAuthPreRuleEntity.getName().length() < 64 ? 1 : 0) != 0, (String)"\u524d\u7f6e\u89c4\u5219\u540d\u79f0,\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(64)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
            Validate.isTrue((dataAuthPreRuleEntity.getCode() == null || dataAuthPreRuleEntity.getCode().length() < 64 ? 1 : 0) != 0, (String)"\u524d\u7f6e\u89c4\u5219code\u7f16\u7801,\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(64)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
            Validate.isTrue((StringUtils.isBlank((CharSequence)dataAuthPreRuleEntity.getProjectName()) || dataAuthPreRuleEntity.getProjectName().length() < 128 ? 1 : 0) != 0, (String)"\u9879\u76ee\u540d,\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(128)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
            DataAuthPreRuleEntity currentDataAuthPreRuleEntity = this.findByNameAndAuthCode(dataAuthPreRuleEntity.getName(), dataViewAuthCode);
            Validate.isTrue((currentDataAuthPreRuleEntity == null ? 1 : 0) != 0, (String)"\u524d\u7f6e\u89c4\u5219\u540d\u79f0\u5df2\u5b58\u5728,\u8bf7\u68c0\u67e5", (Object[])new Object[0]);
            currentDataAuthPreRuleEntity = this.findByCode(dataAuthPreRuleEntity.getCode());
            Validate.isTrue((currentDataAuthPreRuleEntity == null ? 1 : 0) != 0, (String)"\u524d\u7f6e\u89c4\u5219code\u7f16\u7801\u5df2\u5b58\u5728,\u8bf7\u68c0\u67e5", (Object[])new Object[0]);
        }
    }

    private Set<DataAuthPreRuleEntity> updateForm(String dataViewAuthCode, Set<DataAuthPreRuleEntity> dataAuthPreRules) {
        this.updateValidation(dataViewAuthCode, dataAuthPreRules);
        HashSet result = Sets.newHashSet();
        for (DataAuthPreRuleEntity dataAuthPreRuleEntity : dataAuthPreRules) {
            String currentId = dataAuthPreRuleEntity.getId();
            Optional op_currentDataAuthPreRuleEntity = this.dataAuthPreRuleEntityRepository.findById(currentId);
            DataAuthPreRuleEntity currentDataAuthPreRuleEntity = op_currentDataAuthPreRuleEntity.orElse(null);
            Validate.notNull((Object)((Object)currentDataAuthPreRuleEntity), (String)"\u672a\u53d1\u73b0\u6307\u5b9a\u7684\u524d\u7f6e\u89c4\u5219\u4fe1\u606f", (Object[])new Object[0]);
            currentDataAuthPreRuleEntity.setModifyAccount(dataAuthPreRuleEntity.getModifyAccount());
            currentDataAuthPreRuleEntity.setModifyTime(dataAuthPreRuleEntity.getModifyTime());
            currentDataAuthPreRuleEntity.setName(dataAuthPreRuleEntity.getName());
            currentDataAuthPreRuleEntity.setCode(dataAuthPreRuleEntity.getCode());
            currentDataAuthPreRuleEntity.setSortIndex(dataAuthPreRuleEntity.getSortIndex());
            currentDataAuthPreRuleEntity.setProjectName(dataAuthPreRuleEntity.getProjectName());
            currentDataAuthPreRuleEntity.setDataViewAuth(dataAuthPreRuleEntity.getDataViewAuth());
            if (dataAuthPreRuleEntity.getIsDefault() == 0) {
                this.dataAuthPreRuleItemEntityService.update(currentDataAuthPreRuleEntity, dataAuthPreRuleEntity.getPreAuthItems());
            }
            currentDataAuthPreRuleEntity.setPreAuthItems(dataAuthPreRuleEntity.getPreAuthItems());
            this.dataAuthPreRuleEntityRepository.saveAndFlush((Object)currentDataAuthPreRuleEntity);
            result.add(currentDataAuthPreRuleEntity);
        }
        return result;
    }

    private void updateValidation(String dataViewAuthCode, Set<DataAuthPreRuleEntity> dataAuthPreRules) {
        Validate.notEmpty(dataAuthPreRules, (String)"\u66f4\u65b0\u65f6\uff0c\u4f20\u5165\u7684\u524d\u7f6e\u89c4\u5219\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        String account = SecurityUtils.getUserAccount();
        Validate.notBlank((CharSequence)account, (String)"\u672a\u80fd\u83b7\u53d6\u5230\u5f53\u524d\u7528\u6237\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        Date now = new Date();
        for (DataAuthPreRuleEntity dataAuthPreRuleEntity : dataAuthPreRules) {
            Validate.isTrue((!StringUtils.isBlank((CharSequence)dataAuthPreRuleEntity.getId()) ? 1 : 0) != 0, (String)"\u4fee\u6539\u4fe1\u606f\u65f6\uff0c\u5f53\u671f\u4fe1\u606f\u7684\u6570\u636e\u7f16\u53f7\uff08\u4e3b\u952e\uff09\u5fc5\u987b\u6709\u503c\uff01", (Object[])new Object[0]);
            Validate.notBlank((CharSequence)dataAuthPreRuleEntity.getName(), (String)"\u4fee\u6539\u4fe1\u606f\u65f6\uff0c\u524d\u7f6e\u89c4\u5219\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            Validate.notBlank((CharSequence)dataAuthPreRuleEntity.getCode(), (String)"\u4fee\u6539\u4fe1\u606f\u65f6\uff0c\u524d\u7f6e\u89c4\u5219code\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            Validate.notNull((Object)dataAuthPreRuleEntity.getSortIndex(), (String)"\u4fee\u6539\u4fe1\u606f\u65f6\uff0c\u4f18\u5148\u7ea7\u6392\u5e8f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            Validate.notNull((Object)((Object)dataAuthPreRuleEntity.getDataViewAuth()), (String)"\u4fee\u6539\u4fe1\u606f\u65f6\uff0c\u524d\u7f6e\u89c4\u5219\u5173\u8054\u7684\u6570\u636e\u6743\u9650\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            if (dataAuthPreRuleEntity.getIsDefault() == 0) {
                Validate.notEmpty(dataAuthPreRuleEntity.getPreAuthItems(), (String)"\u4fee\u6539\u4fe1\u606f\u65f6\uff0c\u524d\u7f6e\u89c4\u5219\u660e\u7ec6\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            }
            dataAuthPreRuleEntity.setModifyAccount(account);
            dataAuthPreRuleEntity.setModifyTime(now);
            Validate.isTrue((dataAuthPreRuleEntity.getModifyAccount() == null || dataAuthPreRuleEntity.getModifyAccount().length() < 255 ? 1 : 0) != 0, (String)"\u66f4\u65b0\u4eba\u8d26\u53f7,\u5728\u8fdb\u884c\u4fee\u6539\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(255)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
            Validate.isTrue((dataAuthPreRuleEntity.getName() == null || dataAuthPreRuleEntity.getName().length() < 64 ? 1 : 0) != 0, (String)"\u524d\u7f6e\u89c4\u5219\u540d\u79f0,\u5728\u8fdb\u884c\u4fee\u6539\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(64)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
            Validate.isTrue((dataAuthPreRuleEntity.getCode() == null || dataAuthPreRuleEntity.getCode().length() < 64 ? 1 : 0) != 0, (String)"\u524d\u7f6e\u89c4\u5219code\u7f16\u7801,\u5728\u8fdb\u884c\u4fee\u6539\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(64)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
            Validate.isTrue((dataAuthPreRuleEntity.getProjectName() == null || dataAuthPreRuleEntity.getProjectName().length() < 128 ? 1 : 0) != 0, (String)"\u9879\u76ee\u540d,\u5728\u8fdb\u884c\u4fee\u6539\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(128)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
            DataAuthPreRuleEntity dbDataAuthPreRuleEntity = this.findByNameAndAuthCode(dataAuthPreRuleEntity.getName(), dataViewAuthCode);
            Validate.isTrue((dbDataAuthPreRuleEntity == null || StringUtils.equals((CharSequence)dbDataAuthPreRuleEntity.getId(), (CharSequence)dataAuthPreRuleEntity.getId()) ? 1 : 0) != 0, (String)"\u524d\u7f6e\u89c4\u5219\u540d\u79f0\u3010%s\u3011\u91cd\u590d\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[]{dataAuthPreRuleEntity.getName()});
            dbDataAuthPreRuleEntity = this.dataAuthPreRuleEntityRepository.findByCode(dataAuthPreRuleEntity.getCode());
            Validate.isTrue((dbDataAuthPreRuleEntity == null || StringUtils.equals((CharSequence)dbDataAuthPreRuleEntity.getId(), (CharSequence)dataAuthPreRuleEntity.getId()) ? 1 : 0) != 0, (String)"\u524d\u7f6e\u89c4\u5219\u7f16\u7801\u3010%s\u3011\u4e0d\u5339\u914d\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[]{dataAuthPreRuleEntity.getCode()});
        }
    }

    @Override
    public DataAuthPreRuleEntity findDetailsById(@ServiceMethodParam(name="id") String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        return this.dataAuthPreRuleEntityRepository.findDetailsById(id);
    }

    @Override
    public DataAuthPreRuleEntity findDetailsByCode(@ServiceMethodParam(name="code") String code) {
        if (StringUtils.isBlank((CharSequence)code)) {
            return null;
        }
        return this.dataAuthPreRuleEntityRepository.findDetailsByCode(code);
    }

    @Override
    public DataAuthPreRuleEntity findById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        Optional op = this.dataAuthPreRuleEntityRepository.findById(id);
        return op.orElse(null);
    }

    @Override
    @Transactional
    public void deleteAll(Set<DataAuthPreRuleEntity> preRules) {
        if (CollectionUtils.isEmpty(preRules)) {
            return;
        }
        for (DataAuthPreRuleEntity preRule : preRules) {
            for (DataAuthPreRuleItemEntity item : preRule.getPreAuthItems()) {
                this.dataAuthPreRuleValuesEntityService.deleteByPreAuthItemId(item.getId());
                this.dataAuthPreRuleItemEntityService.deleteById(item.getId());
            }
            this.dataAuthPreRuleEntityRepository.delete((Object)preRule);
        }
    }

    @Override
    @Transactional
    public void deleteById(String id) {
        Validate.notBlank((CharSequence)id, (String)"\u8fdb\u884c\u5220\u9664\u65f6\uff0c\u5fc5\u987b\u7ed9\u5b9a\u4e3b\u952e\u4fe1\u606f!!", (Object[])new Object[0]);
        DataAuthPreRuleEntity current = this.findDetailsById(id);
        Validate.isTrue((current != null && current.getIsDefault() == 0 ? 1 : 0) != 0, (String)"\u9ed8\u8ba4\u89c4\u5219\u4e0d\u80fd\u88ab\u5220\u9664", (Object[])new Object[0]);
        for (DataAuthPreRuleItemEntity item : current.getPreAuthItems()) {
            this.dataAuthPreRuleValuesEntityService.deleteByPreAuthItemId(item.getId());
            this.dataAuthPreRuleItemEntityService.deleteById(item.getId());
        }
        this.dataAuthPreRuleEntityRepository.delete((Object)current);
    }

    @Override
    @Transactional
    public void deleteByAuthCode(String code) {
        Validate.notBlank((CharSequence)code, (String)"\u8fdb\u884c\u5220\u9664\u65f6\uff0c\u5fc5\u987b\u7ed9\u5b9a\u6570\u636e\u6743\u9650\u7f16\u7801\u4fe1\u606f!!", (Object[])new Object[0]);
        Set<DataAuthPreRuleEntity> preRuleEntities = this.findDetailsByDataViewAuthCode(code);
        if (CollectionUtils.isEmpty(preRuleEntities)) {
            return;
        }
        for (DataAuthPreRuleEntity current : preRuleEntities) {
            if (current.getIsDefault() == 1) continue;
            for (DataAuthPreRuleItemEntity item : current.getPreAuthItems()) {
                this.dataAuthPreRuleValuesEntityService.deleteByPreAuthItemId(item.getId());
                this.dataAuthPreRuleItemEntityService.deleteById(item.getId());
            }
            this.dataAuthPreRuleEntityRepository.delete((Object)current);
        }
    }

    @Override
    public DataAuthPreRuleEntity findByNameAndAuthCode(String name, String authCode) {
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{name, authCode})) {
            return null;
        }
        String projectName = ApplicationContextUtils.getProjectName();
        return this.dataAuthPreRuleEntityRepository.findByNameAndAuthCodeAndProjectName(name, authCode, projectName);
    }

    @Override
    public DataAuthPreRuleEntity findByCode(String code) {
        if (StringUtils.isBlank((CharSequence)code)) {
            return null;
        }
        return this.dataAuthPreRuleEntityRepository.findByCode(code);
    }

    @Override
    public Set<DataAuthPreRuleEntity> findByDataViewAuthCode(String code) {
        if (StringUtils.isBlank((CharSequence)code)) {
            return Sets.newHashSet();
        }
        return this.dataAuthPreRuleEntityRepository.findByDataViewAuthCode(code);
    }

    @Override
    public Set<DataAuthPreRuleEntity> findDetailsByDataViewAuthCode(String code) {
        if (StringUtils.isBlank((CharSequence)code)) {
            return Sets.newHashSet();
        }
        return this.dataAuthPreRuleEntityRepository.findDetailsByDataViewAuthCode(code);
    }
}

