/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.core.service.dauth.internal;

import com.bizunited.platform.common.entity.UuidEntity;
import com.bizunited.platform.common.service.NebulaToolkitService;
import com.bizunited.platform.core.annotations.ServiceMethodParam;
import com.bizunited.platform.core.entity.dauth.DataAuthPreRuleEntity;
import com.bizunited.platform.core.entity.dauth.DataAuthPreRuleItemEntity;
import com.bizunited.platform.core.repository.dauth.DataAuthPreRuleItemEntityRepository;
import com.bizunited.platform.core.service.dauth.DataAuthPreRuleItemEntityService;
import com.bizunited.platform.core.service.dauth.DataAuthPreRuleValuesEntityService;
import com.bizunited.platform.rbac.server.util.SecurityUtils;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.transaction.Transactional;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="DataAuthPreRuleItemEntityServiceImpl")
public class DataAuthPreRuleItemEntityServiceImpl
implements DataAuthPreRuleItemEntityService {
    @Autowired
    private DataAuthPreRuleItemEntityRepository dataAuthPreRuleItemEntityRepository;
    @Autowired
    private DataAuthPreRuleValuesEntityService dataAuthPreRuleValuesEntityService;
    @Autowired
    private NebulaToolkitService nebulaToolkitService;

    @Override
    @Transactional
    public DataAuthPreRuleItemEntity create(DataAuthPreRuleItemEntity dataAuthPreRuleItemEntity) {
        return this.createForm(dataAuthPreRuleItemEntity);
    }

    @Override
    @Transactional
    public DataAuthPreRuleItemEntity createForm(DataAuthPreRuleItemEntity dataAuthPreRuleItemEntity) {
        this.createValidation(dataAuthPreRuleItemEntity);
        this.dataAuthPreRuleItemEntityRepository.save((Object)dataAuthPreRuleItemEntity);
        dataAuthPreRuleItemEntity.getValues().forEach(e -> e.setPreRuleItem(dataAuthPreRuleItemEntity));
        this.dataAuthPreRuleValuesEntityService.create(dataAuthPreRuleItemEntity.getValues());
        return dataAuthPreRuleItemEntity;
    }

    private void createValidation(DataAuthPreRuleItemEntity dataAuthPreRuleItemEntity) {
        Validate.notNull((Object)((Object)dataAuthPreRuleItemEntity), (String)"\u8fdb\u884c\u5f53\u524d\u64cd\u4f5c\u65f6\uff0c\u4fe1\u606f\u5bf9\u8c61\u5fc5\u987b\u4f20\u5165!!", (Object[])new Object[0]);
        Validate.isTrue((boolean)StringUtils.isBlank((CharSequence)dataAuthPreRuleItemEntity.getId()), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u5f53\u671f\u4fe1\u606f\u7684\u6570\u636e\u7f16\u53f7\uff08\u4e3b\u952e\uff09\u4e0d\u80fd\u6709\u503c\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)dataAuthPreRuleItemEntity.getSortIndex(), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u4f18\u5148\u7ea7\u6392\u5e8f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dataAuthPreRuleItemEntity.getLinkType(), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u903b\u8f91\u8fde\u63a5\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)((Object)dataAuthPreRuleItemEntity.getPreRule()), (String)"\u524d\u7f6e\u89c4\u5219\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)((Object)dataAuthPreRuleItemEntity.getAuthType()), (String)"\u6570\u636e\u6743\u9650\u5173\u8054\u7684\u79cd\u7c7b\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notEmpty(dataAuthPreRuleItemEntity.getValues(), (String)"\u503c\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        dataAuthPreRuleItemEntity.setId(null);
        dataAuthPreRuleItemEntity.setCreateTime(new Date());
        if (StringUtils.isBlank((CharSequence)dataAuthPreRuleItemEntity.getCreateAccount())) {
            String account = SecurityUtils.getUserAccount();
            dataAuthPreRuleItemEntity.setCreateAccount(account);
            dataAuthPreRuleItemEntity.setModifyAccount(account);
        }
        Validate.isTrue((dataAuthPreRuleItemEntity.getCreateAccount().length() < 255 ? 1 : 0) != 0, (String)"\u521b\u5efa\u4eba\u8d26\u53f7,\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(255)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((dataAuthPreRuleItemEntity.getLinkType().length() < 64 ? 1 : 0) != 0, (String)"\u903b\u8f91\u8fde\u63a5\u7c7b\u578b,\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(64)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
    }

    @Override
    @Transactional
    public DataAuthPreRuleItemEntity update(DataAuthPreRuleItemEntity dataAuthPreRuleItemEntity) {
        return this.updateForm(dataAuthPreRuleItemEntity);
    }

    @Override
    @Transactional
    public DataAuthPreRuleItemEntity updateForm(DataAuthPreRuleItemEntity dataAuthPreRuleItemEntity) {
        this.updateValidation(dataAuthPreRuleItemEntity);
        String currentId = dataAuthPreRuleItemEntity.getId();
        Optional op_currentDataAuthPreRuleItemEntity = this.dataAuthPreRuleItemEntityRepository.findById(currentId);
        DataAuthPreRuleItemEntity currentDataAuthPreRuleItemEntity = op_currentDataAuthPreRuleItemEntity.orElse(null);
        Validate.notNull((Object)((Object)currentDataAuthPreRuleItemEntity), (String)"\u672a\u53d1\u73b0\u6307\u5b9a\u7684\u524d\u7f6e\u89c4\u5219\u660e\u7ec6\u4fe1\u606f", (Object[])new Object[0]);
        currentDataAuthPreRuleItemEntity.setModifyAccount(dataAuthPreRuleItemEntity.getModifyAccount());
        currentDataAuthPreRuleItemEntity.setModifyTime(dataAuthPreRuleItemEntity.getModifyTime());
        currentDataAuthPreRuleItemEntity.setSortIndex(dataAuthPreRuleItemEntity.getSortIndex());
        currentDataAuthPreRuleItemEntity.setLinkType(dataAuthPreRuleItemEntity.getLinkType());
        currentDataAuthPreRuleItemEntity.setPreRule(dataAuthPreRuleItemEntity.getPreRule());
        currentDataAuthPreRuleItemEntity.setAuthType(dataAuthPreRuleItemEntity.getAuthType());
        dataAuthPreRuleItemEntity.getValues().forEach(e -> e.setPreRuleItem(dataAuthPreRuleItemEntity));
        this.dataAuthPreRuleValuesEntityService.update(dataAuthPreRuleItemEntity.getValues());
        currentDataAuthPreRuleItemEntity.setValues(dataAuthPreRuleItemEntity.getValues());
        this.dataAuthPreRuleItemEntityRepository.save((Object)currentDataAuthPreRuleItemEntity);
        return currentDataAuthPreRuleItemEntity;
    }

    private void updateValidation(DataAuthPreRuleItemEntity dataAuthPreRuleItemEntity) {
        Validate.notNull((Object)((Object)dataAuthPreRuleItemEntity), (String)"\u660e\u7ec6\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.isTrue((!StringUtils.isBlank((CharSequence)dataAuthPreRuleItemEntity.getId()) ? 1 : 0) != 0, (String)"\u4fee\u6539\u4fe1\u606f\u65f6\uff0c\u5f53\u671f\u4fe1\u606f\u7684\u6570\u636e\u7f16\u53f7\uff08\u4e3b\u952e\uff09\u5fc5\u987b\u6709\u503c\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)dataAuthPreRuleItemEntity.getSortIndex(), (String)"\u4fee\u6539\u4fe1\u606f\u65f6\uff0c\u4f18\u5148\u7ea7\u6392\u5e8f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dataAuthPreRuleItemEntity.getLinkType(), (String)"\u4fee\u6539\u4fe1\u606f\u65f6\uff0c\u903b\u8f91\u8fde\u63a5\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)((Object)dataAuthPreRuleItemEntity.getPreRule()), (String)"\u524d\u7f6e\u89c4\u5219\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)((Object)dataAuthPreRuleItemEntity.getAuthType()), (String)"\u6570\u636e\u6743\u9650\u5173\u8054\u7684\u79cd\u7c7b\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notEmpty(dataAuthPreRuleItemEntity.getValues(), (String)"\u503c\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        if (StringUtils.isBlank((CharSequence)dataAuthPreRuleItemEntity.getCreateAccount())) {
            String account = SecurityUtils.getUserAccount();
            dataAuthPreRuleItemEntity.setModifyAccount(account);
        }
        dataAuthPreRuleItemEntity.setModifyTime(new Date());
        Validate.isTrue((dataAuthPreRuleItemEntity.getModifyAccount().length() < 255 ? 1 : 0) != 0, (String)"\u66f4\u65b0\u4eba\u8d26\u53f7,\u5728\u8fdb\u884c\u4fee\u6539\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(255)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((dataAuthPreRuleItemEntity.getLinkType().length() < 64 ? 1 : 0) != 0, (String)"\u903b\u8f91\u8fde\u63a5\u7c7b\u578b,\u5728\u8fdb\u884c\u4fee\u6539\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(64)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
    }

    @Override
    public DataAuthPreRuleItemEntity findDetailsById(@ServiceMethodParam(name="id") String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        return this.dataAuthPreRuleItemEntityRepository.findDetailsById(id);
    }

    @Override
    public DataAuthPreRuleItemEntity findById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        Optional op = this.dataAuthPreRuleItemEntityRepository.findById(id);
        return op.orElse(null);
    }

    @Override
    @Transactional
    public void deleteById(String id) {
        Validate.notBlank((CharSequence)id, (String)"\u8fdb\u884c\u5220\u9664\u65f6\uff0c\u5fc5\u987b\u7ed9\u5b9a\u4e3b\u952e\u4fe1\u606f!!", (Object[])new Object[0]);
        DataAuthPreRuleItemEntity current = this.findById(id);
        if (current != null) {
            this.dataAuthPreRuleValuesEntityService.deleteByPreAuthItemId(id);
            this.dataAuthPreRuleItemEntityRepository.delete((Object)current);
        }
    }

    @Override
    @Transactional
    public Set<DataAuthPreRuleItemEntity> update(DataAuthPreRuleEntity preRuleEntity, Set<DataAuthPreRuleItemEntity> items) {
        Validate.notNull((Object)((Object)preRuleEntity), (String)"\u524d\u7f6e\u89c4\u5219\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.isTrue((!StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{preRuleEntity.getCode(), preRuleEntity.getId()}) ? 1 : 0) != 0, (String)"\u524d\u7f6e\u89c4\u5219\u7684id\u548ccode\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notEmpty(items, (String)"\u524d\u7f6e\u89c4\u5219\u660e\u7ec6\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Map<String, DataAuthPreRuleItemEntity> itemsMap = items.stream().filter(e -> StringUtils.isNotBlank((CharSequence)e.getId())).collect(Collectors.toMap(UuidEntity::getId, v -> v));
        Set<DataAuthPreRuleItemEntity> oldItems = this.dataAuthPreRuleItemEntityRepository.findByPreRuleCode(preRuleEntity.getCode());
        HashSet updateItems = Sets.newHashSet();
        HashSet deleteItems = Sets.newHashSet();
        HashSet results = Sets.newHashSet();
        this.nebulaToolkitService.collectionDiscrepancy(items, oldItems, UuidEntity::getId, (Collection)deleteItems, (Collection)updateItems, (Collection)Sets.newHashSet());
        for (DataAuthPreRuleItemEntity item : updateItems) {
            DataAuthPreRuleItemEntity newItem = itemsMap.get(item.getId());
            item.setPreRule(newItem.getPreRule());
            item.setAuthType(newItem.getAuthType());
            item.setLinkType(newItem.getLinkType());
            item.setSortIndex(newItem.getSortIndex());
            item.setId(newItem.getId());
            item.setValues(newItem.getValues());
            results.add(this.update(item));
        }
        for (DataAuthPreRuleItemEntity item : deleteItems) {
            this.deleteById(item.getId());
        }
        Set createItems = items.stream().filter(e -> StringUtils.isBlank((CharSequence)e.getId())).collect(Collectors.toSet());
        for (DataAuthPreRuleItemEntity item : createItems) {
            item.setPreRule(preRuleEntity);
            item.setId(null);
            results.add(this.create(item));
        }
        return results;
    }
}

