/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.core.service.dauth.internal;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.bizunited.platform.common.entity.UuidEntity;
import com.bizunited.platform.common.service.NebulaToolkitService;
import com.bizunited.platform.common.util.ApplicationContextUtils;
import com.bizunited.platform.core.common.enums.InnerPresetValuesEnum;
import com.bizunited.platform.core.entity.dauth.DataAuthPrefabricateEntity;
import com.bizunited.platform.core.repository.dauth.DataAuthPrefabricateRepository;
import com.bizunited.platform.core.service.dauth.DataAuthPrefabricateEntityService;
import com.bizunited.platform.rbac.server.util.SecurityUtils;
import com.google.common.collect.Sets;
import java.io.Serializable;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.JoinType;
import javax.persistence.criteria.Order;
import javax.persistence.criteria.Path;
import javax.persistence.criteria.Predicate;
import javax.transaction.Transactional;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class DataAuthPrefabricateEntityServiceImpl
implements DataAuthPrefabricateEntityService {
    @Autowired
    private DataAuthPrefabricateRepository dataAuthPrefabricateRepository;
    @Autowired
    private NebulaToolkitService nebulaToolkitService;

    @Override
    @Transactional
    public Set<DataAuthPrefabricateEntity> save(Set<DataAuthPrefabricateEntity> entities) {
        if (CollectionUtils.isEmpty(entities)) {
            return Sets.newHashSet();
        }
        this.validate(entities);
        this.fillDatas(entities);
        Set<String> keySet = entities.stream().map(DataAuthPrefabricateEntity::getCode).collect(Collectors.toSet());
        List<DataAuthPrefabricateEntity> dbDatas = this.dataAuthPrefabricateRepository.findByCodes(keySet);
        HashSet updateDatas = Sets.newHashSet();
        this.nebulaToolkitService.collectionDiscrepancy(entities, dbDatas, UuidEntity::getId, (Collection)Sets.newHashSet(), (Collection)updateDatas, (Collection)Sets.newHashSet());
        Map<String, DataAuthPrefabricateEntity> frontDatas = entities.stream().filter(e -> StringUtils.isNotBlank((CharSequence)e.getId())).collect(Collectors.toMap(UuidEntity::getId, v -> v));
        for (DataAuthPrefabricateEntity e2 : updateDatas) {
            this.validateRepeatability(e2, 1);
            DataAuthPrefabricateEntity frontData = frontDatas.get(e2.getId());
            e2.setCode(frontData.getCode());
            e2.setCustomClass(frontData.getCustomClass());
            e2.setAuthType(frontData.getAuthType());
            e2.setName(frontData.getName());
            e2.setSortIndex(frontData.getSortIndex());
            e2.setTstatus(frontData.getTstatus());
            this.dataAuthPrefabricateRepository.saveAndFlush((Object)e2);
        }
        HashSet results = Sets.newHashSet();
        Set needCreate = entities.stream().filter(e -> StringUtils.isBlank((CharSequence)e.getId())).collect(Collectors.toSet());
        for (DataAuthPrefabricateEntity e3 : needCreate) {
            this.validateRepeatability(e3, 0);
            this.dataAuthPrefabricateRepository.saveAndFlush((Object)e3);
        }
        results.addAll(needCreate);
        results.addAll(updateDatas);
        return results;
    }

    @Override
    public List<DataAuthPrefabricateEntity> findAllPrefabricate() {
        String projectName = ApplicationContextUtils.getProjectName();
        return this.dataAuthPrefabricateRepository.findAll((Specification & Serializable)(root, query, bd) -> {
            Predicate p1 = bd.equal((Expression)root.get("projectName"), (Object)projectName);
            return query.where((Expression)p1).getRestriction();
        });
    }

    @Override
    public List<DataAuthPrefabricateEntity> findByNameLikeOnlyExpand(String name) {
        String projectName = ApplicationContextUtils.getProjectName();
        return this.dataAuthPrefabricateRepository.findAll((Specification & Serializable)(root, query, bd) -> {
            root.fetch("authType", JoinType.LEFT);
            Path authType = root.get("authType");
            Order[] orders = new Order[]{bd.asc((Expression)authType.get("expand")), bd.asc((Expression)authType.get("sortIndex")), bd.asc((Expression)root.get("sortIndex"))};
            Predicate p1 = bd.equal((Expression)authType.get("expand"), (Object)1);
            Predicate p2 = bd.equal((Expression)root.get("projectName"), (Object)projectName);
            if (StringUtils.isNotBlank((CharSequence)name)) {
                Predicate p3 = bd.like((Expression)root.get("name"), "%" + name + "%");
                return query.where((Expression)bd.and(new Predicate[]{p1, p2, p3})).orderBy(orders).getRestriction();
            }
            return query.where((Expression)bd.and((Expression)p1, (Expression)p2)).orderBy(orders).getRestriction();
        });
    }

    @Override
    public List<DataAuthPrefabricateEntity> findByAuthTypeCodeOnlyEnable(String code) {
        Validate.notBlank((CharSequence)code, (String)"\u4f20\u5165\u7684\u5173\u8054\u79cd\u7c7bcode\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        String projectName = ApplicationContextUtils.getProjectName();
        return this.dataAuthPrefabricateRepository.findAll((Specification & Serializable)(root, query, bd) -> {
            root.fetch("authType", JoinType.INNER);
            Path authType = root.get("authType");
            Order[] orders = new Order[]{bd.asc((Expression)authType.get("expand")), bd.asc((Expression)authType.get("sortIndex")), bd.asc((Expression)root.get("sortIndex"))};
            Predicate p1 = bd.equal((Expression)authType.get("code"), (Object)code);
            Predicate p2 = bd.equal((Expression)root.get("projectName"), (Object)projectName);
            Predicate p3 = bd.equal((Expression)root.get("tstatus"), (Object)1);
            return query.where((Expression)bd.and(new Predicate[]{p1, p2, p3})).orderBy(orders).getRestriction();
        });
    }

    @Override
    public JSONArray findAll() {
        JSONArray result = new JSONArray();
        result.addAll((Collection)InnerPresetValuesEnum.toJson());
        List expandEntities = this.dataAuthPrefabricateRepository.findAll();
        for (DataAuthPrefabricateEntity e : expandEntities) {
            JSONObject json = new JSONObject();
            json.put("type", (Object)e.getAuthType().getExpandValue());
            json.put("paramKey", (Object)e.getCustomClass());
            json.put("descr", (Object)e.getName());
            result.add((Object)json);
        }
        return result;
    }

    @Override
    public JSONArray findByAuthTypeInnerValue(Integer innerValue) {
        return InnerPresetValuesEnum.toJson(InnerPresetValuesEnum.valuesOfType(innerValue));
    }

    @Override
    public JSONObject findByParamKey(String paramKey) {
        return InnerPresetValuesEnum.toJson(InnerPresetValuesEnum.valueOfParamKey(paramKey));
    }

    private void validate(Set<DataAuthPrefabricateEntity> entities) {
        Validate.notEmpty(entities, (String)"\u4f20\u5165\u7684\u9884\u5236\u503c\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        for (DataAuthPrefabricateEntity entity : entities) {
            Validate.notBlank((CharSequence)entity.getName(), (String)"\u540d\u79f0\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            Validate.notNull((Object)entity.getSortIndex(), (String)"\u6392\u5e8f\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            Validate.notNull((Object)((Object)entity.getAuthType()), (String)"\u5173\u8054\u79cd\u7c7b\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            Validate.isTrue((entity.getAuthType().getTstatus() == 1 ? 1 : 0) != 0, (String)"\u5173\u8054\u79cd\u7c7b\u4fe1\u606f\u5904\u4e8e\u7981\u7528\u72b6\u6001\uff0c\u4e0d\u80fd\u88ab\u4f7f\u7528\uff0c\u8bf7\u68c0\u67e5\uff01\uff01", (Object[])new Object[0]);
            Validate.isTrue((entity.getAuthType().getExpand() == 1 ? 1 : 0) != 0, (String)"\u5173\u8054\u79cd\u7c7b\u4fe1\u606f\u662f\u5185\u7f6e\u79cd\u7c7b\u72b6\u6001\uff0c\u4e0d\u80fd\u88ab\u4f7f\u7528\uff0c\u8bf7\u68c0\u67e5\uff01\uff01", (Object[])new Object[0]);
            Validate.notBlank((CharSequence)entity.getCustomClass(), (String)"\u9884\u5236\u503c\u81ea\u5b9a\u4e49\u5b9e\u73b0\u7c7b\u8def\u5f84\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            String clz = null;
            try {
                clz = StringUtils.substringBeforeLast((String)entity.getCustomClass(), (String)".");
                Class.forName(clz);
            }
            catch (ClassNotFoundException e) {
                throw new IllegalArgumentException(String.format("\u9884\u5236\u503c\u4fe1\u606f%s\u7c7b\u4e0d\u5b58\u5728 \u6216 \u4e0d\u662f\u7c7b\u65b9\u6cd5\u5168\u8def\u5f84\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5\uff01", clz));
            }
        }
    }

    private void fillDatas(Set<DataAuthPrefabricateEntity> entities) {
        String account = SecurityUtils.getUserAccount();
        Date now = new Date();
        for (DataAuthPrefabricateEntity entity : entities) {
            if (StringUtils.isBlank((CharSequence)entity.getCreateAccount())) {
                entity.setCreateAccount(account);
                entity.setCreateTime(now);
            }
            entity.setProjectName(ApplicationContextUtils.getProjectName());
            entity.setModifyAccount(account);
            entity.setModifyTime(now);
            if (!StringUtils.isBlank((CharSequence)entity.getCode())) continue;
            entity.setCode(UUID.randomUUID().toString());
        }
    }

    private void validateRepeatability(DataAuthPrefabricateEntity entity, Integer createOrUpdate) {
        DataAuthPrefabricateEntity dbDataAuthPrefabricateEntity = this.dataAuthPrefabricateRepository.findByNameAndProjectName(entity.getName(), entity.getProjectName());
        Validate.isTrue((dbDataAuthPrefabricateEntity == null || StringUtils.equals((CharSequence)dbDataAuthPrefabricateEntity.getId(), (CharSequence)entity.getId()) ? 1 : 0) != 0, (String)"\u5f53\u524d\u9884\u5236\u503c\u540d\u79f0\u3010%s\u3011\u91cd\u590d\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[]{entity.getName()});
        int countByCode = this.dataAuthPrefabricateRepository.countByCode(entity.getCode());
        Validate.isTrue((countByCode <= createOrUpdate ? 1 : 0) != 0, (String)"\u5f53\u524d\u9884\u5236\u503c\u7f16\u7801\u3010%s\u3011\u91cd\u590d\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[]{entity.getCode()});
    }
}

