/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.core.service.init;

import com.bizunited.platform.common.service.init.InitProcessService;
import com.bizunited.platform.common.util.ApplicationContextUtils;
import com.bizunited.platform.core.entity.dauth.DataAuthPrefabricateEntity;
import com.bizunited.platform.core.service.dauth.DataAuthPrefabricateCustomService;
import com.bizunited.platform.core.service.dauth.DataAuthPrefabricateEntityService;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.beans.factory.support.GenericBeanDefinition;
import org.springframework.context.ApplicationContext;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class DataAuthPrefabricateCustomInitProcess
implements InitProcessService {
    @Autowired
    private DataAuthPrefabricateEntityService dataAuthPrefabricateEntityService;

    public int sort() {
        return 100;
    }

    public boolean doProcess() {
        return true;
    }

    public boolean stopOnException() {
        return true;
    }

    public void init() {
        List<DataAuthPrefabricateEntity> presets = this.dataAuthPrefabricateEntityService.findAllPrefabricate();
        Set<String> classPaths = presets.stream().map(e -> StringUtils.substringBeforeLast((String)e.getCustomClass(), (String)".")).collect(Collectors.toSet());
        this.registBeans(classPaths);
    }

    private void registBeans(Set<String> classPaths) {
        if (CollectionUtils.isEmpty(classPaths)) {
            return;
        }
        ApplicationContext context = ApplicationContextUtils.getApplicationContext();
        DefaultListableBeanFactory beanFactory = (DefaultListableBeanFactory)context.getAutowireCapableBeanFactory();
        for (String clzPath : classPaths) {
            try {
                Class<?> clz = Class.forName(clzPath);
                Validate.isTrue((boolean)DataAuthPrefabricateCustomService.class.isAssignableFrom(clz), (String)"\u3010%s\u3011\u7c7b\u4e0d\u662fDataAuthPrefabricateCustomService\u7684\u5b9e\u73b0\u7c7b\uff0c\u8bf7\u68c0\u67e5\uff01", (Object[])new Object[]{clzPath});
                Component component = (Component)AnnotationUtils.findAnnotation(clz, Component.class);
                if (component != null) {
                    beanFactory.removeBeanDefinition(StringUtils.isBlank((CharSequence)component.value()) ? StringUtils.uncapitalize((String)StringUtils.substringAfterLast((String)clz.getName(), (String)".")) : component.value());
                    this.regist(clz, beanFactory);
                    continue;
                }
                this.regist(clz, beanFactory);
            }
            catch (ClassNotFoundException e) {
                throw new IllegalArgumentException(String.format("\u521d\u59cb\u5316\u65f6\uff0c\u672a\u80fd\u53d1\u73b0\u6307\u5b9a\u7c7b\u3010%s\u3011", clzPath));
            }
        }
    }

    private void regist(Class<?> clz, DefaultListableBeanFactory beanFactory) {
        GenericBeanDefinition beanDefinition = new GenericBeanDefinition();
        beanDefinition.setBeanClass(clz);
        String beanName = StringUtils.uncapitalize((String)StringUtils.substringAfterLast((String)clz.getName(), (String)"."));
        beanFactory.registerBeanDefinition(beanName, (BeanDefinition)beanDefinition);
    }
}

