/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.core.service.internal;

import com.bizunited.platform.common.enums.ImportExecuteModeEnum;
import com.bizunited.platform.common.model.MigrateImportModel;
import com.bizunited.platform.common.service.redis.RedisMutexService;
import com.bizunited.platform.common.util.ApplicationContextUtils;
import com.bizunited.platform.common.util.ChineseCharUtils;
import com.bizunited.platform.common.util.ZipFileUtils;
import com.bizunited.platform.core.common.PlatformContext;
import com.bizunited.platform.core.entity.CodeRuleEntity;
import com.bizunited.platform.core.entity.ScriptEntity;
import com.bizunited.platform.core.repository.CodeRuleRepository;
import com.bizunited.platform.core.service.CodeRuleService;
import com.bizunited.platform.core.service.ScriptService;
import com.bizunited.platform.core.service.invoke.InvokeProxyException;
import com.bizunited.platform.user.common.service.user.UserService;
import com.bizunited.platform.user.common.vo.UserVo;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.transaction.Transactional;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="CodeRuleServiceImpl")
public class CodeRuleServiceImpl
implements CodeRuleService {
    private static final Logger LOGGER = LoggerFactory.getLogger(CodeRuleServiceImpl.class);
    @Autowired
    private CodeRuleRepository codeRuleRepository;
    @Autowired
    private UserService userService;
    @Autowired
    private RedisMutexService redisService;
    @Autowired
    private ScriptService scriptService;
    @Autowired
    private PlatformContext platformContext;

    @Override
    @Transactional
    public CodeRuleEntity create(CodeRuleEntity entity) {
        this.validEntity(entity, true);
        UserVo user = this.getAccount();
        entity.setCreateAccount(user.getAccount());
        entity.setModifyAccount(user.getAccount());
        ScriptEntity script = new ScriptEntity();
        script.setLanguage(entity.getLanguage());
        script.setName(String.format("%s%s", "cgr", entity.getRuleCode()));
        script.setModifyAccount(user.getAccount());
        script = this.scriptService.create(script, entity.getContent());
        entity.setScript(script);
        entity.setCreateTime(new Date());
        entity.setModifyTime(new Date());
        entity.setCreateAccount(user.getAccount());
        entity.setModifyAccount(user.getAccount());
        entity.setProjectName(this.platformContext.getAppName());
        return (CodeRuleEntity)((Object)this.codeRuleRepository.save((Object)entity));
    }

    @Override
    @Transactional
    public CodeRuleEntity update(CodeRuleEntity entity) {
        this.validEntity(entity, false);
        UserVo user = this.getAccount();
        Validate.notBlank((CharSequence)entity.getId(), (String)"\u5f53\u524d\u4e1a\u52a1\u7f16\u7801\u89c4\u5219\u7684ID\u4fe1\u606f\u5fc5\u987b\u4f20\u5165", (Object[])new Object[0]);
        Optional exsit = this.codeRuleRepository.findById(entity.getId());
        Validate.isTrue((boolean)exsit.isPresent(), (String)"\u7f16\u7801\u751f\u6210\u89c4\u5219\u672a\u67e5\u8be2\u5230\uff01", (Object[])new Object[0]);
        CodeRuleEntity current = (CodeRuleEntity)((Object)exsit.get());
        ScriptEntity scriptEntity = current.getScript();
        if (scriptEntity == null) {
            ScriptEntity script = new ScriptEntity();
            script.setLanguage(entity.getLanguage());
            script.setName(String.format("%s%s", "cgr", entity.getRuleCode()));
            script.setModifyAccount(user.getAccount());
            scriptEntity = this.scriptService.create(script, entity.getContent());
        } else {
            scriptEntity = this.scriptService.update(scriptEntity, entity.getContent());
        }
        current.setScript(scriptEntity);
        current.setDescription(entity.getDescription());
        current.setLanguage(entity.getLanguage());
        current.setRuleType(entity.getRuleType());
        current.setRuleName(entity.getRuleName());
        current.setModifyTime(new Date());
        current.setModifyAccount(user.getAccount());
        return (CodeRuleEntity)((Object)this.codeRuleRepository.save((Object)current));
    }

    @Override
    @Transactional
    public CodeRuleEntity updateContent(String ruleId, String content) {
        Validate.notBlank((CharSequence)ruleId, (String)"\u7f16\u7801\u751f\u6210\u89c4\u5219ID\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)content, (String)"\u811a\u672c\u5185\u5bb9\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Optional exsit = this.codeRuleRepository.findById(ruleId);
        Validate.isTrue((boolean)exsit.isPresent(), (String)"\u7f16\u7801\u751f\u6210\u89c4\u5219\u672a\u67e5\u8be2\u5230\uff01", (Object[])new Object[0]);
        CodeRuleEntity entity = (CodeRuleEntity)((Object)exsit.get());
        ScriptEntity scriptEntity = entity.getScript();
        if (null == scriptEntity) {
            ScriptEntity script = new ScriptEntity();
            script.setLanguage(entity.getLanguage());
            script.setName(String.format("%s%s", "cgr", entity.getRuleCode()));
            script = this.scriptService.create(script, content);
            entity.setScript(script);
        } else {
            scriptEntity = this.scriptService.update(scriptEntity, content);
            entity.setScript(scriptEntity);
        }
        return (CodeRuleEntity)((Object)this.codeRuleRepository.save((Object)entity));
    }

    @Override
    public String invoke(String ruleCode) {
        Validate.notBlank((CharSequence)ruleCode, (String)"\u89c4\u5219\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        CodeRuleEntity codeRuleEntity = this.codeRuleRepository.findDetailByCode(ruleCode);
        Validate.notNull((Object)((Object)codeRuleEntity), (String)"\u672a\u6839\u636e\u8be5\u7f16\u7801\u67e5\u8be2\u5230\u7f16\u7801\u89c4\u5219\uff01", (Object[])new Object[0]);
        ScriptEntity scriptEntity = codeRuleEntity.getScript();
        Validate.notNull((Object)((Object)scriptEntity), (String)"\u672a\u67e5\u8be2\u5230\u8be5\u89c4\u5219\u7ed1\u5b9a\u7684\u811a\u672c\u4fe1\u606f\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)scriptEntity.getId(), (String)"\u811a\u672cid\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        try {
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("ruleCode", ruleCode);
            params.put("redisService", this.redisService);
            params.put("userService", this.userService);
            Map<String, Object> result = this.scriptService.invoke(new String[]{scriptEntity.getId()}, params);
            return String.valueOf(result.get("resultKey"));
        }
        catch (InvokeProxyException e) {
            throw new IllegalArgumentException("\u6267\u884c\u751f\u6210\u7f16\u7801\u811a\u672c\u9519\u8bef\uff01");
        }
    }

    private void validEntity(CodeRuleEntity entity, Boolean isCreate) {
        Validate.notNull((Object)((Object)entity), (String)"\u7f16\u7801\u751f\u6210\u89c4\u5219\u57fa\u7840\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)entity.getContent(), (String)"\u811a\u672c\u5185\u5bb9\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)entity.getRuleName(), (String)"\u7f16\u7801\u751f\u6210\u89c4\u5219\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a!", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)entity.getRuleCode(), (String)"\u7f16\u7801\u751f\u6210\u89c4\u5219\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a!", (Object[])new Object[0]);
        Validate.isTrue((entity.getRuleName().length() <= 64 ? 1 : 0) != 0, (String)"\u7f16\u7801\u751f\u6210\u89c4\u5219\u540d\u79f0\u4e0d\u80fd\u8d85\u8fc764\u4e2a\u5b57\u7b26", (Object[])new Object[0]);
        Validate.isTrue((entity.getRuleCode().length() <= 64 ? 1 : 0) != 0, (String)"\u7f16\u7801\u751f\u6210\u89c4\u5219\u7f16\u7801\u4e0d\u80fd\u8d85\u8fc764\u4e2a\u5b57\u7b26", (Object[])new Object[0]);
        Validate.isTrue((!ChineseCharUtils.hasChinese((String)entity.getRuleCode()) ? 1 : 0) != 0, (String)"\u7f16\u7801\u751f\u6210\u89c4\u5219\u7f16\u7801\u4e0d\u80fd\u542b\u6709\u4e2d\u6587\uff01", (Object[])new Object[0]);
        CodeRuleEntity existName = this.codeRuleRepository.findByRuleNameAndProjectName(entity.getRuleName(), ApplicationContextUtils.getProjectName());
        CodeRuleEntity existCode = this.codeRuleRepository.findByRuleCode(entity.getRuleCode());
        if (Boolean.TRUE.equals(isCreate)) {
            Validate.isTrue((boolean)StringUtils.isBlank((CharSequence)entity.getId()), (String)"\u65b0\u589e\u65f6ID\u5fc5\u987b\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            Validate.isTrue((null == existName ? 1 : 0) != 0, (String)"\u7f16\u7801\u89c4\u5219\u540d\u79f0\u5df2\u6709\u91cd\u590d\uff0c\u8bf7\u68c0\u67e5\uff01", (Object[])new Object[0]);
            Validate.isTrue((null == existCode ? 1 : 0) != 0, (String)"\u7f16\u7801\u89c4\u5219\u7f16\u7801\u5df2\u6709\u91cd\u590d\uff0c\u8bf7\u68c0\u67e5\uff01", (Object[])new Object[0]);
        } else {
            Validate.notBlank((CharSequence)entity.getId(), (String)"\u4fee\u6539\u65f6id\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            Optional op = this.codeRuleRepository.findById(entity.getId());
            CodeRuleEntity oldEntity = op.orElse(null);
            Validate.notNull((Object)((Object)oldEntity), (String)"\u672a\u6839\u636eID\u67e5\u8be2\u5230\u7f16\u7801\u751f\u6210\u89c4\u5219\u5b9e\u4f53\uff01", (Object[])new Object[0]);
            Validate.isTrue((boolean)StringUtils.equals((CharSequence)entity.getRuleCode(), (CharSequence)oldEntity.getRuleCode()), (String)"\u89c4\u5219\u7f16\u7801\u4e0d\u80fd\u4fee\u6539\uff01", (Object[])new Object[0]);
            long count = this.codeRuleRepository.countByRuleNameAndProjectNameWithoutId(entity.getRuleName(), ApplicationContextUtils.getProjectName(), entity.getId());
            Validate.isTrue((count == 0L ? 1 : 0) != 0, (String)"\u7f16\u7801\u89c4\u5219\u540d\u79f0\u5df2\u6709\u91cd\u590d\uff0c\u8bf7\u68c0\u67e5\uff01", (Object[])new Object[0]);
        }
    }

    private UserVo getAccount() {
        SecurityContext securityContext = SecurityContextHolder.getContext();
        Validate.notNull((Object)securityContext, (String)"\u672a\u53d1\u73b0\u4efb\u4f55\u7528\u6237\u6743\u9650\u4fe1\u606f!!", (Object[])new Object[0]);
        Authentication authentication = securityContext.getAuthentication();
        Validate.notNull((Object)authentication, (String)"\u672a\u53d1\u73b0\u4efb\u4f55\u7528\u6237\u767b\u5f55\u4fe1\u606f!!", (Object[])new Object[0]);
        UserVo userVo = this.userService.findByAccount(authentication.getName());
        Validate.notNull((Object)userVo, (String)"\u672a\u83b7\u53d6\u5230\u5f53\u524d\u767b\u5f55\u8d26\u53f7\uff01", (Object[])new Object[0]);
        return userVo;
    }

    @Override
    public String findContentByCode(String code) {
        Validate.notBlank((CharSequence)code, (String)"\u7f16\u7801\u751f\u6210\u89c4\u5219\u7684\u4e1a\u52a1\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        CodeRuleEntity entity = this.codeRuleRepository.findDetailByCode(code);
        if (entity.getScript() == null) {
            return null;
        }
        String scriptId = entity.getScript().getId();
        return this.scriptService.findContentById(scriptId);
    }

    @Override
    public Page<CodeRuleEntity> findByConditions(Pageable pageable, String ruleName, String ruleCode, String ruleType, String language) {
        HashMap<String, String> params = new HashMap<String, String>();
        if (StringUtils.isNotEmpty((CharSequence)ruleName)) {
            params.put("ruleName", ruleName);
        }
        if (StringUtils.isNotEmpty((CharSequence)ruleCode)) {
            params.put("ruleCode", ruleCode);
        }
        if (StringUtils.isNotEmpty((CharSequence)ruleType)) {
            params.put("ruleType", ruleType);
        }
        if (StringUtils.isNotEmpty((CharSequence)language)) {
            params.put("language", language);
        }
        params.put("projectName", this.platformContext.getAppName());
        if (null == pageable) {
            pageable = PageRequest.of((int)0, (int)50);
        }
        return this.codeRuleRepository.findByConditions(pageable, params);
    }

    @Override
    public Set<CodeRuleEntity> findDetailsByIds(String[] ids) {
        if (ids == null || ids.length <= 0) {
            return Sets.newHashSet();
        }
        return this.codeRuleRepository.findDetailsByIds(ids);
    }

    @Override
    public int countByIds(String[] ids) {
        if (ids == null || ids.length <= 0) {
            return 0;
        }
        return this.codeRuleRepository.countByIds(ids);
    }

    @Override
    public CodeRuleEntity findByRuleCode(String ruleCode) {
        if (StringUtils.isBlank((CharSequence)ruleCode)) {
            return null;
        }
        return this.codeRuleRepository.findByRuleCode(ruleCode);
    }

    @Override
    public CodeRuleEntity findByRuleName(String ruleName) {
        if (StringUtils.isBlank((CharSequence)ruleName)) {
            return null;
        }
        return this.codeRuleRepository.findByRuleNameAndProjectName(ruleName, ApplicationContextUtils.getProjectName());
    }

    @Override
    public Set<CodeRuleEntity> findAll() {
        List all = this.codeRuleRepository.findAll();
        if (!CollectionUtils.isEmpty((Collection)all)) {
            all = all.stream().filter(codeRuleEntity -> StringUtils.equals((CharSequence)codeRuleEntity.getProjectName(), (CharSequence)ApplicationContextUtils.getProjectName())).collect(Collectors.toList());
        }
        return Sets.newHashSet((Iterable)all);
    }

    @Override
    @Transactional(value=Transactional.TxType.REQUIRES_NEW)
    public void importData(MigrateImportModel importModel) {
        Validate.notNull((Object)importModel, (String)"\u5bfc\u5165\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        ZipFile zipFile = importModel.getZipFile();
        Validate.notNull((Object)zipFile, (String)"\u5bfc\u5165\u6587\u4ef6\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)importModel.getExecuteMode(), (String)"\u6267\u884c\u6a21\u5f0f\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        StringBuilder executeLog = new StringBuilder();
        importModel.appendLine("\u5f00\u59cb\u5bfc\u5165\u6570\u636e");
        ZipEntry codeRuleEntry = zipFile.getEntry("codeRule.in");
        if (codeRuleEntry == null) {
            importModel.appendLine("\u5bfc\u5165\u538b\u7f29\u5305\u4e2d\u672a\u53d1\u73b0\u6570\u636e\u6587\u4ef6\uff0c\u8bf7\u68c0\u67e5");
        }
        if (codeRuleEntry != null) {
            try (InputStream is = zipFile.getInputStream(codeRuleEntry);){
                ObjectInputStream ois = new ObjectInputStream(is);
                Set codeRulesSet = (Set)ois.readObject();
                ArrayList codeRules = Lists.newArrayList((Iterable)codeRulesSet);
                for (CodeRuleEntity codeRule : codeRules) {
                    ScriptEntity script = codeRule.getScript();
                    Boolean startWith = StringUtils.startsWith((CharSequence)script.getFileCode(), (CharSequence)"/") || StringUtils.startsWith((CharSequence)script.getFileCode(), (CharSequence)"\\");
                    String filePath = Boolean.TRUE.equals(startWith) ? script.getFileCode().substring(1) : script.getFileCode();
                    ZipEntry scriptFile = ZipFileUtils.getZipEntry((ZipFile)zipFile, (String)filePath, (String)script.getFileName());
                    InputStream inputStream = zipFile.getInputStream(scriptFile);
                    byte[] bytes = IOUtils.toByteArray((InputStream)inputStream);
                    String content = new String(bytes, StandardCharsets.UTF_8);
                    codeRule.setContent(content);
                }
                if (CollectionUtils.isEmpty((Collection)codeRules)) {
                    importModel.appendLine("\u5bfc\u5165\u7684\u6570\u636e\u4e3a\u7a7a");
                } else {
                    this.importData(codeRules, importModel);
                }
            }
            catch (IOException | ClassNotFoundException e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
                executeLog.append("\u8bfb\u53d6\u4e1a\u52a1\u6570\u636e\u5931\u8d25\uff1a").append(e.getMessage()).append("<br/>");
            }
        }
    }

    @Override
    public List<CodeRuleEntity> findAllByConditions(CodeRuleEntity codeRule) {
        ObjectUtils.defaultIfNull((Object)((Object)codeRule), (Object)((Object)new CodeRuleEntity()));
        codeRule.setProjectName(this.platformContext.getAppName());
        return this.codeRuleRepository.findAllByConditions(codeRule);
    }

    private void importData(List<CodeRuleEntity> codeRules, MigrateImportModel importModel) {
        importModel.setTotalCount(codeRules.size());
        for (int i = 0; i < codeRules.size(); ++i) {
            CodeRuleEntity codeRule = codeRules.get(i);
            importModel.appendLine(StringUtils.join((Object[])new Serializable[]{"--------[", Integer.valueOf(i + 1), "]----------"}));
            this.importData(codeRule, importModel);
        }
    }

    private void importData(CodeRuleEntity codeRule, MigrateImportModel importModel) {
        importModel.append("\u5f00\u59cb\u5904\u7406\u6570\u636e\uff1a").appendLine(codeRule.getRuleName());
        ImportExecuteModeEnum executeMode = importModel.getExecuteMode();
        CodeRuleEntity dbCodeRule = this.codeRuleRepository.findByRuleCode(codeRule.getRuleCode());
        this.handleImportDataId(codeRule);
        if (dbCodeRule != null && ImportExecuteModeEnum.SKIP == executeMode) {
            importModel.appendLine("\u7f16\u7801\u89c4\u5219\u5df2\u5b58\u5728\uff0c\u8df3\u8fc7");
            importModel.addSkipCount();
            return;
        }
        if (dbCodeRule != null && ImportExecuteModeEnum.UPDATE == executeMode) {
            importModel.appendLine("\u7f16\u7801\u89c4\u5219\u5df2\u5b58\u5728\uff0c\u8fdb\u884c\u66f4\u65b0\u8986\u76d6");
            this.handleUpdateData(codeRule, dbCodeRule, importModel);
            return;
        }
        if (dbCodeRule == null) {
            this.handleCreateData(codeRule, importModel);
        }
    }

    private void handleCreateData(CodeRuleEntity codeRule, MigrateImportModel importModel) {
        importModel.appendLine("\u5f00\u59cb\u65b0\u589e\u7f16\u7801\u89c4\u5219");
        importModel.appendLine("\u5bfc\u5165\u7f16\u7801\u89c4\u5219");
        this.create(codeRule);
        importModel.addCreateCount();
    }

    private void handleUpdateData(CodeRuleEntity codeRule, CodeRuleEntity dbCodeRule, MigrateImportModel importModel) {
        codeRule.setId(dbCodeRule.getId());
        this.update(codeRule);
        importModel.appendLine("\u66f4\u65b0\u6210\u529f");
        importModel.addUpdateCount();
    }

    private void handleImportDataId(CodeRuleEntity codeRule) {
        codeRule.setId(null);
        ScriptEntity script = codeRule.getScript();
        if (script != null) {
            script.setId(null);
        }
    }
}

