/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.core.service.internal;

import com.bizunited.platform.common.util.ApplicationContextUtils;
import com.bizunited.platform.core.common.constant.UnBusinessTableConst;
import com.bizunited.platform.core.common.enums.DataSourceTableType;
import com.bizunited.platform.core.entity.DataSourceEntity;
import com.bizunited.platform.core.entity.DataSourceTableEntity;
import com.bizunited.platform.core.repository.DataSourceTableRepository;
import com.bizunited.platform.core.repository.dynamic.DynamicDataSourceManager;
import com.bizunited.platform.core.service.DataSourceTableService;
import com.bizunited.platform.core.service.dataview.DataSourceService;
import com.google.common.collect.Sets;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.hibernate.SessionFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service(value="DataSourceTableServiceImpl")
public class DataSourceTableServiceImpl
implements DataSourceTableService {
    @Autowired
    private DataSourceTableRepository dataSourceTableRepository;
    @Autowired
    private DynamicDataSourceManager dynamicDataSourceManager;
    @Autowired
    private DataSourceService dataSourceService;

    @Override
    public Page<DataSourceTableEntity> findByConditions(Pageable pageable, Integer tableType, String dataSourceId, Integer status, String tableName) {
        return this.dataSourceTableRepository.findByConditions(pageable, tableType, dataSourceId, status, tableName);
    }

    @Override
    public Set<String> findByDataSource(DataSourceEntity dataSource) {
        if (dataSource == null) {
            return this.dataSourceTableRepository.queryMainDataSourceTables();
        }
        SessionFactory sessionFactory = this.dynamicDataSourceManager.getCurrentSessionFactory(dataSource.getCode());
        if (sessionFactory == null) {
            throw new NullPointerException("query DataSourceTables is null");
        }
        return this.dataSourceTableRepository.queryDataSourceTables(sessionFactory);
    }

    @Override
    @Transactional
    public void refresh() {
        this.initDataSourceTableWithDataSource(null);
        List<DataSourceEntity> dataSources = this.dataSourceService.findByStatus(1);
        if (CollectionUtils.isEmpty(dataSources)) {
            return;
        }
        for (DataSourceEntity dataSource : dataSources) {
            this.initDataSourceTableWithDataSource(dataSource);
        }
    }

    private void initDataSourceTableWithDataSource(DataSourceEntity dataSource) {
        DataSourceTableEntity dataSourceTable;
        List<DataSourceTableEntity> oldTables = dataSource != null ? this.dataSourceTableRepository.findByDataSource(dataSource.getId()) : this.dataSourceTableRepository.findMainDataSourceTablesByProjectName(ApplicationContextUtils.getProjectName());
        HashSet oldTableSet = new HashSet(128);
        Set<String> tables = this.findByDataSource(dataSource);
        Validate.isTrue((!CollectionUtils.isEmpty(tables) ? 1 : 0) != 0, (String)(dataSource == null ? "\u83b7\u53d6\u4e3b\u6570\u636e\u6e90\u7684\u8868\u6570\u636e\u5931\u8d25" : StringUtils.join((Object[])new String[]{"\u83b7\u53d6\u6570\u636e\u6e90[", dataSource.getCode(), "]\u7684\u8868\u6570\u636e\u5931\u8d25"})), (Object[])new Object[0]);
        HashMap oldTablesMap = new HashMap(128);
        oldTables.forEach(oldTable -> {
            oldTableSet.add(oldTable.getTableName());
            oldTablesMap.put(oldTable.getTableName(), oldTable);
        });
        Sets.SetView newTables = Sets.difference(tables, oldTableSet);
        Sets.SetView deletedTables = Sets.difference(oldTableSet, tables);
        Sets.SetView isTables = Sets.intersection(oldTableSet, tables);
        for (String tableName : newTables) {
            DataSourceTableEntity entity = this.initDataSourceTableEntity(dataSource, tableName);
            entity.setProjectName(ApplicationContextUtils.getProjectName());
            this.dataSourceTableRepository.saveAndFlush((Object)entity);
        }
        for (String tableName : deletedTables) {
            dataSourceTable = (DataSourceTableEntity)((Object)oldTablesMap.get(tableName));
            dataSourceTable.settStatus(0);
            this.dataSourceTableRepository.saveAndFlush((Object)dataSourceTable);
        }
        for (String table : isTables) {
            dataSourceTable = (DataSourceTableEntity)((Object)oldTablesMap.get(table));
            boolean update = false;
            if (dataSourceTable.gettStatus() == 0) {
                dataSourceTable.settStatus(1);
                update = true;
            }
            Integer tableType = dataSourceTable.getTableType();
            if (dataSourceTable.getDataSource() == null && UnBusinessTableConst.isUnBusinessTable(dataSourceTable.getTableName())) {
                if (DataSourceTableType.BUSINESS_TABLE.getType().equals(tableType)) {
                    dataSourceTable.setTableType(DataSourceTableType.UN_BUSINESS_TABLE.getType());
                    if (StringUtils.isBlank((CharSequence)dataSourceTable.getTableDesc())) {
                        dataSourceTable.setTableDesc("\u53ea\u8bfb\u7684\u6570\u636e\u8868");
                    }
                    update = true;
                }
            } else if (DataSourceTableType.UN_BUSINESS_TABLE.getType().equals(tableType)) {
                dataSourceTable.setTableType(DataSourceTableType.BUSINESS_TABLE.getType());
                update = true;
            }
            if (!update) continue;
            dataSourceTable.setModifyTime(new Date());
            this.dataSourceTableRepository.saveAndFlush((Object)dataSourceTable);
        }
    }

    private DataSourceTableEntity initDataSourceTableEntity(DataSourceEntity dataSource, String tableName) {
        DataSourceTableEntity entity = new DataSourceTableEntity();
        Date now = new Date();
        entity.setCreateTime(now);
        entity.setModifyTime(now);
        entity.setTableName(tableName);
        entity.settStatus(1);
        if (dataSource == null && UnBusinessTableConst.isUnBusinessTable(tableName)) {
            entity.setTableType(DataSourceTableType.UN_BUSINESS_TABLE.getType());
            entity.setTableDesc("\u53ea\u8bfb\u7684\u6570\u636e\u8868");
        } else {
            entity.setTableType(DataSourceTableType.BUSINESS_TABLE.getType());
        }
        entity.setDataSource(dataSource);
        return entity;
    }

    @Override
    @Transactional
    public DataSourceTableEntity update(DataSourceTableEntity dataSourceTableEntity) {
        String id = dataSourceTableEntity.getId();
        String tableDesc = dataSourceTableEntity.getTableDesc();
        String dataSourceTableId = null;
        if (dataSourceTableEntity.getDataSource() != null) {
            dataSourceTableId = dataSourceTableEntity.getDataSource().getId();
        }
        Validate.notEmpty((CharSequence)dataSourceTableEntity.getId(), (String)"\u4e3b\u952eID\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.isTrue((StringUtils.isNotBlank((CharSequence)tableDesc) || StringUtils.isNotBlank((CharSequence)dataSourceTableId) ? 1 : 0) != 0, (String)"\u6ca1\u6709\u9700\u8981\u66f4\u65b0\u7684\u6570\u636e", (Object[])new Object[0]);
        Optional op = this.dataSourceTableRepository.findById(id);
        DataSourceTableEntity dataSourceTable = op.orElse(null);
        Validate.notNull((Object)((Object)dataSourceTable), (String)"\u66f4\u65b0\u7684\u5bf9\u8c61\u4e0d\u5b58\u5728", (Object[])new Object[0]);
        if (StringUtils.isNotBlank((CharSequence)tableDesc)) {
            dataSourceTable.setTableDesc(tableDesc);
        }
        if (StringUtils.isNotBlank((CharSequence)dataSourceTableId)) {
            DataSourceEntity dataSource = this.dataSourceService.findById(dataSourceTableId);
            Validate.notNull((Object)((Object)dataSource), (String)"\u6570\u636e\u6e90\u5bf9\u8c61\u4e0d\u5b58\u5728", (Object[])new Object[0]);
            dataSourceTable.setDataSource(dataSource);
        }
        dataSourceTable.setModifyTime(new Date());
        this.dataSourceTableRepository.save((Object)dataSourceTable);
        return dataSourceTable;
    }

    @Override
    @Transactional
    public void updateTableDesc(DataSourceEntity dataSource, String tableName, String tableDesc) {
        Validate.notNull((Object)tableName, (String)"\u8868\u540d\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)tableDesc, (String)"\u8868\u8bf4\u660e\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        DataSourceTableEntity dataSourceTable = dataSource == null ? this.dataSourceTableRepository.findMainDataSourceTableByTableNameAndProjectName(tableName, ApplicationContextUtils.getProjectName()) : this.dataSourceTableRepository.findByTableNameAndDataSourceAndProjectName(tableName, dataSource.getId(), ApplicationContextUtils.getProjectName());
        Validate.notNull((Object)((Object)dataSourceTable), (String)"\u6570\u636e\u8868\u5bf9\u8c61\u4e0d\u5b58\u5728", (Object[])new Object[0]);
        dataSourceTable.setTableDesc(tableDesc);
        this.dataSourceTableRepository.save((Object)dataSourceTable);
    }
}

