/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.core.service.internal;

import com.bizunited.platform.common.enums.ImportExecuteModeEnum;
import com.bizunited.platform.common.model.MigrateImportModel;
import com.bizunited.platform.common.util.ApplicationContextUtils;
import com.bizunited.platform.common.util.ChineseCharUtils;
import com.bizunited.platform.core.entity.EnvironmentVariableEntity;
import com.bizunited.platform.core.repository.EnvironmentVariableRepository;
import com.bizunited.platform.core.service.EnvironmentVariableService;
import com.bizunited.platform.rbac.server.util.SecurityUtils;
import com.bizunited.platform.user.common.vo.UserVo;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.transaction.Transactional;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="EnvironmentVariableServiceImpl")
public class EnvironmentVariableServiceImpl
implements EnvironmentVariableService {
    private static final Logger LOGGER = LoggerFactory.getLogger(EnvironmentVariableServiceImpl.class);
    @Autowired
    private EnvironmentVariableRepository environmentVariableRepository;

    @Override
    public List<EnvironmentVariableEntity> findAll() {
        List environmentVariableEntities = this.environmentVariableRepository.findAll();
        if (!CollectionUtils.isEmpty((Collection)environmentVariableEntities)) {
            environmentVariableEntities = environmentVariableEntities.stream().filter(environmentVariableEntity -> StringUtils.equals((CharSequence)ApplicationContextUtils.getProjectName(), (CharSequence)environmentVariableEntity.getProjectName())).collect(Collectors.toList());
        }
        return environmentVariableEntities;
    }

    @Override
    public Page<EnvironmentVariableEntity> findByConditions(String paramCode, String paramKey, String paramValue, String paramType, Integer paramStatus, Pageable pageable) {
        HashMap<String, Object> conditions = new HashMap<String, Object>();
        if (StringUtils.isNotEmpty((CharSequence)paramCode)) {
            conditions.put("paramCode", paramCode);
        }
        if (StringUtils.isNotEmpty((CharSequence)paramKey)) {
            conditions.put("paramKey", paramKey);
        }
        if (StringUtils.isNotEmpty((CharSequence)paramValue)) {
            conditions.put("paramValue", paramValue);
        }
        if (StringUtils.isNotEmpty((CharSequence)paramType)) {
            conditions.put("paramType", paramType);
        }
        if (null != paramStatus) {
            conditions.put("paramStatus", paramStatus);
        }
        if (pageable == null) {
            pageable = PageRequest.of((int)0, (int)50);
        }
        return this.environmentVariableRepository.queryPage(pageable, conditions);
    }

    @Override
    public EnvironmentVariableEntity findByKey(String key) {
        if (StringUtils.isBlank((CharSequence)key)) {
            return null;
        }
        return this.environmentVariableRepository.findByParamKeyAndProjectName(key, ApplicationContextUtils.getProjectName());
    }

    @Override
    public EnvironmentVariableEntity findByCode(String code) {
        if (StringUtils.isBlank((CharSequence)code)) {
            return null;
        }
        return this.environmentVariableRepository.findByParamCode(code);
    }

    @Override
    public Set<EnvironmentVariableEntity> findDetailsByIds(String[] ids) {
        if (ids == null || ids.length == 0) {
            return Sets.newHashSet();
        }
        return this.environmentVariableRepository.findDetailsByIds(ids);
    }

    @Override
    @Transactional
    public EnvironmentVariableEntity enable(String id) {
        Validate.notBlank((CharSequence)id, (String)"\u542f\u7528\u65f6\u5fc5\u987b\u4f20\u5165ID", (Object[])new Object[0]);
        Optional op = this.environmentVariableRepository.findById(id);
        EnvironmentVariableEntity entity = op.orElse(null);
        Validate.notNull((Object)((Object)entity), (String)"\u672a\u627e\u5230\u8be5\u53c2\u6570\uff01", (Object[])new Object[0]);
        entity.setParamStatus(1);
        return (EnvironmentVariableEntity)((Object)this.environmentVariableRepository.save((Object)entity));
    }

    @Override
    @Transactional
    public EnvironmentVariableEntity disable(String id) {
        Validate.notBlank((CharSequence)id, (String)"\u7981\u7528\u65f6\u5fc5\u987b\u4f20\u5165ID", (Object[])new Object[0]);
        Optional op = this.environmentVariableRepository.findById(id);
        EnvironmentVariableEntity entity = op.orElse(null);
        Validate.notNull((Object)((Object)entity), (String)"\u672a\u627e\u5230\u8be5\u53c2\u6570\uff01", (Object[])new Object[0]);
        entity.setParamStatus(0);
        return (EnvironmentVariableEntity)((Object)this.environmentVariableRepository.save((Object)entity));
    }

    @Override
    @Transactional
    public EnvironmentVariableEntity save(EnvironmentVariableEntity entity) {
        Validate.notNull((Object)((Object)entity), (String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)entity.getParamKey(), (String)"\u53c2\u6570\u7684\u952e\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)entity.getParamValue(), (String)"\u53c2\u6570\u7684\u503c\u4e0d\u80fd\u4e3aNull\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)entity.getParamCode(), (String)"\u53c2\u6570\u7684\u7f16\u7801\u4e0d\u80fd\u4e3aNull\uff01", (Object[])new Object[0]);
        Validate.isTrue((!ChineseCharUtils.hasChinese((String)entity.getParamKey()) ? 1 : 0) != 0, (String)"\u53c2\u6570\u952e\u4e0d\u80fd\u542b\u6709\u4e2d\u6587\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)entity.getParamType(), (String)"\u53c2\u6570\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)entity.getParamStatus(), (String)"\u53c2\u6570\u72b6\u6001\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        UserVo user = SecurityUtils.getCurrentUser();
        if (StringUtils.isEmpty((CharSequence)entity.getId())) {
            long existByKey = this.environmentVariableRepository.countByParamKeyAndProjectName(entity.getParamKey(), ApplicationContextUtils.getProjectName());
            long existByCode = this.environmentVariableRepository.countByParamCodeAndProjectName(entity.getParamCode(), ApplicationContextUtils.getProjectName());
            Validate.isTrue((existByCode < 1L ? 1 : 0) != 0, (String)"\u4fdd\u5b58\u53c2\u6570\u7684\u53c2\u6570\u540d\u79f0\u5df2\u6709\u91cd\u590d\uff0c\u8bf7\u68c0\u67e5\uff01", (Object[])new Object[0]);
            Validate.isTrue((existByKey < 1L ? 1 : 0) != 0, (String)"\u4fdd\u5b58\u53c2\u6570\u7684\u952e\u5df2\u6709\u91cd\u590d\uff0c\u8bf7\u68c0\u67e5\uff01", (Object[])new Object[0]);
            entity.setCreateDate(new Date());
            entity.setModifyDate(new Date());
            entity.setCreateUser(user.getAccount());
            entity.setModifyUser(user.getAccount());
            entity.setProjectName(ApplicationContextUtils.getProjectName());
            return (EnvironmentVariableEntity)((Object)this.environmentVariableRepository.save((Object)entity));
        }
        Optional op = this.environmentVariableRepository.findById(entity.getId());
        EnvironmentVariableEntity exist = op.orElse(null);
        Validate.notNull((Object)((Object)exist), (String)"\u6839\u636eID\u672a\u83b7\u53d6\u5230\u8be5\u53c2\u6570\uff01", (Object[])new Object[0]);
        EnvironmentVariableEntity existCode = this.environmentVariableRepository.findByParamCode(entity.getParamCode());
        Boolean notSameCode = null == existCode || exist.getParamCode().equals(existCode.getParamCode());
        Validate.isTrue((boolean)notSameCode, (String)"\u4fee\u6539\u540e\u7684\u53c2\u6570\u7f16\u7801\u5df2\u6709\u91cd\u590d\uff0c\u8bf7\u68c0\u67e5\uff01", (Object[])new Object[0]);
        EnvironmentVariableEntity existKey = this.environmentVariableRepository.findByParamKeyAndProjectName(entity.getParamKey(), ApplicationContextUtils.getProjectName());
        Boolean notSameKey = null == existKey || exist.getParamKey().equals(existKey.getParamKey());
        Validate.isTrue((boolean)notSameKey, (String)"\u4fee\u6539\u540e\u7684\u53c2\u6570\u952e\u5df2\u6709\u91cd\u590d\uff0c\u8bf7\u68c0\u67e5\uff01", (Object[])new Object[0]);
        exist.setParamCode(entity.getParamCode());
        exist.setParamKey(entity.getParamKey());
        exist.setParamValue(entity.getParamValue());
        exist.setParamType(entity.getParamType());
        exist.setParamDesc(entity.getParamDesc());
        exist.setModifyUser(user.getAccount());
        exist.setModifyDate(new Date());
        return (EnvironmentVariableEntity)((Object)this.environmentVariableRepository.save((Object)exist));
    }

    @Override
    @Transactional(rollbackOn={Exception.class})
    public void delete(String id) {
        Validate.notBlank((CharSequence)id, (String)"\u5220\u9664\u53c2\u6570ID\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Optional op = this.environmentVariableRepository.findById(id);
        EnvironmentVariableEntity exist = op.orElse(null);
        Validate.notNull((Object)((Object)exist), (String)"\u672a\u627e\u5230\u53c2\u6570\uff0c\u8bf7\u68c0\u67e5\uff01", (Object[])new Object[0]);
        this.environmentVariableRepository.delete((Object)exist);
    }

    @Override
    public long countByIds(String[] ids) {
        if (ids == null || ids.length <= 0) {
            return 0L;
        }
        return this.environmentVariableRepository.countByIds(ids);
    }

    @Override
    @Transactional(value=Transactional.TxType.REQUIRES_NEW)
    public void importData(MigrateImportModel importModel) {
        Validate.notNull((Object)importModel, (String)"\u5bfc\u5165\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        ZipFile zipFile = importModel.getZipFile();
        Validate.notNull((Object)zipFile, (String)"\u5bfc\u5165\u6587\u4ef6\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)importModel.getExecuteMode(), (String)"\u6267\u884c\u6a21\u5f0f\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        StringBuilder executeLog = new StringBuilder();
        importModel.appendLine("\u5f00\u59cb\u5bfc\u5165\u6570\u636e");
        ZipEntry evnEntry = zipFile.getEntry("env.in");
        if (evnEntry == null) {
            importModel.appendLine("\u5bfc\u5165\u538b\u7f29\u5305\u4e2d\u672a\u53d1\u73b0\u6570\u636e\u6587\u4ef6\uff0c\u8bf7\u68c0\u67e5");
        }
        if (evnEntry != null) {
            try (InputStream is = zipFile.getInputStream(evnEntry);){
                ObjectInputStream ois = new ObjectInputStream(is);
                Set environmentVariablesSet = (Set)ois.readObject();
                ArrayList environmentVariables = Lists.newArrayList((Iterable)environmentVariablesSet);
                if (CollectionUtils.isEmpty((Collection)environmentVariables)) {
                    importModel.appendLine("\u5bfc\u5165\u7684\u6570\u636e\u4e3a\u7a7a");
                } else {
                    this.importData(environmentVariables, importModel);
                }
            }
            catch (IOException | ClassNotFoundException e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
                executeLog.append("\u8bfb\u53d6\u4e1a\u52a1\u6570\u636e\u5931\u8d25\uff1a").append(e.getMessage()).append("<br/>");
            }
        }
    }

    @Override
    public List<EnvironmentVariableEntity> findAllByConditions(String paramCode, String paramKey, String paramType, Integer paramStatus) {
        HashMap<String, Object> conditions = new HashMap<String, Object>();
        if (StringUtils.isNotEmpty((CharSequence)paramCode)) {
            conditions.put("paramCode", paramCode);
        }
        if (StringUtils.isNotEmpty((CharSequence)paramKey)) {
            conditions.put("paramKey", paramKey);
        }
        if (StringUtils.isNotEmpty((CharSequence)paramType)) {
            conditions.put("paramType", paramType);
        }
        if (null != paramStatus) {
            conditions.put("paramStatus", paramStatus);
        }
        return this.environmentVariableRepository.findAllByConditions(conditions);
    }

    private void importData(List<EnvironmentVariableEntity> environmentVariables, MigrateImportModel importModel) {
        importModel.setTotalCount(environmentVariables.size());
        for (int i = 0; i < environmentVariables.size(); ++i) {
            EnvironmentVariableEntity environmentVariable = environmentVariables.get(i);
            importModel.appendLine(StringUtils.join((Object[])new Serializable[]{"--------[", Integer.valueOf(i + 1), "]----------"}));
            this.importData(environmentVariable, importModel);
        }
    }

    private void importData(EnvironmentVariableEntity environmentVariable, MigrateImportModel importModel) {
        importModel.append("\u5f00\u59cb\u5904\u7406\u6570\u636e\uff1a").appendLine(environmentVariable.getParamCode());
        ImportExecuteModeEnum executeMode = importModel.getExecuteMode();
        EnvironmentVariableEntity dbEnvironmentVariable = this.environmentVariableRepository.findByParamCode(environmentVariable.getParamCode());
        environmentVariable.setId(null);
        if (dbEnvironmentVariable != null && ImportExecuteModeEnum.SKIP == executeMode) {
            importModel.appendLine("\u5168\u5c40\u53c2\u6570\u5df2\u5b58\u5728\uff0c\u8df3\u8fc7");
            importModel.addSkipCount();
            return;
        }
        if (dbEnvironmentVariable != null && ImportExecuteModeEnum.UPDATE == executeMode) {
            importModel.appendLine("\u5168\u5c40\u53c2\u6570\u5df2\u5b58\u5728\uff0c\u8fdb\u884c\u66f4\u65b0\u8986\u76d6");
            this.handleUpdateData(environmentVariable, dbEnvironmentVariable, importModel);
            return;
        }
        if (dbEnvironmentVariable == null) {
            this.handleCreateData(environmentVariable, importModel);
        }
    }

    private void handleCreateData(EnvironmentVariableEntity environmentVariable, MigrateImportModel importModel) {
        this.save(environmentVariable);
        importModel.appendLine("\u5bfc\u5165\u5168\u5c40\u53d8\u91cf");
        importModel.addCreateCount();
    }

    private void handleUpdateData(EnvironmentVariableEntity environmentVariable, EnvironmentVariableEntity dbEnvironmentVariable, MigrateImportModel importModel) {
        dbEnvironmentVariable.setParamDesc(environmentVariable.getParamDesc());
        dbEnvironmentVariable.setParamKey(environmentVariable.getParamKey());
        dbEnvironmentVariable.setParamType(environmentVariable.getParamType());
        dbEnvironmentVariable.setParamValue(environmentVariable.getParamValue());
        dbEnvironmentVariable.setParamStatus(environmentVariable.getParamStatus());
        this.save(dbEnvironmentVariable);
        importModel.appendLine("\u66f4\u65b0\u6210\u529f");
        importModel.addUpdateCount();
    }
}

