/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.core.service.internal;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.bizunited.platform.common.enums.ImportExecuteModeEnum;
import com.bizunited.platform.common.model.MigrateImportModel;
import com.bizunited.platform.common.util.ChineseCharUtils;
import com.bizunited.platform.common.util.ZipFileUtils;
import com.bizunited.platform.core.common.PlatformContext;
import com.bizunited.platform.core.entity.RemoteServiceAddressEntity;
import com.bizunited.platform.core.entity.RemoteServiceEntity;
import com.bizunited.platform.core.repository.RemoteServiceAddressRepository;
import com.bizunited.platform.core.service.RemoteServiceAddressService;
import com.bizunited.platform.core.service.RemoteServiceService;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import feign.Client;
import feign.Request;
import feign.Response;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.transaction.Transactional;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="RemoteServiceAddressServiceImpl")
public class RemoteServiceAddressServiceImpl
implements RemoteServiceAddressService {
    private static final Logger LOGGER = LoggerFactory.getLogger(RemoteServiceAddressServiceImpl.class);
    private static final String REQUEST_METHOD = "RequestMethod";
    private static final String INTERFACE = "Interface";
    private static final String HEAD = "Head";
    private static final String REQUEST_PARAMS = "RequestParams";
    private static final String REQUEST_BODY = "RequestBody";
    private static final String ADDRESS_E_ERROR = "\u5165\u53c2\u8fdc\u7a0b\u670d\u52a1\u5b9e\u4f53JSON\u4e0d\u80fd\u4e3a\u7a7a";
    private static final String ADDRESS_P_ERROR = "\u5165\u53c2\u8fdc\u7a0b\u670d\u52a1\u53c2\u6570JSON\u4e0d\u80fd\u4e3a\u7a7a";
    private static final String ADDRESS_C_ERROR = "\u53c2\u6570\u6267\u884c\u8f6c\u5316\u65f6\u53d1\u751f\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\uff01";
    private static final String ADDRESS_R_ERROR = "\u4f20\u5165\u8fdc\u7aef\u8c03\u7528\u6e90\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\uff01";
    @Autowired
    private RemoteServiceAddressRepository remoteServiceAddressRepository;
    @Autowired
    private RemoteServiceService remoteServiceService;
    @Autowired
    private PlatformContext platformContext;

    @Override
    public Page<RemoteServiceAddressEntity> findByConditions(String code, String alias, Pageable pageable) {
        Validate.notNull((Object)pageable, (String)"\u67e5\u8be2\u5206\u9875\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a!", (Object[])new Object[0]);
        HashMap<String, String> conditions = new HashMap<String, String>();
        if (!StringUtils.isBlank((CharSequence)code)) {
            conditions.put("code", code);
        }
        if (!StringUtils.isBlank((CharSequence)alias)) {
            conditions.put("alias", alias);
        }
        conditions.put("projectName", this.platformContext.getAppName());
        return this.remoteServiceAddressRepository.findByConditions(pageable, conditions);
    }

    @Override
    public void valid(String entityJson, String testJsonStr) {
        Validate.notBlank((CharSequence)entityJson, (String)ADDRESS_E_ERROR, (Object[])new Object[0]);
        RemoteServiceAddressEntity remoteServiceAddress = this.analysisEntityJson(entityJson);
        JSONObject object = this.analysisJsonStr(testJsonStr);
        boolean isCreate = StringUtils.isBlank((CharSequence)remoteServiceAddress.getId());
        this.validEntity(remoteServiceAddress, isCreate);
        this.validConnection(remoteServiceAddress, object);
    }

    private RemoteServiceAddressEntity analysisEntityJson(String entityJson) {
        RemoteServiceAddressEntity entity;
        try {
            entity = (RemoteServiceAddressEntity)((Object)JSON.parseObject((String)entityJson, RemoteServiceAddressEntity.class));
        }
        catch (RuntimeException e) {
            throw new IllegalArgumentException(ADDRESS_C_ERROR, e);
        }
        return entity;
    }

    private JSONObject analysisJsonStr(String jsonStr) {
        JSONObject testJson;
        try {
            testJson = JSON.parseObject((String)jsonStr);
        }
        catch (RuntimeException e) {
            throw new IllegalArgumentException(ADDRESS_C_ERROR, e);
        }
        return testJson;
    }

    @Override
    @Transactional
    public RemoteServiceAddressEntity create(String entityJson, String testJsonStr) {
        Validate.notBlank((CharSequence)entityJson, (String)ADDRESS_E_ERROR, (Object[])new Object[0]);
        RemoteServiceAddressEntity entity = this.analysisEntityJson(entityJson);
        JSONObject object = this.analysisJsonStr(testJsonStr);
        this.validEntity(entity, true);
        this.validConnection(entity, object);
        entity.setCreateDate(new Date());
        entity.setAddressStatus(2);
        entity.setProjectName(this.platformContext.getAppName());
        return (RemoteServiceAddressEntity)((Object)this.remoteServiceAddressRepository.save((Object)entity));
    }

    @Override
    @Transactional
    public RemoteServiceAddressEntity create(RemoteServiceAddressEntity remoteServiceAddressEntity) {
        this.validEntity(remoteServiceAddressEntity, true);
        remoteServiceAddressEntity.setProjectName(this.platformContext.getAppName());
        return (RemoteServiceAddressEntity)((Object)this.remoteServiceAddressRepository.save((Object)remoteServiceAddressEntity));
    }

    @Override
    @Transactional
    public RemoteServiceAddressEntity update(String entityJson, String testJsonStr) {
        JSONObject testJson;
        RemoteServiceAddressEntity entity;
        Validate.notBlank((CharSequence)entityJson, (String)ADDRESS_E_ERROR, (Object[])new Object[0]);
        Validate.notBlank((CharSequence)testJsonStr, (String)ADDRESS_P_ERROR, (Object[])new Object[0]);
        try {
            entity = (RemoteServiceAddressEntity)((Object)JSON.parseObject((String)entityJson, RemoteServiceAddressEntity.class));
            testJson = JSON.parseObject((String)testJsonStr);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(ADDRESS_C_ERROR, e);
        }
        this.validEntity(entity, false);
        this.validConnection(entity, testJson);
        Optional op = this.remoteServiceAddressRepository.findById(entity.getId());
        RemoteServiceAddressEntity existEntity = op.orElse(null);
        Validate.notNull((Object)((Object)existEntity), (String)"\u672a\u80fd\u67e5\u8be2\u5230\u8fdc\u7a0b\u670d\u52a1\u4fe1\u606f!!", (Object[])new Object[0]);
        existEntity.setProtocolType(entity.getProtocolType());
        existEntity.setConnectionType(entity.getConnectionType());
        existEntity.setAddress(entity.getAddress());
        existEntity.setAddressDesc(entity.getAddressDesc());
        return (RemoteServiceAddressEntity)((Object)this.remoteServiceAddressRepository.save((Object)existEntity));
    }

    @Override
    @Transactional
    public RemoteServiceAddressEntity enable(String addressId) {
        Validate.notBlank((CharSequence)addressId, (String)"\u4f20\u5165\u8fdc\u7aef\u8c03\u7528\u6e90ID\u4e0d\u80fd\u4e3a\u7a7a!", (Object[])new Object[0]);
        Optional op = this.remoteServiceAddressRepository.findById(addressId);
        RemoteServiceAddressEntity existEntity = op.orElse(null);
        Validate.notNull((Object)((Object)existEntity), (String)ADDRESS_R_ERROR, (Object[])new Object[0]);
        Validate.isTrue((existEntity.getAddressStatus() == 2 ? 1 : 0) != 0, (String)"\u542f\u7528\u7684\u8fdc\u7aef\u8c03\u7528\u6e90\u72b6\u6001\u5fc5\u987b\u4e3a\u672a\u542f\u7528\uff0c\u8bf7\u68c0\u67e5\uff01", (Object[])new Object[0]);
        existEntity.setAddressStatus(1);
        return (RemoteServiceAddressEntity)((Object)this.remoteServiceAddressRepository.save((Object)existEntity));
    }

    @Override
    @Transactional
    public RemoteServiceAddressEntity disable(String addressId) {
        Validate.notBlank((CharSequence)addressId, (String)"\u4f20\u5165\u8fdc\u7aef\u8c03\u7528\u6e90ID\u4e0d\u80fd\u4e3a\u7a7a!", (Object[])new Object[0]);
        Optional op = this.remoteServiceAddressRepository.findById(addressId);
        RemoteServiceAddressEntity existEntity = op.orElse(null);
        Validate.notNull((Object)((Object)existEntity), (String)ADDRESS_R_ERROR, (Object[])new Object[0]);
        Validate.isTrue((existEntity.getAddressStatus() == 1 ? 1 : 0) != 0, (String)"\u7981\u7528\u7684\u8fdc\u7aef\u8c03\u7528\u6e90\u72b6\u6001\u5fc5\u987b\u4e3a\u542f\u7528\uff0c\u8bf7\u68c0\u67e5\uff01", (Object[])new Object[0]);
        existEntity.setAddressStatus(0);
        this.remoteServiceService.updateRemoteService(addressId, 0);
        return (RemoteServiceAddressEntity)((Object)this.remoteServiceAddressRepository.save((Object)existEntity));
    }

    @Override
    public RemoteServiceAddressEntity findByCode(String code) {
        return this.remoteServiceAddressRepository.findByCode(code);
    }

    private void validEntity(RemoteServiceAddressEntity entity, Boolean isCreate) {
        Validate.notNull((Object)((Object)entity), (String)"\u4f20\u5165\u8fdc\u7aef\u5730\u5740\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)entity.getCode(), (String)"\u8fdc\u7aef\u8c03\u7528\u6e90\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)entity.getAlias(), (String)"\u8fdc\u7aef\u8c03\u7528\u6e90\u522b\u540d\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\uff01", (Object[])new Object[0]);
        Validate.isTrue((!ChineseCharUtils.hasChinese((String)entity.getAlias()) ? 1 : 0) != 0, (String)"\u65b0\u589e\u8fdc\u7aef\u6570\u636e\u6e90\u522b\u540d\u4e0d\u80fd\u542b\u6709\u4e2d\u6587\uff01", (Object[])new Object[0]);
        Validate.isTrue((!ChineseCharUtils.hasChinese((String)entity.getCode()) ? 1 : 0) != 0, (String)"\u65b0\u589e\u8fdc\u7aef\u6570\u636e\u6e90\u7f16\u7801\u4e0d\u80fd\u542b\u6709\u4e2d\u6587\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)entity.getProtocolType(), (String)"\u8fdc\u7aef\u8c03\u7528\u6e90\u534f\u8bae\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)entity.getConnectionType(), (String)"\u8fdc\u7aef\u8c03\u7528\u6e90\u8fde\u63a5\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)entity.getAddress(), (String)"\u8fdc\u7aef\u8c03\u7528\u6e90\u8fde\u63a5\u5730\u5740\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\uff01", (Object[])new Object[0]);
        Validate.isTrue((!entity.getAddress().endsWith("/") ? 1 : 0) != 0, (String)"\u8fde\u63a5\u5730\u5740\u4e0d\u80fd\u4ee5 / \u53f7\u7ed3\u5c3e\uff0c\u8bf7\u79fb\u9664\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)entity.getAddressStatus(), (String)"\u8fdc\u7aef\u8c03\u7528\u6e90\u72b6\u6001\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\uff01", (Object[])new Object[0]);
        if (Boolean.TRUE.equals(isCreate)) {
            RemoteServiceAddressEntity existCodes = this.remoteServiceAddressRepository.findByCode(entity.getCode());
            RemoteServiceAddressEntity existAliases = this.remoteServiceAddressRepository.findByAlias(entity.getAlias());
            Validate.isTrue((boolean)StringUtils.isBlank((CharSequence)entity.getId()), (String)"\u65b0\u589e\u7684\u8fdc\u7aef\u8c03\u7528\u6e90ID\u5fc5\u987b\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            Validate.isTrue((null == existAliases ? 1 : 0) != 0, (String)"\u65b0\u589e\u8fdc\u7aef\u6570\u636e\u6e90\u522b\u540d\u91cd\u590d\uff0c\u8bf7\u66f4\u6362\u522b\u540d\uff01", (Object[])new Object[0]);
            Validate.isTrue((null == existCodes ? 1 : 0) != 0, (String)"\u65b0\u589e\u8fdc\u7aef\u6570\u636e\u6e90\u7f16\u7801\u91cd\u590d\uff0c\u8bf7\u66f4\u6362\u7f16\u7801\uff01", (Object[])new Object[0]);
        } else {
            Validate.notBlank((CharSequence)entity.getId(), (String)"\u4fee\u6539\u7684\u8fdc\u7aef\u8c03\u7528\u6e90ID\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            Optional op = this.remoteServiceAddressRepository.findById(entity.getId());
            RemoteServiceAddressEntity existEntity = op.orElse(null);
            Validate.notNull((Object)((Object)existEntity), (String)ADDRESS_R_ERROR, (Object[])new Object[0]);
            Validate.isTrue((existEntity.getAddressStatus() == 2 ? 1 : 0) != 0, (String)"\u53ea\u80fd\u5bf9\u672a\u542f\u7528\u72b6\u6001\u7684\u8fdc\u7a0b\u8c03\u7528\u6e90\u505a\u4fee\u6539\uff01", (Object[])new Object[0]);
            Validate.isTrue((boolean)existEntity.getCode().equals(entity.getCode()), (String)"\u4fee\u6539\u65f6\u4e0d\u80fd\u4fee\u6539\u8fdc\u7aef\u8c03\u7528\u6e90\u7f16\u53f7\uff01", (Object[])new Object[0]);
            Validate.isTrue((boolean)existEntity.getAlias().equals(entity.getAlias()), (String)"\u4fee\u6539\u65f6\u4e0d\u80fd\u4fee\u6539\u8fdc\u7aef\u8c03\u7528\u6e90\u522b\u540d\uff01", (Object[])new Object[0]);
        }
    }

    private void validConnection(RemoteServiceAddressEntity entity, JSONObject testJson) {
        Validate.notNull((Object)testJson, (String)"\u6d4b\u8bd5\u63a5\u53e3\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)testJson.getString(REQUEST_METHOD), (String)"\u6d4b\u8bd5\u63a5\u53e3\u65b9\u6cd5\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        if (StringUtils.isNotEmpty((CharSequence)testJson.getString(INTERFACE))) {
            Validate.isTrue((boolean)testJson.getString(INTERFACE).startsWith("/"), (String)"\u63a5\u53e3\u5730\u5740\u82e5\u4e0d\u4e3a\u7a7a\uff0c\u5fc5\u987b\u4ee5/\u53f7\u5f00\u59cb", (Object[])new Object[0]);
        }
        Client.Default defaultClient = new Client.Default(null, null);
        String method = testJson.getString(REQUEST_METHOD);
        String url = StringUtils.isEmpty((CharSequence)testJson.getString(INTERFACE)) ? entity.getAddress() : entity.getAddress() + testJson.getString(INTERFACE);
        HashMap headers = new HashMap();
        if (null != testJson.getJSONObject(HEAD)) {
            JSONObject heads = testJson.getJSONObject(HEAD);
            heads.keySet().forEach(o -> {
                Collection cfr_ignored_0 = headers.put(o, Sets.newHashSet((Object[])new String[]{heads.getString(o)}));
            });
        }
        if (null != testJson.getJSONObject(REQUEST_PARAMS)) {
            JSONObject requestParams = testJson.getJSONObject(REQUEST_PARAMS);
            HashSet<String> paramSet = new HashSet<String>();
            for (String key : requestParams.keySet()) {
                paramSet.add(String.format("%s=%s", key, requestParams.getString(key)));
            }
            String paraUrl = String.format("?%s", StringUtils.join(paramSet, (String)"&"));
            url = url.concat(paraUrl);
        }
        byte[] body = new byte[]{};
        JSONObject bodyJson = testJson.getJSONObject(REQUEST_BODY);
        if (null != bodyJson) {
            String bodyStr = bodyJson.toJSONString();
            body = bodyStr.getBytes(StandardCharsets.UTF_8);
        }
        Request.Options options = new Request.Options(18000, 18000);
        Request.HttpMethod httpMethod = Request.HttpMethod.valueOf((String)method);
        Request request = Request.create((Request.HttpMethod)httpMethod, (String)url, headers, (byte[])body, (Charset)Charset.defaultCharset());
        try {
            Response response = defaultClient.execute(request, options);
            Validate.isTrue((response.status() == HttpStatus.OK.value() ? 1 : 0) != 0, (String)String.format("\u8fde\u63a5\u5931\u8d25\uff0c\u8fd4\u56de\u7f16\u7801\uff1a%s,\u539f\u56e0\uff1a%s", response.status(), response.reason()), (Object[])new Object[0]);
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
    }

    @Override
    public List<RemoteServiceAddressEntity> findByAddressStatus(Integer status) {
        if (status == null) {
            return Lists.newArrayList();
        }
        return this.remoteServiceAddressRepository.findByAddressStatus(status);
    }

    @Override
    public int countByIds(String[] ids) {
        if (ids == null || ids.length == 0) {
            return 0;
        }
        return this.remoteServiceAddressRepository.countByIds(ids);
    }

    @Override
    public List<RemoteServiceAddressEntity> findDetailsByIds(String[] ids) {
        if (ids == null || ids.length == 0) {
            return Lists.newArrayList();
        }
        return this.remoteServiceAddressRepository.findDetailsByIds(ids);
    }

    @Override
    @Transactional(value=Transactional.TxType.REQUIRES_NEW)
    public void importData(MigrateImportModel importModel) {
        Validate.notNull((Object)importModel, (String)"\u5bfc\u5165\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        ZipFile zipFile = importModel.getZipFile();
        Validate.notNull((Object)zipFile, (String)"\u5bfc\u5165\u6587\u4ef6\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)importModel.getExecuteMode(), (String)"\u6267\u884c\u6a21\u5f0f\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        importModel.appendLine("\u5f00\u59cb\u5bfc\u5165\u6570\u636e");
        ZipEntry dataViewEntry = zipFile.getEntry("remoteService.in");
        if (dataViewEntry == null) {
            importModel.appendLine("\u5bfc\u5165\u538b\u7f29\u5305\u4e2d\u672a\u53d1\u73b0\u6570\u636e\u6587\u4ef6\uff0c\u8bf7\u68c0\u67e5");
        }
        if (dataViewEntry != null) {
            try (InputStream is = zipFile.getInputStream(dataViewEntry);
                 ObjectInputStream ois = new ObjectInputStream(is);){
                List importRemoteServiceAddress = (List)ois.readObject();
                if (CollectionUtils.isEmpty((Collection)importRemoteServiceAddress)) {
                    importModel.appendLine("\u5bfc\u5165\u7684\u6570\u636e\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u6570\u636e");
                    return;
                }
                this.importData(importRemoteServiceAddress, importModel);
            }
            catch (IOException | ClassNotFoundException e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
                importModel.append("\u8bfb\u53d6\u4e1a\u52a1\u6570\u636e\u5931\u8d25\uff1a").appendLine(e.getMessage());
            }
        }
    }

    private void importData(List<RemoteServiceAddressEntity> importRemoteServiceAddress, MigrateImportModel importModel) {
        importModel.setTotalCount(importRemoteServiceAddress.size());
        for (int i = 0; i < importRemoteServiceAddress.size(); ++i) {
            RemoteServiceAddressEntity address = importRemoteServiceAddress.get(i);
            importModel.appendLine(StringUtils.join((Object[])new Serializable[]{"--------[", Integer.valueOf(i + 1), "]----------"}));
            this.importData(address, importModel);
        }
    }

    private void importData(RemoteServiceAddressEntity address, MigrateImportModel importModel) {
        importModel.append("\u5f00\u59cb\u5bfc\u5165\u6570\u636e\uff1a").appendLine(address.getCode());
        ImportExecuteModeEnum executeMode = importModel.getExecuteMode();
        RemoteServiceAddressEntity dbService = this.remoteServiceAddressRepository.findByCode(address.getCode());
        this.handleImportDataId(address);
        if (dbService != null && ImportExecuteModeEnum.SKIP == executeMode) {
            importModel.appendLine("\u8fdc\u7aef\u6570\u636e\u6e90\u5df2\u5b58\u5728\uff0c\u6267\u884c\u8df3\u8fc7");
            importModel.addSkipCount();
            return;
        }
        if (dbService != null && ImportExecuteModeEnum.UPDATE == executeMode) {
            importModel.appendLine("\u8fdc\u7aef\u6570\u636e\u6e90\u5df2\u5b58\u5728\uff0c\u5c06\u6267\u884c\u66f4\u65b0");
            this.handleUpdateData(address, dbService, importModel);
            return;
        }
        if (dbService == null) {
            this.handleCreateData(address, importModel);
            return;
        }
        importModel.appendLine("\u6682\u4e0d\u652f\u6301\u7684\u6267\u884c\u65b9\u5f0f");
        importModel.addSkipCount();
    }

    private void handleCreateData(RemoteServiceAddressEntity service, MigrateImportModel importModel) {
        importModel.appendLine("\u5f00\u59cb\u5bfc\u5165\u65b0\u589e\u6570\u636e\u6e90");
        RemoteServiceAddressEntity dbAddress = this.remoteServiceAddressRepository.findByCode(service.getCode());
        if (dbAddress == null) {
            importModel.appendLine("\u5bfc\u5165\u6570\u636e\u6e90\u5173\u8054\u7684\u8c03\u7528\u5730\u5740");
            dbAddress = this.create(service);
        }
        ZipFile zipFile = importModel.getZipFile();
        try {
            for (RemoteServiceEntity item : service.getRemoteServices()) {
                item.setRemoteServiceAddress(dbAddress);
                importModel.appendLine("\u8bfb\u53d6json\u5185\u5bb9").appendLine(item.getCode());
                byte[] bytes = ZipFileUtils.readZipFile((ZipFile)zipFile, (String)item.getJsonRelativePath(), (String)item.getJsonName());
                Validate.isTrue((bytes != null && bytes.length > 0 ? 1 : 0) != 0, (String)"json\u5185\u5bb9\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u6570\u636e", (Object[])new Object[0]);
                String json = new String(bytes, StandardCharsets.UTF_8);
                importModel.appendLine("\u5bfc\u5165\u65b0\u589e\u6570\u636e\u6e90");
                String itemJson = JSON.toJSONString((Object)((Object)item));
                this.remoteServiceService.create(itemJson, json);
            }
            importModel.addCreateCount();
            importModel.appendLine("\u5bfc\u5165\u65b0\u589e\u6210\u529f\uff01\uff01");
        }
        catch (IOException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            throw new IllegalArgumentException("\u8bfb\u53d6json\u5185\u5bb9\u51fa\u9519", e);
        }
    }

    private void handleUpdateData(RemoteServiceAddressEntity address, RemoteServiceAddressEntity dbAddress, MigrateImportModel importModel) {
        Validate.isTrue((boolean)address.getCode().equals(dbAddress.getCode()), (String)"\u5bfc\u5165\u8fdc\u7aef\u6570\u636e\u6e90\u7684\u8fdc\u7aef\u8c03\u7528\u5730\u5740\u4e0e\u672c\u7cfb\u7edf\u7684\u8fdc\u7aef\u8c03\u7528\u7f16\u7801\u4e0d\u4e00\u81f4", (Object[])new Object[0]);
        for (RemoteServiceEntity remoteServiceEntity : address.getRemoteServices()) {
            remoteServiceEntity.setRemoteServiceAddress(dbAddress);
        }
        HashMap<String, RemoteServiceEntity> map = new HashMap<String, RemoteServiceEntity>();
        for (RemoteServiceEntity remoteServiceEntity : dbAddress.getRemoteServices()) {
            map.put(remoteServiceEntity.getCode(), remoteServiceEntity);
        }
        address.setId(dbAddress.getId());
        this.remoteServiceAddressRepository.save((Object)address);
        ZipFile zipFile = importModel.getZipFile();
        try {
            for (RemoteServiceEntity item : address.getRemoteServices()) {
                if (!map.containsKey(item.getCode())) continue;
                item.setId(((RemoteServiceEntity)((Object)map.get(item.getCode()))).getId());
                importModel.appendLine("\u8bfb\u53d6json\u5185\u5bb9");
                byte[] bytes = ZipFileUtils.readZipFile((ZipFile)zipFile, (String)item.getJsonRelativePath(), (String)item.getJsonName());
                Validate.isTrue((boolean)ArrayUtils.isNotEmpty((byte[])bytes), (String)"json\u5185\u5bb9\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u6570\u636e", (Object[])new Object[0]);
                String json = new String(bytes, StandardCharsets.UTF_8);
                String itemJson = JSON.toJSONString((Object)((Object)item));
                this.remoteServiceService.update(itemJson, json);
            }
            importModel.addUpdateCount();
            importModel.appendLine("\u66f4\u65b0\u6210\u529f\uff01\uff01");
        }
        catch (IOException iOException) {
            LOGGER.error(iOException.getMessage(), (Throwable)iOException);
            throw new IllegalArgumentException("\u8bfb\u53d6json\u5185\u5bb9\u51fa\u9519", iOException);
        }
    }

    private RemoteServiceAddressEntity handleImportDataId(RemoteServiceAddressEntity address) {
        address.setId(null);
        Set<RemoteServiceEntity> service = address.getRemoteServices();
        for (RemoteServiceEntity item : service) {
            item.setId(null);
        }
        return address;
    }
}

