/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.core.service.internal;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.bizunited.platform.common.util.ApplicationContextUtils;
import com.bizunited.platform.core.entity.RemoteServiceEntity;
import com.bizunited.platform.core.repository.RemoteServiceRepository;
import com.bizunited.platform.core.service.RemoteServiceService;
import com.bizunited.platform.venus.common.service.file.VenusFileService;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import feign.Client;
import feign.Request;
import feign.Response;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.transaction.Transactional;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Example;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="RemoteServiceServiceImpl")
public class RemoteServiceServiceImpl
implements RemoteServiceService {
    private static final String JSON_FILE_SUFFIX = "json";
    private static final String REQUEST_PARAM = "RequestParam";
    private static final String REQUEST_PARAM_VALUE = "RequestParamValue";
    private static final String HEAD = "Head";
    private static final String HEAD_VALUE = "HeadValue";
    private static final String REQUEST_BODY = "RequestBody";
    private static final String REQUEST_BODY_VALUE = "RequestBodyValue";
    private static final String RESPONSE_BODY = "ResponseBody";
    private static final String NULLABLE = "nullable";
    private static final String FIELD_NAME = "fieldName";
    private static final String TYPE = "type";
    private static final String DESC = "desc";
    private static final String CONTENT = "content";
    private static final String OBJECT = "Object";
    private static final String OBJECT_ARRAY = "ObjectArray";
    private static final String KEY = "key";
    private static final String SERVICE_E_ERROR = "\u5165\u53c2\u8fdc\u7a0b\u670d\u52a1\u5b9e\u4f53JSON\u4e0d\u80fd\u4e3a\u7a7a";
    private static final String SERVICE_P_ERROR = "\u5165\u53c2\u8fdc\u7a0b\u670d\u52a1\u53c2\u6570JSON\u4e0d\u80fd\u4e3a\u7a7a";
    private static final String SERVICE_C_ERROR = "\u53c2\u6570\u6267\u884c\u8f6c\u5316\u65f6\u53d1\u751f\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\uff01";
    private static final String SERVICE_S_ERROR = "\u8fdc\u7aef\u670d\u52a1\u6e90\u4e0d\u80fd\u4e3a\u7a7a!";
    private static final HashSet<String> REQUEST_TYPES = Sets.newHashSet((Object[])new String[]{"\u6587\u672c", "\u6570\u5b57", "\u65f6\u95f4", "\u5e03\u5c14\u503c", "Object", "ObjectArray"});
    private static final HashSet<String> RESPONSE_TYPES = Sets.newHashSet((Object[])new String[]{"\u6587\u672c", "\u6570\u5b57", "\u65f6\u95f4", "\u5e03\u5c14\u503c", "Object", "ObjectArray", "\u5206\u9875\u603b\u6570\u636e", "\u5206\u9875\u5355\u9875\u6570\u636e", "\u5206\u9875\u5f53\u524d\u9875\u7801", "\u5206\u9875\u6700\u540e\u9875\u7801", "\u9519\u8bef\u4fe1\u606f"});
    private static final HashSet<String> REQUEST_METHOD = Sets.newHashSet((Object[])new String[]{"POST", "GET", "PATCH", "DELETE", "PUT", "COPY", "HEAD"});
    @Autowired
    private RemoteServiceRepository remoteServiceRepository;
    @Autowired
    private VenusFileService venusFileService;

    @Override
    public JSON valid(String entityJson, String jsonStr) {
        JSONObject json;
        RemoteServiceEntity entity;
        Validate.notBlank((CharSequence)entityJson, (String)SERVICE_E_ERROR, (Object[])new Object[0]);
        Validate.notBlank((CharSequence)jsonStr, (String)SERVICE_P_ERROR, (Object[])new Object[0]);
        try {
            entity = (RemoteServiceEntity)((Object)JSON.parseObject((String)entityJson, RemoteServiceEntity.class));
            json = JSON.parseObject((String)jsonStr);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(SERVICE_C_ERROR, e);
        }
        this.validJson(json);
        JSONObject result = this.validConnection(entity, json);
        return this.resolveJson(result, "");
    }

    @Override
    @Transactional(rollbackOn={Exception.class})
    public RemoteServiceEntity create(String entityJson, String jsonStr) {
        RemoteServiceEntity entity;
        Validate.notBlank((CharSequence)entityJson, (String)SERVICE_E_ERROR, (Object[])new Object[0]);
        Validate.notBlank((CharSequence)jsonStr, (String)SERVICE_P_ERROR, (Object[])new Object[0]);
        try {
            entity = (RemoteServiceEntity)((Object)JSON.parseObject((String)entityJson, RemoteServiceEntity.class));
        }
        catch (Exception e) {
            throw new IllegalArgumentException(SERVICE_C_ERROR, e);
        }
        return this.create(entity, jsonStr);
    }

    private RemoteServiceEntity create(RemoteServiceEntity entity, String jsonStr) {
        Validate.notBlank((CharSequence)jsonStr, (String)SERVICE_P_ERROR, (Object[])new Object[0]);
        JSONObject json = JSON.parseObject((String)jsonStr);
        this.validEntity(entity, true);
        RemoteServiceEntity exsit = this.remoteServiceRepository.findByCode(entity.getCode());
        Validate.isTrue((exsit == null ? 1 : 0) != 0, (String)"\u6307\u5b9a\u7684\u4e1a\u52a1\u7f16\u53f7\u5df2\u5b58\u5728\uff0c\u8bf7\u8fdb\u884c\u66f4\u6362!!", (Object[])new Object[0]);
        this.validJson(json);
        this.validConnection(entity, json);
        Date nowDate = new Date();
        String folderName = new SimpleDateFormat("yyyyMMdd").format(nowDate);
        String uuid = UUID.randomUUID().toString();
        String fileRename = uuid + "." + JSON_FILE_SUFFIX;
        String relativePath = StringUtils.join((Object[])new Serializable[]{"/remoteServiceJson/", folderName, "/", Integer.valueOf(new Random().nextInt(100) % 10)});
        byte[] jsonContent = json.toJSONString().getBytes(StandardCharsets.UTF_8);
        this.venusFileService.saveFile(relativePath, fileRename, fileRename, jsonContent);
        entity.setJsonRelativePath(relativePath);
        entity.setJsonName(fileRename);
        entity.setRemoteServiceStatus(1);
        return (RemoteServiceEntity)((Object)this.remoteServiceRepository.save((Object)entity));
    }

    @Override
    @Transactional
    public RemoteServiceEntity create(RemoteServiceEntity remoteServiceEntity) {
        this.validEntity(remoteServiceEntity, true);
        remoteServiceEntity.setProjectName(ApplicationContextUtils.getProjectName());
        return (RemoteServiceEntity)((Object)this.remoteServiceRepository.save((Object)remoteServiceEntity));
    }

    @Override
    @Transactional
    public RemoteServiceEntity update(String entityJson, String jsonStr) {
        RemoteServiceEntity entity;
        Validate.notBlank((CharSequence)entityJson, (String)SERVICE_E_ERROR, (Object[])new Object[0]);
        Validate.notBlank((CharSequence)jsonStr, (String)SERVICE_P_ERROR, (Object[])new Object[0]);
        try {
            entity = (RemoteServiceEntity)((Object)JSON.parseObject((String)entityJson, RemoteServiceEntity.class));
        }
        catch (Exception e) {
            throw new IllegalArgumentException(SERVICE_C_ERROR, e);
        }
        return this.update(entity, jsonStr);
    }

    private RemoteServiceEntity update(RemoteServiceEntity entity, String jsonStr) {
        JSONObject json = JSON.parseObject((String)jsonStr);
        this.validEntity(entity, false);
        this.validJson(json);
        this.validConnection(entity, json);
        Date nowDate = new Date();
        String folderName = new SimpleDateFormat("yyyyMMdd").format(nowDate);
        String uuid = UUID.randomUUID().toString();
        String fileRename = uuid + "." + JSON_FILE_SUFFIX;
        String relativePath = StringUtils.join((Object[])new Serializable[]{"/remoteServiceJson/", folderName, "/", Integer.valueOf(new Random().nextInt(100) % 10)});
        byte[] jsonContent = json.toJSONString().getBytes(StandardCharsets.UTF_8);
        this.venusFileService.saveFile(relativePath, fileRename, fileRename, jsonContent);
        Optional op = this.remoteServiceRepository.findById(entity.getId());
        RemoteServiceEntity exist = op.orElse(null);
        Validate.notNull((Object)((Object)exist), (String)SERVICE_S_ERROR, (Object[])new Object[0]);
        exist.setRemoteServiceType(entity.getRemoteServiceType());
        exist.setAcceptContentType(entity.getAcceptContentType());
        exist.setRemoteServiceAddress(entity.getRemoteServiceAddress());
        exist.setRequestURL(entity.getRequestURL());
        exist.setRemoteServiceDesc(entity.getRemoteServiceDesc());
        exist.setRequestMethod(entity.getRequestMethod());
        exist.setRequestAccept(entity.getRequestAccept());
        exist.setAcceptContentType(entity.getAcceptContentType());
        exist.setJsonRelativePath(relativePath);
        exist.setJsonName(fileRename);
        return (RemoteServiceEntity)((Object)this.remoteServiceRepository.save((Object)exist));
    }

    @Override
    @Transactional
    public RemoteServiceEntity disable(String remoteServiceId) {
        Validate.notBlank((CharSequence)remoteServiceId, (String)"\u8fdc\u7a0b\u8c03\u7528\u6e90id\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Optional op = this.remoteServiceRepository.findById(remoteServiceId);
        RemoteServiceEntity remoteServiceEntity = op.orElse(null);
        Validate.notNull((Object)((Object)remoteServiceEntity), (String)SERVICE_S_ERROR, (Object[])new Object[0]);
        remoteServiceEntity.setRemoteServiceStatus(0);
        return (RemoteServiceEntity)((Object)this.remoteServiceRepository.save((Object)remoteServiceEntity));
    }

    @Override
    @Transactional
    public RemoteServiceEntity enable(String id) {
        Validate.notBlank((CharSequence)id, (String)"\u8fdc\u7a0b\u8c03\u7528\u6e90id\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Optional op = this.remoteServiceRepository.findById(id);
        RemoteServiceEntity remoteServiceEntity = op.orElse(null);
        remoteServiceEntity.setRemoteServiceStatus(1);
        return (RemoteServiceEntity)((Object)this.remoteServiceRepository.save((Object)remoteServiceEntity));
    }

    @Override
    @Transactional
    public void updateRemoteService(String remoteServiceAddressId, Integer status) {
        Validate.notBlank((CharSequence)remoteServiceAddressId, (String)"\u8fdc\u7aef\u5730\u5740id\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)status, (String)"\u4fee\u6539\u7684\u72b6\u6001\u503c\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Set<RemoteServiceEntity> remoteServiceEntities = this.remoteServiceRepository.findByRemoteServiceAddressId(remoteServiceAddressId);
        if (!CollectionUtils.isEmpty(remoteServiceEntities)) {
            remoteServiceEntities.forEach(rs -> {
                rs.setRemoteServiceStatus(status);
                this.remoteServiceRepository.save(rs);
            });
        }
    }

    @Override
    public List<RemoteServiceEntity> findAllByConditions(RemoteServiceEntity remoteService) {
        if (remoteService == null) {
            List remoteServiceEntities = this.remoteServiceRepository.findAll();
            if (!CollectionUtils.isEmpty((Collection)remoteServiceEntities)) {
                remoteServiceEntities = remoteServiceEntities.stream().filter(remoteServiceEntity -> StringUtils.equals((CharSequence)ApplicationContextUtils.getProjectName(), (CharSequence)remoteServiceEntity.getProjectName())).collect(Collectors.toList());
            }
            return remoteServiceEntities;
        }
        Example example = Example.of((Object)((Object)remoteService));
        return this.remoteServiceRepository.findAll(example);
    }

    @Override
    public JSONArray importJson(String jsonStr) {
        Validate.notBlank((CharSequence)jsonStr, (String)"\u8f93\u5165JSON\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        JSONObject json = JSON.parseObject((String)jsonStr);
        return this.jsonToFormat(json, new JSONArray(), "", 1);
    }

    @Override
    public JSON execute(String code, String jsonStr) {
        JSONObject json;
        Validate.notBlank((CharSequence)code, (String)"\u8fdc\u7aef\u670d\u52a1\u6e90ID\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        RemoteServiceEntity entity = this.remoteServiceRepository.findByCode(code);
        Validate.notNull((Object)((Object)entity), (String)SERVICE_S_ERROR, (Object[])new Object[0]);
        try {
            json = JSON.parseObject((String)jsonStr);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(SERVICE_C_ERROR, e);
        }
        JSONObject result = this.validConnection(entity, json);
        byte[] scriptFile = this.venusFileService.readFileContent(entity.getJsonRelativePath(), entity.getJsonName());
        Validate.notNull((Object)scriptFile, (String)"\u8fdc\u7aef\u670d\u52a1\u4fdd\u5b58\u7684\u6570\u636e\u683c\u5f0f\u6587\u4ef6\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        return result;
    }

    @Override
    public JSON findCompleteByCode(String code) {
        JSONObject requestParamValue;
        JSONObject headValue;
        Validate.notBlank((CharSequence)code, (String)"\u8fdc\u7aef\u8c03\u7528\u6e90\u4e1a\u52a1\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        RemoteServiceEntity entity = this.remoteServiceRepository.findByCode(code);
        Validate.notNull((Object)((Object)entity), (String)SERVICE_S_ERROR, (Object[])new Object[0]);
        byte[] params = this.venusFileService.readFileContent(entity.getJsonRelativePath(), entity.getJsonName());
        Validate.notNull((Object)params, (String)"\u8fdc\u7aef\u8c03\u7528\u6e90\u5b58\u50a8\u7684\u53c2\u6570\u683c\u5f0f\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        JSONObject paramsJson = JSON.parseObject((String)new String(params));
        Validate.notNull((Object)paramsJson, (String)"\u8fdc\u7aef\u8c03\u7528\u6e90\u5b58\u50a8\u7684\u53c2\u6570\u8f6c\u5316json\u4e0d\u80fd\u4e3a\u7a7a!", (Object[])new Object[0]);
        JSONArray headArray = paramsJson.getJSONArray(HEAD);
        JSONObject jSONObject = headValue = paramsJson.getJSONObject(HEAD_VALUE) == null ? new JSONObject() : paramsJson.getJSONObject(HEAD_VALUE);
        if (null != headArray) {
            for (Object o : headArray) {
                JSONObject oJson = (JSONObject)o;
                if (!StringUtils.isBlank((CharSequence)headValue.getString(oJson.getString(FIELD_NAME)))) continue;
                headValue.put(oJson.getString(FIELD_NAME), (Object)"");
            }
        }
        paramsJson.put(HEAD_VALUE, (Object)headValue);
        JSONArray requestParamArray = paramsJson.getJSONArray(REQUEST_PARAM);
        JSONObject jSONObject2 = requestParamValue = paramsJson.getJSONObject(REQUEST_PARAM_VALUE) == null ? new JSONObject() : paramsJson.getJSONObject(REQUEST_PARAM_VALUE);
        if (null != requestParamArray) {
            for (Object o : requestParamArray) {
                JSONObject oJson = (JSONObject)o;
                if (!StringUtils.isBlank((CharSequence)requestParamValue.getString(oJson.getString(FIELD_NAME)))) continue;
                requestParamValue.put(oJson.getString(FIELD_NAME), (Object)"");
            }
        }
        paramsJson.put(REQUEST_PARAM_VALUE, (Object)requestParamValue);
        return paramsJson;
    }

    @Override
    public String findJsonByCode(String code) {
        Validate.notBlank((CharSequence)code, (String)"\u8fdc\u7aef\u8c03\u7528\u6e90\u4e1a\u52a1\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        RemoteServiceEntity entity = this.remoteServiceRepository.findByCode(code);
        Validate.notNull((Object)((Object)entity), (String)SERVICE_S_ERROR, (Object[])new Object[0]);
        byte[] bytes = this.venusFileService.readFileContent(entity.getJsonRelativePath(), entity.getJsonName());
        String json = new String(bytes, StandardCharsets.UTF_8);
        return json;
    }

    @Override
    public RemoteServiceEntity findByCode(String code) {
        return this.remoteServiceRepository.findByCode(code);
    }

    @Override
    public Page<RemoteServiceEntity> findByConditions(Integer remoteServiceType, String addressCode, String addressAlias, String requestMethod, Integer remoteServiceStatus, Pageable pageable) {
        Validate.notNull((Object)pageable, (String)"\u67e5\u8be2\u5206\u9875\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a!", (Object[])new Object[0]);
        HashMap<String, Object> conditions = new HashMap<String, Object>();
        if (null != remoteServiceType) {
            conditions.put("remoteServiceType", remoteServiceType);
        }
        if (StringUtils.isNotBlank((CharSequence)addressCode)) {
            conditions.put("addressCode", addressCode);
        }
        if (StringUtils.isNotBlank((CharSequence)addressAlias)) {
            conditions.put("addressAlias", addressAlias);
        }
        if (StringUtils.isNotBlank((CharSequence)requestMethod)) {
            conditions.put("requestMethod", requestMethod);
        }
        if (null != remoteServiceStatus) {
            conditions.put("remoteServiceStatus", remoteServiceStatus);
        }
        return this.remoteServiceRepository.findByConditions(pageable, conditions);
    }

    @Override
    public List<RemoteServiceEntity> findDetailsByIds(String[] ids) {
        if (ids == null || ids.length == 0) {
            return Lists.newArrayList();
        }
        return this.remoteServiceRepository.findDetailsByIds(ids);
    }

    @Override
    public int countByIds(String[] ids) {
        if (ids == null || ids.length == 0) {
            return 0;
        }
        return this.remoteServiceRepository.countByIds(ids);
    }

    private void validEntity(RemoteServiceEntity entity, Boolean isCreate) {
        Validate.notNull((Object)((Object)entity), (String)"\u8fdc\u7aef\u670d\u52a1\u6e90\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        String code = entity.getCode();
        Validate.notBlank((CharSequence)code, (String)"\u8fdc\u7aef\u670d\u52a1\u6e90\u670d\u52a1\u4e1a\u52a1\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)entity.getRequestURL(), (String)"\u8fdc\u7aef\u670d\u52a1\u6e90\u670d\u52a1\u5730\u5740\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)entity.getRequestMethod(), (String)"\u8fdc\u7aef\u670d\u52a1\u6e90\u8c03\u7528\u65b9\u5f0f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.isTrue((boolean)REQUEST_METHOD.contains(entity.getRequestMethod()), (String)"\u8fdc\u7aef\u670d\u52a1\u6e90\u8c03\u7528\u65b9\u5f0f\u4e0d\u5408\u8981\u6c42\uff0c\u8bf7\u68c0\u67e5\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)entity.getRequestAccept(), (String)"\u8fdc\u7aef\u670d\u52a1\u6e90\u63a5\u53d7\u7684\u56de\u5e94\u5185\u5bb9\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)entity.getAcceptContentType(), (String)"\u8fdc\u7aef\u670d\u52a1\u6e90\u63a5\u53d7\u5185\u5bb9\u7c7b\u578b\u8bbe\u5b9a\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        entity.setRemoteServiceType(null == entity.getRemoteServiceType() ? 0 : entity.getRemoteServiceType());
        if (entity.getRemoteServiceType() == 0) {
            Validate.notNull((Object)((Object)entity.getRemoteServiceAddress()), (String)"\u8fdc\u7a0b\u8c03\u7528\u670d\u52a1\u6240\u5c5e\u8fdc\u7a0b\u8c03\u7528\u6e90\u4e3a\u7a7a,\u8bf7\u68c0\u67e5\uff01", (Object[])new Object[0]);
            Validate.notBlank((CharSequence)entity.getRemoteServiceAddress().getId(), (String)"\u8fdc\u7a0b\u8c03\u7528\u670d\u52a1\u6240\u5c5e\u8fdc\u7a0b\u8c03\u7528\u6e90ID\u4e3a\u7a7a,\u8bf7\u68c0\u67e5\uff01", (Object[])new Object[0]);
        }
        if (Boolean.TRUE.equals(isCreate)) {
            Validate.isTrue((boolean)StringUtils.isBlank((CharSequence)entity.getId()), (String)"\u65b0\u589e\u65f6\uff0c\u4e0d\u80fd\u4f20\u5165id!", (Object[])new Object[0]);
        } else {
            Validate.isTrue((!StringUtils.isBlank((CharSequence)entity.getId()) ? 1 : 0) != 0, (String)"\u4fee\u6539\u65f6\uff0c\u5fc5\u987b\u4f20\u5165id!", (Object[])new Object[0]);
            Optional op = this.remoteServiceRepository.findById(entity.getId());
            Validate.isTrue((boolean)op.isPresent(), (String)"\u66f4\u65b0\u65f6\u672a\u53d1\u73b0\u5df2\u5b58\u6570\u636e\uff01", (Object[])new Object[0]);
        }
    }

    private void validJson(JSONObject json) {
        JSONArray responseBody;
        JSONObject obj;
        JSONArray requestBody;
        if (null != json.get((Object)HEAD)) {
            JSONArray head = json.getJSONArray(HEAD);
            head.forEach(o -> {
                JSONObject jsonObject = JSON.parseObject((String)o.toString());
                Validate.notBlank((CharSequence)jsonObject.getString(FIELD_NAME), (String)"HEAD\u53c2\u6570\u7f3a\u5c11FIELD NAME\u540d\u79f0\uff01", (Object[])new Object[0]);
                Validate.notNull((Object)jsonObject.get((Object)NULLABLE), (String)String.format("HEAD\u53c2\u6570%s\u7f3a\u5c11\u5fc5\u586b\u53c2\u6570\uff01", jsonObject.getString(FIELD_NAME)), (Object[])new Object[0]);
            });
        }
        if (null != json.get((Object)REQUEST_PARAM)) {
            JSONArray requstParam = json.getJSONArray(REQUEST_PARAM);
            requstParam.forEach(o -> {
                JSONObject jsonObject = JSON.parseObject((String)o.toString());
                Validate.notBlank((CharSequence)jsonObject.getString(FIELD_NAME), (String)"\u8bf7\u6c42\u53c2\u6570\u7f3a\u5c11KEY\u540d\u79f0\uff01", (Object[])new Object[0]);
                Validate.notNull((Object)jsonObject.get((Object)NULLABLE), (String)String.format("\u8bf7\u6c42\u53c2\u6570%s\u7f3a\u5c11\u5fc5\u586b\u53c2\u6570\uff01", jsonObject.getString(FIELD_NAME)), (Object[])new Object[0]);
            });
        }
        if (null != json.get((Object)REQUEST_BODY) && null != (requestBody = json.getJSONArray(REQUEST_BODY))) {
            for (Object o2 : requestBody) {
                obj = JSON.parseObject((String)o2.toString());
                this.validObjectJson(obj, true);
            }
        }
        if (null != json.get((Object)RESPONSE_BODY) && null != (responseBody = json.getJSONArray(RESPONSE_BODY))) {
            for (Object o2 : responseBody) {
                obj = JSON.parseObject((String)o2.toString());
                this.validObjectJson(obj, false);
            }
        }
    }

    private void validObjectJson(JSONObject json, Boolean isRequest) {
        Validate.notBlank((CharSequence)json.getString(FIELD_NAME), (String)"\u6709\u53c2\u6570\u7f3a\u5c11\u53c2\u6570\u540d\uff0c\u8bf7\u68c0\u67e5\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)json.getBoolean(NULLABLE), (String)String.format("\u53c2\u6570%s\u672a\u786e\u8ba4\u5fc5\u586b\uff0c\u8bf7\u68c0\u67e5\uff01", json.getString(FIELD_NAME)), (Object[])new Object[0]);
        Validate.notBlank((CharSequence)json.getString(TYPE), (String)String.format("\u53c2\u6570%s\u672a\u786e\u8ba4\u7c7b\u578b\uff0c\u8bf7\u68c0\u67e5\uff01", json.getString(FIELD_NAME)), (Object[])new Object[0]);
        if (Boolean.TRUE.equals(isRequest)) {
            Validate.isTrue((boolean)REQUEST_TYPES.contains(json.getString(TYPE)), (String)String.format("\u53c2\u6570%s\u4e0d\u5339\u914d\u89c4\u5b9a\u8bf7\u6c42\u7c7b\u578b\uff0c\u8bf7\u68c0\u67e5\uff01", json.getString(FIELD_NAME)), (Object[])new Object[0]);
        } else {
            Validate.isTrue((boolean)RESPONSE_TYPES.contains(json.getString(TYPE)), (String)String.format("\u53c2\u6570%s\u4e0d\u5339\u914d\u89c4\u5b9a\u8fd4\u56de\u7c7b\u578b\uff0c\u8bf7\u68c0\u67e5\uff01", json.getString(FIELD_NAME)), (Object[])new Object[0]);
        }
        if (json.getString(TYPE).equals(OBJECT) || json.getString(TYPE).equals(OBJECT_ARRAY)) {
            Validate.notNull((Object)json.get((Object)CONTENT), (String)"\u8bbe\u7f6e\u4e3aOBJECT\u7684\u53c2\u6570\u5fc5\u987b\u6709\u5b50\u5185\u5bb9\uff0c\u8bf7\u68c0\u67e5\uff01", (Object[])new Object[0]);
            JSONArray contentJSon = json.getJSONArray(CONTENT);
            for (Object o : contentJSon) {
                JSONObject oJson = JSON.parseObject((String)o.toString());
                this.validObjectJson(oJson, isRequest);
            }
        }
    }

    private JSONArray jsonToFormat(JSONObject json, JSONArray result, String location, Integer index) {
        Set keys = json.keySet();
        for (String key : keys) {
            Object obj = json.get((Object)key);
            JSONObject thisJson = new JSONObject();
            thisJson.put(FIELD_NAME, (Object)key);
            thisJson.put(DESC, (Object)"");
            String thisLocation = StringUtils.isEmpty((CharSequence)location) ? index.toString() : String.format("%s-%s", location, index.toString());
            thisJson.put(KEY, (Object)thisLocation);
            thisJson.put(NULLABLE, (Object)true);
            if (obj instanceof JSONObject) {
                thisJson.put(TYPE, (Object)OBJECT);
                thisJson.put(CONTENT, (Object)this.jsonToFormat((JSONObject)obj, new JSONArray(), thisLocation, 1));
            } else if (obj instanceof JSONArray) {
                JSONArray thisJsonArry = (JSONArray)obj;
                Object child = thisJsonArry.get(0);
                thisJson.put(TYPE, (Object)OBJECT_ARRAY);
                if (child instanceof JSONObject) {
                    thisJson.put(CONTENT, (Object)this.jsonToFormat((JSONObject)child, new JSONArray(), thisLocation, 1));
                }
            } else if (obj instanceof Boolean) {
                thisJson.put(TYPE, (Object)"\u5e03\u5c14\u503c");
            } else if (obj instanceof Number) {
                thisJson.put(TYPE, (Object)"\u6570\u5b57");
            } else if (obj instanceof Date) {
                thisJson.put(TYPE, (Object)"\u65f6\u95f4");
            } else {
                thisJson.put(TYPE, (Object)"\u6587\u672c");
            }
            result.add((Object)thisJson);
            index = index + 1;
        }
        return result;
    }

    private JSONObject validConnection(RemoteServiceEntity entity, JSONObject json) {
        Client.Default defaultClient = new Client.Default(null, null);
        String url = entity.getRemoteServiceAddress().getAddress().concat(entity.getRequestURL());
        HashMap headers = new HashMap();
        if (null != json.getJSONObject(HEAD_VALUE)) {
            JSONObject heads = json.getJSONObject(HEAD_VALUE);
            heads.keySet().forEach(o -> {
                Collection cfr_ignored_0 = headers.put(o, Sets.newHashSet((Object[])new String[]{heads.getString(o)}));
            });
        }
        if (null != json.getJSONObject(REQUEST_PARAM_VALUE)) {
            JSONObject requestParams = json.getJSONObject(REQUEST_PARAM_VALUE);
            HashSet<String> paramSet = new HashSet<String>();
            for (String key : requestParams.keySet()) {
                paramSet.add(String.format("%s=%s", key, requestParams.getString(key)));
            }
            String paraUrl = String.format("?%s", StringUtils.join(paramSet, (String)"&"));
            url = url.concat(paraUrl);
        }
        byte[] body = new byte[]{};
        try {
            JSONObject bodyJson = json.getJSONObject(REQUEST_BODY_VALUE);
            if (null != bodyJson) {
                String bodyStr = bodyJson.toJSONString();
                body = bodyStr.getBytes(StandardCharsets.UTF_8);
            }
        }
        catch (Exception e) {
            throw new IllegalArgumentException("\u8bf7\u6c42\u4f53\u6267\u884c\u8f6c\u5316\u65f6\u53d1\u751f\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\uff01", e);
        }
        Request.Options options = new Request.Options(18000, 18000);
        Request.HttpMethod httpMethod = Request.HttpMethod.valueOf((String)entity.getRequestMethod());
        Request request = Request.create((Request.HttpMethod)httpMethod, (String)url, headers, (byte[])body, (Charset)Charset.defaultCharset());
        try {
            Response response = defaultClient.execute(request, options);
            Validate.isTrue((response.status() == HttpStatus.OK.value() ? 1 : 0) != 0, (String)String.format("\u8fde\u63a5\u5931\u8d25\uff0c\u8fd4\u56de\u7f16\u7801\uff1a%s,\u539f\u56e0\uff1a%s", response.status(), response.reason()), (Object[])new Object[0]);
            String resultJson = IOUtils.toString((InputStream)response.body().asInputStream(), (Charset)StandardCharsets.UTF_8);
            return JSON.parseObject((String)resultJson);
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
    }

    private JSONArray resolveJson(JSONObject sourceJson, String location) {
        JSONArray resultJson = new JSONArray();
        if (sourceJson == null) {
            return resultJson;
        }
        Set keys = sourceJson.keySet();
        if (!CollectionUtils.isEmpty((Collection)keys)) {
            int index = 1;
            for (String key : keys) {
                String newLocation = StringUtils.isEmpty((CharSequence)location) ? String.format("%s", index) : String.format("%s-%s", location, index);
                JSONObject result = new JSONObject();
                result.put(KEY, (Object)newLocation);
                result.put(FIELD_NAME, (Object)key);
                result.put(DESC, (Object)"");
                result.put(NULLABLE, (Object)true);
                if (sourceJson.get((Object)key) instanceof JSONObject) {
                    result.put(TYPE, (Object)OBJECT);
                    result.put(CONTENT, (Object)this.resolveJson(sourceJson.getJSONObject(key), newLocation));
                    resultJson.add((Object)result);
                } else if (sourceJson.get((Object)key) instanceof JSONArray) {
                    result.put(TYPE, (Object)OBJECT_ARRAY);
                    JSONArray arrayJson = sourceJson.getJSONArray(key);
                    if (arrayJson.get(0) instanceof JSONObject) {
                        result.put(CONTENT, (Object)this.resolveJson((JSONObject)arrayJson.get(0), newLocation));
                    }
                    resultJson.add((Object)result);
                } else {
                    result.put(TYPE, (Object)this.getReusltType(sourceJson.get((Object)key)));
                    resultJson.add((Object)result);
                }
                ++index;
            }
        }
        return resultJson;
    }

    private String getReusltType(Object obj) {
        if (obj instanceof Number) {
            return "\u6570\u5b57";
        }
        if (obj instanceof Date) {
            return "\u65f6\u95f4";
        }
        if (obj instanceof Boolean) {
            return "\u5e03\u5c14\u503c";
        }
        if (obj instanceof JSONObject) {
            return OBJECT;
        }
        if (obj instanceof JSONArray) {
            return OBJECT_ARRAY;
        }
        if (obj instanceof String) {
            return "\u6587\u672c";
        }
        return "\u6587\u672c";
    }
}

