/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.core.service.log.internal;

import com.bizunited.platform.core.entity.log.LoggerInfoEntity;
import com.bizunited.platform.core.repository.log.LoggerInfoEntityRepository;
import com.bizunited.platform.core.service.LoggerInfoEntityService;
import com.bizunited.platform.rbac.server.util.SecurityUtils;
import java.util.Date;
import java.util.HashMap;
import java.util.Optional;
import javax.transaction.Transactional;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;

@Service
public class LoggerInfoEntityServiceImpl
implements LoggerInfoEntityService {
    @Autowired
    private LoggerInfoEntityRepository loggerInfoEntityRepository;

    @Override
    @Transactional
    public LoggerInfoEntity create(LoggerInfoEntity loggerInfoEntity) {
        LoggerInfoEntity current = this.createForm(loggerInfoEntity);
        return current;
    }

    @Override
    @Transactional
    public LoggerInfoEntity createForm(LoggerInfoEntity loggerInfoEntity) {
        Date date = new Date();
        if (StringUtils.isBlank((CharSequence)loggerInfoEntity.getCreateAccount())) {
            loggerInfoEntity.setCreateAccount(SecurityUtils.getUserAccount());
        }
        loggerInfoEntity.setCreateTime(date);
        loggerInfoEntity.setModifyTime(date);
        loggerInfoEntity.setModifyAccount(loggerInfoEntity.getCreateAccount());
        this.createValidation(loggerInfoEntity);
        this.loggerInfoEntityRepository.save((Object)loggerInfoEntity);
        return loggerInfoEntity;
    }

    private void createValidation(LoggerInfoEntity loggerInfoEntity) {
        Validate.notNull((Object)((Object)loggerInfoEntity), (String)"\u8fdb\u884c\u5f53\u524d\u64cd\u4f5c\u65f6\uff0c\u4fe1\u606f\u5bf9\u8c61\u5fc5\u987b\u4f20\u5165!!", (Object[])new Object[0]);
        Validate.isTrue((boolean)StringUtils.isBlank((CharSequence)loggerInfoEntity.getId()), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u5f53\u671f\u4fe1\u606f\u7684\u6570\u636e\u7f16\u53f7\uff08\u4e3b\u952e\uff09\u4e0d\u80fd\u6709\u503c\uff01", (Object[])new Object[0]);
        loggerInfoEntity.setId(null);
        Validate.notBlank((CharSequence)loggerInfoEntity.getModule(), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u65e5\u5fd7\u6240\u5c5e\u6a21\u5757\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)loggerInfoEntity.getOpId(), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u65e5\u5fd7\u5bf9\u5e94\u7684\u4e1a\u52a1\u6570\u636e\u552f\u4e00\u6807\u8bc6\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)loggerInfoEntity.getType(), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u65e5\u5fd7\u64cd\u4f5c\u7c7b\u578b\uff08\u540c\u6a21\u677f\u4e2d\u7684\u8bbe\u5b9a\uff09\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)loggerInfoEntity.getOpTime(), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u65e5\u5fd7\u4e8b\u4ef6\u64cd\u4f5c\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)loggerInfoEntity.getAccount(), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u64cd\u4f5c\u8d26\u53f7\u4fe1\u606f\uff08\u53ef\u80fd\u533f\u540d\uff09\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)loggerInfoEntity.getMsg(), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u65e5\u5fd7\u4fe1\u606f\u63cf\u8ff0\uff08\u6765\u6e90\u4e8e\u6a21\u677f\u7684\u4fe1\u606f\u683c\u5f0f\u8bbe\u5b9a\uff09\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.isTrue((loggerInfoEntity.getModule() == null || loggerInfoEntity.getModule().length() < 255 ? 1 : 0) != 0, (String)"\u65e5\u5fd7\u6240\u5c5e\u6a21\u5757,\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(255)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((loggerInfoEntity.getOpId() == null || loggerInfoEntity.getOpId().length() < 255 ? 1 : 0) != 0, (String)"\u65e5\u5fd7\u5bf9\u5e94\u7684\u4e1a\u52a1\u6570\u636e\u552f\u4e00\u6807\u8bc6,\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(255)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((loggerInfoEntity.getType() == null || loggerInfoEntity.getType().length() < 255 ? 1 : 0) != 0, (String)"\u65e5\u5fd7\u64cd\u4f5c\u7c7b\u578b\uff08\u540c\u6a21\u677f\u4e2d\u7684\u8bbe\u5b9a\uff09,\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(255)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((loggerInfoEntity.getAccount() == null || loggerInfoEntity.getAccount().length() < 255 ? 1 : 0) != 0, (String)"\u64cd\u4f5c\u8d26\u53f7\u4fe1\u606f\uff08\u53ef\u80fd\u533f\u540d\uff09,\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(255)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((loggerInfoEntity.getMsg() == null || loggerInfoEntity.getMsg().length() < 255 ? 1 : 0) != 0, (String)"\u65e5\u5fd7\u4fe1\u606f\u63cf\u8ff0\uff08\u6765\u6e90\u4e8e\u6a21\u677f\u7684\u4fe1\u606f\u683c\u5f0f\u8bbe\u5b9a\uff09,\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(255)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((loggerInfoEntity.getRelativePath() == null || loggerInfoEntity.getRelativePath().length() < 255 ? 1 : 0) != 0, (String)"\u65e5\u5fd7\u6587\u4ef6\u5b58\u50a8\u76f8\u5bf9\u4f4d\u7f6e,\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(255)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((loggerInfoEntity.getFileName() == null || loggerInfoEntity.getFileName().length() < 255 ? 1 : 0) != 0, (String)"\u65e5\u5fd7\u6587\u4ef6\u6587\u4ef6\u540d,\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(255)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
    }

    @Override
    @Transactional
    public LoggerInfoEntity update(LoggerInfoEntity loggerInfoEntity) {
        LoggerInfoEntity current = this.updateForm(loggerInfoEntity);
        return current;
    }

    @Override
    @Transactional
    public LoggerInfoEntity updateForm(LoggerInfoEntity loggerInfoEntity) {
        this.updateValidation(loggerInfoEntity);
        String currentId = loggerInfoEntity.getId();
        Optional op_currentLoggerInfoEntity = this.loggerInfoEntityRepository.findById(currentId);
        LoggerInfoEntity currentLoggerInfoEntity = op_currentLoggerInfoEntity.orElse(null);
        currentLoggerInfoEntity = (LoggerInfoEntity)((Object)Validate.notNull((Object)((Object)currentLoggerInfoEntity), (String)"\u672a\u53d1\u73b0\u6307\u5b9a\u7684\u539f\u59cb\u6a21\u578b\u5bf9\u8c61\u4fe1", (Object[])new Object[0]));
        loggerInfoEntity.setModifyTime(new Date());
        if (StringUtils.isBlank((CharSequence)loggerInfoEntity.getModifyAccount())) {
            loggerInfoEntity.setModifyAccount(SecurityUtils.getUserAccount());
        }
        currentLoggerInfoEntity.setModule(loggerInfoEntity.getModule());
        currentLoggerInfoEntity.setOpId(loggerInfoEntity.getOpId());
        currentLoggerInfoEntity.setType(loggerInfoEntity.getType());
        currentLoggerInfoEntity.setOpTime(loggerInfoEntity.getOpTime());
        currentLoggerInfoEntity.setAccount(loggerInfoEntity.getAccount());
        currentLoggerInfoEntity.setMsg(loggerInfoEntity.getMsg());
        currentLoggerInfoEntity.setRelativePath(loggerInfoEntity.getRelativePath());
        currentLoggerInfoEntity.setFileName(loggerInfoEntity.getFileName());
        this.loggerInfoEntityRepository.saveAndFlush((Object)currentLoggerInfoEntity);
        return currentLoggerInfoEntity;
    }

    private void updateValidation(LoggerInfoEntity loggerInfoEntity) {
        Validate.isTrue((!StringUtils.isBlank((CharSequence)loggerInfoEntity.getId()) ? 1 : 0) != 0, (String)"\u4fee\u6539\u4fe1\u606f\u65f6\uff0c\u5f53\u671f\u4fe1\u606f\u7684\u6570\u636e\u7f16\u53f7\uff08\u4e3b\u952e\uff09\u5fc5\u987b\u6709\u503c\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)loggerInfoEntity.getModule(), (String)"\u4fee\u6539\u4fe1\u606f\u65f6\uff0c\u65e5\u5fd7\u6240\u5c5e\u6a21\u5757\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)loggerInfoEntity.getOpId(), (String)"\u4fee\u6539\u4fe1\u606f\u65f6\uff0c\u65e5\u5fd7\u5bf9\u5e94\u7684\u4e1a\u52a1\u6570\u636e\u552f\u4e00\u6807\u8bc6\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)loggerInfoEntity.getType(), (String)"\u4fee\u6539\u4fe1\u606f\u65f6\uff0c\u65e5\u5fd7\u64cd\u4f5c\u7c7b\u578b\uff08\u540c\u6a21\u677f\u4e2d\u7684\u8bbe\u5b9a\uff09\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)loggerInfoEntity.getOpTime(), (String)"\u4fee\u6539\u4fe1\u606f\u65f6\uff0c\u65e5\u5fd7\u4e8b\u4ef6\u64cd\u4f5c\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)loggerInfoEntity.getAccount(), (String)"\u4fee\u6539\u4fe1\u606f\u65f6\uff0c\u64cd\u4f5c\u8d26\u53f7\u4fe1\u606f\uff08\u53ef\u80fd\u533f\u540d\uff09\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)loggerInfoEntity.getMsg(), (String)"\u4fee\u6539\u4fe1\u606f\u65f6\uff0c\u65e5\u5fd7\u4fe1\u606f\u63cf\u8ff0\uff08\u6765\u6e90\u4e8e\u6a21\u677f\u7684\u4fe1\u606f\u683c\u5f0f\u8bbe\u5b9a\uff09\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.isTrue((loggerInfoEntity.getModule() == null || loggerInfoEntity.getModule().length() < 255 ? 1 : 0) != 0, (String)"\u65e5\u5fd7\u6240\u5c5e\u6a21\u5757,\u5728\u8fdb\u884c\u4fee\u6539\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(255)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((loggerInfoEntity.getOpId() == null || loggerInfoEntity.getOpId().length() < 255 ? 1 : 0) != 0, (String)"\u65e5\u5fd7\u5bf9\u5e94\u7684\u4e1a\u52a1\u6570\u636e\u552f\u4e00\u6807\u8bc6,\u5728\u8fdb\u884c\u4fee\u6539\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(255)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((loggerInfoEntity.getType() == null || loggerInfoEntity.getType().length() < 255 ? 1 : 0) != 0, (String)"\u65e5\u5fd7\u64cd\u4f5c\u7c7b\u578b\uff08\u540c\u6a21\u677f\u4e2d\u7684\u8bbe\u5b9a\uff09,\u5728\u8fdb\u884c\u4fee\u6539\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(255)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((loggerInfoEntity.getAccount() == null || loggerInfoEntity.getAccount().length() < 255 ? 1 : 0) != 0, (String)"\u64cd\u4f5c\u8d26\u53f7\u4fe1\u606f\uff08\u53ef\u80fd\u533f\u540d\uff09,\u5728\u8fdb\u884c\u4fee\u6539\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(255)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((loggerInfoEntity.getMsg() == null || loggerInfoEntity.getMsg().length() < 255 ? 1 : 0) != 0, (String)"\u65e5\u5fd7\u4fe1\u606f\u63cf\u8ff0\uff08\u6765\u6e90\u4e8e\u6a21\u677f\u7684\u4fe1\u606f\u683c\u5f0f\u8bbe\u5b9a\uff09,\u5728\u8fdb\u884c\u4fee\u6539\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(255)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((loggerInfoEntity.getRelativePath() == null || loggerInfoEntity.getRelativePath().length() < 255 ? 1 : 0) != 0, (String)"\u65e5\u5fd7\u6587\u4ef6\u5b58\u50a8\u76f8\u5bf9\u4f4d\u7f6e,\u5728\u8fdb\u884c\u4fee\u6539\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(255)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((loggerInfoEntity.getFileName() == null || loggerInfoEntity.getFileName().length() < 255 ? 1 : 0) != 0, (String)"\u65e5\u5fd7\u6587\u4ef6\u6587\u4ef6\u540d,\u5728\u8fdb\u884c\u4fee\u6539\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(255)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
    }

    @Override
    public LoggerInfoEntity findDetailsById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        return this.loggerInfoEntityRepository.findDetailsById(id);
    }

    @Override
    public LoggerInfoEntity findById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        Optional op = this.loggerInfoEntityRepository.findById(id);
        return op.orElse(null);
    }

    @Override
    @Transactional
    public void deleteById(String id) {
        Validate.notBlank((CharSequence)id, (String)"\u8fdb\u884c\u5220\u9664\u65f6\uff0c\u5fc5\u987b\u7ed9\u5b9a\u4e3b\u952e\u4fe1\u606f!!", (Object[])new Object[0]);
        LoggerInfoEntity current = this.findById(id);
        if (current != null) {
            this.loggerInfoEntityRepository.delete((Object)current);
        }
    }

    @Override
    public Page<LoggerInfoEntity> findByOpidAndModule(String opId, String module, Pageable pageable) {
        Validate.notNull((Object)pageable, (String)"\u67e5\u8be2\u5206\u9875\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a!", (Object[])new Object[0]);
        HashMap<String, String> conditions = new HashMap<String, String>(2);
        if (StringUtils.isNotBlank((CharSequence)opId)) {
            conditions.put("opId", opId);
        }
        if (StringUtils.isNotBlank((CharSequence)module)) {
            conditions.put("module", module);
        }
        return this.loggerInfoEntityRepository.findByConditions(pageable, conditions);
    }
}

