/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.core.service.scheduler.handle;

import com.bizunited.platform.core.entity.DynamicTaskSchedulerEntity;
import com.bizunited.platform.core.entity.DynamicTaskSchedulerLogEntity;
import com.bizunited.platform.core.service.DynamicTaskSchedulerLogService;
import com.bizunited.platform.core.service.invoke.HandleChain;
import com.bizunited.platform.core.service.invoke.InvokeParams;
import com.bizunited.platform.core.service.invoke.InvokeProxyContext;
import com.bizunited.platform.core.service.invoke.InvokeProxyException;
import com.bizunited.platform.core.service.invoke.InvokeResponseHandle;
import java.util.Date;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="dynamicTaskInvokeLogHandle")
public class DynamicTaskInvokeLogHandle
implements InvokeResponseHandle {
    @Autowired
    private DynamicTaskSchedulerLogService dynamicTaskSchedulerLogService;
    private static final Logger LOGGER = LoggerFactory.getLogger(DynamicTaskInvokeLogHandle.class);

    @Override
    public boolean handleException(InvokeProxyContext context) {
        return true;
    }

    @Override
    public void doHandle(InvokeProxyContext context, HandleChain chain) throws InvokeProxyException {
        InvokeParams invokeParams = context.getParams();
        DynamicTaskSchedulerEntity currentTask = (DynamicTaskSchedulerEntity)((Object)invokeParams.getVariables()[0]);
        Validate.notNull((Object)((Object)currentTask), (String)"\u5728\u8fdb\u884c\u52a8\u6001\u4efb\u52a1\u6267\u884c\u65f6\uff0c\u672a\u53d1\u73b0\u6307\u5b9a\u7684\u4e1a\u52a1\u4efb\u52a1", (Object[])new Object[0]);
        Date startTime = (Date)invokeParams.getInvokeParam("_timerRecord");
        Validate.notNull((Object)startTime, (String)"\u672a\u53d1\u73b0\u8c03\u7528\u7684\u5f00\u59cb\u65f6\u95f4!!", (Object[])new Object[0]);
        Date endTime = new Date();
        LOGGER.info(String.format("\u6b63\u5728\u5199\u5165\u52a8\u6001\u4efb\u52a1%s\u7684\u6267\u884c\u65e5\u5fd7", currentTask.getId()));
        DynamicTaskSchedulerLogEntity log = new DynamicTaskSchedulerLogEntity();
        log.setDynamicTaskScheduler(currentTask);
        log.setEndTime(endTime);
        log.setStartTime(startTime);
        log.setSuccess(!context.isException());
        if (context.isException()) {
            log.setErrorContents(context.getErrMsg());
        }
        this.dynamicTaskSchedulerLogService.create(log);
        chain.doHandle(context, HandleChain.ChainLogic.CONTINUE);
    }
}

