/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.core.service.serviceable.init;

import com.bizunited.platform.common.service.init.InitProcessService;
import com.bizunited.platform.core.annotations.NebulaServiceMethod;
import com.bizunited.platform.core.annotations.ServiceMethodParam;
import com.bizunited.platform.core.common.PlatformContext;
import com.bizunited.platform.core.service.invoke.InvokeProxyBuilder;
import com.bizunited.platform.core.service.invoke.InvokeRequestHandle;
import com.bizunited.platform.core.service.invoke.InvokeResponseHandle;
import com.bizunited.platform.core.service.serviceable.ServicableMethodService;
import com.bizunited.platform.core.service.serviceable.model.ServicableMethodInfo;
import com.bizunited.platform.core.service.serviceable.model.ServicableMethodProperty;
import com.bizunited.platform.core.service.serviceable.template.ValueMappingTemplate;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.dom4j.IllegalAddException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.SpringProxy;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Component;

@Component(value="ServicableMethodInitProcess2")
public class ServicableMethodInitProcess
implements InitProcessService {
    private static final Logger LOGGER = LoggerFactory.getLogger(ServicableMethodInitProcess.class);
    @Autowired
    private ApplicationContext applicationContext;
    @Autowired
    private ServicableMethodService servicableMethodService;
    @Autowired
    private BeanFactory beanFactory;
    @Autowired
    private PlatformContext platformContext;
    @Autowired
    private List<ValueMappingTemplate> valueMappingTemplates;

    public boolean doProcess() {
        return true;
    }

    public int sort() {
        return 5;
    }

    public boolean stopOnException() {
        return true;
    }

    public void init() {
        try {
            this.initServicableMethod();
        }
        catch (ClassNotFoundException | NoSuchMethodException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            throw new IllegalArgumentException(e.getMessage(), e);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void initServicableMethod() throws NoSuchMethodException, ClassNotFoundException {
        void var5_10;
        void var5_7;
        LOGGER.info("service method scan started .......");
        String[] beanDefinitionNames = this.applicationContext.getBeanDefinitionNames();
        if (beanDefinitionNames == null || beanDefinitionNames.length == 0) {
            return;
        }
        ArrayList<Object> mappingAnnotations = new ArrayList<Object>(1000);
        String[] stringArray = beanDefinitionNames;
        int n = stringArray.length;
        boolean bl = false;
        while (var5_7 < n) {
            String beanDefinitionName = stringArray[var5_7];
            Object currentBean = this.applicationContext.getBean(beanDefinitionName);
            mappingAnnotations.add(currentBean);
            ++var5_7;
        }
        ArrayList serviceMethods = new ArrayList();
        for (Object e : mappingAnnotations) {
            Class<?> targetClass = this.recursionFindInterface(e.getClass());
            if (targetClass == null) continue;
            Arrays.stream(targetClass.getDeclaredMethods()).filter(item -> item.getAnnotation(NebulaServiceMethod.class) != null).forEach(item -> serviceMethods.add(item));
        }
        ArrayList<ServicableMethodInfo> exsitServiceMethodReops = new ArrayList<ServicableMethodInfo>();
        boolean bl2 = false;
        for (Method currentMethod : serviceMethods) {
            ServicableMethodInfo serviceMethodReop = new ServicableMethodInfo();
            NebulaServiceMethod serviceMethodAnno = currentMethod.getAnnotation(NebulaServiceMethod.class);
            String serviceMethodAnnoName = serviceMethodAnno.name();
            if (StringUtils.isBlank((CharSequence)serviceMethodAnnoName)) {
                LOGGER.warn("\u6307\u5b9a\u7684ServicableMethodProperty[{}]\u6ca1\u6709\u8bbe\u5b9aname\uff0c\u8bf7\u68c0\u67e5!!", (Object)serviceMethodAnnoName);
                continue;
            }
            String serviceMethodAnnoDesc = serviceMethodAnno.desc();
            if (StringUtils.isBlank((CharSequence)serviceMethodAnnoDesc)) {
                LOGGER.warn("\u6307\u5b9a\u7684ServicableMethodProperty[{}]\u6ca1\u6709\u8bbe\u5b9adesc\uff0c\u8bf7\u68c0\u67e5!!", (Object)serviceMethodAnnoName);
                continue;
            }
            String returnPropertiesFilter = serviceMethodAnno.returnPropertiesFilter();
            String methodSimpleName = currentMethod.getName();
            String className = currentMethod.getDeclaringClass().getName();
            Validate.isTrue((!exsitServiceMethodReops.stream().map(ServicableMethodInfo::getName).filter(item -> StringUtils.equals((CharSequence)item, (CharSequence)serviceMethodAnnoName)).findAny().isPresent() ? 1 : 0) != 0, (String)("\u5728\u8fdb\u884c\u670d\u52a1\u6e90\u5b9a\u4e49\u5206\u6790\u65f6\uff0c\u53d1\u73b0\u6709\u91cd\u590d\u7684NebulaServiceMethod.name[" + serviceMethodAnnoName + "]\uff0c\u8bf7\u68c0\u67e5!!"), (Object[])new Object[0]);
            serviceMethodReop.setUsedScope(serviceMethodAnno.scope());
            serviceMethodReop.setDescription(serviceMethodAnnoDesc);
            serviceMethodReop.setInterfaceName(className);
            serviceMethodReop.setProjectName(this.platformContext.getAppName());
            serviceMethodReop.setSimpleMethodName(methodSimpleName);
            serviceMethodReop.setName(serviceMethodAnnoName);
            this.checkInvokeHandle(serviceMethodAnno, currentMethod, serviceMethodReop);
            serviceMethodReop.setReturnPropertiesFilter(returnPropertiesFilter);
            this.analysisMethodParameters(serviceMethodReop, currentMethod);
            this.analysisMethodReturnParameter(serviceMethodReop, currentMethod);
            exsitServiceMethodReops.add(serviceMethodReop);
            this.servicableMethodService.create(serviceMethodReop);
            LOGGER.info(String.format("servicable named [%s] cached .......", serviceMethodReop.getName()));
            ++var5_10;
        }
        LOGGER.info(String.format("service method scan completed , [%d] servicable be found .......", (int)var5_10));
    }

    private void checkInvokeHandle(NebulaServiceMethod serviceMethodAnno, Method ctMethod, ServicableMethodInfo serviceMethodReop) {
        String methodSimpleName = ctMethod.getName();
        String className = ctMethod.getDeclaringClass().getName();
        String methodName = StringUtils.join((Object[])new String[]{className, ".", methodSimpleName});
        String requestHandleGroup = serviceMethodAnno.requestHandleGroup();
        Class<?>[] requestHandleTypes = serviceMethodAnno.requestHandleTypes();
        if (!(StringUtils.isBlank((CharSequence)requestHandleGroup) || requestHandleTypes.length <= 1 && requestHandleTypes[0] == Void.class)) {
            throw new IllegalArgumentException(String.format("RequestHandleGroup\u548cRequestHandleTypes\u4e0d\u80fd\u540c\u65f6\u8bbe\u5b9a[%s]", methodName));
        }
        if (requestHandleTypes.length > 1 || requestHandleTypes[0] != Void.class) {
            for (Class<?> requestHandleType : requestHandleTypes) {
                Validate.isTrue((boolean)InvokeRequestHandle.class.isAssignableFrom(requestHandleType), (String)"\u7c7b\u578b[%s]\u5e76\u6ca1\u6709\u5b9e\u73b0InvokeRequestHandle\u63a5\u53e3\uff0c\u4e0d\u80fd\u914d\u7f6e\u5230NebulaServiceMethod\u6ce8\u89e3\u7684requestHandleTypes\u5c5e\u6027[methodname=%s]\uff0c\u8bf7\u68c0\u67e5", (Object[])new Object[]{requestHandleType.getTypeName(), methodName});
            }
            serviceMethodReop.setRequestHandleTypes(requestHandleTypes);
        }
        if (!StringUtils.isBlank((CharSequence)requestHandleGroup)) {
            Object targetBean = null;
            try {
                targetBean = this.beanFactory.getBean(requestHandleGroup);
            }
            catch (NoSuchBeanDefinitionException e) {
                throw new IllegalAddException(String.format("\u672a\u53d1\u73b0\u6307\u5b9aname\u7684spring bean[%s]\uff0c\u8bf7\u68c0\u67e5!!", requestHandleGroup));
            }
            Validate.isTrue((boolean)(targetBean instanceof InvokeProxyBuilder), (String)"bean name[%s]\u5e76\u4e0d\u662f\u4e00\u4e2aInvokeProxyBuilder\u5bf9\u8c61\uff0c\u4e0d\u80fd\u914d\u7f6e\u5230NebulaServiceMethod\u6ce8\u89e3\u7684requestHandleGroup\u5c5e\u6027[methodname=%s]\uff0c\u8bf7\u68c0\u67e5", (Object[])new Object[]{requestHandleGroup, methodName});
            serviceMethodReop.setRequestHandleGroup(requestHandleGroup);
        }
        String responseHandleGroup = serviceMethodAnno.responseHandleGroup();
        Class<?>[] responseHandleTypes = serviceMethodAnno.responseHandleTypes();
        if (!(StringUtils.isBlank((CharSequence)responseHandleGroup) || responseHandleTypes.length <= 1 && responseHandleTypes[0] == Void.class)) {
            throw new IllegalArgumentException(String.format("ResponseHandleGroup\u548cResponseHandleTypes\u4e0d\u80fd\u540c\u65f6\u8bbe\u5b9a[%s]", methodName));
        }
        if (responseHandleTypes.length > 1 || responseHandleTypes[0] != Void.class) {
            for (Class<?> responseHandleType : responseHandleTypes) {
                Validate.isTrue((boolean)InvokeResponseHandle.class.isAssignableFrom(responseHandleType), (String)"\u7c7b\u578b[%s]\u5e76\u6ca1\u6709\u5b9e\u73b0InvokeResponseHandle\u63a5\u53e3\uff0c\u4e0d\u80fd\u914d\u7f6e\u5230NebulaServiceMethod\u6ce8\u89e3\u7684responseHandleTypes\u5c5e\u6027[methodname=%s]\uff0c\u8bf7\u68c0\u67e5", (Object[])new Object[]{responseHandleType.getTypeName(), methodName});
            }
            serviceMethodReop.setResponseHandleTypes(responseHandleTypes);
        }
        if (!StringUtils.isBlank((CharSequence)responseHandleGroup)) {
            Object targetBean = null;
            try {
                targetBean = this.beanFactory.getBean(responseHandleGroup);
            }
            catch (NoSuchBeanDefinitionException e) {
                throw new IllegalAddException(String.format("\u672a\u53d1\u73b0\u6307\u5b9aname\u7684spring bean[%s]\uff0c\u8bf7\u68c0\u67e5!!", responseHandleGroup));
            }
            Validate.isTrue((boolean)(targetBean instanceof InvokeProxyBuilder), (String)"bean name[%s]\u5e76\u4e0d\u662f\u4e00\u4e2aInvokeProxyBuilder\u5bf9\u8c61\uff0c\u4e0d\u80fd\u914d\u7f6e\u5230NebulaServiceMethod\u6ce8\u89e3\u7684responseHandleGroup\u5c5e\u6027[methodname=%s]\uff0c\u8bf7\u68c0\u67e5", (Object[])new Object[]{responseHandleGroup, methodName});
            serviceMethodReop.setResponseHandleGroup(responseHandleGroup);
        }
    }

    private void analysisMethodParameters(ServicableMethodInfo serviceMethodReop, Method ctMethod) throws ClassNotFoundException {
        String methodName = ctMethod.getName();
        Class<?> targetType = ctMethod.getDeclaringClass();
        Parameter[] parameters = ctMethod.getParameters();
        if (parameters == null || parameters.length == 0) {
            serviceMethodReop.setProperties(null);
            return;
        }
        ArrayList<ServicableMethodProperty> servicableMethodProperties = new ArrayList<ServicableMethodProperty>(16);
        for (int index = 0; index < parameters.length; ++index) {
            ServicableMethodProperty servicableMethodProperty = new ServicableMethodProperty();
            Parameter parameterItem = parameters[index];
            for (ValueMappingTemplate valueMappingTemplateItem : this.valueMappingTemplates) {
                boolean match = valueMappingTemplateItem.match(targetType, ctMethod, parameterItem, index);
                if (!match) continue;
                servicableMethodProperty.setValueMappingTemplate(valueMappingTemplateItem);
                break;
            }
            Validate.notNull((Object)servicableMethodProperty.getValueMappingTemplate(), (String)"\u5728\u65b9\u6cd5[%s]\u4e2d\uff0c\u7c7b\u578b[%s]\u6ca1\u6709\u53d1\u73b0\u7b26\u5408\u503c\u6620\u5c04\u6240\u9700\u7684\u5904\u7406\u5668\uff0c\u8be5\u7c7b\u578b\u76ee\u524d\u670d\u52a1\u6e90\u4e0d\u652f\u6301\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[]{methodName, parameterItem.getName()});
            servicableMethodProperty.setParamType(parameterItem);
            servicableMethodProperty.setPropertyIndex(index);
            ServiceMethodParam serviceMethodParam = parameterItem.getAnnotation(ServiceMethodParam.class);
            if (serviceMethodParam != null) {
                servicableMethodProperty.setAnnonQualifiedName(serviceMethodParam.name());
                servicableMethodProperty.setHasParamAnnotation(true);
            } else {
                servicableMethodProperty.setAnnonQualifiedName("");
                servicableMethodProperty.setHasParamAnnotation(false);
            }
            servicableMethodProperties.add(servicableMethodProperty);
        }
        serviceMethodReop.setProperties(servicableMethodProperties);
    }

    private Class<?> recursionFindInterface(Class<?> targetClass) {
        if (SpringProxy.class.isAssignableFrom(targetClass)) {
            String cglibClassName = targetClass.getName();
            String realClassName = null;
            if (cglibClassName.indexOf("$$") != -1) {
                realClassName = cglibClassName.split("\\$\\$")[0];
            } else if (cglibClassName.indexOf("$") != -1) {
                realClassName = cglibClassName.split("\\$")[0];
            } else {
                return null;
            }
            Class<?> realClass = null;
            try {
                realClass = Class.forName(realClassName);
            }
            catch (ClassNotFoundException e) {
                LOGGER.debug(e.getMessage());
            }
            return realClass;
        }
        return targetClass;
    }

    private void analysisMethodReturnParameter(ServicableMethodInfo serviceMethodReop, Method ctMethod) throws NoSuchMethodException {
        boolean isCollectionInterface = false;
        Class<Object> returnClass = ctMethod.getReturnType();
        Class<Collection> collectionClass = Collection.class;
        Class<Iterable> iterableClass = Iterable.class;
        if (returnClass == null || returnClass == Void.class) {
            returnClass = Void.class;
        }
        boolean bl = isCollectionInterface = collectionClass.isAssignableFrom(returnClass) || iterableClass.isAssignableFrom(returnClass);
        if (isCollectionInterface) {
            Class genericClazz = null;
            Type genericType = ctMethod.getGenericReturnType();
            if (genericType instanceof ParameterizedType) {
                ParameterizedType pt = (ParameterizedType)genericType;
                genericClazz = (Class)pt.getActualTypeArguments()[0];
            }
            serviceMethodReop.setReturnCollection(true);
            serviceMethodReop.setReturnClass(genericClazz);
        } else if (returnClass == Void.class) {
            serviceMethodReop.setReturnCollection(false);
            serviceMethodReop.setReturnClass(Void.class);
        } else {
            serviceMethodReop.setReturnCollection(false);
            serviceMethodReop.setReturnClass(returnClass);
        }
    }
}

