/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.core.service.serviceable.internal;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.bizunited.platform.core.annotations.NebulaServiceMethod;
import com.bizunited.platform.core.service.invoke.InvokeParams;
import com.bizunited.platform.core.service.invoke.InvokeProxyException;
import com.bizunited.platform.core.service.serviceable.ServicableMethodService;
import com.bizunited.platform.core.service.serviceable.model.ServicableMethodInfo;
import com.bizunited.platform.core.service.serviceable.model.ServicableMethodProperty;
import com.bizunited.platform.core.service.serviceable.template.ValueMappingTemplate;
import com.google.common.collect.Lists;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;

@Service(value="KuiperServiceMethodServiceImpl")
public class ServicableMethodServiceImpl
implements ServicableMethodService {
    private static Map<String, ServicableMethodInfo> caches = new ConcurrentHashMap<String, ServicableMethodInfo>();
    private static Logger LOGGER = LoggerFactory.getLogger(ServicableMethodService.class);
    @Autowired
    private ApplicationContext applicationContext;

    @Override
    public void create(ServicableMethodInfo serviceMethod) {
        Validate.notNull((Object)serviceMethod, (String)"\u5c06\u8981\u7f13\u5b58\u7684\u670d\u52a1\u6e90\u4fe1\u606f\uff0c\u4e0d\u80fd\u4e3a\u7a7a!!", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)serviceMethod.getName(), (String)"\u5c06\u8981\u7f13\u5b58\u7684\u670d\u52a1\u6e90\u4fe1\u606f\uff0c\u5fc5\u987b\u6709\u4e3a\u4e00\u4e2aname\u4fe1\u606f", (Object[])new Object[0]);
        caches.put(serviceMethod.getName(), serviceMethod);
    }

    @Override
    public Page<JSONObject> findByConditions(Pageable pageable, String name, String description, String interfaceName, String simpleMethodName, String returnClassName, String usedScope) {
        if (caches == null) {
            return new PageImpl((List)Lists.newArrayList());
        }
        Collection<ServicableMethodInfo> servicableMethodInfos = caches.values();
        List<ServicableMethodInfo> methods = servicableMethodInfos.stream().filter(item -> {
            if (StringUtils.isNotBlank((CharSequence)name)) {
                return StringUtils.contains((CharSequence)item.getName(), (CharSequence)name);
            }
            return true;
        }).filter(item -> {
            if (StringUtils.isNotBlank((CharSequence)description)) {
                return StringUtils.contains((CharSequence)item.getDescription(), (CharSequence)description);
            }
            return true;
        }).filter(item -> {
            if (StringUtils.isNotBlank((CharSequence)interfaceName)) {
                return StringUtils.contains((CharSequence)item.getInterfaceName(), (CharSequence)interfaceName);
            }
            return true;
        }).filter(item -> {
            if (StringUtils.isNotBlank((CharSequence)simpleMethodName)) {
                return StringUtils.contains((CharSequence)item.getSimpleMethodName(), (CharSequence)simpleMethodName);
            }
            return true;
        }).filter(item -> {
            if (StringUtils.isNotBlank((CharSequence)returnClassName)) {
                return StringUtils.contains((CharSequence)item.getReturnClass().getName(), (CharSequence)returnClassName);
            }
            return true;
        }).filter(item -> {
            if (StringUtils.isBlank((CharSequence)usedScope)) {
                return true;
            }
            if (StringUtils.equalsIgnoreCase((CharSequence)usedScope, (CharSequence)"write")) {
                return item.getUsedScope() == NebulaServiceMethod.ScopeType.WRITE;
            }
            if (StringUtils.equalsIgnoreCase((CharSequence)usedScope, (CharSequence)"read")) {
                return item.getUsedScope() == NebulaServiceMethod.ScopeType.READ;
            }
            return true;
        }).collect(Collectors.toList());
        List<JSONObject> results = this.buildResults(methods);
        return new PageImpl(results);
    }

    private List<JSONObject> buildResults(List<ServicableMethodInfo> servicableMethodInfos) {
        ArrayList<JSONObject> results = new ArrayList<JSONObject>();
        servicableMethodInfos.forEach(item -> {
            JSONObject jsonitem = this.findDetailJson((ServicableMethodInfo)item);
            results.add(jsonitem);
        });
        return results;
    }

    private JSONObject findDetailJson(ServicableMethodInfo servicableMethodInfo) {
        JSONObject jsonitem = new JSONObject();
        jsonitem.put("name", (Object)servicableMethodInfo.getName());
        jsonitem.put("description", (Object)servicableMethodInfo.getDescription());
        jsonitem.put("simpleMethodName", (Object)servicableMethodInfo.getSimpleMethodName());
        jsonitem.put("interfaceName", (Object)servicableMethodInfo.getInterfaceName());
        jsonitem.put("returnCollection", (Object)servicableMethodInfo.isReturnCollection());
        jsonitem.put("returnClass", (Object)servicableMethodInfo.getReturnClass().getName());
        jsonitem.put("usedScope", (Object)servicableMethodInfo.getUsedScope());
        List<ServicableMethodProperty> servicableMethodProperties = servicableMethodInfo.getProperties();
        if (servicableMethodProperties != null) {
            JSONArray itemps = new JSONArray();
            servicableMethodProperties.forEach(itemp -> {
                JSONObject itempObject = new JSONObject();
                itempObject.put("propertyIndex", (Object)itemp.getPropertyIndex());
                itempObject.put("parameter", (Object)itemp.getParamType().getType().getName());
                itempObject.put("hasParamAnnotation", (Object)itemp.isHasParamAnnotation());
                itempObject.put("annonQualifiedName", (Object)itemp.getAnnonQualifiedName());
                itemps.add((Object)itempObject);
            });
            jsonitem.put("properties", (Object)itemps);
        } else {
            jsonitem.put("properties", (Object)new JSONArray());
        }
        return jsonitem;
    }

    @Override
    public ServicableMethodInfo findDetailsByName(String name) {
        return caches.get(name);
    }

    @Override
    public JSONObject findDetailJsonByName(String name) {
        ServicableMethodInfo servicableMethodInfo = this.findDetailsByName(name);
        if (servicableMethodInfo == null) {
            return null;
        }
        JSONObject jsonObject = this.findDetailJson(servicableMethodInfo);
        return jsonObject;
    }

    @Override
    public Object invoke(String serviceName, InvokeParams invokeParams) throws InvokeProxyException {
        Validate.notBlank((CharSequence)serviceName, (String)"\u8fdb\u884c\u670d\u52a1\u6e90\u8c03\u7528\u65f6\uff0c\u670d\u52a1\u6e90\u552f\u4e00\u6807\u8bc6\u540d\u79f0\u5fc5\u987b\u4f20\u5165!!", (Object[])new Object[0]);
        InvokeParams currentInvokeParams = invokeParams;
        if (currentInvokeParams == null) {
            currentInvokeParams = new InvokeParams();
        }
        ServicableMethodInfo servicableMethodInfo = this.findDetailsByName(serviceName);
        Validate.notNull((Object)servicableMethodInfo, (String)"\u6ca1\u53d1\u73b0\u6307\u5b9a\u7684\u670d\u52a1\u6e90\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        String methodParentClassName = servicableMethodInfo.getInterfaceName();
        Class<?> methodParentClass = null;
        try {
            methodParentClass = this.applicationContext.getClassLoader().loadClass(methodParentClassName);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
        Object targetBean = this.applicationContext.getBean(methodParentClass);
        Method targetMethod = this.findTargetMethod(methodParentClass, serviceName);
        ArrayList<Object> parameterValues = new ArrayList<Object>();
        List<ServicableMethodProperty> servicableMethodProperties = servicableMethodInfo.getProperties();
        Class<?> targetClass = targetMethod.getDeclaringClass();
        for (int index = 0; servicableMethodProperties != null && index < servicableMethodProperties.size(); ++index) {
            ServicableMethodProperty property = servicableMethodProperties.get(index);
            String qualifiedName = property.getAnnonQualifiedName();
            ValueMappingTemplate valueMappingTemplate = property.getValueMappingTemplate();
            Parameter parameter = property.getParamType();
            Object mappingValue = valueMappingTemplate.mapping(targetClass, targetMethod, parameter, index, qualifiedName, currentInvokeParams);
            parameterValues.add(mappingValue);
        }
        Object result = null;
        try {
            result = targetMethod.invoke(targetBean, parameterValues.toArray(new Object[0]));
            return result;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (InvocationTargetException e) {
            Throwable throwable = e.getTargetException();
            if (throwable != null && throwable instanceof RuntimeException) {
                throw (RuntimeException)throwable;
            }
            throw new IllegalArgumentException(e);
        }
        catch (Throwable e) {
            LOGGER.error(e.getMessage(), e);
            throw new IllegalArgumentException(e);
        }
    }

    private Method findTargetMethod(Class<?> methodParentClass, String serviceName) {
        Method[] targetMethods = methodParentClass.getDeclaredMethods();
        Validate.notNull((Object)targetMethods, (String)"\u672a\u5728spring ioc proxy\u627e\u5230\u6307\u5b9aservice method name\u7684\u670d\u52a1\u6e90!!", (Object[])new Object[0]);
        Method targetMethod = null;
        for (Method methodItem : targetMethods) {
            NebulaServiceMethod anno = methodItem.getAnnotation(NebulaServiceMethod.class);
            if (anno == null || !StringUtils.equals((CharSequence)anno.name(), (CharSequence)serviceName)) continue;
            targetMethod = methodItem;
            break;
        }
        Validate.notNull(targetMethod, (String)"\u672a\u5728spring ioc proxy\u627e\u5230\u6307\u5b9aservice method name\u7684\u670d\u52a1\u6e90!!", (Object[])new Object[0]);
        return targetMethod;
    }

    @Override
    public Object invoke(String serviceName, Object[] values) {
        Validate.notBlank((CharSequence)serviceName, (String)"\u8fdb\u884c\u670d\u52a1\u6e90\u8c03\u7528\u65f6\uff0c\u670d\u52a1\u6e90\u552f\u4e00\u6807\u8bc6\u540d\u79f0\u5fc5\u987b\u4f20\u5165!!", (Object[])new Object[0]);
        ServicableMethodInfo servicableMethodInfo = this.findDetailsByName(serviceName);
        Validate.notNull((Object)servicableMethodInfo, (String)"\u6ca1\u53d1\u73b0\u6307\u5b9a\u7684\u670d\u52a1\u6e90\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        Object[] currentValues = values;
        if (currentValues == null) {
            currentValues = new Object[]{};
        }
        String methodParentClassName = servicableMethodInfo.getInterfaceName();
        Class<?> methodParentClass = null;
        try {
            methodParentClass = this.applicationContext.getClassLoader().loadClass(methodParentClassName);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
        Object targetBean = this.applicationContext.getBean(methodParentClass);
        Method targetMethod = this.findTargetMethod(methodParentClass, serviceName);
        Object result = null;
        try {
            result = targetMethod.invoke(targetBean, currentValues);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (InvocationTargetException e) {
            Throwable throwable = e.getTargetException();
            if (throwable != null && throwable instanceof RuntimeException) {
                throw (RuntimeException)throwable;
            }
            throw new IllegalArgumentException(e);
        }
        catch (Throwable e) {
            LOGGER.error(e.getMessage(), e);
            throw new IllegalArgumentException(e);
        }
        return result;
    }
}

