/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.core.configuration.datasource;

import com.alibaba.druid.pool.DruidDataSource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.core.env.Environment;

@Configuration
public class PrimaryDataSourceConfig {
    private static final String JDBC_TYPE = "com.alibaba.druid.pool.DruidDataSource";
    @Autowired
    private ApplicationContext applicationContext;
    @Value(value="${nebula.datasource.url:}")
    private String url;
    @Value(value="${nebula.datasource.username:}")
    private String username;
    @Value(value="${nebula.datasource.password:}")
    private String password;
    @Value(value="${nebula.datasource.enable:false}")
    private boolean enable;
    @Value(value="${nebula.datasource-mapping:spring.datasource}")
    private String dataSourceMapping;

    @Primary
    @Bean(value={"primaryDataSource"}, initMethod="init")
    public DruidDataSource primaryDataSource() {
        DruidDataSource dataSource = new DruidDataSource();
        Environment environment = this.applicationContext.getEnvironment();
        String initialSize = environment.getProperty(StringUtils.join((Object[])new String[]{this.dataSourceMapping, ".", "initialSize"}));
        String minIdle = environment.getProperty(StringUtils.join((Object[])new String[]{this.dataSourceMapping, ".", "minIdle"}));
        String maxActive = environment.getProperty(StringUtils.join((Object[])new String[]{this.dataSourceMapping, ".", "maxActive"}));
        if (StringUtils.isNotBlank((CharSequence)initialSize)) {
            dataSource.setInitialSize(Integer.parseInt(initialSize));
        }
        if (StringUtils.isNotBlank((CharSequence)minIdle)) {
            dataSource.setMinIdle(Integer.parseInt(minIdle));
        }
        if (StringUtils.isNotBlank((CharSequence)maxActive)) {
            dataSource.setMaxActive(Integer.parseInt(maxActive));
        }
        if (!this.enable || StringUtils.isBlank((CharSequence)this.url)) {
            dataSource.setDbType(environment.getProperty(StringUtils.join((Object[])new String[]{this.dataSourceMapping, ".", "type"})));
            dataSource.setUsername(environment.getProperty(StringUtils.join((Object[])new String[]{this.dataSourceMapping, ".", "username"})));
            dataSource.setPassword(environment.getProperty(StringUtils.join((Object[])new String[]{this.dataSourceMapping, ".", "password"})));
            dataSource.setUrl(environment.getProperty(StringUtils.join((Object[])new String[]{this.dataSourceMapping, ".", "url"})));
            return dataSource;
        }
        dataSource.setUrl(this.url);
        dataSource.setPassword(this.password);
        dataSource.setUsername(this.username);
        dataSource.setDbType(JDBC_TYPE);
        return dataSource;
    }
}

