/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.core.controller;

import com.alibaba.fastjson.JSON;
import com.bizunited.platform.common.controller.BaseController;
import com.bizunited.platform.common.controller.model.ResponseModel;
import com.bizunited.platform.core.entity.CodeRuleEntity;
import com.bizunited.platform.core.service.CodeRuleService;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v1/nebula/codeRules"})
public class CodeRuleController
extends BaseController {
    private static final Logger LOGGER = LoggerFactory.getLogger(CodeRuleController.class);
    @Autowired
    private CodeRuleService codeRuleService;

    @ApiOperation(value="\u521b\u5efa\u7f16\u7801\u751f\u6210\u89c4\u5219")
    @RequestMapping(value={""}, method={RequestMethod.POST})
    public ResponseModel create(@ApiParam(name="\u7f16\u7801\u751f\u6210\u89c4\u5219\u4fe1\u606f") @RequestBody CodeRuleEntity entity) {
        LOGGER.debug("\u521b\u5efa\u7f16\u7801\u751f\u6210\u89c4\u5219\uff1a{}", (Object)JSON.toJSONString((Object)((Object)entity)));
        try {
            CodeRuleEntity codeRuleEntity = this.codeRuleService.create(entity);
            return this.buildHttpResultW((Object)codeRuleEntity, new String[]{""});
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u4fee\u6539\u7f16\u7801\u751f\u6210\u89c4\u5219")
    @RequestMapping(value={""}, method={RequestMethod.PATCH})
    public ResponseModel update(@ApiParam(name="\u7f16\u7801\u751f\u6210\u89c4\u5219\u4fe1\u606f") @RequestBody CodeRuleEntity entity) {
        LOGGER.debug("\u4fee\u6539\u7f16\u7801\u751f\u6210\u89c4\u5219\uff1a{}", (Object)JSON.toJSONString((Object)((Object)entity)));
        try {
            CodeRuleEntity codeRuleEntity = this.codeRuleService.update(entity);
            return this.buildHttpResultW((Object)codeRuleEntity, new String[]{""});
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u751f\u6210/\u4fee\u6539\u7f16\u7801\u751f\u6210\u89c4\u5219\u811a\u672c\u5185\u5bb9")
    @RequestMapping(value={"/updateContent"}, method={RequestMethod.PATCH})
    public ResponseModel updateContent(@ApiParam(name="\u7f16\u7801\u751f\u6210\u89c4\u5219ID") @RequestParam(name="ruleId") String ruleId, @ApiParam(name="\u7f16\u7801\u751f\u6210\u89c4\u5219\u811a\u672c\u5185\u5bb9") @RequestParam(name="content") String content) {
        try {
            return this.buildHttpResultW((Object)this.codeRuleService.updateContent(ruleId, content), new String[0]);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u6839\u636e\u89c4\u5219\u751f\u6210\u7f16\u7801")
    @RequestMapping(value={"/invoke"}, method={RequestMethod.POST})
    public ResponseModel invoke(@ApiParam(name="\u7f16\u7801\u751f\u6210\u89c4\u5219\u7684\u4e1a\u52a1\u7f16\u7801") @RequestParam(name="ruleCode") String ruleCode) {
        try {
            String content = this.codeRuleService.invoke(ruleCode);
            return this.buildHttpResult(content);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u67e5\u8be2\u4e1a\u52a1\u7f16\u7801\u751f\u6210\u89c4\u5219\u811a\u672c\u5185\u5bb9")
    @RequestMapping(value={"/findContentByCode"}, method={RequestMethod.GET})
    public ResponseModel findContentByCode(@ApiParam(name="\u7f16\u7801\u751f\u6210\u89c4\u5219\u7684\u4e1a\u52a1\u7f16\u7801") @RequestParam(name="code") String code) {
        try {
            String content = this.codeRuleService.findContentByCode(code);
            return this.buildHttpResultW(content, new String[]{""});
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u6309\u7167\u6761\u4ef6\u641c\u7d22\u7f16\u7801\u751f\u6210\u89c4\u5219\uff0c\u4e0d\u652f\u6301\u6a21\u7cca\u67e5\u8be2")
    @RequestMapping(value={"/findByConditions"}, method={RequestMethod.GET})
    public ResponseModel findByConditions(@ApiParam(name="ruleName", value="\u540d\u79f0") String ruleName, @ApiParam(name="ruleCode", value="\u7f16\u7801") String ruleCode, @ApiParam(name="ruleType", value="\u7c7b\u578b") String ruleType, @ApiParam(name="language", value="\u8bed\u8a00") String language, @PageableDefault(value=50) Pageable pageable) {
        try {
            Page<CodeRuleEntity> page = this.codeRuleService.findByConditions(pageable, ruleName, ruleCode, ruleType, language);
            return this.buildHttpResultW(page, new String[]{""});
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u6309\u7167\u6761\u4ef6\u641c\u7d22\u7f16\u7801\u751f\u6210\u89c4\u5219\uff0c\u4e0d\u652f\u6301\u6a21\u7cca\u67e5\u8be2,\u4e0d\u5206\u9875")
    @RequestMapping(value={"/findAllByConditions"}, method={RequestMethod.GET})
    public ResponseModel findAllByConditions(@RequestParam(required=false) @ApiParam(value="\u540d\u79f0") String ruleName, @RequestParam(required=false) @ApiParam(value="\u7f16\u7801") String ruleCode, @RequestParam(required=false) @ApiParam(value="\u7c7b\u578b") String ruleType, @RequestParam(required=false) @ApiParam(value="\u8bed\u8a00") String language) {
        try {
            CodeRuleEntity codeRule = new CodeRuleEntity();
            codeRule.setRuleName(ruleName);
            codeRule.setRuleCode(ruleCode);
            codeRule.setRuleType(ruleType);
            codeRule.setLanguage(language);
            List<CodeRuleEntity> codeRules = this.codeRuleService.findAllByConditions(codeRule);
            return this.buildHttpResultW(codeRules, new String[0]);
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }
}

